/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.migrator.workers;

import org.joda.time.Duration;
import org.rhq.server.metrics.domain.Bucket;

public enum MigrationTable {
    RAW("raw_metrics", Duration.standardDays((long)7L).toStandardSeconds().getSeconds(), null, Bucket.ONE_HOUR),
    ONE_HOUR("one_hour_metrics", Duration.standardDays((long)14L).toStandardSeconds().getSeconds(), Bucket.ONE_HOUR, Bucket.SIX_HOUR),
    SIX_HOUR("six_hour_metrics", Duration.standardDays((long)31L).toStandardSeconds().getSeconds(), Bucket.SIX_HOUR, Bucket.TWENTY_FOUR_HOUR),
    TWENTY_FOUR_HOUR("twenty_four_hour_metrics", Duration.standardDays((long)365L).toStandardSeconds().getSeconds(), Bucket.TWENTY_FOUR_HOUR, null);

    private final String tableName;
    private final int ttl;
    private final Bucket aggregationBucket;
    private final Bucket migrationBucket;

    private MigrationTable(String tableName, int ttl, Bucket migrationBucket, Bucket aggregationBucket) {
        this.tableName = tableName;
        this.ttl = ttl;
        this.aggregationBucket = aggregationBucket;
        this.migrationBucket = migrationBucket;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getTTL() {
        return this.ttl;
    }

    public long getTTLinMilliseconds() {
        return (long)this.ttl * 1000L;
    }

    public Bucket getAggregationBucket() {
        return this.aggregationBucket;
    }

    public Bucket getMigrationBucket() {
        return this.migrationBucket;
    }

    public String toString() {
        return this.tableName;
    }
}

