/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.migrator.workers;

import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.hibernate.StatelessSession;
import org.rhq.server.metrics.domain.AggregateType;
import org.rhq.server.metrics.domain.MetricsTable;
import org.rhq.server.metrics.migrator.DataMigrator;
import org.rhq.server.metrics.migrator.ExistingDataSource;
import org.rhq.server.metrics.migrator.Telemetry;
import org.rhq.server.metrics.migrator.workers.AbstractMigrationWorker;
import org.rhq.server.metrics.migrator.workers.CallableMigrationWorker;
import org.rhq.server.metrics.migrator.workers.MetricsIndexUpdateAccumulator;
import org.rhq.server.metrics.migrator.workers.MigrationQuery;

public class AggregateDataMigrator
extends AbstractMigrationWorker
implements CallableMigrationWorker {
    private final Log log = LogFactory.getLog(AggregateDataMigrator.class);
    private final DataMigrator.DataMigratorConfiguration config;
    private final String selectQuery;
    private final String deleteQuery;
    private final String countQuery;
    private final MetricsTable metricsTable;
    private final MetricsIndexUpdateAccumulator metricsIndexAccumulator;

    public AggregateDataMigrator(MetricsTable metricsTable, DataMigrator.DataMigratorConfiguration config) throws Exception {
        this.metricsTable = metricsTable;
        this.config = config;
        if (MetricsTable.ONE_HOUR.equals((Object)this.metricsTable)) {
            this.selectQuery = MigrationQuery.SELECT_1H_DATA.toString();
            this.deleteQuery = MigrationQuery.DELETE_1H_DATA.toString();
            this.countQuery = MigrationQuery.COUNT_1H_DATA.toString();
        } else if (MetricsTable.SIX_HOUR.equals((Object)this.metricsTable)) {
            this.selectQuery = MigrationQuery.SELECT_6H_DATA.toString();
            this.deleteQuery = MigrationQuery.DELETE_6H_DATA.toString();
            this.countQuery = MigrationQuery.COUNT_6H_DATA.toString();
        } else if (MetricsTable.TWENTY_FOUR_HOUR.equals((Object)this.metricsTable)) {
            this.selectQuery = MigrationQuery.SELECT_1D_DATA.toString();
            this.deleteQuery = MigrationQuery.DELETE_1D_DATA.toString();
            this.countQuery = MigrationQuery.COUNT_1D_DATA.toString();
        } else {
            throw new Exception("MetricsTable " + metricsTable.toString() + " not supported by this migrator.");
        }
        this.metricsIndexAccumulator = new MetricsIndexUpdateAccumulator(metricsTable, config);
    }

    @Override
    public long estimate() throws Exception {
        long recordCount = this.getRowCount(this.countQuery);
        this.log.debug((Object)("Retrieved record count for table " + this.metricsTable.toString() + " -- " + recordCount));
        Telemetry telemetry = this.performMigration(DataMigrator.Task.Estimate);
        long estimatedTimeToMigrate = telemetry.getMigrationTime();
        long estimation = recordCount / 30000L / 4L * estimatedTimeToMigrate;
        return estimation += telemetry.getNonMigrationTime();
    }

    @Override
    public void migrate() throws Exception {
        this.performMigration(DataMigrator.Task.Migrate);
        if (this.config.isDeleteDataImmediatelyAfterMigration()) {
            this.deleteTableData();
        }
    }

    private long getRowCount(String countQuery) {
        StatelessSession session = this.getSQLSession(this.config);
        SQLQuery query = session.createSQLQuery(countQuery);
        query.setReadOnly(true);
        query.setTimeout(6000000);
        long count = Long.parseLong(query.uniqueResult().toString());
        this.closeSQLSession(session);
        return count;
    }

    private void deleteTableData() throws Exception {
        int failureCount = 0;
        while (failureCount < 5) {
            try {
                StatelessSession session = this.getSQLSession(this.config);
                session.getTransaction().begin();
                SQLQuery nativeQuery = session.createSQLQuery(this.deleteQuery);
                nativeQuery.executeUpdate();
                session.getTransaction().commit();
                this.closeSQLSession(session);
                this.log.info((Object)("- " + this.metricsTable.toString() + " - Cleaned -"));
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to delete " + this.metricsTable.toString() + " data. Attempting to delete data one more time..."));
                if (++failureCount != 5) continue;
                throw e;
            }
        }
    }

    private Telemetry performMigration(DataMigrator.Task task) throws Exception {
        List<Object[]> existingData;
        Telemetry telemetry = new Telemetry();
        telemetry.getGeneralTimer().start();
        long numberOfBatchesMigrated = 0L;
        int lastMigratedRecord = 0;
        ExistingDataSource dataSource = this.getExistingDataSource(this.selectQuery, task, this.config);
        dataSource.initialize();
        telemetry.getMigrationTimer().start();
        while ((existingData = dataSource.getData(lastMigratedRecord, 30000)).size() != 0) {
            lastMigratedRecord += existingData.size();
            int failureCount = 0;
            while (failureCount < 5) {
                try {
                    this.insertDataToCassandra(existingData);
                    break;
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to insert " + this.metricsTable.toString() + " data. Attempting to insert the current batch of data one more time"));
                    this.log.error((Object)e);
                    if (++failureCount != 5) continue;
                    throw e;
                }
            }
            this.log.info((Object)("- " + this.metricsTable + " - " + lastMigratedRecord + " -"));
            if (!DataMigrator.Task.Estimate.equals((Object)task) || ++numberOfBatchesMigrated < 4L) continue;
        }
        this.metricsIndexAccumulator.drain();
        telemetry.getMigrationTimer().stop();
        dataSource.close();
        telemetry.getGeneralTimer().stop();
        return telemetry;
    }

    private void insertDataToCassandra(List<Object[]> existingData) throws Exception {
        ArrayList<ResultSetFuture> resultSetFutures = new ArrayList<ResultSetFuture>();
        Batch batch = QueryBuilder.batch((Statement[])new Statement[0]);
        int batchSize = 0;
        long currentTimeMillis = System.currentTimeMillis();
        long expectedTTLMillis = this.metricsTable.getTTLinMilliseconds();
        for (Object[] rawMeasurement : existingData) {
            long creationTimeMillis = Long.parseLong(rawMeasurement[1].toString());
            long itemTTLSeconds = (expectedTTLMillis - currentTimeMillis + creationTimeMillis) / 1000L;
            if (itemTTLSeconds > 0L) {
                int scheduleId = Integer.parseInt(rawMeasurement[0].toString());
                Date time = new Date(creationTimeMillis);
                batch.add((Statement)QueryBuilder.insertInto((String)this.metricsTable.toString()).value("schedule_id", (Object)scheduleId).value("time", (Object)time).value("type", (Object)AggregateType.AVG.ordinal()).value("value", (Object)Double.parseDouble(rawMeasurement[2].toString())).using(QueryBuilder.ttl((int)((int)itemTTLSeconds))));
                batch.add((Statement)QueryBuilder.insertInto((String)this.metricsTable.toString()).value("schedule_id", (Object)scheduleId).value("time", (Object)time).value("type", (Object)AggregateType.MIN.ordinal()).value("value", (Object)Double.parseDouble(rawMeasurement[3].toString())).using(QueryBuilder.ttl((int)((int)itemTTLSeconds))));
                batch.add((Statement)QueryBuilder.insertInto((String)this.metricsTable.toString()).value("schedule_id", (Object)scheduleId).value("time", (Object)time).value("type", (Object)AggregateType.MAX.ordinal()).value("value", (Object)Double.parseDouble(rawMeasurement[4].toString())).using(QueryBuilder.ttl((int)((int)itemTTLSeconds))));
                batchSize += 3;
                this.metricsIndexAccumulator.add(scheduleId, creationTimeMillis);
            }
            if (batchSize < 50) continue;
            resultSetFutures.add(this.config.getSession().executeAsync((Query)batch));
            batch = QueryBuilder.batch((Statement[])new Statement[0]);
            batchSize = 0;
        }
        if (batchSize != 0) {
            resultSetFutures.add(this.config.getSession().executeAsync((Query)batch));
        }
        for (ResultSetFuture future : resultSetFutures) {
            future.get();
        }
    }
}

