/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.database.CustomTableRowDiscoveryComponent;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabaseQueryUtility;

public class CustomTableComponent
implements DatabaseComponent<DatabaseComponent>,
MeasurementFacet {
    private ResourceContext<DatabaseComponent> context;

    public void start(ResourceContext<DatabaseComponent> resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.context = resourceContext;
    }

    public void stop() {
    }

    public String getTable() {
        return this.context.getPluginConfiguration().getSimpleValue("table", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        Statement statement = null;
        try {
            statement = this.getConnection().createStatement();
            statement.executeQuery("SELECT COUNT(*) FROM " + this.getTable());
            AvailabilityType availabilityType = AvailabilityType.UP;
            return availabilityType;
        }
        catch (SQLException e) {
            AvailabilityType availabilityType = AvailabilityType.DOWN;
            return availabilityType;
        }
        finally {
            JDBCUtil.safeClose((Statement)statement);
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        String query = this.context.getPluginConfiguration().getSimpleValue("metricQuery", null);
        query = CustomTableRowDiscoveryComponent.formatMessage(query, this.context.getPluginConfiguration().getSimpleValue("key", null));
        Map<String, Double> values = DatabaseQueryUtility.getNumericQueryValues(this, query, new Object[0]);
        for (MeasurementScheduleRequest request : metrics) {
            Double value = values.get(request.getName());
            if (value == null) continue;
            report.addData(new MeasurementDataNumeric(request, value));
        }
    }

    @Override
    public Connection getConnection() {
        return ((DatabaseComponent)this.context.getParentResourceComponent()).getConnection();
    }

    @Override
    public void removeConnection() {
        ((DatabaseComponent)this.context.getParentResourceComponent()).removeConnection();
    }
}

