/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.database;

import java.sql.Connection;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.database.ConnectionPoolingSupport;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.database.PooledConnectionProvider;

public abstract class AbstractDatabaseComponent<T extends DatabaseComponent<?>>
implements DatabaseComponent,
ConnectionPoolingSupport {
    private PooledConnectionProvider pooledConnectionProvider;
    protected ResourceContext<T> resourceContext;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        if (DatabasePluginUtil.hasConnectionPoolingSupport(resourceContext.getParentResourceComponent())) {
            this.pooledConnectionProvider = ((ConnectionPoolingSupport)resourceContext.getParentResourceComponent()).getPooledConnectionProvider();
        }
    }

    public void stop() {
        this.pooledConnectionProvider = null;
    }

    @Override
    public boolean supportsConnectionPooling() {
        return this.pooledConnectionProvider != null;
    }

    @Override
    public PooledConnectionProvider getPooledConnectionProvider() {
        return this.pooledConnectionProvider;
    }

    @Override
    public Connection getConnection() {
        return ((DatabaseComponent)this.resourceContext.getParentResourceComponent()).getConnection();
    }

    @Override
    public void removeConnection() {
        ((DatabaseComponent)this.resourceContext.getParentResourceComponent()).removeConnection();
    }

    public String toString() {
        return this.getClass().getName() + " key=" + this.resourceContext.getResourceKey();
    }
}

