/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.database.DatabaseComponent;

public class DatabaseQueryUtility {
    private static final Log LOG = LogFactory.getLog(DatabaseQueryUtility.class);

    public static int executeUpdate(DatabaseComponent databaseComponent, String query, Object ... parameters) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = databaseComponent.getConnection().prepareStatement(query);
            DatabaseQueryUtility.bindParameters(statement, parameters);
            int n = statement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            databaseComponent.removeConnection();
            throw e;
        }
        finally {
            DatabaseQueryUtility.close(statement, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double getSingleNumericQueryValue(DatabaseComponent databaseComponent, String query, Object ... parameters) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = databaseComponent.getConnection().prepareStatement(query);
            DatabaseQueryUtility.bindParameters(statement, parameters);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                Double d = resultSet.getDouble(1);
                DatabaseQueryUtility.close(statement, resultSet);
                return d;
            }
            DatabaseQueryUtility.close(statement, resultSet);
        }
        catch (SQLException e) {
            databaseComponent.removeConnection();
        }
        finally {
            DatabaseQueryUtility.close(statement, resultSet);
        }
        return Double.NaN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Double> getNumericQueryValues(DatabaseComponent databaseComponent, String query, Object ... parameters) {
        HashMap<String, Double> hashMap;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = databaseComponent.getConnection().prepareStatement(query);
            DatabaseQueryUtility.bindParameters(statement, parameters);
            resultSet = statement.executeQuery();
            HashMap<String, Double> row = new HashMap<String, Double>();
            ResultSetMetaData md = resultSet.getMetaData();
            String[] names = DatabaseQueryUtility.getColumns(md);
            if (resultSet.next()) {
                for (String name : names) {
                    try {
                        row.put(name, resultSet.getDouble(name));
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            hashMap = row;
        }
        catch (SQLException e) {
            try {
                LOG.debug((Object)"Unable to read value", (Throwable)e);
                databaseComponent.removeConnection();
            }
            catch (Throwable throwable) {
                DatabaseQueryUtility.close(statement, resultSet);
                throw throwable;
            }
            DatabaseQueryUtility.close(statement, resultSet);
            return Collections.emptyMap();
        }
        DatabaseQueryUtility.close(statement, resultSet);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Double> getNumericQueryValueMap(DatabaseComponent databaseComponent, String query, Object ... parameters) {
        HashMap<String, Double> hashMap;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Connection c = databaseComponent.getConnection();
            statement = c.prepareStatement(query);
            DatabaseQueryUtility.bindParameters(statement, parameters);
            resultSet = statement.executeQuery();
            HashMap<String, Double> map = new HashMap<String, Double>();
            while (resultSet.next()) {
                try {
                    map.put(resultSet.getString(1), resultSet.getDouble(2));
                }
                catch (SQLException e) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("A query column value is not a double, ignoring:" + ThrowableUtil.getAllMessages((Throwable)e)));
                }
            }
            hashMap = map;
        }
        catch (SQLException e) {
            try {
                LOG.info((Object)"Unable to read value", (Throwable)e);
                databaseComponent.removeConnection();
            }
            catch (Throwable throwable) {
                DatabaseQueryUtility.close(statement, resultSet);
                throw throwable;
            }
            DatabaseQueryUtility.close(statement, resultSet);
            return Collections.emptyMap();
        }
        DatabaseQueryUtility.close(statement, resultSet);
        return hashMap;
    }

    private static void bindParameters(PreparedStatement statement, Object ... parameters) throws SQLException {
        int i = 1;
        for (Object p : parameters) {
            if (p instanceof String) {
                statement.setString(i++, (String)p);
                continue;
            }
            if (p instanceof Number) {
                statement.setDouble(i++, ((Number)p).doubleValue());
                continue;
            }
            statement.setObject(i++, p);
        }
    }

    public static String[] getColumns(ResultSetMetaData rsmd) throws SQLException {
        String[] names = new String[rsmd.getColumnCount()];
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            names[i] = rsmd.getColumnName(i + 1);
        }
        return names;
    }

    public static void close(Statement statement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static class StatementParameter {
        private String name;
        private String value;
    }
}

