/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.database.DatabaseComponent;

public class CustomTableDiscoveryComponent
implements ManualAddFacet<DatabaseComponent<?>>,
ResourceDiscoveryComponent<DatabaseComponent<?>> {
    protected Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<DatabaseComponent<?>> resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        Set<DiscoveredResourceDetails> set;
        Configuration config = resourceDiscoveryContext.getDefaultPluginConfiguration();
        String table = config.getSimpleValue("table", "");
        ResourceType rt = resourceDiscoveryContext.getResourceType();
        String resourceName = config.getSimpleValue("name", rt.getName());
        String resourceDescription = config.getSimpleValue("description", rt.getDescription());
        if (table.isEmpty()) {
            this.log.debug((Object)("'table' value not set, cannot discover " + resourceName));
            return Collections.emptySet();
        }
        Statement statement = null;
        try {
            Connection conn = ((DatabaseComponent)resourceDiscoveryContext.getParentResourceComponent()).getConnection();
            if (conn == null) {
                throw new InvalidPluginConfigurationException("cannot obtain connection from parent");
            }
            statement = conn.createStatement();
            statement.setMaxRows(1);
            statement.setFetchSize(1);
            statement.executeQuery("SELECT * FROM " + table).close();
            DiscoveredResourceDetails details = new DiscoveredResourceDetails(resourceDiscoveryContext.getResourceType(), table + resourceName, resourceName, null, resourceDescription, config, null);
            this.log.debug((Object)("discovered " + details));
            set = Collections.singleton(details);
        }
        catch (SQLException e) {
            try {
                this.log.debug((Object)("discovery failed " + e + " for " + table));
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(statement);
                throw throwable;
            }
            JDBCUtil.safeClose((Statement)statement);
            return Collections.emptySet();
        }
        JDBCUtil.safeClose((Statement)statement);
        return set;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfiguration, ResourceDiscoveryContext<DatabaseComponent<?>> discoveryContext) throws InvalidPluginConfigurationException {
        Configuration config = pluginConfiguration;
        String table = config.getSimpleValue("table", null);
        String resourceName = config.getSimpleValue("name", table);
        String resourceDescription = config.getSimpleValue("description", discoveryContext.getResourceType().getDescription());
        String resourceVersion = config.getSimpleValue("version", null);
        DiscoveredResourceDetails details = new DiscoveredResourceDetails(discoveryContext.getResourceType(), table + resourceName, resourceName, resourceVersion, resourceDescription, config, null);
        return details;
    }
}

