/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.update;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.rhq.enterprise.agent.update.LoggerAntBuildListener;

public class AgentUpdate {
    private static final String RHQ_AGENT_UPDATE_VERSION_PROPERTIES = "rhq-agent-update-version.properties";
    private static final String BUILD_TASKS_PROPERTIES_FILE = "rhq-agent-update-build-tasks.properties";
    private static final String ANT_TARGET_BACKUP_AGENT = "backup-agent";
    private static final String ANT_TARGET_RESTORE_AGENT = "restore-agent";
    private static final String ANT_TARGET_LAUNCH_AGENT = "launch-agent";
    private static final String DEFAULT_OLD_AGENT_HOME = "rhq-agent";
    private static final String DEFAULT_NEW_AGENT_HOME_PARENT = ".";
    private static final String DEFAULT_LOG_FILE = "rhq-agent-update.log";
    private static final boolean DEFAULT_QUIET_FLAG = false;
    private static final String DEFAULT_SCRIPT_FILE = "rhq-agent-update-build.xml";
    private boolean showVersion = false;
    private boolean updateFlag = false;
    private boolean installFlag = false;
    private Boolean launchFlag;
    private String oldAgentHomeArgument = "rhq-agent";
    private String newAgentHomeParentArgument = ".";
    private String logFileArgument = "rhq-agent-update.log";
    private String jarFileArgument = null;
    private boolean quietFlag = false;
    private String scriptFileArgument = "rhq-agent-update-build.xml";

    public static void main(String[] args) throws Exception {
        AgentUpdate agentUpdate = new AgentUpdate();
        try {
            agentUpdate.processArguments(args);
        }
        catch (IllegalArgumentException error) {
            error.printStackTrace();
            agentUpdate.printSyntax();
            return;
        }
        catch (UnsupportedOperationException helpException) {
            try {
                System.out.println(new String(agentUpdate.getJarFileContent("README.txt")));
            }
            catch (Throwable t) {
                System.out.println("Cannot show README.txt: " + t);
            }
            System.out.println();
            agentUpdate.printSyntax();
            System.out.println();
            agentUpdate.showVersionInfo();
            return;
        }
        if (agentUpdate.showVersion) {
            agentUpdate.showVersionInfo();
            return;
        }
        File logFile = new File(agentUpdate.logFileArgument);
        URL buildFile = DEFAULT_SCRIPT_FILE.equals(agentUpdate.scriptFileArgument) ? AgentUpdate.class.getClassLoader().getResource(agentUpdate.scriptFileArgument) : new File(agentUpdate.scriptFileArgument).toURI().toURL();
        Properties props = agentUpdate.getAgentUpdateVersionProperties();
        props.setProperty("rhq.agent.update.jar-file", agentUpdate.getJarFilename());
        props.setProperty("rhq.agent.update.log-dir", logFile.getParent() != null ? logFile.getParent() : DEFAULT_NEW_AGENT_HOME_PARENT);
        if (agentUpdate.updateFlag) {
            props.setProperty("rhq.agent.update.update-flag", "true");
            props.setProperty("rhq.agent.update.update-agent-dir", agentUpdate.oldAgentHomeArgument);
            props.setProperty("rhq.agent.update.launch-script-dir", new File(agentUpdate.oldAgentHomeArgument, "bin").getAbsolutePath());
        } else if (agentUpdate.installFlag) {
            props.setProperty("rhq.agent.update.install-flag", "true");
            props.setProperty("rhq.agent.update.install-agent-dir", agentUpdate.newAgentHomeParentArgument);
            props.setProperty("rhq.agent.update.launch-script-dir", new File(agentUpdate.newAgentHomeParentArgument, "rhq-agent/bin").getAbsolutePath());
        }
        if (agentUpdate.updateFlag) {
            try {
                agentUpdate.startAnt(buildFile, ANT_TARGET_BACKUP_AGENT, BUILD_TASKS_PROPERTIES_FILE, props, logFile, !agentUpdate.quietFlag);
            }
            catch (Exception e) {
                AgentUpdate.logMessage(logFile, "WARNING! Agent backup failed! Agent will not recover if it can't update!");
                AgentUpdate.logStackTrace(logFile, e);
            }
        }
        try {
            agentUpdate.startAnt(buildFile, null, BUILD_TASKS_PROPERTIES_FILE, props, logFile, !agentUpdate.quietFlag);
        }
        catch (Exception e) {
            if (agentUpdate.updateFlag) {
                AgentUpdate.logMessage(logFile, "WARNING! Agent update failed! Will try to restore old agent!");
                AgentUpdate.logStackTrace(logFile, e);
                try {
                    agentUpdate.startAnt(buildFile, ANT_TARGET_RESTORE_AGENT, BUILD_TASKS_PROPERTIES_FILE, props, logFile, true);
                }
                catch (Exception e2) {
                    AgentUpdate.logMessage(logFile, "WARNING! Agent restore failed! Agent is dead and cannot recover!");
                    AgentUpdate.logStackTrace(logFile, e2);
                }
            }
            AgentUpdate.logMessage(logFile, "WARNING! Agent installation failed!");
            AgentUpdate.logStackTrace(logFile, e);
            throw e;
        }
        if (!agentUpdate.launchFlag.booleanValue()) {
            return;
        }
        try {
            agentUpdate.startAnt(buildFile, ANT_TARGET_LAUNCH_AGENT, BUILD_TASKS_PROPERTIES_FILE, props, logFile, true);
        }
        catch (Exception e) {
            AgentUpdate.logMessage(logFile, "WARNING! Agent failed to be restarted!");
            AgentUpdate.logStackTrace(logFile, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logMessage(File logFile, String msg) {
        msg = new Date().toString() + ": " + msg;
        System.out.println(msg);
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(logFile, true));
            try {
                pw.println(msg);
            }
            finally {
                pw.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logStackTrace(File logFile, Throwable t) {
        t.printStackTrace(System.out);
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(logFile, true));
            try {
                t.printStackTrace(pw);
            }
            finally {
                pw.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessage(String msg) {
        msg = new Date().toString() + ": " + msg;
        System.out.println(msg);
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(this.logFileArgument, true));
            try {
                pw.println(msg);
            }
            finally {
                pw.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void showVersionInfo() throws Exception {
        String str = "\n============================================\nRHQ Agent Update Binary Version Information:\n============================================\n" + new String(this.getJarFileContent(RHQ_AGENT_UPDATE_VERSION_PROPERTIES));
        this.logMessage(str);
    }

    private String getJarFilename() throws Exception {
        if (this.jarFileArgument == null) {
            URL propsUrl = this.getClass().getClassLoader().getResource(RHQ_AGENT_UPDATE_VERSION_PROPERTIES);
            String propsUrlString = propsUrl.toString();
            propsUrlString = propsUrlString.replaceFirst("jar:", "");
            propsUrlString = propsUrlString.replaceFirst("!/rhq-agent-update-version.properties", "");
            File propsFile = new File(new URI(propsUrlString));
            this.jarFileArgument = propsFile.getAbsolutePath();
        }
        return this.jarFileArgument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getAgentUpdateVersionProperties() throws Exception {
        byte[] bytes = this.getJarFileContent(RHQ_AGENT_UPDATE_VERSION_PROPERTIES);
        ByteArrayInputStream propertiesStream = new ByteArrayInputStream(bytes);
        Properties versionProps = new Properties();
        try {
            versionProps.load(propertiesStream);
        }
        finally {
            ((InputStream)propertiesStream).close();
        }
        return versionProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getJarFileContent(String filename) throws Exception {
        JarFile jarFile = new JarFile(this.getJarFilename());
        try {
            JarEntry jarFileEntry = jarFile.getJarEntry(filename);
            InputStream jarFileEntryStream = jarFile.getInputStream(jarFileEntry);
            byte[] byArray = this.slurp(jarFileEntryStream);
            return byArray;
        }
        finally {
            jarFile.close();
        }
    }

    private void printSyntax() {
        String syntax = "Valid options are:\n[--help] : Help information on how to use this jar file.\n[--version] : Shows version information about this jar file and exits.\n[--update[=<old agent home>]] : When specified, this will update an existing\n                                agent. If you do not specify the directory\n                                where the existing agent is, the default is:\n                                rhq-agent\n                                This is mutually exclusive of --install\n[--install[=<new agent dir>]] : When specified, this will install a new agent\n                                without attempting to update any existing\n                                agent. If you do not specify the directory,\n                                the default is:.\n                                Note the directory will be the parent of the\n                                new agent home installation directory.\n                                This is mutually exclusive of --update\n[--launch=<true|false>] : If specified, this explicitly indicates if the\n                          agent should be started immediately after being\n                          installed or updated. If not specified, the\n                          default will be 'false' if installing a new agent\n                          and 'true' if updating an existing agent.\n[--quiet] : If specified, this turns off console log messages.\n[--pause[=<ms>]] : If specified, the update will not occur until the given\n                   number of milliseconds expires. If this option is given\n                   without the number of milliseconds, 30000 is the default.\n[--jar=<jar file>] : If specified, the agent found in the given jar file will\n                     be the new one that will be installed. You usually do not\n                     have to specify this, since the jar running this update\n                     code will usually be the one that contains the agent to\n                     be installed. Do not use this unless you have a reason.\n[--log=<log file>] : If specified, this is where the log messages will be\n                     written. Default=rhq-agent-update.log\n[--script=<ant script>] : If specified, this will override the default\n                          upgrade script URL found in the classloader.\n                          Users will rarely need this;\n                          use this only if you know what you are doing.\n                          Default=rhq-agent-update-build.xml\n";
        System.out.println(syntax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processArguments(String[] args) throws Exception {
        int code;
        if (args.length <= 0) {
            throw new UnsupportedOperationException();
        }
        String sopts = "u::i::qhvo:j:p::s:l:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("update", 2, null, 117), new LongOpt("install", 2, null, 105), new LongOpt("quiet", 0, null, 113), new LongOpt("launch", 1, null, 108), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 118), new LongOpt("log", 1, null, 111), new LongOpt("jar", 1, null, 106), new LongOpt("pause", 2, null, 112), new LongOpt("script", 1, null, 115)};
        Getopt getopt = new Getopt(AgentUpdate.class.getSimpleName(), args, sopts, lopts);
        long pause = -1L;
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 1: 
                case 58: 
                case 63: {
                    throw new IllegalArgumentException("Bad argument!");
                }
                case 117: {
                    File agentHome;
                    this.updateFlag = true;
                    String value = getopt.getOptarg();
                    if (value != null) {
                        this.oldAgentHomeArgument = value;
                    }
                    if (!(agentHome = new File(this.oldAgentHomeArgument)).exists() || !agentHome.isDirectory()) {
                        throw new FileNotFoundException("There is no agent located at: " + this.oldAgentHomeArgument);
                    }
                    File possibleHomeDir = new File(agentHome, DEFAULT_OLD_AGENT_HOME);
                    if (possibleHomeDir.exists() && possibleHomeDir.isDirectory()) {
                        agentHome = possibleHomeDir;
                    }
                    this.oldAgentHomeArgument = agentHome.getAbsolutePath();
                    break;
                }
                case 105: {
                    this.installFlag = true;
                    String value = getopt.getOptarg();
                    if (value == null) break;
                    this.newAgentHomeParentArgument = value;
                    break;
                }
                case 113: {
                    this.quietFlag = true;
                    break;
                }
                case 104: {
                    throw new UnsupportedOperationException();
                }
                case 118: {
                    this.showVersion = true;
                    break;
                }
                case 111: {
                    this.logFileArgument = getopt.getOptarg();
                    break;
                }
                case 108: {
                    this.launchFlag = Boolean.parseBoolean(getopt.getOptarg());
                    break;
                }
                case 106: {
                    this.jarFileArgument = getopt.getOptarg();
                    File jarFile = new File(this.jarFileArgument);
                    if (jarFile.exists() && jarFile.isFile()) break;
                    throw new FileNotFoundException("There is no agent jar located at: " + this.jarFileArgument);
                }
                case 112: {
                    pause = 30000L;
                    String value = getopt.getOptarg();
                    if (value == null) break;
                    try {
                        pause = Long.parseLong(value);
                    }
                    catch (Exception e) {
                        pause = 30000L;
                    }
                    break;
                }
                case 115: {
                    this.scriptFileArgument = getopt.getOptarg();
                }
            }
        }
        if (getopt.getOptind() < args.length) {
            throw new IllegalArgumentException("Bad arguments.");
        }
        if (this.showVersion) {
            return;
        }
        if (this.updateFlag && this.installFlag) {
            throw new IllegalArgumentException("Cannot use both --update and --install");
        }
        if (!this.updateFlag && !this.installFlag) {
            throw new IllegalArgumentException("Must specify either --update or --install");
        }
        if (this.launchFlag == null) {
            this.launchFlag = this.updateFlag;
        }
        if (pause > 0L) {
            try {
                this.logMessage("Pausing for [" + pause + "] milliseconds...");
                Thread.sleep(pause);
            }
            catch (InterruptedException e) {
            }
            finally {
                this.logMessage("Done pausing. Continuing with the update.");
            }
        }
    }

    private byte[] slurp(InputStream stream) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        long numBytesCopied = 0L;
        int bufferSize = 32768;
        try {
            stream = new BufferedInputStream(stream, bufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = stream.read(buffer);
            while (bytesRead != -1) {
                out.write(buffer, 0, bytesRead);
                numBytesCopied += (long)bytesRead;
                bytesRead = stream.read(buffer);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Stream data cannot be slurped", ioe);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe2) {}
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAnt(URL buildFile, String target, String customTaskDefs, Properties properties, File logFile, boolean logStdOut) {
        PrintWriter logFileOutput = null;
        try {
            logFileOutput = new PrintWriter(new FileOutputStream(logFile, true));
            ClassLoader classLoader = this.getClass().getClassLoader();
            Properties taskDefs = new Properties();
            if (customTaskDefs != null) {
                InputStream taskDefsStream = classLoader.getResourceAsStream(customTaskDefs);
                try {
                    taskDefs.load(taskDefsStream);
                }
                finally {
                    taskDefsStream.close();
                }
            }
            Project project = new Project();
            project.setCoreLoader(classLoader);
            project.init();
            project.addBuildListener(new LoggerAntBuildListener(target, logFileOutput, 4));
            if (logStdOut) {
                PrintWriter stdout = new PrintWriter(System.out);
                project.addBuildListener(new LoggerAntBuildListener(target, stdout, 2));
            }
            if (properties != null) {
                for (Map.Entry<Object, Object> property : properties.entrySet()) {
                    project.setProperty(property.getKey().toString(), property.getValue().toString());
                }
            }
            for (Map.Entry<Object, Object> taskDef : taskDefs.entrySet()) {
                project.addTaskDefinition(taskDef.getKey().toString(), Class.forName(taskDef.getValue().toString(), true, classLoader));
            }
            new ProjectHelper2().parse(project, buildFile);
            project.executeTarget(target == null ? project.getDefaultTarget() : target);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot run ANT on script [" + buildFile + "]. Cause: " + e, e);
        }
        finally {
            if (logFileOutput != null) {
                logFileOutput.close();
            }
        }
    }
}

