/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.update;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CopyWithBackup
extends Task {
    private File oldDirectory;
    private File newDirectory;
    private String filename;
    private String keep;
    private String backupextension;
    private Boolean failonerror = Boolean.FALSE;

    public void setOlddir(File dir) {
        this.oldDirectory = dir;
    }

    public void setNewdir(File dir) {
        this.newDirectory = dir;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setKeep(String keep) {
        this.keep = keep;
    }

    public void setBackupextension(String ext) {
        this.backupextension = ext;
    }

    public void setFailonerror(Boolean flag) {
        this.failonerror = flag;
    }

    @Override
    public void execute() throws BuildException {
        this.validateAttributes();
        try {
            MessageDigest messageDigest;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new BuildException(e);
            }
            File oldFile = new File(this.oldDirectory, this.filename);
            File newFile = new File(this.newDirectory, this.filename);
            this.log("* old file=" + oldFile, 4);
            this.log("* old file exists=" + oldFile.exists(), 4);
            this.log("* new file=" + newFile, 4);
            this.log("* new file exists=" + newFile.exists(), 4);
            this.log("* backup extension=" + this.backupextension, 4);
            this.log("* keep=" + this.keep, 4);
            if (!oldFile.exists()) {
                if (!newFile.exists()) {
                    this.log("old file and new file do not exist - nothing to be done");
                    return;
                }
                if (this.keep.equals("new")) {
                    this.log("old file does not exist, new file does, keeping new file as-is");
                } else if (this.backupextension == null) {
                    this.log("old file does not exist, new file does, removing new file");
                    if (!newFile.delete()) {
                        throw new BuildException("Cannot remove new file [" + newFile + "]");
                    }
                } else {
                    this.log("old file does not exist, new file does, backing up new file");
                    if (!newFile.renameTo(new File(this.newDirectory, this.filename + this.backupextension))) {
                        throw new BuildException("Cannot backup new file [" + newFile + "]");
                    }
                }
            } else if (!newFile.exists()) {
                if (this.keep.equals("new")) {
                    if (this.backupextension == null) {
                        this.log("old file exists, new file does not, do nothing");
                    } else {
                        this.log("old file exists, new file does not, backup old");
                        this.copy(oldFile, new File(this.newDirectory, this.filename + this.backupextension));
                    }
                } else {
                    this.log("old file exists, new file does not, copying old file");
                    this.copy(oldFile, newFile);
                }
            } else {
                byte[] oldMD5Bytes = messageDigest.digest(this.slurp(oldFile));
                messageDigest.reset();
                byte[] newMD5Bytes = messageDigest.digest(this.slurp(newFile));
                if (MessageDigest.isEqual(oldMD5Bytes, newMD5Bytes)) {
                    this.log("old file and new file are the same, nothing to do");
                    return;
                }
                if (this.keep.equals("new")) {
                    if (this.backupextension == null) {
                        this.log("files differ, keeping new, not backing up old");
                    } else {
                        this.log("files differ, keeping new, backing up old");
                        this.copy(oldFile, new File(this.newDirectory, this.filename + this.backupextension));
                    }
                } else if (this.backupextension == null) {
                    this.log("files differ, keeping old, not backing up new");
                    newFile.delete();
                    this.copy(oldFile, newFile);
                } else {
                    this.log("files differ, keeping old, backing up new");
                    newFile.renameTo(new File(this.newDirectory, this.filename + this.backupextension));
                    this.copy(oldFile, newFile);
                }
            }
        }
        catch (BuildException e) {
            if (this.failonerror.booleanValue()) {
                throw e;
            }
            this.log("got a failure but will not exit: " + e);
        }
    }

    private byte[] slurp(File file) throws BuildException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.copy(new FileInputStream(file), out);
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new BuildException("Stream data cannot be slurped", e);
        }
    }

    private void copy(File src, File dest) throws BuildException {
        if (dest.exists()) {
            throw new BuildException("Cannot copy [" + src + "] to [" + dest + "] because the latter exists");
        }
        try {
            this.copy(new FileInputStream(src), new FileOutputStream(dest));
        }
        catch (Exception e) {
            throw new BuildException("Cannot copy [" + src + "] to [" + dest + "]", e);
        }
    }

    private long copy(InputStream input, OutputStream output) throws RuntimeException {
        long numBytesCopied = 0L;
        int bufferSize = 32768;
        try {
            input = new BufferedInputStream(input, bufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = input.read(buffer);
            while (bytesRead != -1) {
                output.write(buffer, 0, bytesRead);
                numBytesCopied += (long)bytesRead;
                bytesRead = input.read(buffer);
            }
            output.flush();
        }
        catch (Exception e) {
            throw new BuildException("Stream data cannot be copied", e);
        }
        finally {
            try {
                output.close();
            }
            catch (IOException ioe) {}
            try {
                input.close();
            }
            catch (IOException ioe) {}
        }
        return numBytesCopied;
    }

    private void validateAttributes() throws BuildException {
        if (this.filename == null) {
            throw new BuildException("Must specify 'filename'");
        }
        if (this.oldDirectory == null) {
            throw new BuildException("Must specify 'olddir' directory");
        }
        if (this.newDirectory == null) {
            throw new BuildException("Must specify 'newdir' directory");
        }
        if (!this.newDirectory.exists()) {
            throw new BuildException("'newdir' directory must exist: " + this.newDirectory);
        }
        if (!this.newDirectory.isDirectory()) {
            throw new BuildException("'newdir' must be a directory: " + this.newDirectory);
        }
        if (this.keep == null) {
            throw new BuildException("Must specify 'keep' as either 'old' or 'new'");
        }
        if (!"old".equals(this.keep) && !"new".equals(this.keep)) {
            throw new BuildException("'keep' must be one of: [old, new]");
        }
        if (this.backupextension != null && this.backupextension.trim().length() == 0) {
            this.backupextension = null;
        }
    }
}

