/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.update;

import java.io.PrintWriter;
import java.util.Date;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class LoggerAntBuildListener
implements BuildListener {
    private final String mainTarget;
    private final PrintWriter output;
    private final int priorityThreshold;

    public LoggerAntBuildListener(String target, PrintWriter logFile, int priorityThreshold) {
        this.mainTarget = target != null ? target : "(default)";
        this.output = logFile;
        this.priorityThreshold = priorityThreshold;
        this.output.println("======================================");
        this.output.println("ANT target [" + this.mainTarget + "]");
        this.output.println(new Date().toString());
        this.output.println("======================================");
    }

    @Override
    public void buildFinished(BuildEvent event) {
        this.logEvent(event, "FINISHED! [" + this.mainTarget + ']');
    }

    @Override
    public void buildStarted(BuildEvent event) {
        this.logEvent(event, "STARTED! [" + this.mainTarget + ']');
    }

    @Override
    public void messageLogged(BuildEvent event) {
        this.logEvent(event, null);
    }

    @Override
    public void targetFinished(BuildEvent event) {
        this.logEvent(event, null);
    }

    @Override
    public void targetStarted(BuildEvent event) {
        this.logEvent(event, null);
    }

    @Override
    public void taskFinished(BuildEvent event) {
        this.logEvent(event, null);
    }

    @Override
    public void taskStarted(BuildEvent event) {
        this.logEvent(event, null);
    }

    private void logEvent(BuildEvent event, String additionalMessage) {
        if (event.getPriority() > this.priorityThreshold) {
            return;
        }
        String message = event.getMessage();
        Throwable exception = event.getException();
        Target target = event.getTarget();
        Task task = event.getTask();
        if (additionalMessage != null) {
            this.output.println(additionalMessage);
        }
        if (target != null) {
            this.output.print("[" + target.getName() + "] ");
        }
        if (task != null) {
            this.output.print("[" + task.getTaskName() + "] ");
        }
        if (message != null) {
            this.output.print(message);
        }
        if (exception != null) {
            this.output.println();
            exception.printStackTrace(this.output);
        }
        this.output.println();
        this.output.flush();
    }
}

