/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.update;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MigrateAgentPreferences
extends Task {
    private static final String NODE_PARENT = "rhq-agent";
    private static final String NODE_DELIM = "/";
    private static final String NODE_PREFIX = "rhq-agent/";
    private static final String DEFAULT_PREFS_FILE = "agent-prefs.properties";
    private static final String MAINTAIN_NATIVE_PREFS_SYSPROP = "rhq.preferences.migrate.keep-native-prefs";
    private static final String MAINTAIN_NATIVE_PREFS_DEFAULT = "true";
    private static final Boolean MAINTAIN_NATIVE_PREFS = Boolean.valueOf(System.getProperty("rhq.preferences.migrate.keep-native-prefs", "true"));
    private File toDir;
    private Boolean failonerror = Boolean.FALSE;

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }

    public void setFailonerror(Boolean flag) {
        this.failonerror = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        this.validateAttributes();
        try {
            File toFile;
            String filePath = System.getProperty("rhq.preferences.file");
            File file = toFile = null != filePath ? new File(filePath) : new File(this.toDir, DEFAULT_PREFS_FILE);
            if (toFile.exists()) {
                return;
            }
            Preferences userRoot = Preferences.userRoot();
            if (!userRoot.nodeExists(NODE_PARENT)) {
                return;
            }
            Properties configProps = new Properties();
            Preferences topNode = userRoot.node(NODE_PARENT);
            for (String pref : topNode.childrenNames()) {
                Preferences prefNode = topNode.node(pref);
                for (String key : prefNode.keys()) {
                    String configPropKey = NODE_PREFIX + prefNode.name() + NODE_DELIM + key;
                    String configPropVal = prefNode.get(key, "");
                    configProps.setProperty(configPropKey, configPropVal);
                }
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(toFile);
                configProps.store(fos, "Created by RHQ MigrateAgentPreferences tool.");
            }
            finally {
                if (null != fos) {
                    fos.close();
                }
            }
            if (!MAINTAIN_NATIVE_PREFS.booleanValue()) {
                topNode.removeNode();
            }
        }
        catch (Throwable e) {
            if (this.failonerror.booleanValue()) {
                throw new BuildException(e);
            }
            this.log("Failed, but will not exit of failure: " + e);
        }
    }

    private void validateAttributes() throws BuildException {
        if (null == this.toDir || !this.toDir.exists()) {
            throw new BuildException("Must specify existing 'todir' directory");
        }
    }
}

