/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import mazz.i18n.Logger;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.rhq.enterprise.communications.ServiceContainer;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.RemoteIOException;
import org.rhq.enterprise.communications.command.impl.stream.RemoteOutputStreamCommand;
import org.rhq.enterprise.communications.command.impl.stream.RemoteOutputStreamCommandResponse;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public class RemoteOutputStream
extends OutputStream
implements Serializable {
    private static final Logger LOG = CommI18NFactory.getLogger(RemoteOutputStream.class);
    private static final long serialVersionUID = 1L;
    private static Method CLOSE;
    private static Method FLUSH;
    private static Method WRITE_INT;
    private static Method WRITE_BYTEARRAY;
    private static Method WRITE_BYTEARRAY_INT_INT;
    private transient ClientCommandSender m_sender;
    private final Long m_streamId;
    private final String m_serverEndpoint;

    public RemoteOutputStream(OutputStream stream, ServiceContainer server) throws Exception {
        this(server.addRemoteOutputStream(stream), server);
    }

    public RemoteOutputStream(Long id, ServiceContainer server) {
        this.m_streamId = id;
        this.m_serverEndpoint = server.getServerEndpoint();
    }

    public String getServerEndpoint() {
        return this.m_serverEndpoint;
    }

    public void setClientCommandSender(ClientCommandSender sender) {
        this.m_sender = sender;
    }

    public String toString() {
        return "RemoteOutputStream: stream-id=[" + this.m_streamId + "]; server-endpoint=[" + this.m_serverEndpoint + "]";
    }

    public void close() throws IOException {
        this.sendRequest(CLOSE, null);
    }

    public void flush() throws IOException {
        this.sendRequest(FLUSH, null);
    }

    public void write(int b) throws IOException {
        this.sendRequest(WRITE_INT, new Object[]{new Integer(b)});
    }

    public void write(byte[] b) throws IOException {
        this.sendRequest(WRITE_BYTEARRAY, new Object[]{b});
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.sendRequest(WRITE_BYTEARRAY_INT_INT, new Object[]{b, off, len});
    }

    protected Object sendRequest(Method method, Object[] args) throws RemoteIOException {
        RemoteOutputStreamCommandResponse response;
        if (this.m_sender == null) {
            throw new RemoteIOException(LOG.getMsgString("RemoteOutputStream.remote-output-stream-missing-sender", new Object[]{this.m_streamId, this.m_serverEndpoint}));
        }
        RemoteOutputStreamCommand cmd = new RemoteOutputStreamCommand();
        cmd.setNameBasedInvocation(new NameBasedInvocation(method, args));
        cmd.setStreamId(this.m_streamId);
        try {
            response = new RemoteOutputStreamCommandResponse(this.m_sender.sendSynch(cmd));
        }
        catch (Exception e) {
            throw new RemoteIOException(e);
        }
        if (!response.isSuccessful()) {
            throw new RemoteIOException(response.getException());
        }
        return response.getResults();
    }

    static {
        try {
            CLOSE = OutputStream.class.getMethod("close", new Class[0]);
            FLUSH = OutputStream.class.getMethod("flush", new Class[0]);
            WRITE_INT = OutputStream.class.getMethod("write", Integer.TYPE);
            WRITE_BYTEARRAY = OutputStream.class.getMethod("write", byte[].class);
            WRITE_BYTEARRAY_INT_INT = OutputStream.class.getMethod("write", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "ClientRemoteOutputStream.invalid-method-definition", new Object[0]);
        }
    }
}

