/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.impl.identify.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import mazz.i18n.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.transport.ConnectorMBean;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.CommandType;
import org.rhq.enterprise.communications.command.impl.identify.AgentIdentification;
import org.rhq.enterprise.communications.command.impl.identify.Identification;
import org.rhq.enterprise.communications.command.impl.identify.IdentifyCommand;
import org.rhq.enterprise.communications.command.impl.identify.IdentifyCommandResponse;
import org.rhq.enterprise.communications.command.impl.identify.ServerIdentification;
import org.rhq.enterprise.communications.command.server.CommandService;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public class IdentifyCommandService
extends CommandService {
    private static final Logger LOG = CommI18NFactory.getLogger(IdentifyCommandService.class);

    public CommandResponse execute(Command command, InputStream in, OutputStream out) {
        Identification our_ident;
        IdentifyCommand identifyCommand = new IdentifyCommand(command);
        String our_type = null;
        InvokerLocator locator = null;
        try {
            ConnectorMBean connector = this.getConnector();
            locator = connector.getLocator();
            Map locator_params = locator.getParameters();
            our_type = (String)locator_params.get("rhq.communications.connector.rhqtype");
        }
        catch (Exception e) {
            return new IdentifyCommandResponse((Command)identifyCommand, e);
        }
        if (our_type.equals("agent")) {
            our_ident = new AgentIdentification(our_type, locator.getLocatorURI());
        } else if (our_type.equals("server")) {
            our_ident = new ServerIdentification(our_type, locator.getLocatorURI());
        } else {
            return new IdentifyCommandResponse((Command)identifyCommand, new Exception(LOG.getMsgString("IdentifyCommandService.unknown-endpoint", new Object[0])));
        }
        return new IdentifyCommandResponse((Command)identifyCommand, our_ident);
    }

    public CommandType[] getSupportedCommandTypes() {
        return new CommandType[]{IdentifyCommand.COMMAND_TYPE};
    }
}

