/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.impl.start;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.rhq.enterprise.communications.command.AbstractCommand;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandType;
import org.rhq.enterprise.communications.command.param.InvalidParameterDefinitionException;
import org.rhq.enterprise.communications.command.param.InvalidParameterValueException;
import org.rhq.enterprise.communications.command.param.ParameterDefinition;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartCommand
extends AbstractCommand {
    public static final CommandType COMMAND_TYPE = new CommandType("start", 1);
    public static final ParameterDefinition PARAM_PROGRAM_TITLE = new ParameterDefinition("programTitle", String.class.getName(), false, false, false, CommI18NFactory.getMsg().getMsg("StartCommand.program-title", new Object[0]));
    public static final ParameterDefinition PARAM_PROGRAM_EXE = new ParameterDefinition("programExecutable", String.class.getName(), true, false, false, CommI18NFactory.getMsg().getMsg("StartCommand.program-executable", new Object[0]));
    public static final ParameterDefinition PARAM_PROGRAM_DIR = new ParameterDefinition("programDirectory", String.class.getName(), true, false, false, CommI18NFactory.getMsg().getMsg("StartCommand.program-directory", new Object[0]));
    public static final ParameterDefinition PARAM_ARGS = new ParameterDefinition("arguments", String[].class.getName(), false, false, false, CommI18NFactory.getMsg().getMsg("StartCommand.arguments", new Object[0]));
    public static final ParameterDefinition PARAM_ENV = new ParameterDefinition("environmentVariables", String[].class.getName(), false, true, false, CommI18NFactory.getMsg().getMsg("StartCommand.environment-variables", new Object[0]));
    public static final ParameterDefinition PARAM_WORKING_DIR = new ParameterDefinition("workingDirectory", String.class.getName(), false, true, false, CommI18NFactory.getMsg().getMsg("StartCommand.working-directory", new Object[0]));
    public static final ParameterDefinition PARAM_OUTPUT_DIR = new ParameterDefinition("outputDirectory", String.class.getName(), false, false, false, CommI18NFactory.getMsg().getMsg("StartCommand.output-directory", new Object[0]));
    public static final ParameterDefinition PARAM_OUTPUT_FILE = new ParameterDefinition("outputFile", String.class.getName(), false, false, false, CommI18NFactory.getMsg().getMsg("StartCommand.output-file", new Object[0]));
    public static final ParameterDefinition PARAM_INPUT_DIR = new ParameterDefinition("inputDirectory", String.class.getName(), false, false, false, CommI18NFactory.getMsg().getMsg("StartCommand.input-directory", new Object[0]));
    public static final ParameterDefinition PARAM_INPUT_FILE = new ParameterDefinition("inputFile", String.class.getName(), false, false, false, CommI18NFactory.getMsg().getMsg("StartCommand.input-file", new Object[0]));
    public static final ParameterDefinition PARAM_WAIT_FOR_EXIT = new ParameterDefinition("waitForExit", Long.class.getName(), false, false, false, CommI18NFactory.getMsg().getMsg("StartCommand.wait-for-exit", new Object[0]));
    public static final ParameterDefinition PARAM_CAPTURE_OUTPUT = new ParameterDefinition("captureOutput", Boolean.class.getName(), false, false, false, CommI18NFactory.getMsg().getMsg("StartCommand.capture-output", new Object[0]));
    public static final ParameterDefinition PARAM_BACKUP_OUTPUT_FILE = new ParameterDefinition("backupOutputFile", Boolean.class.getName(), false, false, false, CommI18NFactory.getMsg().getMsg("StartCommand.backup-output-file", new Object[0]));
    private static final long serialVersionUID = 1L;

    public StartCommand() throws IllegalArgumentException, InvalidParameterDefinitionException {
    }

    public StartCommand(Map<String, Object> commandParameters) throws IllegalArgumentException, InvalidParameterDefinitionException {
        super(commandParameters);
    }

    public StartCommand(Command commandToTransform) {
        super(commandToTransform);
    }

    public String getProgramTitle() {
        return (String)this.getParameterValue(PARAM_PROGRAM_TITLE.getName());
    }

    public void setProgramTitle(String value) {
        if (value != null) {
            this.setParameterValue(PARAM_PROGRAM_TITLE.getName(), value);
        } else {
            this.removeParameterValue(PARAM_PROGRAM_TITLE.getName());
        }
    }

    public String getProgramExecutable() {
        return (String)this.getParameterValue(PARAM_PROGRAM_EXE.getName());
    }

    public void setProgramExecutable(String value) {
        this.setParameterValue(PARAM_PROGRAM_EXE.getName(), value);
    }

    public String getProgramDirectory() {
        return (String)this.getParameterValue(PARAM_PROGRAM_DIR.getName());
    }

    public void setProgramDirectory(String value) {
        this.setParameterValue(PARAM_PROGRAM_DIR.getName(), value);
    }

    public String[] getArguments() {
        return (String[])this.getParameterValue(PARAM_ARGS.getName());
    }

    public void setArguments(String[] value) {
        if (value != null) {
            this.setParameterValue(PARAM_ARGS.getName(), value);
        } else {
            this.removeParameterValue(PARAM_ARGS.getName());
        }
    }

    public String[] getEnvironment() {
        return (String[])this.getParameterValue(PARAM_ENV.getName());
    }

    public String[] getEnvironment(Properties properties) throws InvalidParameterValueException, IllegalArgumentException {
        if (properties == null) {
            throw new IllegalArgumentException("properties=null");
        }
        properties.clear();
        String[] envVarArray = this.getEnvironment();
        if (envVarArray != null) {
            for (int i = 0; i < envVarArray.length; ++i) {
                String envVarString = envVarArray[i];
                int equals = envVarString.indexOf(61);
                if (equals < 0) {
                    throw new InvalidParameterValueException(CommI18NFactory.getMsgWithLoggerLocale().getMsg("StartCommand.env-var-bad-format", new Object[]{envVarString}));
                }
                properties.setProperty(envVarString.substring(0, equals), envVarString.substring(equals + 1));
            }
        }
        return envVarArray;
    }

    public void setEnvironment(String[] value) {
        this.setParameterValue(PARAM_ENV.getName(), value);
    }

    public void setEnvironment(Properties value) {
        String[] env = null;
        if (value != null) {
            env = new String[value.size()];
            Enumeration<?> propNames = value.propertyNames();
            int i = 0;
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propValue = value.getProperty(propName);
                env[i] = propName + "=" + propValue;
                ++i;
            }
        }
        this.setEnvironment(env);
    }

    public String getWorkingDirectory() {
        return (String)this.getParameterValue(PARAM_WORKING_DIR.getName());
    }

    public void setWorkingDirectory(String value) {
        this.setParameterValue(PARAM_WORKING_DIR.getName(), value);
    }

    public String getOutputDirectory() {
        return (String)this.getParameterValue(PARAM_OUTPUT_DIR.getName());
    }

    public void setOutputDirectory(String value) {
        if (value != null) {
            this.setParameterValue(PARAM_OUTPUT_DIR.getName(), value);
        } else {
            this.removeParameterValue(PARAM_OUTPUT_DIR.getName());
        }
    }

    public String getOutputFile() {
        return (String)this.getParameterValue(PARAM_OUTPUT_FILE.getName());
    }

    public void setOutputFile(String value) {
        if (value != null) {
            this.setParameterValue(PARAM_OUTPUT_FILE.getName(), value);
        } else {
            this.removeParameterValue(PARAM_OUTPUT_FILE.getName());
        }
    }

    public String getInputDirectory() {
        return (String)this.getParameterValue(PARAM_INPUT_DIR.getName());
    }

    public void setInputDirectory(String value) {
        if (value != null) {
            this.setParameterValue(PARAM_INPUT_DIR.getName(), value);
        } else {
            this.removeParameterValue(PARAM_INPUT_DIR.getName());
        }
    }

    public String getInputFile() {
        return (String)this.getParameterValue(PARAM_INPUT_FILE.getName());
    }

    public void setInputFile(String value) {
        if (value != null) {
            this.setParameterValue(PARAM_INPUT_FILE.getName(), value);
        } else {
            this.removeParameterValue(PARAM_INPUT_FILE.getName());
        }
    }

    public Long getWaitForExit() {
        return (Long)this.getParameterValue(PARAM_WAIT_FOR_EXIT.getName());
    }

    public void setWaitForExit(Long value) {
        if (value != null) {
            this.setParameterValue(PARAM_WAIT_FOR_EXIT.getName(), value);
        } else {
            this.removeParameterValue(PARAM_WAIT_FOR_EXIT.getName());
        }
    }

    public Boolean isCaptureOutput() {
        return (Boolean)this.getParameterValue(PARAM_CAPTURE_OUTPUT.getName());
    }

    public void setCaptureOutput(Boolean value) {
        if (value != null) {
            this.setParameterValue(PARAM_CAPTURE_OUTPUT.getName(), value);
        } else {
            this.removeParameterValue(PARAM_CAPTURE_OUTPUT.getName());
        }
    }

    public Boolean isBackupOutputFile() {
        return (Boolean)this.getParameterValue(PARAM_BACKUP_OUTPUT_FILE.getName());
    }

    public void setBackupOutputFile(Boolean value) {
        if (value != null) {
            this.setParameterValue(PARAM_BACKUP_OUTPUT_FILE.getName(), value);
        } else {
            this.removeParameterValue(PARAM_BACKUP_OUTPUT_FILE.getName());
        }
    }

    @Override
    public void checkParameterValidity(boolean convertIfNecessary) throws InvalidParameterValueException {
        boolean inputFileSpecified;
        boolean inputDirSpecified = this.getParameterValue(PARAM_INPUT_DIR.getName()) != null;
        boolean bl = inputFileSpecified = this.getParameterValue(PARAM_INPUT_FILE.getName()) != null;
        if (inputDirSpecified ^ inputFileSpecified) {
            throw new InvalidParameterValueException(CommI18NFactory.getMsg().getMsg("StartCommand.bad-input-params", new Object[]{this.toString()}));
        }
        super.checkParameterValidity(convertIfNecessary);
    }

    @Override
    protected CommandType buildCommandType() {
        return COMMAND_TYPE;
    }

    @Override
    protected ParameterDefinition[] buildParameterDefinitions() {
        return new ParameterDefinition[]{PARAM_PROGRAM_TITLE, PARAM_PROGRAM_EXE, PARAM_PROGRAM_DIR, PARAM_ARGS, PARAM_ENV, PARAM_WORKING_DIR, PARAM_OUTPUT_DIR, PARAM_OUTPUT_FILE, PARAM_INPUT_DIR, PARAM_INPUT_FILE, PARAM_WAIT_FOR_EXIT, PARAM_CAPTURE_OUTPUT, PARAM_BACKUP_OUTPUT_FILE};
    }
}

