/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.server;

import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.remoting.transport.ConnectorMBean;
import org.rhq.enterprise.communications.ServiceContainer;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderConfiguration;
import org.rhq.enterprise.communications.command.client.RemoteInputStream;
import org.rhq.enterprise.communications.command.client.RemoteOutputStream;
import org.rhq.enterprise.communications.command.server.CommandMBean;
import org.rhq.enterprise.communications.command.server.CommandServiceId;
import org.rhq.enterprise.communications.command.server.CommandServiceMBean;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public abstract class CommandService
extends CommandMBean
implements CommandServiceMBean {
    private ServiceContainer m_container = null;

    public ObjectName preRegister(MBeanServer mbs, ObjectName name) throws Exception {
        if (!"command".equals(name.getKeyProperty("type"))) {
            String errorMsg = CommI18NFactory.getMsgWithLoggerLocale().getMsg("CommandService.invalid-cmd-service-name", new Object[]{name, "type", "command"});
            throw new IllegalArgumentException(errorMsg);
        }
        return super.preRegister(mbs, name);
    }

    public ServiceContainer getServiceContainer() {
        return this.m_container;
    }

    public void setServiceContainer(ServiceContainer container) {
        this.m_container = container;
    }

    protected ConnectorMBean getConnector() throws Exception {
        ConnectorMBean connector = MBeanServerInvocationHandler.newProxyInstance(this.getMBeanServer(), ServiceContainer.OBJECTNAME_CONNECTOR, ConnectorMBean.class, false);
        return connector;
    }

    protected String getSubsystem() {
        ObjectName obj_name = this.getObjectName();
        String subsystem = null;
        if (obj_name != null) {
            subsystem = obj_name.getKeyProperty("subsystem");
        }
        return subsystem;
    }

    protected CommandServiceId getCommandServiceId() {
        String index;
        ObjectName obj_name = this.getObjectName();
        CommandServiceId id = null;
        if (obj_name != null && (index = obj_name.getKeyProperty("id")) != null) {
            id = new CommandServiceId(index);
        }
        return id;
    }

    protected void prepareRemoteInputStream(RemoteInputStream remote_stream) {
        String server_endpoint = remote_stream.getServerEndpoint();
        ClientCommandSenderConfiguration config = this.getServiceContainer().getClientConfiguration();
        config.commandSpoolFileName = null;
        config.enableQueueThrottling = false;
        config.enableSendThrottling = false;
        config.serverPollingIntervalMillis = 0L;
        config.maxConcurrent = 1;
        ClientCommandSender sender = this.getServiceContainer().createClientCommandSender(server_endpoint, config);
        sender.startSending();
        remote_stream.setClientCommandSender(sender);
    }

    protected void prepareRemoteOutputStream(RemoteOutputStream remote_stream) {
        String server_endpoint = remote_stream.getServerEndpoint();
        ClientCommandSenderConfiguration config = this.getServiceContainer().getClientConfiguration();
        config.commandSpoolFileName = null;
        config.enableQueueThrottling = false;
        config.enableSendThrottling = false;
        config.serverPollingIntervalMillis = 0L;
        config.maxConcurrent = 1;
        ClientCommandSender sender = this.getServiceContainer().createClientCommandSender(server_endpoint, config);
        sender.startSending();
        remote_stream.setClientCommandSender(sender);
    }
}

