/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandProcessorMetrics
implements Serializable {
    private static final long serialVersionUID = 1L;
    long numberSuccessfulCommands = 0L;
    long numberFailedCommands = 0L;
    long numberDroppedCommands = 0L;
    long numberNotProcessedCommands = 0L;
    long averageExecutionTime = 0L;
    private Map<String, Calltime> calltimes = new HashMap<String, Calltime>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock();
        try {
            this.numberSuccessfulCommands = 0L;
            this.numberFailedCommands = 0L;
            this.numberDroppedCommands = 0L;
            this.numberNotProcessedCommands = 0L;
            this.averageExecutionTime = 0L;
            this.calltimes.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Calltime> getCallTimeData() {
        this.readLock();
        try {
            HashMap<String, Calltime> hashMap = new HashMap<String, Calltime>(this.calltimes);
            return hashMap;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumberFailedCommands() {
        this.readLock();
        try {
            long l = this.numberFailedCommands;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumberDroppedCommands() {
        this.readLock();
        try {
            long l = this.numberDroppedCommands;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumberNotProcessedCommands() {
        this.readLock();
        try {
            long l = this.numberNotProcessedCommands;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumberSuccessfulCommands() {
        this.readLock();
        try {
            long l = this.numberSuccessfulCommands;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAverageExecutionTime() {
        this.readLock();
        try {
            long l = this.averageExecutionTime;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    void addCallTimeData(String type, long executionTime, UnsuccessfulReason unsuccessfulReason) {
        Calltime calltime = this.calltimes.get(type);
        if (calltime == null) {
            calltime = new Calltime();
            this.calltimes.put(type, calltime);
        }
        calltime.count++;
        if (unsuccessfulReason != null) {
            if (unsuccessfulReason == UnsuccessfulReason.DROPPED) {
                calltime.dropped++;
            } else if (unsuccessfulReason == UnsuccessfulReason.NOT_PROCESSED) {
                calltime.unprocessed++;
            } else {
                calltime.failures++;
            }
        } else {
            if (executionTime > calltime.max) {
                calltime.max = executionTime;
            }
            if (executionTime < calltime.min) {
                calltime.min = executionTime;
            }
            long successes = calltime.getSuccesses();
            calltime.avg = ((successes - 1L) * calltime.avg + executionTime) / successes;
        }
    }

    boolean writeLock() {
        try {
            return this.lock.writeLock().tryLock(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            this.lock = new ReentrantReadWriteLock();
        }
        return false;
    }

    void writeUnlock() {
        try {
            this.lock.writeLock().unlock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean readLock() {
        try {
            return this.lock.readLock().tryLock(30L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void readUnlock() {
        try {
            this.lock.readLock().unlock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class Calltime
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long count = 0L;
        private long failures = 0L;
        private long dropped = 0L;
        private long unprocessed = 0L;
        private long min = Long.MAX_VALUE;
        private long max = Long.MIN_VALUE;
        private long avg = 0L;

        public long getCount() {
            return this.count;
        }

        public long getFailures() {
            return this.failures;
        }

        public long getDropped() {
            return this.dropped;
        }

        public long getNotProcessed() {
            return this.unprocessed;
        }

        public long getSuccesses() {
            return this.count - (this.failures + this.dropped + this.unprocessed);
        }

        public long getMinimum() {
            return this.min;
        }

        public long getMaximum() {
            return this.max;
        }

        public long getAverage() {
            return this.avg;
        }

        public String toString() {
            return "" + this.count + ':' + this.failures + ':' + this.dropped + ':' + this.unprocessed + ':' + this.min + ':' + this.max + ':' + this.avg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnsuccessfulReason {
        FAILED,
        DROPPED,
        NOT_PROCESSED;

    }
}

