/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.util.prefs;

import java.io.PrintWriter;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.prefs.SetupValidityChecker;

public class RegexSetupValidityChecker
implements SetupValidityChecker {
    private Pattern pattern;
    private String resourceKeyName;
    private Object[] resourceKeyArguments;

    public RegexSetupValidityChecker(String regexPattern, String resourceKeyName, Object ... resourceKeyArguments) {
        this.pattern = Pattern.compile(regexPattern);
        this.resourceKeyName = resourceKeyName;
        this.resourceKeyArguments = resourceKeyArguments;
    }

    public RegexSetupValidityChecker(String regexPattern, int flags, String resourceKeyName, Object ... resourceKeyArguments) {
        this.pattern = Pattern.compile(regexPattern, flags);
        this.resourceKeyName = resourceKeyName;
        this.resourceKeyArguments = resourceKeyArguments;
    }

    @Override
    public boolean checkValidity(String pref_name, String value_to_check, Preferences preferences, PrintWriter out) {
        try {
            boolean matches = this.pattern.matcher(value_to_check).matches();
            if (!matches) {
                out.println(CommI18NFactory.getMsg().getMsg(this.resourceKeyName, this.resourceKeyArguments));
                return false;
            }
        }
        catch (PatternSyntaxException pse) {
            out.println(CommI18NFactory.getMsg().getMsg(this.resourceKeyName, this.resourceKeyArguments));
            return false;
        }
        return true;
    }
}

