/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.util.prefs;

import java.io.PrintWriter;
import java.util.prefs.Preferences;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.prefs.SetupValidityChecker;

public class LongSetupValidityChecker
implements SetupValidityChecker {
    private Long m_min;
    private Long m_max;

    public LongSetupValidityChecker(Long min_value_allowed, Long max_value_allowed) {
        this.m_min = min_value_allowed;
        this.m_max = max_value_allowed;
    }

    @Override
    public boolean checkValidity(String pref_name, String value_to_check, Preferences preferences, PrintWriter out) {
        try {
            long new_long = Long.parseLong(value_to_check);
            if (this.m_min != null && new_long < this.m_min) {
                out.println(CommI18NFactory.getMsg().getMsg("Setup.number-checker.too-low", new Object[]{value_to_check, this.m_min}));
                return false;
            }
            if (this.m_max != null && new_long > this.m_max) {
                out.println(CommI18NFactory.getMsg().getMsg("Setup.number-checker.too-high", new Object[]{value_to_check, this.m_max}));
                return false;
            }
        }
        catch (NumberFormatException e) {
            out.println(CommI18NFactory.getMsg().getMsg("Setup.long-checker.not-a-long", new Object[]{value_to_check}));
            return false;
        }
        return true;
    }
}

