/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.rhq.enterprise.communications.command.client.CommandQueue;
import org.rhq.enterprise.communications.command.client.PersistentFifo;

public class ClientCommandSenderMetrics {
    private final CommandQueue queue;
    private final PersistentFifo commandStore;
    private ThreadPoolExecutor threadPool;
    AtomicBoolean sendingMode = new AtomicBoolean(false);
    AtomicLong queueThrottleMaxCommands = new AtomicLong(0L);
    AtomicLong queueThrottleBurstPeriodMillis = new AtomicLong(0L);
    AtomicLong sendThrottleMaxCommands = new AtomicLong(0L);
    AtomicLong sendThrottleQuietPeriodDurationMillis = new AtomicLong(0L);
    AtomicLong successfulCommands = new AtomicLong(0L);
    AtomicLong failedCommands = new AtomicLong(0L);
    AtomicLong averageExecutionTime = new AtomicLong(0L);

    public ClientCommandSenderMetrics(CommandQueue queue, PersistentFifo commandStore, ThreadPoolExecutor threadPool) {
        this.queue = queue;
        this.commandStore = commandStore;
        this.setThreadPool(threadPool);
    }

    public ClientCommandSenderMetrics() {
        this(null, null, null);
    }

    void setThreadPool(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
    }

    public long getNumberCommandsActive() {
        long num = 0L;
        if (this.threadPool != null) {
            num = this.threadPool.getActiveCount();
        }
        return num;
    }

    public long getNumberSuccessfulCommandsSent() {
        return this.successfulCommands.get();
    }

    public long getNumberFailedCommandsSent() {
        return this.failedCommands.get();
    }

    public long getAverageExecutionTimeSent() {
        return this.averageExecutionTime.get();
    }

    public long getNumberCommandsInQueue() {
        return this.queue != null ? (long)this.queue.size() : 0L;
    }

    public long getNumberCommandsSpooled() {
        long num = 0L;
        if (this.commandStore != null) {
            try {
                num = this.commandStore.count();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return num;
    }

    public boolean isSending() {
        return this.sendingMode.get();
    }

    public long getQueueThrottleMaxCommands() {
        return this.queueThrottleMaxCommands.get();
    }

    public long getQueueThrottleBurstPeriodMillis() {
        return this.queueThrottleBurstPeriodMillis.get();
    }

    public long getSendThrottleMaxCommands() {
        return this.sendThrottleMaxCommands.get();
    }

    public long getSendThrottleQuietPeriodDurationMillis() {
        return this.sendThrottleQuietPeriodDurationMillis.get();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Sender Metrics: [");
        buf.append("is-sending=" + this.isSending());
        buf.append(",num-successful-commands-sent=" + this.getNumberSuccessfulCommandsSent());
        buf.append(",num-failed-commands-sent=" + this.getNumberFailedCommandsSent());
        buf.append(",avg-execution-time=" + this.getAverageExecutionTimeSent());
        buf.append(",num-commands-in-queue=" + this.getNumberCommandsInQueue());
        buf.append(",num-commands-spooled=" + this.getNumberCommandsSpooled());
        buf.append(",queue-throttle-max-commands=" + this.getQueueThrottleMaxCommands());
        buf.append(",queue-throttle-burst-period=" + this.getQueueThrottleBurstPeriodMillis());
        buf.append(",send-throttle-max-commands=" + this.getSendThrottleMaxCommands());
        buf.append(",send-throttle-max-commands=" + this.getSendThrottleMaxCommands());
        buf.append(']');
        return buf.toString();
    }
}

