/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertDefinitionContext;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.alert.notification.EmailNotification;
import org.rhq.core.domain.alert.notification.RoleNotification;
import org.rhq.core.domain.alert.notification.SnmpNotification;
import org.rhq.core.domain.alert.notification.SubjectNotification;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PersistenceUtility;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.InvalidAlertDefinitionException;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RoleManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class AlertNotificationManagerBean
implements AlertNotificationManagerLocal {
    private static final Log LOG = LogFactory.getLog(AlertNotificationManagerBean.class);
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    private AlertTemplateManagerLocal alertTemplateManager;
    @EJB
    private GroupAlertDefinitionManagerLocal groupAlertDefintionManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private RoleManagerLocal roleManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    private AlertDefinition getDetachedAlertDefinition(int alertDefinitionId) {
        AlertDefinition alertDefinition = this.alertDefinitionManager.getAlertDefinitionById(this.subjectManager.getOverlord(), alertDefinitionId);
        this.checkPermission(this.subjectManager.getOverlord(), alertDefinition);
        AlertDefinitionContext context = alertDefinition.getContext();
        if (context == AlertDefinitionContext.Resource) {
            return alertDefinition;
        }
        AlertDefinition detachedDefinition = new AlertDefinition(alertDefinition, true);
        detachedDefinition.setContext(context);
        detachedDefinition.setId(alertDefinition.getId());
        return detachedDefinition;
    }

    private void checkPermission(Subject subject, AlertDefinition alertDefinition) {
        boolean hasPermission = false;
        hasPermission = alertDefinition.getResourceType() != null ? this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS) : (alertDefinition.getResourceGroup() != null ? this.authorizationManager.hasGroupPermission(subject, Permission.MANAGE_ALERTS, alertDefinition.getResourceGroup().getId()) : this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_ALERTS, alertDefinition.getResource().getId()));
        if (!hasPermission) {
            throw new PermissionException(subject + " is not authorized to edit this alert definition");
        }
    }

    @Override
    public int addEmailNotifications(Subject subject, Integer alertDefinitionId, String[] emails) {
        AlertDefinition alertDefinition = this.getDetachedAlertDefinition(alertDefinitionId);
        Set notifications = alertDefinition.getAlertNotifications();
        int added = 0;
        for (String emailAddress : emails) {
            EmailNotification notification;
            if ((emailAddress = emailAddress.toLowerCase().trim()).equals("") || notifications.contains(notification = new EmailNotification(alertDefinition, emailAddress))) continue;
            ++added;
            notifications.add(notification);
        }
        this.postProcessAlertDefinition(alertDefinition);
        return added;
    }

    @Override
    public PageList<EmailNotification> getEmailNotifications(Integer alertDefinitionId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("en.emailAddress");
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"EmailNotification.findAllByAlertDefinitionId");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"EmailNotification.findAllByAlertDefinitionId", (PageControl)pageControl);
        queryCount.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        query.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        long count = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<EmailNotification> getEmailNotifications(Integer[] alertNotificationIds, PageControl pageControl) {
        pageControl.initDefaultOrderingField("en.emailAddress");
        if (alertNotificationIds == null || alertNotificationIds.length == 0) {
            return new PageList((Collection)Collections.EMPTY_LIST, 0, pageControl);
        }
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"EmailNotification.findByIds");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"EmailNotification.findByIds", (PageControl)pageControl);
        queryCount.setParameter("ids", (Object)alertNotificationIds);
        query.setParameter("ids", (Object)alertNotificationIds);
        long count = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public int addRoleNotifications(Subject subject, Integer alertDefinitionId, Integer[] roleIds) {
        AlertDefinition alertDefinition = this.getDetachedAlertDefinition(alertDefinitionId);
        Set notifications = alertDefinition.getAlertNotifications();
        PageList<Role> roles = this.roleManager.findRolesByIds(roleIds, PageControl.getUnlimitedInstance());
        int added = 0;
        for (Role role : roles) {
            RoleNotification notification = new RoleNotification(alertDefinition, role);
            if (notifications.contains(notification)) continue;
            ++added;
            notifications.add(notification);
        }
        this.postProcessAlertDefinition(alertDefinition);
        return added;
    }

    @Override
    public PageList<RoleNotification> getRoleNotifications(Integer alertDefinitionId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("rn.role.name");
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"RoleNotification.findAllByAlertDefinitionId");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"RoleNotification.findAllByAlertDefinitionId", (PageControl)pageControl);
        queryCount.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        query.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        long count = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<RoleNotification> getRoleNotifications(Integer[] alertNotificationIds, PageControl pageControl) {
        pageControl.initDefaultOrderingField("rn.role.name");
        if (alertNotificationIds == null || alertNotificationIds.length == 0) {
            return new PageList((Collection)Collections.EMPTY_LIST, 0, pageControl);
        }
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"RoleNotification.findByIds");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"RoleNotification.findByIds", (PageControl)pageControl);
        queryCount.setParameter("ids", (Object)alertNotificationIds);
        query.setParameter("ids", (Object)alertNotificationIds);
        long count = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<RoleNotification> getRoleNotificationsByRoles(Integer[] roleIds, PageControl pageControl) {
        pageControl.initDefaultOrderingField("rn.role.name");
        if (roleIds == null || roleIds.length == 0) {
            return new PageList((Collection)Collections.EMPTY_LIST, 0, pageControl);
        }
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"SubjectNotification.findByRoleIds");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"SubjectNotification.findByRoleIds", (PageControl)pageControl);
        queryCount.setParameter("ids", (Object)roleIds);
        query.setParameter("ids", (Object)roleIds);
        long count = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public int addSubjectNotifications(Subject user, Integer alertDefinitionId, Integer[] subjectIds) {
        AlertDefinition alertDefinition = this.getDetachedAlertDefinition(alertDefinitionId);
        Set notifications = alertDefinition.getAlertNotifications();
        PageList<Subject> subjects = this.subjectManager.findSubjectsById(subjectIds, PageControl.getUnlimitedInstance());
        int added = 0;
        for (Subject subject : subjects) {
            SubjectNotification notification = new SubjectNotification(alertDefinition, subject);
            if (notifications.contains(notification)) continue;
            ++added;
            notifications.add(notification);
        }
        this.postProcessAlertDefinition(alertDefinition);
        return added;
    }

    @Override
    public PageList<SubjectNotification> getSubjectNotifications(Integer alertDefinitionId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("sn.subject.name");
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"SubjectNotification.findAllByAlertDefinitionId");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"SubjectNotification.findAllByAlertDefinitionId", (PageControl)pageControl);
        queryCount.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        query.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        long count = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<SnmpNotification> getSnmpNotifications(Integer alertDefinitionId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("sn.host");
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"SnmpNotification.findAllByAlertDefinitionId");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"SnmpNotification.findAllByAlertDefinitionId", (PageControl)pageControl);
        queryCount.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        query.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        long count = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<SubjectNotification> getSubjectNotifications(Integer[] alertNotificationIds, PageControl pageControl) {
        pageControl.initDefaultOrderingField("sn.subject.name");
        if (alertNotificationIds == null || alertNotificationIds.length == 0) {
            return new PageList((Collection)Collections.EMPTY_LIST, 0, pageControl);
        }
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"SubjectNotification.findByIds");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"SubjectNotification.findByIds", (PageControl)pageControl);
        queryCount.setParameter("ids", (Object)alertNotificationIds);
        query.setParameter("ids", (Object)alertNotificationIds);
        long count = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<SubjectNotification> getSubjectNotificationsBySubjects(Integer[] subjectIds, PageControl pageControl) {
        pageControl.initDefaultOrderingField("rn.role.name");
        if (subjectIds == null || subjectIds.length == 0) {
            return new PageList((Collection)Collections.EMPTY_LIST, 0, pageControl);
        }
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"SubjectNotification.findBySubjectIds");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"SubjectNotification.findBySubjectIds", (PageControl)pageControl);
        queryCount.setParameter("ids", (Object)subjectIds);
        query.setParameter("ids", (Object)subjectIds);
        long count = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public int removeNotifications(Subject subject, Integer alertDefinitionId, Integer[] notificationIds) {
        AlertDefinition alertDefinition = this.getDetachedAlertDefinition(alertDefinitionId);
        if (notificationIds == null || notificationIds.length == 0) {
            return 0;
        }
        HashSet<Integer> notificationIdSet = new HashSet<Integer>(Arrays.asList(notificationIds));
        ArrayList notifications = new ArrayList(alertDefinition.getAlertNotifications());
        ArrayList<AlertNotification> toBeRemoved = new ArrayList<AlertNotification>();
        int removed = 0;
        for (AlertNotification notification : notifications) {
            if (!notificationIdSet.contains(notification.getId())) continue;
            toBeRemoved.add(notification);
            --removed;
        }
        alertDefinition.getAlertNotifications().removeAll(toBeRemoved);
        this.postProcessAlertDefinition(alertDefinition);
        return removed;
    }

    @Override
    public void setSnmpNotification(Subject subject, Integer alertDefinitionId, SnmpNotification snmpNotification) {
        AlertDefinition alertDefinition = this.getDetachedAlertDefinition(alertDefinitionId);
        Set alertNotifications = alertDefinition.getAlertNotifications();
        for (AlertNotification alertNotification : alertNotifications) {
            if (!(alertNotification instanceof SnmpNotification)) continue;
            alertNotifications.remove(alertNotification);
        }
        alertNotifications.add(snmpNotification);
        this.postProcessAlertDefinition(alertDefinition);
    }

    @Override
    public int purgeOrphanedAlertNotifications() {
        Query purgeQuery = this.entityManager.createNamedQuery("AlertNotification.deleteOrphaned");
        return purgeQuery.executeUpdate();
    }

    private void postProcessAlertDefinition(AlertDefinition definition) {
        AlertDefinitionContext context = definition.getContext();
        if (context == AlertDefinitionContext.Type) {
            try {
                this.alertTemplateManager.updateAlertTemplate(this.subjectManager.getOverlord(), definition, true);
            }
            catch (InvalidAlertDefinitionException iade) {
                LOG.error((Object)("Can not update alert template, invalid definition: " + definition));
            }
        } else if (context == AlertDefinitionContext.Group) {
            try {
                this.groupAlertDefintionManager.updateGroupAlertDefinitions(this.subjectManager.getOverlord(), definition, true);
            }
            catch (InvalidAlertDefinitionException iade) {
                LOG.error((Object)("Can not update alert template, invalid definition: " + definition));
            }
        }
    }
}

