/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.resource.Agent;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.cloud.CloudManagerLocal;
import org.rhq.enterprise.server.cloud.StatusManagerLocal;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class StatusManagerBean
implements StatusManagerLocal {
    private final Log log = LogFactory.getLog(StatusManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    AgentManagerLocal agentManager;
    @EJB
    @IgnoreDependency
    ServerManagerLocal serverManager;
    @EJB
    @IgnoreDependency
    CloudManagerLocal cloudManager;
    @EJB
    @IgnoreDependency
    AlertDefinitionManagerLocal alertDefinitionManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<Integer> getAndClearAgentsWithStatusForServer(String serverName) {
        Query selectQuery = this.entityManager.createNamedQuery("Agent.findAllWithStatusByServer");
        selectQuery.setParameter("serverName", (Object)serverName);
        List agentIds = selectQuery.getResultList();
        if (agentIds.size() > 0) {
            Query updateQuery = this.entityManager.createNamedQuery("Agent.updateClearStatusByIds");
            updateQuery.setParameter("agentIds", (Object)agentIds);
            updateQuery.executeUpdate();
        }
        return agentIds;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateByAlertDefinition(int alertDefinitionId) {
        if (this.alertDefinitionManager.isTemplate(alertDefinitionId)) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            Server server = this.serverManager.getServer();
            server.addStatus(Server.Status.ALERT_DEFINITION);
            this.log.debug((Object)("Marking status, server[id=" + server.getId() + ", status=" + server.getStatus() + "] for alertDefinition[id=" + alertDefinitionId + "]"));
            AlertDefinition definition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefinitionId);
            Agent agent = this.agentManager.getAgentByResourceId(definition.getResource().getId());
            agent.addStatus(Agent.Status.ALERT_DEFINITION);
            this.log.debug((Object)("Marking status, agent[id=" + agent.getId() + ", status=" + agent.getStatus() + "] for alertDefinition[id=" + alertDefinitionId + "]"));
        } else {
            Query updateServerQuery = this.entityManager.createNamedQuery("Server.updateStatusByName");
            updateServerQuery.setParameter("identity", (Object)this.serverManager.getIdentity());
            updateServerQuery.executeUpdate();
            Query updateAgentQuery = this.entityManager.createNamedQuery("Agent.updateStatusByAlertDefinition");
            updateAgentQuery.setParameter("alertDefinitionId", (Object)alertDefinitionId);
            updateAgentQuery.executeUpdate();
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateByMeasurementBaseline(int baselineId) {
        if (this.log.isDebugEnabled()) {
            MeasurementBaseline baseline = (MeasurementBaseline)this.entityManager.find(MeasurementBaseline.class, (Object)baselineId);
            Agent agent = baseline.getSchedule().getResource().getAgent();
            agent.addStatus(Agent.Status.BASELINES_CALCULATED);
            this.log.debug((Object)("Marking status, agent[id=" + agent.getId() + ", status=" + agent.getStatus() + "] for measurementBaseline[id=" + baselineId + "]"));
        } else {
            Query updateAgentQuery = this.entityManager.createNamedQuery("Agent.updateStatusByMeasurementBasleine");
            updateAgentQuery.setParameter("baselineId", (Object)baselineId);
            updateAgentQuery.executeUpdate();
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateByAgent(int agentId) {
        if (this.log.isDebugEnabled()) {
            Agent agent = (Agent)this.entityManager.find(Agent.class, (Object)agentId);
            agent.addStatus(Agent.Status.RESOURCE_HIERARCHY_UPDATED);
            this.log.debug((Object)("Marking status, agent[id=" + agent.getId() + ", status=" + agent.getStatus() + "]"));
        } else {
            Query updateAgentQuery = this.entityManager.createNamedQuery("Agent.updateStatusByAgent");
            updateAgentQuery.setParameter("agentId", (Object)agentId);
            updateAgentQuery.executeUpdate();
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateByAutoBaselineCalculationJob() {
        if (this.log.isDebugEnabled()) {
            List<Agent> agents = this.agentManager.getAllAgents();
            for (Agent agent : agents) {
                agent.addStatus(Agent.Status.BASELINES_CALCULATED);
                this.log.debug((Object)("Marking status, agent[id=" + agent.getId() + ", status=" + agent.getStatus() + "] for AutoBaselineCalculationJob"));
            }
        } else {
            Query updateAgentQuery = this.entityManager.createNamedQuery("Agent.updateStatusForAll");
            updateAgentQuery.executeUpdate();
        }
    }
}

