/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.content.Channel;
import org.rhq.core.domain.content.ChannelContentSource;
import org.rhq.core.domain.content.ChannelPackageVersion;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.PackageVersionContentSource;
import org.rhq.core.domain.content.ResourceChannel;
import org.rhq.core.domain.content.composite.ChannelComposite;
import org.rhq.core.domain.criteria.ChannelCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.PackageVersionCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.CriteriaQueryGenerator;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PersistenceUtility;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.content.ChannelException;
import org.rhq.enterprise.server.content.ChannelManagerLocal;
import org.rhq.enterprise.server.content.ChannelManagerRemote;
import org.rhq.enterprise.server.content.ContentManagerHelper;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class ChannelManagerBean
implements ChannelManagerLocal,
ChannelManagerRemote {
    private final Log log = LogFactory.getLog(ChannelManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authzManager;
    @EJB
    private ContentSourceManagerLocal contentSourceManager;

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteChannel(Subject subject, int channelId) {
        this.log.debug((Object)("User [" + subject + "] is deleting channel [" + channelId + "]"));
        this.entityManager.flush();
        this.entityManager.clear();
        this.entityManager.createNamedQuery("ResourceChannel.deleteByChannelId").setParameter("channelId", (Object)channelId).executeUpdate();
        this.entityManager.createNamedQuery("ChannelContentSource.deleteByChannelId").setParameter("channelId", (Object)channelId).executeUpdate();
        this.entityManager.createNamedQuery("ChannelPackageVersion.deleteByChannelId").setParameter("channelId", (Object)channelId).executeUpdate();
        Channel channel = (Channel)this.entityManager.find(Channel.class, (Object)channelId);
        if (channel != null) {
            this.entityManager.remove((Object)channel);
            this.log.debug((Object)("User [" + subject + "] deleted channel [" + channel + "]"));
        } else {
            this.log.debug((Object)("Channel ID [" + channelId + "] doesn't exist - nothing to delete"));
        }
        this.contentSourceManager.purgeOrphanedPackageVersions(subject);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Channel> findChannels(Subject subject, PageControl pc) {
        pc.initDefaultOrderingField("c.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Channel.findAll", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Channel.findAll");
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Channel getChannel(Subject subject, int channelId) {
        Channel channel = (Channel)this.entityManager.find(Channel.class, (Object)channelId);
        if (channel != null && channel.getChannelContentSources() != null) {
            channel.getChannelContentSources().size();
        }
        return channel;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<ContentSource> findAssociatedContentSources(Subject subject, int channelId, PageControl pc) {
        pc.initDefaultOrderingField("cs.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ContentSource.findByChannelId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ContentSource.findByChannelId");
        query.setParameter("id", (Object)channelId);
        countQuery.setParameter("id", (Object)channelId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Resource> findSubscribedResources(Subject subject, int channelId, PageControl pc) {
        pc.initDefaultOrderingField("rc.resource.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Channel.findSubscriberResources", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Channel.findSubscriberResources");
        query.setParameter("id", (Object)channelId);
        countQuery.setParameter("id", (Object)channelId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public PageList<ChannelComposite> findResourceSubscriptions(Subject subject, int resourceId, PageControl pc) {
        pc.initDefaultOrderingField("c.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Channel.findChannelCompositesByResourceId", (PageControl)pc);
        Query countQuery = this.entityManager.createNamedQuery("Channel.findChannelCompositesByResourceId_count");
        query.setParameter("resourceId", (Object)resourceId);
        countQuery.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<ChannelComposite> findAvailableResourceSubscriptions(Subject subject, int resourceId, PageControl pc) {
        pc.initDefaultOrderingField("c.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Channel.findAvailableChannelCompositesByResourceId", (PageControl)pc);
        Query countQuery = this.entityManager.createNamedQuery("Channel.findAvailableChannelCompositesByResourceId_count");
        query.setParameter("resourceId", (Object)resourceId);
        countQuery.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public List<ChannelComposite> findResourceSubscriptions(int resourceId) {
        Query query = this.entityManager.createNamedQuery("Channel.findChannelCompositesByResourceId");
        query.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<ChannelComposite> findAvailableResourceSubscriptions(int resourceId) {
        Query query = this.entityManager.createNamedQuery("Channel.findAvailableChannelCompositesByResourceId");
        query.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        return results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PackageVersion> findPackageVersionsInChannel(Subject subject, int channelId, PageControl pc) {
        pc.initDefaultOrderingField("pv.generalPackage.name, pv.version");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersion.findByChannelIdWithPackage", (PageControl)pc);
        query.setParameter("channelId", (Object)channelId);
        List results = query.getResultList();
        long count = this.getPackageVersionCountFromChannel(subject, null, channelId);
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PackageVersion> findPackageVersionsInChannel(Subject subject, int channelId, String filter, PageControl pc) {
        pc.initDefaultOrderingField("pv.generalPackage.name, pv.version");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersion.findByChannelIdWithPackageFiltered", (PageControl)pc);
        query.setParameter("channelId", (Object)channelId);
        query.setParameter("filter", (Object)PersistenceUtility.formatSearchParameter((String)filter));
        List results = query.getResultList();
        long count = this.getPackageVersionCountFromChannel(subject, filter, channelId);
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Channel updateChannel(Subject subject, Channel channel) throws ChannelException {
        if (channel.getName() == null || channel.getName().trim().equals("")) {
            throw new ChannelException("Channel name is required");
        }
        this.log.debug((Object)("User [" + subject + "] is updating channel [" + channel + "]"));
        channel = (Channel)this.entityManager.merge((Object)channel);
        this.log.debug((Object)("User [" + subject + "] updated channel [" + channel + "]"));
        return channel;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Channel createChannel(Subject subject, Channel channel) throws ChannelException {
        this.validateChannel(channel);
        this.log.debug((Object)("User [" + subject + "] is creating channel [" + channel + "]"));
        this.entityManager.persist((Object)channel);
        this.log.debug((Object)("User [" + subject + "] created channel [" + channel + "]"));
        return channel;
    }

    private void validateChannel(Channel c) throws ChannelException {
        if (c.getName() == null || c.getName().trim().equals("")) {
            throw new ChannelException("Channel name is required");
        }
        List<Channel> channels = this.getChannelByName(c.getName());
        if (channels.size() != 0) {
            throw new ChannelException("There is already a channel with the name of [" + c.getName() + "]");
        }
    }

    private List<Channel> getChannelByName(String name) {
        Query query = this.entityManager.createNamedQuery("Channel.findByName");
        query.setParameter("name", (Object)name);
        List results = query.getResultList();
        return results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void addContentSourcesToChannel(Subject subject, int channelId, int[] contentSourceIds) throws Exception {
        Channel channel = (Channel)this.entityManager.find(Channel.class, (Object)channelId);
        if (channel == null) {
            throw new Exception("There is no channel with an ID [" + channelId + "]");
        }
        channel.setLastModifiedDate(System.currentTimeMillis());
        this.log.debug((Object)("User [" + subject + "] is adding content sources to channel [" + channel + "]"));
        ContentSourcePluginContainer pc = ContentManagerHelper.getPluginContainer();
        Query q = this.entityManager.createNamedQuery("PackageVersionContentSource.findByContentSourceIdNoFetch");
        for (int id : contentSourceIds) {
            ContentSource cs = (ContentSource)this.entityManager.find(ContentSource.class, (Object)id);
            if (cs == null) {
                throw new Exception("There is no content source with id [" + id + "]");
            }
            ChannelContentSource ccsmapping = channel.addContentSource(cs);
            this.entityManager.persist((Object)ccsmapping);
            HashSet alreadyAssociatedPVs = new HashSet(channel.getPackageVersions());
            q.setParameter("id", (Object)cs.getId());
            List pvcss = q.getResultList();
            for (PackageVersionContentSource pvcs : pvcss) {
                PackageVersion pv = pvcs.getPackageVersionContentSourcePK().getPackageVersion();
                if (alreadyAssociatedPVs.contains(pv)) continue;
                ChannelPackageVersion mapping = new ChannelPackageVersion(channel, pv);
                this.entityManager.persist((Object)mapping);
            }
            this.entityManager.flush();
            this.entityManager.clear();
            pc.syncNow(cs);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void addPackageVersionsToChannel(Subject subject, int channelId, int[] packageVersionIds) {
        Channel channel = (Channel)this.entityManager.find(Channel.class, (Object)channelId);
        for (int packageVersionId : packageVersionIds) {
            PackageVersion packageVersion = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
            ChannelPackageVersion mapping = new ChannelPackageVersion(channel, packageVersion);
            this.entityManager.persist((Object)mapping);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void removeContentSourcesFromChannel(Subject subject, int channelId, int[] contentSourceIds) throws ChannelException {
        Channel channel = this.getChannel(subject, channelId);
        this.log.debug((Object)("User [" + subject + "] is removing content sources from channel [" + channel + "]"));
        Set currentSet = channel.getChannelContentSources();
        if (currentSet != null && currentSet.size() > 0) {
            HashSet<ChannelContentSource> toBeRemoved = new HashSet<ChannelContentSource>();
            block0: for (ChannelContentSource current : currentSet) {
                for (int id : contentSourceIds) {
                    if (id != current.getChannelContentSourcePK().getContentSource().getId()) continue;
                    toBeRemoved.add(current);
                    continue block0;
                }
            }
            for (ChannelContentSource doomed : toBeRemoved) {
                this.entityManager.remove((Object)doomed);
            }
            currentSet.removeAll(toBeRemoved);
        }
    }

    @Override
    public void subscribeResourceToChannels(Subject subject, int resourceId, int[] channelIds) {
        if (channelIds == null || channelIds.length == 0) {
            return;
        }
        if (!this.authzManager.hasResourcePermission(subject, Permission.MANAGE_CONTENT, resourceId)) {
            throw new PermissionException("[" + subject + "] does not have permission to subscribe this resource to channels");
        }
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (resource == null) {
            throw new RuntimeException("There is no resource with the ID [" + resourceId + "]");
        }
        Query q = this.entityManager.createNamedQuery("Channel.findByIds");
        ArrayList<Integer> idList = new ArrayList<Integer>(channelIds.length);
        int[] arr$ = channelIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer id = arr$[i$];
            idList.add(id);
        }
        q.setParameter("ids", idList);
        List channels = q.getResultList();
        if (channels.size() != channelIds.length) {
            throw new RuntimeException("One or more of the channels do not exist [" + idList + "]->[" + channels + "]");
        }
        for (Channel channel : channels) {
            ResourceChannel mapping = channel.addResource(resource);
            this.entityManager.persist((Object)mapping);
        }
    }

    @Override
    public void unsubscribeResourceFromChannels(Subject subject, int resourceId, int[] channelIds) {
        if (channelIds == null || channelIds.length == 0) {
            return;
        }
        if (!this.authzManager.hasResourcePermission(subject, Permission.MANAGE_CONTENT, resourceId)) {
            throw new PermissionException("[" + subject + "] does not have permission to unsubscribe this resource from channels");
        }
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (resource == null) {
            throw new RuntimeException("There is no resource with the ID [" + resourceId + "]");
        }
        Query q = this.entityManager.createNamedQuery("Channel.findByIds");
        ArrayList<Integer> idList = new ArrayList<Integer>(channelIds.length);
        int[] arr$ = channelIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer id = arr$[i$];
            idList.add(id);
        }
        q.setParameter("ids", idList);
        List channels = q.getResultList();
        if (channels.size() != channelIds.length) {
            throw new RuntimeException("One or more of the channels do not exist [" + idList + "]->[" + channels + "]");
        }
        for (Channel channel : channels) {
            ResourceChannel mapping = channel.removeResource(resource);
            this.entityManager.remove((Object)mapping);
        }
    }

    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public long getPackageVersionCountFromChannel(Subject subject, String filter, int channelId) {
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersion.findByChannelIdFiltered");
        countQuery.setParameter("channelId", (Object)channelId);
        countQuery.setParameter("filter", filter == null ? null : "%" + filter.toUpperCase() + "%");
        return (Long)countQuery.getSingleResult();
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public long getPackageVersionCountFromChannel(Subject subject, int channelId) {
        return this.getPackageVersionCountFromChannel(subject, null, channelId);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Channel> findChannelsByCriteria(Subject subject, ChannelCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        Query query = generator.getQuery(this.entityManager);
        Query countQuery = generator.getCountQuery(this.entityManager);
        long count = (Long)countQuery.getSingleResult();
        List channels = query.getResultList();
        return new PageList((Collection)channels, (int)count, criteria.getPageControl());
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PackageVersion> findPackageVersionsInChannelByCriteria(Subject subject, PackageVersionCriteria criteria) {
        Integer channelId = criteria.getFilterChannelId();
        if (null == channelId || channelId < 1) {
            throw new IllegalArgumentException("Illegal filterResourceId: " + channelId);
        }
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        Query query = generator.getQuery(this.entityManager);
        Query countQuery = generator.getCountQuery(this.entityManager);
        long count = (Long)countQuery.getSingleResult();
        List packageVersions = query.getResultList();
        return new PageList((Collection)packageVersions, (int)count, criteria.getPageControl());
    }
}

