/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content;

import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.mx.util.MBeanServerLocator;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginContainer;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginServiceManagement;

public class ContentManagerHelper {
    public static ContentSourcePluginContainer getPluginContainer() throws Exception {
        ContentSourcePluginContainer pc = null;
        try {
            MBeanServer mbs = MBeanServerLocator.locateJBoss();
            ObjectName name = ObjectNameFactory.create((String)"rhq.serverplugin:service=ContentSourcePluginService");
            Class<ContentSourcePluginServiceManagement> iface = ContentSourcePluginServiceManagement.class;
            ContentSourcePluginServiceManagement mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, iface, false);
            if (!mbean.isPluginContainerStarted()) {
                throw new IllegalStateException("The content source plugin container is not started!");
            }
            pc = mbean.getPluginContainer();
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (Exception e) {
            throw new Exception("Cannot obtain the content source plugin container", e);
        }
        if (pc == null) {
            throw new Exception("Content source plugin container is null!");
        }
        return pc;
    }

    public static ResourcePackageDetails installedPackageToDetails(InstalledPackage installedPackage) {
        PackageVersion packageVersion = installedPackage.getPackageVersion();
        ResourcePackageDetails details = ContentManagerHelper.packageVersionToDetails(packageVersion);
        return details;
    }

    public static ResourcePackageDetails packageVersionToDetails(PackageVersion packageVersion) {
        Package generalPackage = packageVersion.getGeneralPackage();
        PackageDetailsKey key = new PackageDetailsKey(generalPackage.getName(), packageVersion.getVersion(), packageVersion.getGeneralPackage().getPackageType().getName(), packageVersion.getArchitecture().getName());
        ResourcePackageDetails details = new ResourcePackageDetails(key);
        details.setClassification(generalPackage.getClassification());
        details.setDisplayName(packageVersion.getDisplayName());
        details.setFileCreatedDate(packageVersion.getFileCreatedDate());
        details.setFileName(packageVersion.getFileName());
        details.setFileSize(packageVersion.getFileSize());
        details.setLicenseName(packageVersion.getLicenseName());
        details.setLicenseVersion(packageVersion.getLicenseVersion());
        details.setLongDescription(packageVersion.getLongDescription());
        details.setMD5(packageVersion.getMD5());
        details.setMetadata(packageVersion.getMetadata());
        details.setSHA256(packageVersion.getSHA256());
        details.setShortDescription(packageVersion.getShortDescription());
        return details;
    }
}

