/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.rhq.enterprise.server.core.CoreServerMBean;

public class CoreServer
extends ServiceMBeanSupport
implements CoreServerMBean {
    private final Log log = LogFactory.getLog(CoreServer.class);
    private static final String VERSION_FILE = "rhq-server-version.properties";
    private static final String PROP_PRODUCT_VERSION = "Product-Version";
    private static final String PROP_BUILD_NUMBER = "Build-Number";
    private static final String PROP_BUILD_DATE = "Build-Date";
    private Properties buildProps;
    private Date bootTime;

    protected void createService() throws Exception {
        this.buildProps = this.loadBuildProperties();
        this.bootTime = new Date();
        String version = this.getVersion();
        String buildNumber = this.getBuildNumber();
        String buildDate = this.buildProps.getProperty(PROP_BUILD_DATE, "?");
        this.log.info((Object)("Version=[" + version + "], Build Number=[" + buildNumber + "], Build Date=[" + buildDate + "]"));
    }

    public String getName() {
        return "RHQ Server";
    }

    public String getVersion() {
        return this.buildProps.getProperty(PROP_PRODUCT_VERSION, "?");
    }

    public String getBuildNumber() {
        return this.buildProps.getProperty(PROP_BUILD_NUMBER, "?");
    }

    public Date getBootTime() {
        return this.bootTime;
    }

    private Properties loadBuildProperties() {
        Properties buildProps = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            InputStream stream = classLoader.getResourceAsStream(VERSION_FILE);
            buildProps.load(stream);
            stream.close();
        }
        catch (Exception e) {
            this.log.fatal((Object)("Failed to load [rhq-server-version.properties] via class loader [" + classLoader + "]"));
        }
        return buildProps;
    }
}

