/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.plugin;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.DeploymentState;
import org.jboss.deployment.SubDeployerSupport;
import org.rhq.core.clientapi.agent.metadata.PluginDependencyGraph;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.util.MD5Generator;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.core.concurrency.LatchedServiceCircularityException;
import org.rhq.enterprise.server.core.concurrency.LatchedServiceController;
import org.rhq.enterprise.server.core.concurrency.LatchedServiceException;
import org.rhq.enterprise.server.core.plugin.ProductPluginDeployerMBean;
import org.rhq.enterprise.server.license.LicenseManager;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.ResourceMetadataManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductPluginDeployer
extends SubDeployerSupport
implements ProductPluginDeployerMBean {
    public static final String AMPS_VERSION = "2.0";
    private static final String DEFAULT_PLUGIN_DESCRIPTOR_PATH = "META-INF/rhq-plugin.xml";
    private static final String PLUGIN_DESCRIPTOR_SCHEMA = "rhq-plugin.xsd";
    private Log log = LogFactory.getLog((String)ProductPluginDeployer.class.getName());
    private File pluginDir = null;
    private String licenseFile = null;
    private Map<String, DeploymentInfo> deploymentInfos = new HashMap<String, DeploymentInfo>();
    private Map<String, PluginDescriptor> pluginDescriptors = new HashMap<String, PluginDescriptor>();
    private Map<String, ComparableVersion> pluginVersions = new HashMap<String, ComparableVersion>();
    private Set<String> namesOfPluginsToBeRegistered = new HashSet<String>();
    private boolean isStarted = false;
    private boolean isReady = false;

    @Override
    public void setPluginDir(String pluginDirString) {
        this.pluginDir = new File(pluginDirString);
        if (!this.pluginDir.exists()) {
            this.pluginDir.mkdirs();
        }
    }

    @Override
    public String getPluginDir() {
        return this.pluginDir.getAbsolutePath();
    }

    @Override
    public List<String> getRegisteredPluginNames() {
        ResourceMetadataManagerLocal metadataManager = LookupUtil.getResourceMetadataManager();
        List<Plugin> plugins = metadataManager.getPlugins();
        ArrayList<String> pluginNames = new ArrayList<String>();
        for (Plugin plugin : plugins) {
            pluginNames.add(plugin.getName());
        }
        return pluginNames;
    }

    public void startService() throws Exception {
        if (!this.isStarted) {
            this.isStarted = true;
            super.startService();
        }
    }

    public void stopService() throws Exception {
        if (this.isStarted) {
            super.stopService();
            this.deploymentInfos.clear();
            this.pluginDescriptors.clear();
            this.pluginVersions.clear();
            this.namesOfPluginsToBeRegistered.clear();
            this.isStarted = false;
            this.isReady = false;
        }
    }

    public void create(DeploymentInfo deploymentInfo) throws DeploymentException {
        if (this.isLicenseFile(deploymentInfo)) {
            return;
        }
        String key = null;
        for (Map.Entry<String, DeploymentInfo> entry : this.deploymentInfos.entrySet()) {
            if (!entry.getValue().equals((Object)deploymentInfo)) continue;
            key = entry.getKey();
            break;
        }
        if (key != null) {
            this.deploymentInfos.put(key, deploymentInfo);
        }
        String name = this.preprocessPlugin(deploymentInfo);
        this.log.debug((Object)("CREATE: [" + deploymentInfo.localUrl + "]: plugin name=[" + name + "]"));
    }

    public void start(DeploymentInfo deploymentInfo) throws DeploymentException {
        if (this.isLicenseFile(deploymentInfo)) {
            return;
        }
        this.log.debug((Object)("START: [" + deploymentInfo.localUrl + "]"));
        if (this.isReady && this.areAllPluginsStarted(deploymentInfo)) {
            this.log.debug((Object)("Hot deploying plugin [" + deploymentInfo.url + "]..."));
            try {
                this.registerPlugins();
            }
            catch (Exception e) {
                throw new DeploymentException("Unable to deploy RHQ plugin [" + deploymentInfo.url + "]", (Throwable)e);
            }
        } else {
            this.log.debug((Object)("Not ready yet - will deploy plugin [" + deploymentInfo.url + "] later"));
        }
    }

    public void stop(DeploymentInfo deploymentInfo) throws DeploymentException {
        if (this.isLicenseFile(deploymentInfo)) {
            return;
        }
        this.log.debug((Object)("STOP: [" + deploymentInfo.localUrl + "]"));
    }

    public void destroy(DeploymentInfo deploymentInfo) throws DeploymentException {
        if (this.isLicenseFile(deploymentInfo)) {
            return;
        }
        this.log.debug((Object)("DESTROY: [" + deploymentInfo.localUrl + "]"));
    }

    public boolean accepts(DeploymentInfo di) {
        if (di.isDirectory) {
            return false;
        }
        String urlString = di.url.getFile();
        if (this.isLicenseFile(di)) {
            this.licenseFile = urlString;
            return true;
        }
        if (!urlString.endsWith(".jar")) {
            return false;
        }
        File deploymentDirectory = new File(urlString).getParentFile();
        if (deploymentDirectory.getName().equals(this.pluginDir.getName())) {
            this.log.debug((Object)("accepting agent plugin=" + urlString));
            return true;
        }
        return false;
    }

    @Override
    public void startDeployer() {
        LicenseManager licenseManager = LicenseManager.instance();
        licenseManager.doStartupCheck(this.licenseFile);
        this.registerPlugins();
        this.isReady = true;
    }

    private boolean areAllPluginsStarted(DeploymentInfo deploymentInfo) {
        ArrayList<String> pluginsNotReady = new ArrayList<String>();
        ArrayList<String> pluginsDeleted = new ArrayList<String>();
        for (Map.Entry<String, DeploymentInfo> entry : this.deploymentInfos.entrySet()) {
            DeploymentInfo entryDI = entry.getValue();
            if (entryDI.equals((Object)deploymentInfo) || entryDI.state == DeploymentState.STARTED) continue;
            pluginsNotReady.add(entry.getKey());
        }
        for (String pluginName : pluginsNotReady) {
            DeploymentInfo notReadyDI = this.deploymentInfos.get(pluginName);
            File notReadyFile = new File(notReadyDI.url.getFile());
            if (notReadyFile.exists()) continue;
            this.log.info((Object)("Agent plugin named [" + pluginName + "] has been deleted, it will be removed from cache"));
            this.deploymentInfos.remove(pluginName);
            this.pluginDescriptors.remove(pluginName);
            this.pluginVersions.remove(pluginName);
            this.namesOfPluginsToBeRegistered.remove(pluginName);
            pluginsDeleted.add(pluginName);
        }
        pluginsNotReady.removeAll(pluginsDeleted);
        return pluginsNotReady.size() == 0;
    }

    private String preprocessPlugin(DeploymentInfo deploymentInfo) throws DeploymentException {
        ComparableVersion version;
        File pluginFile = new File(deploymentInfo.localUrl.getFile());
        this.ensureDeploymentIsValid(pluginFile);
        PluginDescriptor descriptor = this.getPluginDescriptor(deploymentInfo);
        String pluginName = descriptor.getName();
        boolean initialDeploy = !this.deploymentInfos.containsKey(pluginName);
        try {
            version = AgentPluginDescriptorUtil.getPluginVersion((File)pluginFile, (PluginDescriptor)descriptor);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        if (initialDeploy) {
            this.log.info((Object)("Discovered agent plugin [" + pluginName + "]"));
        } else {
            this.log.info((Object)("Rediscovered agent plugin [" + pluginName + "]"));
        }
        if (initialDeploy || this.isNewestVersion(pluginName, version)) {
            this.deploymentInfos.put(pluginName, deploymentInfo);
            this.pluginDescriptors.put(pluginName, descriptor);
            this.pluginVersions.put(pluginName, version);
            this.namesOfPluginsToBeRegistered.add(pluginName);
        }
        return pluginName;
    }

    private PluginDescriptor getPluginDescriptor(DeploymentInfo di) throws DeploymentException {
        PluginDescriptor pluginDescriptor;
        ValidationEventCollector vec;
        URL descriptorURL = di.localCl.findResource(DEFAULT_PLUGIN_DESCRIPTOR_PATH);
        if (descriptorURL == null) {
            throw new DeploymentException("Could not load META-INF/rhq-plugin.xml from plugin jar file [" + di.localUrl + "]");
        }
        try {
            Schema pluginSchema;
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.rhq.core.clientapi.descriptor.plugin");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            URL pluginSchemaURL = this.getClass().getClassLoader().getResource(PLUGIN_DESCRIPTOR_SCHEMA);
            try {
                pluginSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(pluginSchemaURL);
            }
            catch (SAXException e) {
                throw new DeploymentException("Schema is invalid: " + e.getMessage());
            }
            unmarshaller.setSchema(pluginSchema);
            vec = new ValidationEventCollector();
            unmarshaller.setEventHandler((ValidationEventHandler)vec);
            pluginDescriptor = (PluginDescriptor)unmarshaller.unmarshal(descriptorURL);
        }
        catch (JAXBException e) {
            throw new DeploymentException("Failed to parse descriptor found in plugin [" + di.localUrl + "]", (Throwable)e);
        }
        for (ValidationEvent event : vec.getEvents()) {
            this.log.warn((Object)(event.getSeverity() + ":" + event.getMessage() + "    " + event.getLinkedException()));
        }
        return pluginDescriptor;
    }

    private void registerPlugins() {
        Iterator<String> it = this.namesOfPluginsToBeRegistered.iterator();
        while (it.hasNext()) {
            String pluginName = it.next();
            if (this.isNewOrUpdated(pluginName)) continue;
            this.log.debug((Object)("Plugin [" + pluginName + "] has not been updated."));
            it.remove();
        }
        if (this.namesOfPluginsToBeRegistered.isEmpty()) {
            this.log.info((Object)"All agent plugins were already up to date in the database.");
            return;
        }
        this.log.info((Object)("Deploying [" + this.namesOfPluginsToBeRegistered.size() + "] new or updated agent plugins: " + this.namesOfPluginsToBeRegistered));
        PluginDependencyGraph dependencyGraph = this.buildDependencyGraph();
        StringBuilder errorBuffer = new StringBuilder();
        if (!dependencyGraph.isComplete(errorBuffer)) {
            this.log.error((Object)errorBuffer.toString());
            this.log.error((Object)dependencyGraph.toString());
            return;
        }
        this.registerPlugins(dependencyGraph);
        this.log.info((Object)("Plugin metadata updates are complete: " + this.namesOfPluginsToBeRegistered));
        this.namesOfPluginsToBeRegistered.clear();
        try {
            ResourceTypeManagerLocal typeManager = LookupUtil.getResourceTypeManager();
            typeManager.reloadResourceFacetsCache();
        }
        catch (Throwable t) {
            this.log.error((Object)"Could not load ResourceFacets cache", t);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        Subject superuser = LookupUtil.getSubjectManager().getOverlord();
        SystemManagerLocal systemManager = LookupUtil.getSystemManager();
        systemManager.vacuum(superuser, new String[]{"RHQ_MEASUREMENT_DEF", "RHQ_CONFIG_DEF", "RHQ_RESOURCE_TYPE", "RHQ_RESOURCE_TYPE_PARENTS", "RHQ_PLUGIN"});
    }

    private boolean isNewestVersion(String pluginName, ComparableVersion version) {
        boolean newestVersion;
        ComparableVersion existingVersion = this.pluginVersions.get(pluginName);
        if (existingVersion != null) {
            boolean bl = newestVersion = version.compareTo((Object)existingVersion) >= 0;
            if (newestVersion) {
                this.log.info((Object)("Newer version of [" + pluginName + "] plugin found (version " + version + ") - older version (" + existingVersion + ") will be ignored."));
            }
        } else {
            newestVersion = false;
        }
        return newestVersion;
    }

    private boolean isNewOrUpdated(String pluginName) {
        Plugin plugin;
        DeploymentInfo deploymentInfo = this.deploymentInfos.get(pluginName);
        if (deploymentInfo == null) {
            throw new IllegalStateException("DeploymentInfo was not found for plugin [" + pluginName + " ] - it should have been initialized by preprocessPlugin().");
        }
        ResourceMetadataManagerLocal metadataManager = LookupUtil.getResourceMetadataManager();
        try {
            plugin = metadataManager.getPlugin(pluginName);
        }
        catch (RuntimeException e) {
            this.log.debug((Object)("New plugin [" + pluginName + "] detected."));
            return true;
        }
        String md5 = null;
        try {
            md5 = MD5Generator.getDigestString((File)new File(deploymentInfo.localUrl.toURI()));
        }
        catch (Exception e) {
            this.log.error((Object)("Error generating MD5 for plugin [" + pluginName + "]. Cause: " + e));
        }
        if (!plugin.getMd5().equals(md5)) {
            this.log.debug((Object)("Updated plugin [" + pluginName + "] detected."));
            return true;
        }
        return false;
    }

    private PluginDependencyGraph buildDependencyGraph() {
        PluginDependencyGraph dependencyGraph = new PluginDependencyGraph();
        for (String pluginName : this.deploymentInfos.keySet()) {
            PluginDescriptor descriptor = this.pluginDescriptors.get(pluginName);
            AgentPluginDescriptorUtil.addPluginToDependencyGraph((PluginDependencyGraph)dependencyGraph, (PluginDescriptor)descriptor);
        }
        this.log.debug((Object)("Dependency graph deployment order: " + dependencyGraph.getDeploymentOrder()));
        return dependencyGraph;
    }

    private void registerPlugins(PluginDependencyGraph dependencyGraph) {
        HashMap<String, LatchedPluginDeploymentService> latchedDependencyMap = new HashMap<String, LatchedPluginDeploymentService>();
        for (String pluginName : this.namesOfPluginsToBeRegistered) {
            LatchedPluginDeploymentService service = this.getServiceIfExists(pluginName, latchedDependencyMap);
            for (String dependencyPluginName : dependencyGraph.getPluginDependencies(pluginName)) {
                LatchedPluginDeploymentService dependencyService = this.getServiceIfExists(dependencyPluginName, latchedDependencyMap);
                if (null != dependencyService) {
                    service.addDependency(dependencyService);
                    continue;
                }
                this.log.warn((Object)("Ignoring [" + pluginName + "] dependency on missing dependency plugin: " + dependencyPluginName));
            }
            List optionalDependents = dependencyGraph.getOptionalDependents(pluginName);
            for (String dependentPluginName : optionalDependents) {
                LatchedPluginDeploymentService dependentService = this.getServiceIfExists(dependentPluginName, latchedDependencyMap);
                if (null != dependentService) {
                    dependentService.setForceUpdate(true);
                    dependentService.addDependency(service);
                    continue;
                }
                this.log.warn((Object)("Ignoring [" + pluginName + "] dependent on missing dependent plugin: " + dependentPluginName));
            }
        }
        ArrayList<LatchedPluginDeploymentService> orderedLatchedServices = new ArrayList<LatchedPluginDeploymentService>();
        List pluginOrder = dependencyGraph.getDeploymentOrder();
        for (String nextPlugin : pluginOrder) {
            LatchedPluginDeploymentService nextService = (LatchedPluginDeploymentService)latchedDependencyMap.get(nextPlugin);
            if (nextService == null) continue;
            orderedLatchedServices.add(nextService);
        }
        long startDeployTime = System.currentTimeMillis();
        LatchedServiceController controller = new LatchedServiceController(orderedLatchedServices);
        try {
            controller.executeServices();
        }
        catch (LatchedServiceCircularityException lsce) {
            this.log.error((Object)lsce.getMessage());
        }
        long endDeployTime = System.currentTimeMillis();
        this.log.debug((Object)("Registered [" + dependencyGraph.getPlugins().size() + "] plugins in [" + (endDeployTime - startDeployTime) + "]ms"));
    }

    private LatchedPluginDeploymentService getServiceIfExists(String pluginName, Map<String, LatchedPluginDeploymentService> latchedServiceMap) {
        LatchedPluginDeploymentService result = latchedServiceMap.get(pluginName);
        if (result == null) {
            DeploymentInfo deploymentInfo = this.deploymentInfos.get(pluginName);
            PluginDescriptor descriptor = this.pluginDescriptors.get(pluginName);
            if (null != deploymentInfo && null != descriptor) {
                result = new LatchedPluginDeploymentService(pluginName, deploymentInfo, descriptor);
                latchedServiceMap.put(pluginName, result);
            }
        }
        return result;
    }

    private void registerPluginJar(PluginDescriptor pluginDescriptor, DeploymentInfo deploymentInfo, boolean forceUpdate) {
        if (pluginDescriptor == null) {
            this.log.error((Object)("Missing plugin descriptor; is [" + deploymentInfo.localUrl + "] a valid plugin?"));
            return;
        }
        try {
            File localPluginFile = new File(deploymentInfo.localUrl.toURI());
            String pluginName = pluginDescriptor.getName();
            String displayName = pluginDescriptor.getDisplayName();
            String pluginNameDisplayName = pluginName + " (" + displayName + ")";
            ComparableVersion comparableVersion = this.pluginVersions.get(pluginName);
            String version = comparableVersion != null ? comparableVersion.toString() : null;
            this.log.debug((Object)("Registering RHQ plugin " + pluginNameDisplayName + ", " + (version != null ? "version " + version : "undefined version") + "..."));
            this.checkVersionCompatibility(pluginDescriptor.getAmpsVersion());
            String filename = this.getPluginJarFilename(deploymentInfo);
            Plugin plugin = new Plugin(pluginName, filename);
            plugin.setDisplayName(displayName != null ? displayName : pluginName);
            plugin.setEnabled(true);
            plugin.setDescription(pluginDescriptor.getDescription());
            long mtime = deploymentInfo.url.openConnection().getLastModified();
            plugin.setMtime(mtime);
            if (pluginDescriptor.getHelp() != null && !pluginDescriptor.getHelp().getContent().isEmpty()) {
                plugin.setHelp(String.valueOf(pluginDescriptor.getHelp().getContent().get(0)));
            }
            plugin.setVersion(version);
            plugin.setMD5(MD5Generator.getDigestString((File)localPluginFile));
            ResourceMetadataManagerLocal metadataManager = LookupUtil.getResourceMetadataManager();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            metadataManager.registerPlugin(subjectManager.getOverlord(), plugin, pluginDescriptor, localPluginFile, forceUpdate);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to register RHQ plugin file [" + deploymentInfo.shortName + "] at [" + deploymentInfo.localUrl + "]"), (Throwable)e);
        }
    }

    private void checkVersionCompatibility(String version) throws RuntimeException {
    }

    private void ensureDeploymentIsValid(File pluginFile) throws DeploymentException {
        int retries = 4;
        while (!this.isDeploymentValidZipFile(pluginFile)) {
            if (--retries <= 0) {
                throw new DeploymentException("File [" + pluginFile + "] is not a valid jarfile - " + " it is either corrupted or file has not been fully written yet.");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDeploymentValidZipFile(File pluginFile) {
        JarFile jarFile = null;
        jarFile = new JarFile(pluginFile);
        if (jarFile.size() <= 0) {
            throw new Exception("There are no entries in the plugin file");
        }
        JarEntry entry = jarFile.entries().nextElement();
        entry.getName();
        boolean isValid = true;
        Object var6_6 = null;
        if (jarFile == null) return isValid;
        try {
            jarFile.close();
            return isValid;
        }
        catch (Exception e2) {
            this.log.error((Object)("Failed to close jar file [" + pluginFile + "]"));
        }
        return isValid;
        {
            catch (Exception e) {
                this.log.info((Object)("File [" + pluginFile + "] is not a valid jarfile - " + " the file may not have been fully written yet. Cause: " + e));
                isValid = false;
                Object var6_7 = null;
                if (jarFile == null) return isValid;
                try {
                    jarFile.close();
                    return isValid;
                }
                catch (Exception e2) {
                    this.log.error((Object)("Failed to close jar file [" + pluginFile + "]"));
                }
                return isValid;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (Exception e2) {
                this.log.error((Object)("Failed to close jar file [" + pluginFile + "]"));
            }
            throw throwable;
        }
    }

    private String getPluginJarFilename(DeploymentInfo di) {
        return new File(di.url.getPath()).getName();
    }

    private boolean isLicenseFile(DeploymentInfo deploymentInfo) {
        String name = LicenseManager.getLicenseFileName();
        return deploymentInfo.url.getFile().endsWith(name);
    }

    protected void processNestedDeployments(DeploymentInfo di) throws DeploymentException {
        if (di.isDirectory) {
            super.processNestedDeployments(di);
        }
    }

    class LatchedPluginDeploymentService
    extends LatchedServiceController.LatchedService {
        private final DeploymentInfo pluginDeploymentInfo;
        private final PluginDescriptor pluginDescriptor;
        private boolean forceUpdate;

        public LatchedPluginDeploymentService(String pluginName, DeploymentInfo di, PluginDescriptor descriptor) {
            super(pluginName);
            this.pluginDeploymentInfo = di;
            this.pluginDescriptor = descriptor;
            this.forceUpdate = false;
        }

        public void setForceUpdate(boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
        }

        public void executeService() throws LatchedServiceException {
            try {
                ProductPluginDeployer.this.registerPluginJar(this.pluginDescriptor, this.pluginDeploymentInfo, this.forceUpdate);
            }
            catch (Throwable t) {
                throw new LatchedServiceException(t);
            }
        }
    }
}

