/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.discovery.InvalidPluginConfigurationClientException;
import org.rhq.core.clientapi.server.discovery.InvalidInventoryReportException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.discovery.InventoryReport;
import org.rhq.core.domain.discovery.MergeResourceResponse;
import org.rhq.core.domain.discovery.ResourceSyncInfo;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.ProductVersion;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.domain.util.PersistenceUtility;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.discovery.DiscoveryBossRemote;
import org.rhq.enterprise.server.resource.ProductVersionManagerLocal;
import org.rhq.enterprise.server.resource.ResourceAlreadyExistsException;
import org.rhq.enterprise.server.resource.ResourceAvailabilityManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class DiscoveryBossBean
implements DiscoveryBossLocal,
DiscoveryBossRemote {
    private final Log log = LogFactory.getLog((String)DiscoveryBossBean.class.getName());
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private DiscoveryBossLocal discoveryBoss;
    @EJB
    private ResourceGroupManagerLocal groupManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ResourceAvailabilityManagerLocal resourceAvailabilityManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ProductVersionManagerLocal productVersionManager;

    @Override
    public ResourceSyncInfo mergeInventoryReport(InventoryReport report) throws InvalidInventoryReportException {
        this.validateInventoryReport(report);
        Agent agent = report.getAgent();
        long start = System.currentTimeMillis();
        Agent knownAgent = this.agentManager.getAgentByName(agent.getName());
        if (knownAgent == null) {
            throw new InvalidInventoryReportException("Unknown Agent named [" + agent.getName() + "] sent an inventory report - that report will be ignored");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received inventory report from RHQ Agent [" + knownAgent + "]. Number of added roots: " + report.getAddedRoots().size()));
        }
        Set roots = report.getAddedRoots();
        this.log.debug((Object)report);
        for (Resource root : roots) {
            long rootStart = System.currentTimeMillis();
            if (!this.initResourceTypes(root)) continue;
            if (root.getParentResource() != Resource.ROOT && root.getParentResource().getId() != -1) {
                Resource parent = this.getExistingResource(root.getParentResource());
                assert (parent != null);
                this.mergeResource(root, parent, knownAgent);
            } else {
                this.mergeResource(root, Resource.ROOT, knownAgent);
            }
            this.entityManager.flush();
            this.entityManager.clear();
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Root merged: resource/millis=" + root.getName() + '/' + (System.currentTimeMillis() - rootStart)));
        }
        Resource platform = this.resourceManager.getPlatform(knownAgent);
        ResourceSyncInfo syncInfo = (ResourceSyncInfo)this.entityManager.find(ResourceSyncInfo.class, (Object)platform.getId());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Inventory merge completed in (" + (System.currentTimeMillis() - start) + ")ms"));
        }
        return syncInfo;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Map<Resource, List<Resource>> getQueuedPlatformsAndServers(Subject user, PageControl pc) {
        HashMap<Resource, List<Resource>> queuedResources = new HashMap<Resource, List<Resource>>();
        PageList<Resource> queuedPlatforms = this.getQueuedPlatforms(user, EnumSet.of(InventoryStatus.NEW), pc);
        for (Resource platform : queuedPlatforms) {
            List<Resource> queuedServers = this.getQueuedPlatformChildServers(user, InventoryStatus.NEW, platform);
            ArrayList<Resource> servers = new ArrayList<Resource>();
            for (Resource server : queuedServers) {
                servers.add(server);
            }
            queuedResources.put(platform, servers);
        }
        return queuedResources;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Resource> getQueuedPlatforms(Subject user, EnumSet<InventoryStatus> statuses, PageControl pc) {
        pc.initDefaultOrderingField("res.ctime", PageOrdering.DESC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findQueuedPlatformsByInventoryStatus");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findQueuedPlatformsByInventoryStatus", (PageControl)pc);
        queryCount.setParameter("inventoryStatuses", statuses);
        long count = (Long)queryCount.getSingleResult();
        query.setParameter("inventoryStatuses", statuses);
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public List<Resource> getQueuedPlatformChildServers(Subject user, InventoryStatus status, Resource platform) {
        PageList<Resource> childServers = this.resourceManager.findChildResourcesByCategoryAndInventoryStatus(user, platform, ResourceCategory.SERVER, status, PageControl.getUnlimitedInstance());
        return childServers;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void updateInventoryStatus(Subject user, List<Resource> platforms, List<Resource> servers, InventoryStatus status) {
        AgentClient agentClient;
        long start = System.currentTimeMillis();
        ArrayList<Resource> attachedPlatforms = new ArrayList<Resource>(platforms.size());
        for (Resource p : platforms) {
            attachedPlatforms.add((Resource)this.entityManager.find(Resource.class, (Object)p.getId()));
        }
        platforms = attachedPlatforms;
        ArrayList<Resource> attachedServers = new ArrayList<Resource>(servers.size());
        for (Resource s : servers) {
            attachedServers.add((Resource)this.entityManager.find(Resource.class, (Object)s.getId()));
        }
        servers = attachedServers;
        this.discoveryBoss.updateInventoryStatus(user, status, platforms, servers);
        for (Resource platform : platforms) {
            agentClient = this.agentManager.getAgentClient(platform.getAgent());
            try {
                agentClient.getDiscoveryAgentService().synchronizeInventory((ResourceSyncInfo)this.entityManager.find(ResourceSyncInfo.class, (Object)platform.getId()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Could not perform commit synchronization with agent for platform [" + platform.getName() + "]"), (Throwable)e);
            }
        }
        for (Resource server : servers) {
            if (platforms.contains(server.getParentResource())) continue;
            agentClient = this.agentManager.getAgentClient(server.getAgent());
            try {
                agentClient.getDiscoveryAgentService().synchronizeInventory((ResourceSyncInfo)this.entityManager.find(ResourceSyncInfo.class, (Object)server.getId()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Could not perform commit synchronization with agent for server [" + server.getName() + "]"), (Throwable)e);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Inventory status set to [" + status + "] for [" + platforms.size() + "] platforms and [" + servers.size() + "] servers in [" + (System.currentTimeMillis() - start) + "]ms"));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateInventoryStatus(Subject user, InventoryStatus status, List<Resource> platforms, List<Resource> servers) {
        for (Resource platform : platforms) {
            this.resourceManager.setResourceStatus(user, platform, status, false);
        }
        for (Resource server : servers) {
            this.resourceManager.setResourceStatus(user, server, status, true);
        }
        if (status == InventoryStatus.COMMITTED) {
            ArrayList<Integer> allResourceIds = new ArrayList<Integer>();
            for (Resource platform : platforms) {
                allResourceIds.add(platform.getId());
            }
            for (Resource server : servers) {
                allResourceIds.add(server.getId());
            }
            this.resourceAvailabilityManager.insertNeededAvailabilityForImportedResources(allResourceIds);
        }
    }

    @Override
    @NotNull
    public MergeResourceResponse manuallyAddResource(Subject user, ResourceType resourceType, int parentResourceId, Configuration pluginConfiguration) throws InvalidPluginConfigurationClientException, PluginContainerException {
        MergeResourceResponse mergeResourceResponse;
        if (!this.authorizationManager.hasResourcePermission(user, Permission.CREATE_CHILD_RESOURCES, parentResourceId)) {
            throw new PermissionException("You do not have permission on resource with id " + parentResourceId + " to manually add child resources.");
        }
        try {
            Resource parentResource = this.resourceManager.getResourceById(user, parentResourceId);
            AgentClient agentClient = this.agentManager.getAgentClient(parentResource.getAgent());
            mergeResourceResponse = agentClient.getDiscoveryAgentService().manuallyAddResource(resourceType, parentResourceId, pluginConfiguration, user.getId());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error adding " + resourceType.getName() + " resource to inventory as a child of the resource with id " + parentResourceId + " - cause: " + e.getLocalizedMessage(), e);
        }
        return mergeResourceResponse;
    }

    @Override
    public MergeResourceResponse addResource(Resource resource, int creatorSubjectId) {
        MergeResourceResponse mergeResourceResponse;
        try {
            this.validateResource(resource);
        }
        catch (InvalidInventoryReportException e) {
            throw new IllegalStateException("Plugin Container sent an invalid Resource - " + e.getLocalizedMessage());
        }
        if (!this.initResourceTypes(resource)) {
            throw new IllegalStateException("Plugin Container sent a Resource with an unknown type - " + resource.getResourceType());
        }
        Resource existingResource = this.getExistingResource(resource);
        if (existingResource != null) {
            mergeResourceResponse = new MergeResourceResponse(existingResource.getId(), true);
        } else {
            Subject creator = this.subjectManager.getSubjectById(creatorSubjectId);
            try {
                creator = this.subjectManager.loginUnauthenticated(creator.getName(), true);
            }
            catch (LoginException e) {
                throw new IllegalStateException("Unable to temporarily login to provided resource creator user for resource creation", e);
            }
            Resource parentResource = this.resourceManager.getResourceById(creator, resource.getParentResource().getId());
            resource.setAgent(parentResource.getAgent());
            resource.setModifiedBy(creator);
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            resource.setItime(System.currentTimeMillis());
            try {
                this.resourceManager.createResource(creator, resource, parentResource.getId());
            }
            catch (ResourceAlreadyExistsException e) {
                throw new IllegalStateException(e);
            }
            mergeResourceResponse = new MergeResourceResponse(resource.getId(), false);
        }
        return mergeResourceResponse;
    }

    @Override
    public boolean updateResourceVersion(int resourceId, String version) {
        Resource existingResource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (existingResource != null) {
            boolean changed = this.updateResourceVersion(existingResource, version);
            if (changed) {
                this.entityManager.merge((Object)existingResource);
            }
            return true;
        }
        return false;
    }

    private boolean updateResourceVersion(Resource resource, String newVersion) {
        boolean versionChanged = false;
        if (resource != null) {
            String oldVersion = resource.getVersion();
            if (oldVersion == null) {
                oldVersion = "";
            }
            if (newVersion == null) {
                newVersion = "";
            }
            boolean bl = versionChanged = !oldVersion.equals(newVersion);
            if (versionChanged) {
                this.log.info((Object)("Resource [" + resource + "] changed its version from [" + oldVersion + "] to [" + newVersion + "]"));
                resource.setVersion(newVersion);
                ProductVersion productVersion = null;
                if (newVersion.length() > 0) {
                    productVersion = this.productVersionManager.addProductVersion(resource.getResourceType(), newVersion);
                }
                resource.setProductVersion(productVersion);
            }
        }
        return versionChanged;
    }

    private void validateInventoryReport(InventoryReport report) throws InvalidInventoryReportException {
        for (Resource root : report.getAddedRoots()) {
            this.validateResource(root);
        }
    }

    private void validateResource(Resource resource) throws InvalidInventoryReportException {
        if (resource.getResourceType() == null) {
            throw new InvalidInventoryReportException("Reported resource [" + resource + "] has a null type.");
        }
        if (resource.getResourceKey() == null) {
            throw new InvalidInventoryReportException("Reported resource [" + resource + "] has a null key.");
        }
        if (resource.getInventoryStatus() == InventoryStatus.DELETED) {
            throw new InvalidInventoryReportException("Reported resource [" + resource + "] has an illegal inventory status of 'DELETED' - agents are not allowed to delete platforms from inventory.");
        }
        for (Resource childResource : resource.getChildResources()) {
            this.validateResource(childResource);
        }
    }

    private void mergeResource(@NotNull Resource resource, @Nullable Resource parentResource, @NotNull Agent agent) throws InvalidInventoryReportException {
        long start = System.currentTimeMillis();
        this.log.debug((Object)("Merging [" + resource + "]..."));
        Resource existingResource = this.getExistingResource(resource);
        if (existingResource != null) {
            this.updatePreviouslyInventoriedResource(resource, existingResource, parentResource);
        } else {
            this.presetAgent(resource, agent);
            this.addResourceToInventory(resource, parentResource);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Resource merged: resource/millis=" + resource.getName() + '/' + (System.currentTimeMillis() - start)));
        }
    }

    private void presetAgent(Resource resource, Agent agent) {
        resource.setAgent(agent);
        for (Resource child : resource.getChildResources()) {
            this.presetAgent(child, agent);
        }
    }

    private Resource getExistingResource(Resource resource) {
        Resource existingResource = null;
        this.log.debug((Object)("getExistingResource processing for [" + resource + "]"));
        String idLogMsg = "id=" + resource.getId();
        if (resource.getId() != 0) {
            this.log.debug((Object)(idLogMsg + ": Agent claims resource is already in inventory."));
            existingResource = (Resource)this.entityManager.find(Resource.class, (Object)resource.getId());
            if (existingResource == null) {
                this.log.debug((Object)(idLogMsg + ": However, no resource exists with the specified id."));
            } else {
                this.log.debug((Object)(idLogMsg + ": Found resource already in inventory with specified id"));
            }
        } else {
            this.log.debug((Object)(idLogMsg + ": Agent reported resource with id of 0."));
        }
        if (existingResource == null) {
            this.log.debug((Object)(idLogMsg + ": Checking if a resource exists with the specified business key."));
            ResourceType resourceType = resource.getResourceType();
            existingResource = this.resourceManager.getResourceByParentAndKey(this.subjectManager.getOverlord(), resource.getParentResource(), resource.getResourceKey(), resourceType.getPlugin(), resourceType.getName());
            if (existingResource != null) {
                resource.setId(existingResource.getId());
                this.log.debug((Object)(idLogMsg + ": Found resource already in inventory with specified business key"));
            } else {
                this.log.debug((Object)(idLogMsg + ": Unable to find the agent-reported resource by id and business key."));
                if (resource.getId() != 0) {
                    this.log.error((Object)(idLogMsg + ": Resetting the resource's id to zero."));
                    resource.setId(0);
                } else {
                    this.log.debug((Object)(idLogMsg + ": Resource's id was already zero, nothing to do for the merge."));
                }
            }
        }
        if (existingResource != null) {
            existingResource.getChildResources().size();
        }
        return existingResource;
    }

    private void updatePreviouslyInventoriedResource(Resource resource, Resource existingResource, Resource parentResource) throws InvalidInventoryReportException {
        assert (parentResource == null || parentResource.getId() != 0);
        if (existingResource.getDescription() == null && resource.getDescription() != null) {
            this.log.debug((Object)("Setting description of existing resource with id " + existingResource.getId() + " to '" + resource.getDescription() + "' (as reported by agent)..."));
            existingResource.setDescription(resource.getDescription());
        }
        if (existingResource.getResourceKey() != null && !existingResource.getResourceKey().equals(resource.getResourceKey())) {
            this.log.warn((Object)("Agent reported that key for " + existingResource + " has changed from '" + existingResource.getResourceKey() + "' to '" + resource.getResourceKey() + "'."));
        }
        this.updateResourceVersion(existingResource, resource.getVersion());
        if (existingResource.getInventoryStatus() == InventoryStatus.DELETED) {
            existingResource.setInventoryStatus(InventoryStatus.COMMITTED);
            existingResource.setPluginConfiguration(resource.getPluginConfiguration());
        }
        for (Resource childResource : resource.getChildResources()) {
            this.mergeResource(childResource, existingResource, existingResource.getAgent());
        }
    }

    private boolean initResourceTypes(Resource resource) {
        ResourceType resourceType = this.resourceTypeManager.getResourceTypeByNameAndPlugin(resource.getResourceType().getName(), resource.getResourceType().getPlugin());
        if (resourceType == null) {
            this.log.error((Object)("Reported resource [" + resource + "] has an unknown type [" + resource.getResourceType() + "]. The Agent most likely has a plugin named '" + resource.getResourceType().getPlugin() + "' installed that is not installed on the Server. Resource will be ignored..."));
            return false;
        }
        resource.setResourceType(resourceType);
        Iterator childIterator = resource.getChildResources().iterator();
        while (childIterator.hasNext()) {
            Resource child = (Resource)childIterator.next();
            if (this.initResourceTypes(child)) continue;
            childIterator.remove();
        }
        return true;
    }

    private void addResourceToInventory(Resource resource, Resource parentResource) {
        this.log.debug((Object)("New resource [" + resource + "] reported - adding to inventory with status 'NEW'..."));
        this.initAutoDiscoveredResource(resource, parentResource);
        this.entityManager.persist((Object)resource);
        if (parentResource != null) {
            parentResource.addChildResource(resource);
        }
        this.addProductVersionsRecursively(resource);
        if (parentResource != null) {
            this.groupManager.updateImplicitGroupMembership(this.subjectManager.getOverlord(), resource);
        }
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void addProductVersionsRecursively(Resource resource) {
        if (resource.getVersion() != null && resource.getVersion().length() > 0) {
            ResourceType type = resource.getResourceType();
            ProductVersion productVersion = this.productVersionManager.addProductVersion(type, resource.getVersion());
            resource.setProductVersion(productVersion);
        }
        for (Resource child : resource.getChildResources()) {
            this.addProductVersionsRecursively(child);
        }
    }

    private void initAutoDiscoveredResource(Resource resource, Resource parent) {
        if (resource.getParentResource() != null && resource.getParentResource().getInventoryStatus() == InventoryStatus.COMMITTED && (resource.getResourceType().getCategory() == ResourceCategory.SERVICE || resource.getParentResource().getResourceType().getCategory() == ResourceCategory.SERVER)) {
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
        } else {
            resource.setInventoryStatus(InventoryStatus.NEW);
        }
        resource.setItime(System.currentTimeMillis());
        resource.setModifiedBy(this.subjectManager.getOverlord());
        for (Resource childResource : resource.getChildResources()) {
            this.initAutoDiscoveredResource(childResource, resource);
        }
    }

    @Override
    public void importResources(Subject subject, Integer[] resourceIds) {
        if (resourceIds == null || resourceIds.length == 0) {
            return;
        }
        this.checkStatus(subject, resourceIds, InventoryStatus.COMMITTED, EnumSet.of(InventoryStatus.NEW));
    }

    @Override
    public void ignoreResources(Subject subject, Integer[] resourceIds) {
        if (resourceIds == null || resourceIds.length == 0) {
            return;
        }
        this.checkStatus(subject, resourceIds, InventoryStatus.IGNORED, EnumSet.of(InventoryStatus.NEW));
    }

    @Override
    public void unignoreResources(Subject subject, Integer[] resourceIds) {
        if (resourceIds == null || resourceIds.length == 0) {
            return;
        }
        this.checkStatus(subject, resourceIds, InventoryStatus.NEW, EnumSet.of(InventoryStatus.IGNORED));
    }

    private void checkStatus(Subject subject, Integer[] resourceIds, InventoryStatus target, EnumSet<InventoryStatus> validStatuses) {
        Query query = this.entityManager.createQuery("  SELECT res.inventoryStatus     FROM Resource res    WHERE res.id IN ( :resourceIds ) GROUP BY res.inventoryStatus ");
        query.setParameter("resourceIds", Arrays.asList(resourceIds));
        List results = query.getResultList();
        for (InventoryStatus expected : validStatuses) {
            results.remove(expected);
        }
        if (results.size() > 0) {
            throw new IllegalArgumentException("Can only commit resources with status: " + results);
        }
        PageList<Resource> resources = this.resourceManager.findResourceByIds(subject, ArrayUtils.unwrapArray((Integer[])resourceIds), false, PageControl.getUnlimitedInstance());
        ArrayList<Resource> platforms = new ArrayList<Resource>();
        ArrayList<Resource> servers = new ArrayList<Resource>();
        for (Resource res : resources) {
            ResourceCategory category = res.getResourceType().getCategory();
            if (category == ResourceCategory.PLATFORM) {
                platforms.add(res);
                continue;
            }
            if (category == ResourceCategory.SERVER) {
                servers.add(res);
                continue;
            }
            throw new IllegalArgumentException("Can not directly change the inventory status of a service");
        }
        this.updateInventoryStatus(subject, platforms, servers, target);
    }
}

