/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.rhq.core.clientapi.util.TimeUtil;
import org.rhq.core.util.StopWatch;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.measurement.MeasurementCompressionManagerLocal;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitor;
import org.rhq.enterprise.server.measurement.util.MeasurementDataManagerUtility;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.TimingVoodoo;

@Stateless
public class MeasurementCompressionManagerBean
implements MeasurementCompressionManagerLocal {
    private final Log log = LogFactory.getLog(MeasurementCompressionManagerBean.class);
    private static final String DATASOURCE_NAME = "java:/RHQDS";
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long SIX_HOUR = 21600000L;
    @Resource
    private SessionContext ctx;
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    private MeasurementCompressionManagerLocal compressionManager;
    private long purge1h;
    private long purge6h;
    private long purge1d;

    private void loadPurgeDefaults() {
        this.log.debug((Object)"Loading default purge intervals");
        Properties conf = this.systemManager.getSystemConfiguration();
        try {
            this.purge1h = Long.parseLong(conf.getProperty("CAM_DATA_PURGE_1H"));
            this.purge6h = Long.parseLong(conf.getProperty("CAM_DATA_PURGE_6H"));
            this.purge1d = Long.parseLong(conf.getProperty("CAM_DATA_PURGE_1D"));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid purge interval: " + e);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void compressData() throws SQLException {
        String[] rawTables;
        this.loadPurgeDefaults();
        long now = TimingVoodoo.roundDownTime(System.currentTimeMillis(), 3600000L);
        long hourAgo = TimingVoodoo.roundDownTime(now - 3600000L, 3600000L);
        String deadTable = MeasurementDataManagerUtility.getDeadTable(hourAgo);
        int deadTableIndex = MeasurementDataManagerUtility.getTableNameIndex(deadTable);
        for (String rawTable : rawTables = MeasurementDataManagerUtility.getAllRawTables(deadTableIndex + 1)) {
            if (rawTable.equals(deadTable)) continue;
            this.compressionManager.compressData(rawTable, "RHQ_MEASUREMENT_DATA_NUM_1H", 3600000L, now);
        }
        this.compressionManager.truncateMeasurements(deadTable);
        long last = this.compressionManager.compressData("RHQ_MEASUREMENT_DATA_NUM_1H", "RHQ_MEASUREMENT_DATA_NUM_6H", 21600000L, now);
        this.compressionManager.purgeMeasurements("RHQ_MEASUREMENT_DATA_NUM_1H", Math.min(now - this.purge1h, last), this.purge1h);
        last = this.compressionManager.compressData("RHQ_MEASUREMENT_DATA_NUM_6H", "RHQ_MEASUREMENT_DATA_NUM_1D", 86400000L, now);
        this.compressionManager.purgeMeasurements("RHQ_MEASUREMENT_DATA_NUM_6H", Math.min(now - this.purge6h, last), this.purge6h);
        this.compressionManager.purgeMeasurements("RHQ_MEASUREMENT_DATA_NUM_1D", now - this.purge1d, this.purge1d);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=21600)
    public long compressData(String fromTable, String toTable, long interval, long now) throws SQLException {
        long fromTableMax;
        long start = this.getMaxTimestamp(toTable);
        if (start == 0L) {
            start = this.getMinTimestamp(fromTable);
            if (start == 0L) {
                return 0L;
            }
        } else {
            start += interval;
        }
        long rawTimeStart = TimingVoodoo.roundDownTime(MeasurementDataManagerUtility.getRawTimePeriodStart(now), 3600000L);
        long begin = TimingVoodoo.roundDownTime(start, interval);
        if (begin < rawTimeStart) {
            begin = rawTimeStart;
        }
        if ((fromTableMax = this.getMaxTimestamp(fromTable)) < begin) {
            return begin;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Compressing from [" + fromTable + "] to [" + toTable + "]"));
        }
        return this.compactData(fromTable, toTable, begin, now, interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long compactData(String fromTable, String toTable, long begin, long now, long interval) throws SQLException {
        Connection conn = null;
        PreparedStatement insStmt = null;
        try {
            conn = ((DataSource)this.ctx.lookup(DATASOURCE_NAME)).getConnection();
            String minMax = MeasurementDataManagerUtility.isRawTable(fromTable) ? "AVG(value), MIN(value), MAX(value) " : "AVG(value), MIN(minvalue), MAX(maxvalue) ";
            insStmt = conn.prepareStatement("INSERT INTO " + toTable + " (SELECT ?, ft.schedule_id, " + minMax + "  FROM " + fromTable + " ft " + "  WHERE ft.time_stamp >= ? AND ft.time_stamp < ? " + "  GROUP BY ft.schedule_id)");
            StopWatch watch = new StopWatch();
            while (begin < now) {
                watch.reset();
                long end = begin + interval;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Compression interval: " + TimeUtil.toString((long)begin) + " to " + TimeUtil.toString((long)end)));
                }
                int rows = 0;
                try {
                    insStmt.setLong(1, begin);
                    insStmt.setLong(2, begin);
                    insStmt.setLong(3, end);
                    rows = insStmt.executeUpdate();
                    this.log.info((Object)("Compressed from [" + fromTable + "] into [" + rows + "] rows in [" + toTable + "] in [" + watch.getElapsed() / 1000L + "] seconds"));
                }
                catch (SQLException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.error((Object)("SQL exception when inserting data at " + TimeUtil.toString((long)begin)), (Throwable)e);
                    }
                    this.log.error((Object)("SQL exception when inserting data at " + TimeUtil.toString((long)begin) + ": " + ThrowableUtil.getAllMessages((Throwable)e)));
                }
                MeasurementMonitor.getMBean().incrementMeasurementCompressionTime(watch.getElapsed());
                begin = end;
            }
            Object var18_13 = null;
            this.close(insStmt);
            this.close(conn);
        }
        catch (Throwable throwable) {
            Object var18_14 = null;
            this.close(insStmt);
            this.close(conn);
            throw throwable;
        }
        return begin;
    }

    private long getMinTimestamp(String dataTable) throws SQLException {
        block3: {
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                conn = ((DataSource)this.ctx.lookup(DATASOURCE_NAME)).getConnection();
                String sql = "SELECT MIN(time_stamp) FROM " + dataTable;
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block3;
                long l = rs.getLong(1);
                Object var9_7 = null;
                this.close(rs);
                this.close(stmt);
                this.close(conn);
                return l;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                this.close(rs);
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        throw new SQLException("Unable to determine oldest measurement");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMaxTimestamp(String dataTable) throws SQLException {
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block3: {
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = ((DataSource)this.ctx.lookup(DATASOURCE_NAME)).getConnection();
                String sql = "SELECT MAX(time_stamp) FROM " + dataTable;
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block3;
                long l = rs.getLong(1);
                Object var9_8 = null;
                this.close(rs);
                this.close(stmt);
                this.close(conn);
                return l;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.close(rs);
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        long l = 0L;
        Object var9_9 = null;
        this.close(rs);
        this.close(stmt);
        this.close(conn);
        return l;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void purgeMeasurements(String tableName, long purgeBefore, long interval) {
        int totalRows = 0;
        int rows = 1;
        int iterations = 0;
        long start = purgeBefore - interval;
        while (rows > 0) {
            try {
                rows = this.compressionManager.purgeMeasurementInterval(tableName, start, start + interval);
                totalRows += rows;
            }
            catch (SQLException e) {
                this.log.error((Object)("Unable to delete from [" + tableName + "] between [" + new Date(start) + "] and [" + new Date(start + interval) + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
            }
            start -= interval;
            if (++iterations <= 30) continue;
        }
        this.log.info((Object)("Purged [" + totalRows + "] measurement rows from table: " + tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=21600)
    public int purgeMeasurementInterval(String tableName, long purgeAfter, long purgeBefore) throws SQLException {
        int rows;
        Connection conn = null;
        PreparedStatement stmt = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Purging data older than [" + TimeUtil.toString((long)purgeAfter) + "] from table: " + tableName));
        }
        StopWatch watch = new StopWatch();
        try {
            conn = ((DataSource)this.ctx.lookup(DATASOURCE_NAME)).getConnection();
            String sql = "DELETE FROM " + tableName + " WHERE time_stamp > ? AND time_stamp < ?";
            stmt = conn.prepareStatement(sql);
            stmt.setLong(1, purgeAfter);
            stmt.setLong(2, purgeBefore);
            rows = stmt.executeUpdate();
            Object var12_9 = null;
            this.close(stmt);
            this.close(conn);
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            this.close(stmt);
            this.close(conn);
            throw throwable;
        }
        MeasurementMonitor.getMBean().incrementPurgeTime(watch.getElapsed());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Done purging [" + rows + "] rows older than [" + TimeUtil.toString((long)purgeAfter) + "] from [" + tableName + "] in [" + watch.getElapsed() / 1000L + "] seconds)"));
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void truncateMeasurements(String tableName) throws SQLException {
        if (tableName.equals(MeasurementDataManagerUtility.getDeadTable(System.currentTimeMillis()))) {
            Connection conn = null;
            Statement stmt = null;
            StopWatch watch = new StopWatch();
            try {
                conn = ((DataSource)this.ctx.lookup(DATASOURCE_NAME)).getConnection();
                stmt = conn.createStatement();
                long startTime = System.currentTimeMillis();
                stmt.executeUpdate("TRUNCATE TABLE " + tableName);
                MeasurementMonitor.getMBean().incrementPurgeTime(System.currentTimeMillis() - startTime);
                Object var8_6 = null;
                this.close(stmt);
                this.close(conn);
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.close(stmt);
                this.close(conn);
                this.log.info((Object)("Truncated table [" + tableName + "] in [" + watch.getElapsed() / 1000L + "] seconds"));
                throw throwable;
            }
            this.log.info((Object)("Truncated table [" + tableName + "] in [" + watch.getElapsed() / 1000L + "] seconds"));
            {
            }
        }
    }

    private void close(Statement c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception e) {
            this.log.warn((Object)(this.ctx + ": Error closing statement."), (Throwable)e);
        }
    }

    private void close(ResultSet c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception e) {
            this.log.warn((Object)(this.ctx + ": Error closing result set."), (Throwable)e);
        }
    }

    private void close(Connection c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception e) {
            this.log.warn((Object)(this.ctx + ": Error closing connection."), (Throwable)e);
        }
    }
}

