/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.composite.ProblemResourceComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PersistenceUtility;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementProblemManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementProblemManagerRemote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class MeasurementProblemManagerBean
implements MeasurementProblemManagerLocal,
MeasurementProblemManagerRemote {
    private final Log log = LogFactory.getLog(MeasurementProblemManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;

    @Override
    public PageList<ProblemResourceComposite> findProblemResources(Subject subject, long oldestDate, PageControl pc) {
        Query query;
        Query queryCount;
        pc.initDefaultOrderingField("res.name");
        if (this.authorizationManager.isInventoryManager(subject)) {
            queryCount = this.entityManager.createNamedQuery("Resource.findProblemResourcesAlertCount_admin");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findProblemResourcesAlert_admin", (PageControl)pc);
        } else {
            queryCount = this.entityManager.createNamedQuery("Resource.findProblemResourcesAlertCount");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findProblemResourcesAlert", (PageControl)pc);
            queryCount.setParameter("subject", (Object)subject);
            query.setParameter("subject", (Object)subject);
        }
        queryCount.setParameter("oldest", (Object)oldestDate);
        query.setParameter("oldest", (Object)oldestDate);
        long count = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pc);
    }
}

