/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.content;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.plugin.content.ContentSourceAdapter;
import org.rhq.core.clientapi.server.plugin.content.ContentSourcePackageDetails;
import org.rhq.core.clientapi.server.plugin.content.ContentSourcePackageDetailsKey;
import org.rhq.core.clientapi.server.plugin.content.PackageSyncReport;
import org.rhq.core.clientapi.server.plugin.content.metadata.ContentSourcePluginMetadataManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceSyncResults;
import org.rhq.core.domain.content.ContentSourceSyncStatus;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.PackageVersionContentSource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.metadata.ContentSourceMetadataManagerLocal;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginContainerConfiguration;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginEnvironment;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginManager;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentSourceAdapterManager {
    private static final Log log = LogFactory.getLog(ContentSourceAdapterManager.class);
    private ContentSourcePluginContainerConfiguration configuration;
    private ContentSourcePluginManager pluginManager;
    private Map<ContentSource, ContentSourceAdapter> adapters;
    private Object synchronizeContentSourceLock = new Object();

    public InputStream loadPackageBits(int contentSourceId, String location) throws Exception {
        ContentSourceAdapter adapter = this.getIsolatedContentSourceAdapter(contentSourceId);
        InputStream inputStream = adapter.getInputStream(location);
        if (inputStream == null) {
            throw new Exception("Adapter for content source [" + contentSourceId + "] failed to give us a stream to the package at location [" + location + "]");
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean synchronizeContentSource(int contentSourceId) throws Exception {
        ContentSource contentSource;
        StringBuilder progress;
        SubjectManagerLocal subjMgr;
        ContentSourceSyncResults results;
        ContentSourceAdapter adapter;
        ContentSourceManagerLocal manager;
        block11: {
            manager = LookupUtil.getContentSourceManager();
            adapter = this.getIsolatedContentSourceAdapter(contentSourceId);
            results = null;
            subjMgr = LookupUtil.getSubjectManager();
            progress = new StringBuilder();
            contentSource = manager.getContentSource(subjMgr.getOverlord(), contentSourceId);
            if (contentSource == null) {
                throw new Exception("Cannot sync a non-existing content source [" + contentSourceId + "]");
            }
            Object object = this.synchronizeContentSourceLock;
            synchronized (object) {
                progress.append(new Date()).append(": ");
                progress.append("Start synchronization of content source [" + contentSource.getName() + "]");
                progress.append('\n');
                progress.append(new Date()).append(": ");
                progress.append("Getting currently known list of content source packages...");
                results = new ContentSourceSyncResults(contentSource);
                results.setResults(progress.toString());
                results = manager.persistContentSourceSyncResults(results);
            }
            if (results != null) break block11;
            log.info((Object)("Content source [" + contentSource.getName() + "] is already currently being synchronized, this sync request will be ignored"));
            boolean bl = false;
            Object var24_14 = null;
            if (results == null) return bl;
            results.setEndTime(new Long(System.currentTimeMillis()));
            manager.mergeContentSourceSyncResults(results);
            return bl;
        }
        try {
            try {
                long start = System.currentTimeMillis();
                PackageSyncReport report = new PackageSyncReport();
                PageControl pc = PageControl.getUnlimitedInstance();
                PageList<PackageVersionContentSource> existingPVCS = manager.getPackageVersionsFromContentSource(subjMgr.getOverlord(), contentSource.getId(), pc);
                int existingCount = existingPVCS.size();
                HashMap<ContentSourcePackageDetailsKey, PackageVersionContentSource> keyPVCSMap = new HashMap<ContentSourcePackageDetailsKey, PackageVersionContentSource>(existingCount);
                HashSet<ContentSourcePackageDetails> allDetails = new HashSet<ContentSourcePackageDetails>(existingCount);
                for (PackageVersionContentSource pvcs : existingPVCS) {
                    PackageVersion pv = pvcs.getPackageVersionContentSourcePK().getPackageVersion();
                    Package p = pv.getGeneralPackage();
                    ResourceType rt = p.getPackageType().getResourceType();
                    ContentSourcePackageDetailsKey key = new ContentSourcePackageDetailsKey(p.getName(), pv.getVersion(), p.getPackageType().getName(), pv.getArchitecture().getName(), rt.getName(), rt.getPlugin());
                    ContentSourcePackageDetails details = new ContentSourcePackageDetails(key);
                    details.setClassification(pv.getGeneralPackage().getClassification());
                    details.setDisplayName(pv.getDisplayName());
                    details.setDisplayVersion(pv.getDisplayVersion());
                    details.setExtraProperties(pv.getExtraProperties());
                    details.setFileCreatedDate(pv.getFileCreatedDate());
                    details.setFileName(pv.getFileName());
                    details.setFileSize(pv.getFileSize());
                    details.setLicenseName(pv.getLicenseName());
                    details.setLicenseVersion(pv.getLicenseVersion());
                    details.setLocation(pvcs.getLocation());
                    details.setLongDescription(pv.getLongDescription());
                    details.setMD5(pv.getMD5());
                    details.setMetadata(pv.getMetadata());
                    details.setSHA256(pv.getSHA256());
                    details.setShortDescription(pv.getShortDescription());
                    allDetails.add(details);
                    keyPVCSMap.put(key, pvcs);
                }
                log.info((Object)("synchronizeContentSource: [" + contentSource.getName() + "]: loaded existing list of size=[" + existingCount + "] (" + (System.currentTimeMillis() - start) + ")ms"));
                progress.append(existingCount).append('\n');
                progress.append(new Date()).append(": ");
                progress.append("Asking content source to update the list of packages...");
                results.setResults(progress.toString());
                results = manager.mergeContentSourceSyncResults(results);
                start = System.currentTimeMillis();
                adapter.synchronizePackages(report, allDetails);
                log.info((Object)("synchronizeContentSource: [" + contentSource.getName() + "]: got sync report from adapter=[" + report + "] (" + (System.currentTimeMillis() - start) + ")ms"));
                progress.append("new=").append(report.getNewPackages().size());
                progress.append(", updated=").append(report.getUpdatedPackages().size());
                progress.append(", deleted=").append(report.getDeletedPackages().size());
                progress.append('\n');
                progress.append(new Date()).append(": ");
                progress.append("FULL SUMMARY FOLLOWS:");
                progress.append('\n');
                progress.append(report.getSummary());
                progress.append('\n');
                progress.append(new Date()).append(": ");
                progress.append("Merging the updated list of packages to database");
                progress.append('\n');
                results.setResults(progress.toString());
                results = manager.mergeContentSourceSyncResults(results);
                start = System.currentTimeMillis();
                results = manager.mergeContentSourceSyncReport(contentSource, report, keyPVCSMap, results);
                progress.setLength(0);
                progress.append(results.getResults());
                log.info((Object)("synchronizeContentSource: [" + contentSource.getName() + "]: report has been merged (" + (System.currentTimeMillis() - start) + ")ms"));
                progress.append(new Date()).append(": ").append("DONE.");
                results.setResults(progress.toString());
                results.setStatus(ContentSourceSyncStatus.SUCCESS);
                results = manager.mergeContentSourceSyncResults(results);
            }
            catch (Throwable t) {
                if (results == null) throw new Exception("Failed to sync content source [" + contentSourceId + "]", t);
                ContentSourceSyncResults reloadedResults = manager.getContentSourceSyncResults(results.getId());
                if (reloadedResults != null && (results = reloadedResults).getResults() != null) {
                    progress = new StringBuilder(results.getResults());
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                t.printStackTrace(new PrintStream(baos));
                progress.append(new Date()).append(": ");
                progress.append("SYNCHRONIZATION ERROR - STACK TRACE FOLLOWS:\n");
                progress.append(baos.toString());
                results.setResults(progress.toString());
                results.setStatus(ContentSourceSyncStatus.FAILURE);
                throw new Exception("Failed to sync content source [" + contentSourceId + "]", t);
            }
            Object var24_15 = null;
            if (results == null) return true;
        }
        catch (Throwable throwable) {
            Object var24_16 = null;
            if (results == null) throw throwable;
            results.setEndTime(new Long(System.currentTimeMillis()));
            manager.mergeContentSourceSyncResults(results);
            throw throwable;
        }
        results.setEndTime(new Long(System.currentTimeMillis()));
        manager.mergeContentSourceSyncResults(results);
        return true;
    }

    public boolean testConnection(int contentSourceId) throws Exception {
        ContentSourceAdapter adapter = this.getIsolatedContentSourceAdapter(contentSourceId);
        try {
            adapter.testConnection();
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ContentSource> getAllContentSources() {
        Map<ContentSource, ContentSourceAdapter> map = this.adapters;
        synchronized (map) {
            return new HashSet<ContentSource>(this.adapters.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAdapter(ContentSource contentSource) {
        Map<ContentSource, ContentSourceAdapter> map = this.adapters;
        synchronized (map) {
            if (this.adapters.containsKey(contentSource)) {
                return;
            }
        }
        this.instantiateAdapter(contentSource);
        try {
            log.info((Object)("Initializing content source adapter for [" + contentSource + "] of type [" + contentSource.getContentSourceType() + "]"));
            ContentSourceAdapter adapter = this.getIsolatedContentSourceAdapter(contentSource);
            adapter.initialize(contentSource.getConfiguration());
        }
        catch (Throwable t) {
            log.warn((Object)("Failed to initialize adapter for content source [" + contentSource.getName() + "]"), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdownAdapter(ContentSource contentSource) {
        Map<ContentSource, ContentSourceAdapter> map = this.adapters;
        synchronized (map) {
            if (!this.adapters.containsKey(contentSource)) {
                return;
            }
        }
        try {
            try {
                log.info((Object)("Shutting down content source adapter for [" + contentSource + "] of type [" + contentSource.getContentSourceType() + "]"));
                ContentSourceAdapter adapter = this.getIsolatedContentSourceAdapter(contentSource);
                adapter.shutdown();
            }
            catch (Throwable t) {
                log.warn((Object)("Failed to shutdown adapter for content source [" + contentSource.getName() + "]"), t);
                Object var5_5 = null;
                this.adapters.remove(contentSource);
                return;
            }
            Object var5_4 = null;
            this.adapters.remove(contentSource);
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.adapters.remove(contentSource);
            throw throwable;
        }
    }

    public void restartAdapter(ContentSource contentSource) {
        this.shutdownAdapter(contentSource);
        this.startAdapter(contentSource);
    }

    protected void setConfiguration(ContentSourcePluginContainerConfiguration config) {
        this.configuration = config;
    }

    protected void initialize(ContentSourcePluginManager pluginManager) {
        this.pluginManager = pluginManager;
        ContentSourceMetadataManagerLocal metadataManager = LookupUtil.getContentSourceMetadataManager();
        ContentSourceManagerLocal contentSourceManager = LookupUtil.getContentSourceManager();
        ContentSourcePluginMetadataManager pluginMetadataManager = this.pluginManager.getMetadataManager();
        Set allTypes = pluginMetadataManager.getAllContentSourceTypes();
        metadataManager.registerTypes(allTypes);
        this.createInitialAdaptersMap();
        PageControl pc = PageControl.getUnlimitedInstance();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        PageList<ContentSource> contentSources = contentSourceManager.getAllContentSources(overlord, pc);
        if (contentSources != null) {
            for (ContentSource contentSource : contentSources) {
                this.startAdapter(contentSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        HashMap<ContentSource, ContentSourceAdapter> adaptersCopy;
        Map<ContentSource, ContentSourceAdapter> map = this.adapters;
        synchronized (map) {
            adaptersCopy = new HashMap<ContentSource, ContentSourceAdapter>(this.adapters);
        }
        for (ContentSource contentSource : adaptersCopy.keySet()) {
            this.shutdownAdapter(contentSource);
        }
        map = this.adapters;
        synchronized (map) {
            this.adapters.clear();
        }
    }

    protected void createInitialAdaptersMap() {
        this.adapters = new HashMap<ContentSource, ContentSourceAdapter>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentSourceAdapter instantiateAdapter(ContentSource contentSource) {
        ContentSourceAdapter adapter = null;
        String apiClassName = "?";
        String pluginName = "?";
        try {
            ContentSourceType type = contentSource.getContentSourceType();
            apiClassName = type.getContentSourceApiClass();
            pluginName = this.pluginManager.getMetadataManager().getPluginNameFromContentSourceType(type);
            ContentSourcePluginEnvironment pluginEnv = this.pluginManager.getPlugin(pluginName);
            ClassLoader pluginClassloader = pluginEnv.getClassLoader();
            ClassLoader startingClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(pluginClassloader);
                Class<?> apiClass = Class.forName(apiClassName, true, pluginClassloader);
                if (ContentSourceAdapter.class.isAssignableFrom(apiClass)) {
                    adapter = (ContentSourceAdapter)apiClass.newInstance();
                } else {
                    log.warn((Object)("The API class [" + apiClassName + "] does not implement [" + ContentSourceAdapter.class.getName() + "] in plugin [" + pluginName + "]"));
                }
                Object var11_11 = null;
                Thread.currentThread().setContextClassLoader(startingClassLoader);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                Thread.currentThread().setContextClassLoader(startingClassLoader);
                throw throwable;
            }
        }
        catch (Throwable t) {
            log.warn((Object)("Failed to create the API class [" + apiClassName + "] for plugin [" + pluginName + "]"), t);
        }
        if (adapter != null) {
            Map<ContentSource, ContentSourceAdapter> map = this.adapters;
            synchronized (map) {
                this.adapters.put(contentSource, adapter);
            }
        }
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentSourceAdapter getIsolatedContentSourceAdapter(int contentSourceId) throws RuntimeException {
        Map<ContentSource, ContentSourceAdapter> map = this.adapters;
        synchronized (map) {
            for (ContentSource contentSource : this.adapters.keySet()) {
                if (contentSource.getId() != contentSourceId) continue;
                return this.getIsolatedContentSourceAdapter(contentSource);
            }
        }
        throw new RuntimeException("Content source ID [" + contentSourceId + "] doesn't exist; can't get adapter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentSourceAdapter getIsolatedContentSourceAdapter(ContentSource contentSource) throws RuntimeException {
        ContentSourceAdapter adapter;
        Map<ContentSource, ContentSourceAdapter> map = this.adapters;
        synchronized (map) {
            adapter = this.adapters.get(contentSource);
        }
        if (adapter == null) {
            throw new RuntimeException("There is no adapter for content source [" + adapter + "]");
        }
        ContentSourcePluginEnvironment env = this.pluginManager.getPlugin(contentSource.getContentSourceType());
        if (env == null) {
            throw new RuntimeException("There is no plugin env. for content source [" + contentSource + "]");
        }
        ClassLoader classLoader = env.getClassLoader();
        IsolatedInvocationHandler handler = new IsolatedInvocationHandler(adapter, classLoader);
        Class[] ifaces = new Class[]{ContentSourceAdapter.class};
        return (ContentSourceAdapter)Proxy.newProxyInstance(classLoader, ifaces, (InvocationHandler)handler);
    }

    private class IsolatedInvocationHandler
    implements InvocationHandler {
        private final Object instance;
        private final ClassLoader classLoader;

        public IsolatedInvocationHandler(Object obj, ClassLoader cl) {
            this.instance = obj;
            this.classLoader = cl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ClassLoader startingClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                Object object = method.invoke(this.instance, args);
                Object var7_6 = null;
                Thread.currentThread().setContextClassLoader(startingClassLoader);
                return object;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                Thread.currentThread().setContextClassLoader(startingClassLoader);
                throw throwable;
            }
        }
    }
}

