/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.content;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.enterprise.server.plugin.content.ContentSourceAdapterManager;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginContainerConfiguration;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginManager;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.ContentSourceSyncJob;
import org.rhq.enterprise.server.util.LookupUtil;

public class ContentSourcePluginContainer {
    private static final String SYNC_JOB_GROUP_NAME = "syncContentSource";
    private static final Log log = LogFactory.getLog(ContentSourcePluginContainer.class);
    private ContentSourcePluginContainerConfiguration configuration;
    private ContentSourcePluginManager pluginManager;
    private ContentSourceAdapterManager adapterManager;

    public void initialize(ContentSourcePluginContainerConfiguration config) {
        log.debug((Object)("Content server plugin container has been initialized with config: " + config));
        this.configuration = config;
        this.pluginManager = this.createPluginManager();
        this.adapterManager = this.createAdapterManager(this.pluginManager);
    }

    public void shutdown() {
        log.debug((Object)"Content server plugin container is being shutdown");
        this.adapterManager.shutdown();
        this.pluginManager.shutdown();
        this.configuration = null;
    }

    public ContentSourcePluginContainerConfiguration getConfiguration() {
        return this.configuration;
    }

    public ContentSourceAdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    protected ContentSourcePluginManager getPluginManager() {
        return this.pluginManager;
    }

    public void syncNow(ContentSource contentSource) throws SchedulerException {
        JobDetail job = new JobDetail(ContentSourceSyncJob.createUniqueJobName(contentSource), SYNC_JOB_GROUP_NAME, ContentSourceSyncJob.class, false, false, false);
        ContentSourceSyncJob.createJobDataMap(contentSource, job);
        SimpleTrigger trigger = new SimpleTrigger(job.getName(), job.getGroup());
        trigger.setVolatility(false);
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        Date next = scheduler.scheduleJob(job, (Trigger)trigger);
        log.info((Object)("Scheduled content source sync job [" + job.getName() + ':' + job.getGroup() + "] to fire now at [" + next + "] for [" + contentSource + "]"));
    }

    public void scheduleSyncJob(ContentSource contentSource) throws SchedulerException {
        String syncSchedule = contentSource.getSyncSchedule();
        if (syncSchedule == null || syncSchedule.trim().length() == 0) {
            log.debug((Object)(contentSource.toString() + " does not define a sync schedule - not scheduling"));
            return;
        }
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        scheduler.scheduleCronJob(ContentSourceSyncJob.createJobName(contentSource), SYNC_JOB_GROUP_NAME, ContentSourceSyncJob.createJobDataMap(contentSource, null), ContentSourceSyncJob.class, true, false, syncSchedule);
    }

    public void scheduleSyncJobs() {
        if (this.adapterManager != null) {
            for (ContentSource contentSource : this.adapterManager.getAllContentSources()) {
                try {
                    this.scheduleSyncJob(contentSource);
                }
                catch (Exception e) {
                    log.warn((Object)("Could not schedule sync job for content source [" + contentSource + "]"), (Throwable)e);
                }
            }
        }
    }

    public void unscheduleSyncJob(ContentSource contentSource) throws SchedulerException {
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        scheduler.deleteJob(ContentSourceSyncJob.createJobName(contentSource), SYNC_JOB_GROUP_NAME);
    }

    protected ContentSourcePluginManager createPluginManager() {
        ContentSourcePluginManager pm = new ContentSourcePluginManager();
        pm.setConfiguration(this.getConfiguration());
        pm.initialize();
        return pm;
    }

    protected ContentSourceAdapterManager createAdapterManager(ContentSourcePluginManager pluginManager) {
        ContentSourceAdapterManager am = new ContentSourceAdapterManager();
        am.setConfiguration(this.getConfiguration());
        am.initialize(pluginManager);
        return am;
    }
}

