/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.content;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.Management;
import org.jboss.annotation.ejb.Service;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginContainer;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginContainerConfiguration;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginServiceManagement;

@Management(value=ContentSourcePluginServiceManagement.class)
@Service(objectName="rhq.serverplugin:service=ContentSourcePluginService")
public class ContentSourcePluginService
implements ContentSourcePluginServiceManagement {
    private static final Log log = LogFactory.getLog(ContentSourcePluginService.class);
    private boolean started;
    private ContentSourcePluginContainer pluginContainer;

    public synchronized void start() {
        log.debug((Object)"The content source plugin service has been deployed (but plugin container will not be started yet)");
        this.started = true;
    }

    public synchronized void startPluginContainer() {
        if (!this.started) {
            throw new IllegalStateException("The content source plugin service is not started - cannot start the plugin container");
        }
        if (this.pluginContainer == null) {
            log.debug((Object)"The content source plugin service is now starting the content server plugin container");
            this.pluginContainer = this.createPluginContainer();
        }
    }

    public synchronized void stopPluginContainer() {
        if (this.started && this.pluginContainer != null) {
            log.info((Object)"The content source plugin service is now stopping - the content server plugin container will be shutdown now");
            this.pluginContainer.shutdown();
            this.pluginContainer = null;
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.stopPluginContainer();
            this.started = false;
        }
    }

    public synchronized void restartPluginContainer() {
        this.stopPluginContainer();
        this.startPluginContainer();
    }

    public ContentSourcePluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isPluginContainerStarted() {
        return this.pluginContainer != null;
    }

    protected ContentSourcePluginContainer createPluginContainer() {
        ContentSourcePluginContainer pc = new ContentSourcePluginContainer();
        ContentSourcePluginContainerConfiguration config = new ContentSourcePluginContainerConfiguration();
        String pluginDirStr = System.getProperty("jboss.server.home.dir");
        config.setPluginDirectory(new File(pluginDirStr, "deploy/rhq.ear/rhq-serverplugins"));
        String tmpDirStr = System.getProperty("jboss.server.temp.dir");
        config.setTemporaryDirectory(new File(tmpDirStr));
        pc.initialize(config);
        return pc;
    }
}

