/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group.definition;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.group.GroupDefinition;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.resource.group.composite.ResourceGroupComposite;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PersistenceUtility;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.RecursivityChangeType;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupUpdateException;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionManagerLocal;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionAlreadyExistsException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionCreateException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionDeleteException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionNotFoundException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionUpdateException;
import org.rhq.enterprise.server.resource.group.definition.framework.ExpressionEvaluator;
import org.rhq.enterprise.server.resource.group.definition.framework.InvalidExpressionException;
import org.rhq.enterprise.server.resource.group.definition.mbean.GroupDefinitionRecalculationThreadMonitor;
import org.rhq.enterprise.server.resource.group.definition.mbean.GroupDefinitionRecalculationThreadMonitorMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
public class GroupDefinitionManagerBean
implements GroupDefinitionManagerLocal {
    private final Log log = LogFactory.getLog(GroupDefinitionManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS")
    private DataSource rhqDs;
    private DatabaseType dbType;
    @EJB
    private GroupDefinitionManagerLocal groupDefinitionManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;

    @PostConstruct
    public void init() {
        Connection conn = null;
        try {
            try {
                conn = this.rhqDs.getConnection();
                this.dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            JDBCUtil.safeClose((Connection)conn);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void recalculateDynaGroups(Subject subject) {
        Query recalculationFinderQuery = this.entityManager.createNamedQuery("GroupDefinition.findIdsForRecalculation_admin");
        recalculationFinderQuery.setParameter("now", (Object)System.currentTimeMillis());
        List groupDefinitionIdsToRecalculate = recalculationFinderQuery.getResultList();
        if (groupDefinitionIdsToRecalculate.size() == 0) {
            return;
        }
        GroupDefinitionRecalculationThreadMonitorMBean monitor = GroupDefinitionRecalculationThreadMonitor.getMBean();
        long totalStart = System.currentTimeMillis();
        for (Integer groupDefinitionId : groupDefinitionIdsToRecalculate) {
            long singleStart = System.currentTimeMillis();
            boolean success = false;
            try {
                this.groupDefinitionManager.calculateGroupMembership(subject, groupDefinitionId);
                success = true;
            }
            catch (Throwable t) {
                this.log.error((Object)("Error recalculating DynaGroups for GroupDefinition[id=" + groupDefinitionId + "]"), t);
            }
            long singleEnd = System.currentTimeMillis();
            try {
                GroupDefinition groupDefinition = this.getById(groupDefinitionId);
                int size = this.getManagedResourceGroupSizeForGroupDefinition(groupDefinitionId);
                monitor.updateStatistic(groupDefinition.getName(), size, success, singleEnd - singleStart);
            }
            catch (Throwable t) {
                this.log.error((Object)("Error updating DynaGroup statistics GroupDefinition[id=" + groupDefinitionId + "]"), t);
            }
        }
        long totalEnd = System.currentTimeMillis();
        monitor.updateAutoRecalculationThreadTime(totalEnd - totalStart);
    }

    @Override
    public GroupDefinition getById(int groupDefinitionId) throws GroupDefinitionNotFoundException {
        GroupDefinition groupDefinition = (GroupDefinition)this.entityManager.find(GroupDefinition.class, (Object)groupDefinitionId);
        if (groupDefinition == null) {
            throw new GroupDefinitionNotFoundException("Group definition with specified id does not exist");
        }
        return groupDefinition;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public GroupDefinition createGroupDefinition(Subject subject, GroupDefinition newGroupDefinition) throws GroupDefinitionAlreadyExistsException, GroupDefinitionCreateException {
        try {
            this.validate(newGroupDefinition, null);
        }
        catch (GroupDefinitionException gde) {
            throw new GroupDefinitionCreateException(gde.getMessage());
        }
        try {
            this.entityManager.persist((Object)newGroupDefinition);
        }
        catch (Exception e) {
            throw new GroupDefinitionCreateException(e);
        }
        return newGroupDefinition;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public GroupDefinition updateGroupDefinition(Subject subject, GroupDefinition groupDefinition) throws GroupDefinitionAlreadyExistsException, GroupDefinitionUpdateException, InvalidExpressionException, ResourceGroupUpdateException {
        boolean nameChanged = false;
        try {
            nameChanged = this.validate(groupDefinition, groupDefinition.getId());
        }
        catch (GroupDefinitionException gde) {
            throw new GroupDefinitionUpdateException(gde.getMessage());
        }
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        for (String expression : groupDefinition.getExpressionAsList()) {
            evaluator.addExpression(expression);
        }
        RecursivityChangeType changeType = RecursivityChangeType.None;
        GroupDefinition attachedGroupDefinition = null;
        try {
            attachedGroupDefinition = this.getById(groupDefinition.getId());
        }
        catch (GroupDefinitionNotFoundException gdnfe) {
            throw new GroupDefinitionUpdateException(gdnfe.getMessage());
        }
        if (groupDefinition.isRecursive() && !attachedGroupDefinition.isRecursive()) {
            changeType = RecursivityChangeType.AddedRecursion;
        } else if (!groupDefinition.isRecursive() && attachedGroupDefinition.isRecursive()) {
            changeType = RecursivityChangeType.RemovedRecursion;
        }
        if (nameChanged || changeType != RecursivityChangeType.None) {
            String oldGroupDefinitionName = attachedGroupDefinition.getName();
            Subject overlord = this.subjectManager.getOverlord();
            for (ResourceGroup dynaGroup : attachedGroupDefinition.getManagedResourceGroups()) {
                String dynaGroupName = dynaGroup.getName();
                String newDynaGroupName = this.updateDynaGroupName(oldGroupDefinitionName, groupDefinition.getName(), dynaGroupName);
                dynaGroup.setName(newDynaGroupName);
                this.resourceGroupManager.updateResourceGroup(overlord, dynaGroup, changeType);
            }
        }
        try {
            return (GroupDefinition)this.entityManager.merge((Object)groupDefinition);
        }
        catch (Exception e) {
            throw new GroupDefinitionUpdateException(e);
        }
    }

    private boolean validate(GroupDefinition definition, Integer id) throws GroupDefinitionException, GroupDefinitionAlreadyExistsException {
        String description;
        String name = definition.getName() == null ? "" : definition.getName().trim();
        String string = description = definition.getDescription() == null ? "" : definition.getDescription().trim();
        if (name.equals("")) {
            throw new GroupDefinitionException("Name is a required property");
        }
        if (name.length() > 100) {
            throw new GroupDefinitionException("Name is limited to 100 characters");
        }
        if (description.length() > 100) {
            throw new GroupDefinitionException("Description is limited to 100 characters");
        }
        Query query = this.entityManager.createNamedQuery("GroupDefinition.findByName");
        query.setParameter("name", (Object)name);
        try {
            GroupDefinition found = (GroupDefinition)query.getSingleResult();
            if (id == null || found.getId() != id.intValue()) {
                throw new GroupDefinitionAlreadyExistsException("GroupDefinition with name " + name + " already exists");
            }
        }
        catch (NoResultException e) {
            return true;
        }
        return false;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void calculateGroupMembership(Subject subject, int groupDefinitionId) throws GroupDefinitionDeleteException, GroupDefinitionNotFoundException, InvalidExpressionException, ResourceGroupUpdateException {
        long startTime = System.currentTimeMillis();
        GroupDefinition groupDefinition = this.getById(groupDefinitionId);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        for (String expression : groupDefinition.getExpressionAsList()) {
            evaluator.addExpression(expression);
        }
        ArrayList<Integer> doomedResourceGroupIds = new ArrayList<Integer>();
        for (Integer managedGroupId : this.getManagedResourceGroupIdsForGroupDefinition(groupDefinitionId)) {
            doomedResourceGroupIds.add(managedGroupId);
        }
        for (ExpressionEvaluator.Result result : evaluator) {
            if (result == null) continue;
            Integer nextResourceGroupId = this.groupDefinitionManager.calculateGroupMembership_helper(subject, groupDefinitionId, result);
            doomedResourceGroupIds.remove(nextResourceGroupId);
        }
        for (Integer doomedGroupId : doomedResourceGroupIds) {
            this.groupDefinitionManager.removeManagedResource_helper(subject, groupDefinitionId, doomedGroupId);
        }
        groupDefinition = this.getById(groupDefinitionId);
        groupDefinition.setLastCalculationTime(Long.valueOf(System.currentTimeMillis()));
        long endTime = System.currentTimeMillis();
        this.log.debug((Object)("calculateGroupMembership took " + (endTime - startTime) + " millis"));
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Integer calculateGroupMembership_helper(Subject overlord, int groupDefinitionId, ExpressionEvaluator.Result result) throws GroupDefinitionNotFoundException, GroupDefinitionNotFoundException {
        long startTime = System.currentTimeMillis();
        GroupDefinition groupDefinition = this.getById(groupDefinitionId);
        String groupByClause = result.getGroupByClause();
        ResourceGroup resourceGroup = this.resourceGroupManager.getByGroupDefinitionAndGroupByClause(groupDefinition.getId(), groupByClause);
        int resourceGroupId = 0;
        if (resourceGroup == null) {
            String newDynamicGroupName = this.getDynamicGroupName(groupDefinition.getName(), groupByClause);
            resourceGroup = new ResourceGroup(newDynamicGroupName);
            resourceGroupId = this.resourceGroupManager.createResourceGroup(overlord, resourceGroup).getId();
            resourceGroup.setRecursive(groupDefinition.isRecursive());
            resourceGroup.setGroupByClause(groupByClause);
            groupDefinition.addResourceGroup(resourceGroup);
        } else {
            resourceGroupId = resourceGroup.getId();
        }
        List<Integer> existingResourceIds = this.resourceManager.findExplicitResourceIdsByResourceGroup(resourceGroup.getId());
        HashSet<Integer> idsToAdd = new HashSet<Integer>(result.getData());
        idsToAdd.removeAll(existingResourceIds);
        HashSet<Integer> idsToRemove = new HashSet<Integer>(existingResourceIds);
        idsToRemove.removeAll(result.getData());
        this.resourceGroupManager.addResourcesToGroup(overlord, resourceGroupId, ArrayUtils.unwrapCollection(idsToAdd));
        this.resourceGroupManager.removeResourcesFromGroup(overlord, resourceGroupId, ArrayUtils.unwrapCollection(idsToRemove));
        this.resourceGroupManager.setResourceType(resourceGroupId);
        this.entityManager.flush();
        this.entityManager.clear();
        long endTime = System.currentTimeMillis();
        this.log.debug((Object)("calculateGroupMembership_helper took " + (endTime - startTime) + " millis"));
        return resourceGroupId;
    }

    private Map<Integer, ResourceGroup> getIdGroupMap(List<Integer> groupIds) {
        if (groupIds == null || groupIds.size() == 0) {
            return new HashMap<Integer, ResourceGroup>();
        }
        Query query = this.entityManager.createNamedQuery("ResourceGroup.findByIds_admin");
        query.setParameter("ids", groupIds);
        List groups = query.getResultList();
        HashMap<Integer, ResourceGroup> results = new HashMap<Integer, ResourceGroup>();
        for (ResourceGroup group : groups) {
            results.put(group.getId(), group);
        }
        return results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<ResourceGroupComposite> getManagedResourceGroups(Subject subject, int groupDefinitionId, PageControl pc) throws GroupDefinitionException {
        pc.initDefaultOrderingField("groupName");
        pc.truncateOrderingFields(1);
        OrderingField primary = (OrderingField)pc.getOrderingFields().get(0);
        String field = primary.getField();
        if (field.endsWith("Avail")) {
            String prefix = field.substring(0, field.length() - 5);
            String secondaryField = prefix + "Count";
            pc.addDefaultOrderingField(secondaryField, primary.getOrdering());
        }
        if (!field.equals("groupName")) {
            pc.addDefaultOrderingField("groupName");
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Object[]> rawResults = new ArrayList<Object[]>();
        try {
            try {
                conn = this.rhqDs.getConnection();
                String query = "         SELECT               (     SELECT COUNT(eresAvail.ID)                       FROM rhq_resource_avail eresAvail                 INNER JOIN rhq_resource eres                         ON eresAvail.resource_id = eres.id                 INNER JOIN rhq_resource_group_res_exp_map expMap                         ON eres.id = expMap.resource_id                      WHERE expMap.resource_group_id = rg.id               ) as explicitCount,               (     SELECT AVG(eresAvail.availability_type)                       FROM rhq_resource_avail eresAvail                 INNER JOIN rhq_resource eres                         ON eresAvail.resource_id = eres.id                 INNER JOIN rhq_resource_group_res_exp_map expMap                         ON eres.id = expMap.resource_id                      WHERE expMap.resource_group_id = rg.id               ) as explicitAvail,               (     SELECT COUNT(iresAvail.ID)                       FROM rhq_resource_avail iresAvail                 INNER JOIN rhq_resource ires                         ON iresAvail.resource_id = ires.id                 INNER JOIN rhq_resource_group_res_imp_map impMap                         ON ires.id = impMap.resource_id                      WHERE impMap.resource_group_id = rg.id               ) as implicitCount,               (     SELECT AVG(iresAvail.availability_type)                       FROM rhq_resource_avail iresAvail                 INNER JOIN rhq_resource ires                         ON iresAvail.resource_id = ires.id                 INNER JOIN rhq_resource_group_res_imp_map impMap                         ON ires.id = impMap.resource_id                      WHERE impMap.resource_group_id = rg.id               ) as implicitAvail,                 rg.id as groupId,                 rg.name as groupName,                 rg.category as groupCategory,                 rg.group_by as groupedBy            FROM rhq_resource_group rg LEFT OUTER JOIN rhq_resource_group_res_imp_map memberMap              ON rg.id = memberMap.resource_group_id LEFT OUTER JOIN rhq_resource res              ON memberMap.resource_id = res.id LEFT OUTER JOIN rhq_resource_avail resAvail              ON res.id = resAvail.resource_id           WHERE rg.group_definition_id = ?        GROUP BY rg.id, rg.category, rg.name, rg.group_by ";
                if (this.dbType instanceof PostgresqlDatabaseType) {
                    query = PersistenceUtility.addPostgresNativePagingSortingToQuery((String)query, (PageControl)pc);
                } else if (this.dbType instanceof OracleDatabaseType) {
                    query = PersistenceUtility.addOracleNativePagingSortingToQuery((String)query, (PageControl)pc);
                } else if (this.dbType instanceof H2DatabaseType) {
                    query = PersistenceUtility.addH2NativePagingSortingToQuery((String)query, (PageControl)pc);
                } else if (this.dbType instanceof SQLServerDatabaseType) {
                    query = PersistenceUtility.addSQLServerNativePagingSortingToQuery((String)query, (PageControl)pc);
                } else {
                    throw new RuntimeException("Unknown database type: " + this.dbType);
                }
                stmt = conn.prepareStatement(query);
                stmt.setInt(1, groupDefinitionId);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    long explicitCount = rs.getLong(1);
                    double explicitAvail = rs.getDouble(2);
                    long implicitCount = rs.getLong(3);
                    double implicitAvail = rs.getDouble(4);
                    int groupId = rs.getInt(5);
                    Object[] next = new Object[]{explicitCount, explicitAvail, implicitCount, implicitAvail, groupId};
                    rawResults.add(next);
                }
                Object var22_23 = null;
            }
            catch (Throwable t) {
                throw new GroupDefinitionException(t);
            }
        }
        catch (Throwable throwable) {
            Object var22_24 = null;
            JDBCUtil.safeClose((Connection)conn, stmt, rs);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)stmt, (ResultSet)rs);
        Query queryCount = this.entityManager.createNamedQuery("GroupDefinition.findMembers_count");
        queryCount.setParameter("groupDefinitionId", (Object)groupDefinitionId);
        long count = (Long)queryCount.getSingleResult();
        ArrayList<Integer> groupIds = new ArrayList<Integer>();
        for (Object[] row : rawResults) {
            groupIds.add(((Number)row[4]).intValue());
        }
        Map<Integer, ResourceGroup> groupMap = this.getIdGroupMap(groupIds);
        ArrayList<ResourceGroupComposite> results = new ArrayList<ResourceGroupComposite>(rawResults.size());
        int i = 0;
        for (Object[] row : rawResults) {
            ResourceGroup group;
            ResourceType type;
            long explicitCount = (Long)row[0];
            double explicitAvail = (Double)row[1];
            long implicitCount = (Long)row[2];
            double implicitAvail = (Double)row[3];
            ResourceFacets facets = (type = (group = groupMap.get(groupIds.get(i++))).getResourceType()) == null ? ResourceFacets.NONE : this.resourceTypeManager.getResourceFacets(group.getResourceType().getId());
            ResourceGroupComposite composite = new ResourceGroupComposite(explicitCount, explicitAvail, implicitCount, implicitAvail, group, facets);
            results.add(composite);
        }
        return new PageList(results, (int)count, pc);
    }

    @Override
    public PageList<GroupDefinition> getGroupDefinitions(Subject subject, PageControl pc) {
        pc.initDefaultOrderingField("gd.name");
        if (this.authorizationManager.isInventoryManager(subject)) {
            Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"GroupDefinition.findAll", (PageControl)pc);
            List results = query.getResultList();
            int count = this.getGroupDefinitionCount(subject);
            return new PageList((Collection)results, count, pc);
        }
        return new PageList(pc);
    }

    @Override
    public int getGroupDefinitionCount(Subject subject) {
        if (this.authorizationManager.isInventoryManager(subject)) {
            Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"GroupDefinition.findAll");
            long count = (Long)queryCount.getSingleResult();
            return (int)count;
        }
        return 0;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public int getAutoRecalculationGroupDefinitionCount(Subject subject) {
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"GroupDefinition.findAllRecalculating_admin");
        long count = (Long)queryCount.getSingleResult();
        return (int)count;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public int getDynaGroupCount(Subject subject) {
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"GroupDefinition.findAllMembers_admin");
        long count = (Long)queryCount.getSingleResult();
        return (int)count;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void removeGroupDefinition(Subject subject, Integer groupDefinitionId) throws GroupDefinitionNotFoundException, GroupDefinitionDeleteException {
        List<Integer> managedGroupIds = this.getManagedResourceGroupIdsForGroupDefinition(groupDefinitionId);
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer managedGroupId : managedGroupIds) {
            this.removeManagedResource_helper(overlord, groupDefinitionId, managedGroupId);
        }
        GroupDefinition groupDefinition = this.getById(groupDefinitionId);
        try {
            this.entityManager.remove((Object)groupDefinition);
        }
        catch (Exception e) {
            throw new GroupDefinitionDeleteException("Error deleting groupDefinition '" + groupDefinition.getName() + "': ", e);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void removeManagedResource_helper(Subject overlord, int groupDefinitionId, Integer doomedGroupId) throws GroupDefinitionDeleteException, GroupDefinitionNotFoundException {
        GroupDefinition groupDefinition = this.getById(groupDefinitionId);
        ResourceGroup doomedGroup = (ResourceGroup)this.entityManager.getReference(ResourceGroup.class, (Object)doomedGroupId);
        groupDefinition.removeResourceGroup(doomedGroup);
        try {
            this.resourceGroupManager.deleteResourceGroup(this.subjectManager.getOverlord(), doomedGroupId);
        }
        catch (Exception e) {
            throw new GroupDefinitionDeleteException("Error removing managedGroup '" + doomedGroup.getName() + "' " + "from groupDefinition '" + groupDefinition.getName() + "': ", e);
        }
    }

    private List<Integer> getManagedResourceGroupIdsForGroupDefinition(int groupDefinitionId) {
        Query query = this.entityManager.createNamedQuery("GroupDefinition.findManagedResourceGroupIds_admin");
        query.setParameter("groupDefinitionId", (Object)groupDefinitionId);
        List results = query.getResultList();
        return results;
    }

    private int getManagedResourceGroupSizeForGroupDefinition(int groupDefinitionId) {
        Query query = this.entityManager.createNamedQuery("GroupDefinition.findManagedResourceGroupSize_admin");
        query.setParameter("groupDefinitionId", (Object)groupDefinitionId);
        Number result = (Number)query.getSingleResult();
        return result.intValue();
    }

    private String getDynamicGroupName(String groupDefinitionName, String groupByClause) {
        String newDynamicGroupName = "DynaGroup - " + groupDefinitionName + (groupByClause.equals("") ? "" : " ( " + groupByClause + " )");
        return newDynamicGroupName;
    }

    private String updateDynaGroupName(String oldGroupDefinitionName, String updatedGroupDefinitionName, String dynaGroupName) throws GroupDefinitionUpdateException {
        String newGroupDefinitionName = updatedGroupDefinitionName;
        int oldGroupNameIndexStart = 12;
        int oldGroupNameLength = oldGroupDefinitionName.length();
        return dynaGroupName.substring(0, oldGroupNameIndexStart) + newGroupDefinitionName + dynaGroupName.substring(oldGroupNameIndexStart + oldGroupNameLength);
    }
}

