/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.system;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.system.server.ServerConfig;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.SystemConfiguration;
import org.rhq.core.domain.util.PersistenceUtility;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.core.util.StopWatch;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.core.CustomJaasDeploymentServiceMBean;
import org.rhq.enterprise.server.license.FeatureUnavailableException;
import org.rhq.enterprise.server.license.License;
import org.rhq.enterprise.server.license.LicenseManager;
import org.rhq.enterprise.server.license.LicenseStoreManager;
import org.rhq.enterprise.server.system.InvalidSystemConfigurationException;
import org.rhq.enterprise.server.system.LicenseException;
import org.rhq.enterprise.server.system.ServerVersion;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerRemote;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
public class SystemManagerBean
implements SystemManagerLocal,
SystemManagerRemote {
    private final String SQL_VACUUM = "VACUUM ANALYZE {0}";
    private final String SQL_ANALYZE = "ANALYZE";
    private final String SQL_REINDEX = "REINDEX TABLE {0}";
    private final String SQL_REBUILD = "ALTER INDEX {0} REBUILD UNRECOVERABLE";
    private final String[] TABLES_TO_VACUUM = new String[]{"RHQ_RESOURCE", "RHQ_CONFIG", "RHQ_CONFIG_PROPERTY", "RHQ_AGENT"};
    private final String[] TABLES_TO_REINDEX = new String[]{"RHQ_MEASUREMENT_DATA_NUM_1D", "RHQ_MEASUREMENT_DATA_NUM_6H", "RHQ_MEASUREMENT_DATA_NUM_1H", "RHQ_MEASUREMENT_DATA_TRAIT", "RHQ_CALLTIME_DATA_KEY", "RHQ_CALLTIME_DATA_VALUE", "RHQ_AVAILABILITY"};
    private final String[] ORA_INDEXES_TO_REBUILD = new String[]{"RHQ_MEAS_DATA_1H_ID_TIME_PK", "RHQ_MEAS_DATA_6H_ID_TIME_PK", "RHQ_MEAS_DATA_1D_ID_TIME_PK", "RHQ_MEAS_BASELINE_CTIME_IDX", "RHQ_MEAS_DATA_TRAIT_ID_TIME_PK"};
    private Log log = LogFactory.getLog(SystemManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS", mappedName="java:/RHQDS")
    private DataSource dataSource;
    @Resource
    private TimerService timerService;
    private LicenseManager licenseManager;
    @EJB
    private SystemManagerLocal systemManager;
    private static Properties systemConfigurationCache = null;
    private final String TIMER_DATA = "SystemManagerBean.reloadConfigCache";

    @PostConstruct
    public void initialize() {
        this.licenseManager = LicenseManager.instance();
    }

    public void scheduleConfigCacheReloader() {
        Collection timers = this.timerService.getTimers();
        for (Timer existingTimer : timers) {
            this.log.debug((Object)("Found timer - attempting to cancel: " + existingTimer.toString()));
            try {
                existingTimer.cancel();
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed in attempting to cancel timer: " + existingTimer.toString()));
            }
        }
        this.timerService.createTimer(60000L, (Serializable)((Object)"SystemManagerBean.reloadConfigCache"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Timeout
    public void reloadConfigCache(Timer timer) {
        try {
            try {
                this.systemManager.loadSystemConfigurationCacheInNewTx();
            }
            catch (Throwable t) {
                this.log.error((Object)("Failed to reload the system config cache - will try again later. Cause: " + t));
                Object var4_3 = null;
                this.timerService.createTimer(60000L, (Serializable)((Object)"SystemManagerBean.reloadConfigCache"));
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.timerService.createTimer(60000L, (Serializable)((Object)"SystemManagerBean.reloadConfigCache"));
            throw throwable;
        }
        this.timerService.createTimer(60000L, (Serializable)((Object)"SystemManagerBean.reloadConfigCache"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public DatabaseType getDatabaseType() {
        DatabaseType databaseType;
        Connection conn = null;
        DatabaseType dbtype = null;
        try {
            try {
                conn = this.dataSource.getConnection();
                databaseType = dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
                Object var5_5 = null;
                if (conn == null) return databaseType;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException e2) {
                this.log.warn((Object)"Failed to close temporary connection", (Throwable)e2);
                throw throwable;
            }
        }
        try {}
        catch (SQLException e2) {
            this.log.warn((Object)"Failed to close temporary connection", (Throwable)e2);
            return databaseType;
        }
        conn.close();
        return databaseType;
    }

    public Properties getSystemConfiguration() {
        if (systemConfigurationCache == null) {
            this.loadSystemConfigurationCache();
        }
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)systemConfigurationCache);
        return copy;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void loadSystemConfigurationCacheInNewTx() {
        this.loadSystemConfigurationCache();
    }

    public void loadSystemConfigurationCache() {
        List configs = this.entityManager.createNamedQuery("SystemConfiguration.findAll").getResultList();
        Properties properties = new Properties();
        for (SystemConfiguration config : configs) {
            this.transformSystemConfigurationProperty(config);
            if (config.getPropertyValue() == null) {
                String defaultValue = config.getDefaultPropertyValue();
                properties.put(config.getPropertyKey(), defaultValue != null ? defaultValue : "");
                continue;
            }
            properties.put(config.getPropertyKey(), config.getPropertyValue());
        }
        systemConfigurationCache = properties;
    }

    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void setSystemConfiguration(Subject subject, Properties properties, boolean skipValidation) {
        List configs = this.entityManager.createNamedQuery("SystemConfiguration.findAll").getResultList();
        HashMap<String, SystemConfiguration> existingConfigMap = new HashMap<String, SystemConfiguration>();
        for (SystemConfiguration config : configs) {
            existingConfigMap.put(config.getPropertyKey(), config);
        }
        Properties newCacheProperties = new Properties();
        for (Object key : properties.keySet()) {
            String name = (String)key;
            String value = properties.getProperty(name);
            if (!skipValidation) {
                this.verifyNewSystemConfigurationProperty(name, value, properties);
            }
            newCacheProperties.setProperty(name, value);
            SystemConfiguration existingConfig = (SystemConfiguration)existingConfigMap.get(name);
            if (existingConfig == null) {
                existingConfig = new SystemConfiguration(name, value);
                this.transformSystemConfigurationProperty(existingConfig);
                this.entityManager.persist((Object)existingConfig);
                continue;
            }
            if (existingConfig.getPropertyValue() != null && existingConfig.getPropertyValue().equals(value)) continue;
            if (existingConfig.getFreadOnly() != null && existingConfig.getFreadOnly().booleanValue()) {
                throw new IllegalArgumentException("The setting [" + name + "] is read-only - you cannot change its current value!");
            }
            existingConfig.setPropertyValue(value);
            this.transformSystemConfigurationProperty(existingConfig);
            this.entityManager.merge((Object)existingConfig);
        }
        systemConfigurationCache = newCacheProperties;
    }

    private void transformSystemConfigurationProperty(SystemConfiguration prop) {
        String propName = prop.getPropertyKey();
        if ("ENABLE_AGENT_AUTO_UPDATE".equals(propName) || "ENABLE_DEBUG_MODE".equals(propName) || "DATA_REINDEX_NIGHTLY".equals(propName)) {
            String booleanValue = prop.getPropertyValue();
            if ("0".equals(booleanValue)) {
                prop.setPropertyValue(Boolean.FALSE.toString());
            } else if ("1".equals(booleanValue)) {
                prop.setPropertyValue(Boolean.TRUE.toString());
            }
        }
    }

    private void verifyNewSystemConfigurationProperty(String name, String value, Properties properties) {
        long time;
        if ("CAM_BASELINE_DATASET".equals(name)) {
            long baselineDataSet = Long.parseLong(value);
            if (baselineDataSet > 1209600000L) {
                throw new InvalidSystemConfigurationException("Baseline dataset must be less than 14 days");
            }
        } else if ("CAM_BASELINE_FREQUENCY".equals(name)) {
            long baselineDataSet;
            long baselineFrequency = Long.parseLong(value);
            if (baselineFrequency > (baselineDataSet = Long.parseLong(properties.getProperty("CAM_BASELINE_DATASET")))) {
                throw new InvalidSystemConfigurationException("baseline computation frequency must not be larger than baseline data set");
            }
        } else if ("AGENT_MAX_QUIET_TIME_ALLOWED".endsWith(name) && (time = Long.parseLong(value)) < 120000L) {
            throw new InvalidSystemConfigurationException("Agent Max Quiet Time Allowed must be at least 2 minutes");
        }
    }

    public void enableHibernateStatistics() {
        PersistenceUtility.enableHibernateStatistics((EntityManager)this.entityManager, (MBeanServer)ManagementFactory.getPlatformMBeanServer());
    }

    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void reconfigureSystem(Subject whoami) {
        try {
            CustomJaasDeploymentServiceMBean mbean = MBeanServerInvocationHandler.newProxyInstance(MBeanServerLocator.locateJBoss(), CustomJaasDeploymentServiceMBean.OBJECT_NAME, CustomJaasDeploymentServiceMBean.class, false);
            mbean.installJaasModules();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long analyze(Subject whoami) {
        long l;
        block7: {
            DatabaseType dbtype;
            Connection conn;
            block5: {
                long l2;
                block6: {
                    conn = null;
                    dbtype = null;
                    conn = this.dataSource.getConnection();
                    dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
                    if (DatabaseTypeFactory.isPostgres((DatabaseType)dbtype)) break block5;
                    l2 = -1L;
                    Object var9_7 = null;
                    if (dbtype == null) break block6;
                    dbtype.closeConnection(conn);
                }
                return l2;
            }
            try {
                long duration;
                l = duration = this.doCommand(dbtype, conn, "ANALYZE", null);
                Object var9_8 = null;
                if (dbtype == null) break block7;
            }
            catch (Exception e) {
                try {
                    this.log.error((Object)"Error analyzing database", (Throwable)e);
                    throw new RuntimeException("Error analyzing database", e);
                }
                catch (Throwable throwable) {
                    block8: {
                        Object var9_9 = null;
                        if (dbtype == null) break block8;
                        dbtype.closeConnection(conn);
                    }
                    throw throwable;
                }
            }
            dbtype.closeConnection(conn);
        }
        return l;
    }

    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long reindex(Subject whoami) {
        long l;
        block11: {
            long duration;
            DatabaseType dbtype;
            Connection conn;
            block9: {
                long l2;
                block10: {
                    int i;
                    conn = null;
                    dbtype = null;
                    conn = this.dataSource.getConnection();
                    dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
                    duration = 0L;
                    if (DatabaseTypeFactory.isPostgres((DatabaseType)dbtype)) {
                        for (i = 0; i < this.TABLES_TO_REINDEX.length; ++i) {
                            duration += this.doCommand(dbtype, conn, "REINDEX TABLE {0}", this.TABLES_TO_REINDEX[i]);
                        }
                        break block9;
                    }
                    if (DatabaseTypeFactory.isOracle((DatabaseType)dbtype)) {
                        for (i = 0; i < this.ORA_INDEXES_TO_REBUILD.length; ++i) {
                            duration += this.doCommand(dbtype, conn, "ALTER INDEX {0} REBUILD UNRECOVERABLE", this.ORA_INDEXES_TO_REBUILD[i]);
                        }
                        break block9;
                    }
                    l2 = -1L;
                    Object var9_9 = null;
                    if (dbtype == null) break block10;
                    dbtype.closeConnection(conn);
                }
                return l2;
            }
            try {
                l = duration;
                Object var9_10 = null;
                if (dbtype == null) break block11;
            }
            catch (Exception e) {
                try {
                    this.log.error((Object)"Error reindexing database", (Throwable)e);
                    throw new RuntimeException("Error reindexing database", e);
                }
                catch (Throwable throwable) {
                    block12: {
                        Object var9_11 = null;
                        if (dbtype == null) break block12;
                        dbtype.closeConnection(conn);
                    }
                    throw throwable;
                }
            }
            dbtype.closeConnection(conn);
        }
        return l;
    }

    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long vacuum(Subject whoami) {
        return this.vacuum(whoami, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long vacuum(Subject whoami, String[] tableNames) {
        long arr$;
        block9: {
            DatabaseType dbtype;
            Connection conn;
            long duration;
            block7: {
                long l;
                block8: {
                    duration = 0L;
                    conn = null;
                    dbtype = null;
                    conn = this.dataSource.getConnection();
                    dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
                    if (DatabaseTypeFactory.isPostgres((DatabaseType)dbtype)) break block7;
                    l = -1L;
                    Object var12_10 = null;
                    if (dbtype == null) break block8;
                    dbtype.closeConnection(conn);
                }
                return l;
            }
            try {
                if (tableNames == null) {
                    tableNames = new String[]{null};
                }
                for (String tableName : tableNames) {
                    duration += this.doCommand(dbtype, conn, "VACUUM ANALYZE {0}", tableName);
                }
                arr$ = duration;
                Object var12_11 = null;
                if (dbtype == null) break block9;
            }
            catch (Exception e) {
                long l;
                block10: {
                    try {
                        this.log.error((Object)("Error vacuuming database: " + e.getMessage()), (Throwable)e);
                        l = duration;
                        Object var12_12 = null;
                        if (dbtype == null) break block10;
                    }
                    catch (Throwable throwable) {
                        block11: {
                            Object var12_13 = null;
                            if (dbtype == null) break block11;
                            dbtype.closeConnection(conn);
                        }
                        throw throwable;
                    }
                    dbtype.closeConnection(conn);
                }
                return l;
            }
            dbtype.closeConnection(conn);
        }
        return arr$;
    }

    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long vacuumAppdef(Subject whoami) {
        return this.vacuum(whoami, this.TABLES_TO_VACUUM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doCommand(DatabaseType dbtype, Connection conn, String command, String table) {
        long l;
        Statement stmt = null;
        StopWatch watch = new StopWatch();
        if (table == null) {
            table = "";
        }
        command = command.replace("{0}", table);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Execute command: " + command));
        }
        try {
            stmt = conn.createStatement();
            stmt.execute(command);
            l = watch.getElapsed();
            Object var11_9 = null;
        }
        catch (SQLException e) {
            long l2;
            try {
                this.log.error((Object)("Error in command: " + command + ": " + e), (Throwable)e);
                l2 = watch.getElapsed();
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                dbtype.closeStatement(stmt);
                throw throwable;
            }
            dbtype.closeStatement(stmt);
            return l2;
        }
        dbtype.closeStatement(stmt);
        return l;
    }

    public void undeployInstaller() {
        block17: {
            try {
                MBeanServer mbs = MBeanServerLocator.locateJBoss();
                ObjectName name = ObjectNameFactory.create((String)"jboss.system:type=ServerConfig");
                ServerConfig mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, ServerConfig.class, false);
                File deployDirectory = new File(mbean.getServerHomeDir(), "deploy");
                if (deployDirectory.exists()) {
                    File deployedInstallWar = new File(deployDirectory.getAbsolutePath(), "rhq-installer.war");
                    File undeployedInstallWar = new File(deployDirectory.getAbsolutePath(), "rhq-installer.war.rej");
                    if (deployedInstallWar.exists()) {
                        name = ObjectNameFactory.create((String)"jboss.system:service=MainDeployer");
                        mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, MainDeployerMBean.class, false);
                        URL url = deployedInstallWar.toURI().toURL();
                        String urlString = url.toString().replace("%20", " ");
                        ((MainDeployerMBean)mbean).undeploy(urlString);
                        if (!((MainDeployerMBean)mbean).isDeployed(urlString)) {
                            this.log.info((Object)"Installer war has been hot-undeployed from memory");
                        } else {
                            this.log.warn((Object)"Installer hot-undeploy failed - full installer undeploy may not work...");
                        }
                        if (!deployedInstallWar.renameTo(undeployedInstallWar)) {
                            throw new RuntimeException("Cannot undeploy the installer war: " + deployedInstallWar);
                        }
                        if (deployedInstallWar.exists()) {
                            throw new RuntimeException("Failed to undeploy the installer war: " + deployedInstallWar);
                        }
                        File deployedPostInstallWar = new File(deployDirectory.getAbsolutePath(), "rhq-postinstaller.war");
                        File undeployedPostInstallWar = new File(deployDirectory.getAbsolutePath(), "rhq-postinstaller.war.rej");
                        if (!deployedPostInstallWar.exists()) {
                            if (undeployedPostInstallWar.exists()) {
                                if (undeployedPostInstallWar.renameTo(deployedPostInstallWar)) {
                                    this.log.debug((Object)"Post-install notification war has been deployed");
                                } else {
                                    this.log.info((Object)"Post-install notification war failed to deploy - this can be ignored");
                                }
                            } else {
                                this.log.info((Object)"Post-install notification war not found and not deployed - this can be ignored");
                            }
                        } else {
                            this.log.info((Object)"Post-install notification war already deployed");
                        }
                    } else if (undeployedInstallWar.exists()) {
                        this.log.debug((Object)("Installer looks to be undeployed already, this is good: " + undeployedInstallWar));
                    } else {
                        this.log.debug((Object)("Installer can't be found - assume it has been completely purged: " + deployedInstallWar));
                    }
                    break block17;
                }
                throw new RuntimeException("Your deployment seems corrupted - missing deploy dir: " + deployDirectory);
            }
            catch (Exception e) {
                this.log.warn((Object)("Please manually remove installer war to secure your deployment: " + e));
                return;
            }
        }
        this.log.info((Object)"Confirmed that the installer has been undeployed");
    }

    public boolean isMonitoringEnabled() {
        try {
            LicenseManager.instance().enforceFeatureLimit(2);
            return true;
        }
        catch (FeatureUnavailableException e) {
            this.log.debug((Object)"Monitoring feature is not enabled");
            return false;
        }
    }

    public License getLicense() {
        License license = LicenseManager.instance().getLicense();
        if (license == null) {
            return license;
        }
        try {
            LicenseStoreManager.store(license);
        }
        catch (Exception ule) {
            this.log.error((Object)ule.getMessage());
            throw new LicenseException(ule);
        }
        return license;
    }

    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void updateLicense(Subject subject, byte[] licenseData) {
        try {
            MBeanServer mbs = MBeanServerLocator.locateJBoss();
            ObjectName name = ObjectNameFactory.create((String)"jboss.system:type=ServerConfig");
            ServerConfig mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, ServerConfig.class, false);
            File deployDirectory = new File(mbean.getServerHomeDir(), "deploy");
            String licenseFileName = LicenseManager.getLicenseFileName();
            if (deployDirectory.exists()) {
                String licenseDirectoryName = deployDirectory.getAbsolutePath() + File.separator + "rhq.ear" + File.separator + "license";
                File licenseDir = new File(licenseDirectoryName);
                if (licenseDir.exists()) {
                    File licenseFile = this.saveLicenseFile(licenseDir, licenseFileName, licenseData);
                    LicenseManager.instance().doStartupCheck(licenseFile.getAbsolutePath());
                } else {
                    this.log.error((Object)("Could not update license file in non-existent directory: " + licenseDir.getAbsolutePath()));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File saveLicenseFile(File dataDir, String licenseFileName, byte[] licenseData) throws IOException {
        this.log.debug((Object)("Updating license file in directory: " + dataDir.getAbsolutePath()));
        File licenseFile = new File(dataDir, licenseFileName);
        FileOutputStream fos = new FileOutputStream(licenseFile);
        fos.write(licenseData);
        fos.close();
        return licenseFile;
    }

    public Date getExpiration() {
        long exp;
        try {
            exp = this.licenseManager.getExpiration();
        }
        catch (Exception e) {
            throw new LicenseException(e);
        }
        if (exp == -1L) {
            return null;
        }
        return new Date(exp);
    }

    public ServerVersion getServerVersion(Subject subject) throws Exception {
        CoreServerMBean coreServer = LookupUtil.getCoreServer();
        String version = coreServer.getVersion();
        String buildNumber = coreServer.getBuildNumber();
        ServerVersion serverVersion = new ServerVersion(version, buildNumber);
        return serverVersion;
    }
}

