/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.persistence.EntityManager;
import org.hibernate.stat.Statistics;
import org.rhq.core.domain.util.PersistenceUtility;

public class HibernateStatisticsStopWatch {
    private Statistics stats;
    long queryExecutions;
    long transations;
    long entityLoads;
    long connects;
    long time;

    public HibernateStatisticsStopWatch(EntityManager entityManager) {
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.stats = PersistenceUtility.getStatisticsService((EntityManager)entityManager, (MBeanServer)platformMBeanServer);
    }

    public void start() {
        this.queryExecutions = -this.stats.getQueryExecutionCount();
        this.transations = -this.stats.getTransactionCount();
        this.entityLoads = -this.stats.getEntityLoadCount();
        this.connects = -this.stats.getConnectCount();
        this.time = -System.currentTimeMillis();
    }

    public void stop() {
        this.queryExecutions += this.stats.getQueryExecutionCount();
        this.transations += this.stats.getTransactionCount();
        this.entityLoads += this.stats.getEntityLoadCount();
        this.connects += this.stats.getConnectCount();
        this.time += System.currentTimeMillis();
    }

    public String toString() {
        return "HibernateStats[ queries=" + this.queryExecutions + ", xactions=" + this.transations + ", loads=" + this.entityLoads + ", connects=" + this.connects + ", time=" + this.time + " ]";
    }
}

