/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.domain.util.PersistenceUtility;
import org.rhq.enterprise.server.alert.AlertDefinitionCreationException;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionUpdateException;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.InvalidAlertDefinitionException;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class GroupAlertDefinitionManagerBean
implements GroupAlertDefinitionManagerLocal {
    private static final Log LOG = LogFactory.getLog(GroupAlertDefinitionManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    @Override
    public PageList<AlertDefinition> findGroupAlertDefinitions(Subject subject, int resourceGroupId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("ctime", PageOrdering.DESC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"AlertDefinition.findByResourceGroup");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"AlertDefinition.findByResourceGroup", (PageControl)pageControl);
        queryCount.setParameter("groupId", (Object)resourceGroupId);
        query.setParameter("groupId", (Object)resourceGroupId);
        long totalCount = (Long)queryCount.getSingleResult();
        List list = query.getResultList();
        return new PageList((Collection)list, (int)totalCount, pageControl);
    }

    private List<Integer> getChildrenAlertDefinitionIds(Subject subject, int groupAlertDefinitionId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.findByGroupAlertDefinitionId");
        query.setParameter("groupAlertDefinitionId", (Object)groupAlertDefinitionId);
        List list = query.getResultList();
        return list;
    }

    @Override
    public int removeGroupAlertDefinitions(Subject subject, Integer[] groupAlertDefinitionIds) {
        if (groupAlertDefinitionIds == null || groupAlertDefinitionIds.length == 0) {
            return 0;
        }
        int modified = 0;
        ArrayList<Integer> allChildDefinitionIds = new ArrayList<Integer>();
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer groupAlertDefinitionId : groupAlertDefinitionIds) {
            List<Integer> childDefinitions = this.getChildrenAlertDefinitionIds(subject, groupAlertDefinitionId);
            allChildDefinitionIds.addAll(childDefinitions);
            modified += this.alertDefinitionManager.removeAlertDefinitions(subject, new Integer[]{groupAlertDefinitionId});
            this.alertDefinitionManager.removeAlertDefinitions(overlord, childDefinitions.toArray(new Integer[childDefinitions.size()]));
        }
        if (allChildDefinitionIds.size() > 0) {
            Query breakLinksQuery = this.entityManager.createNamedQuery("AlertDefinition.updateSetParentsNull");
            breakLinksQuery.setParameter("childrenDefinitionIds", allChildDefinitionIds);
            breakLinksQuery.executeUpdate();
        }
        return modified;
    }

    @Override
    public void updateAlertDefinitionsForResource(Subject subject, AlertDefinition groupAlertDefinition, Integer resourceId) throws AlertDefinitionCreationException, InvalidAlertDefinitionException {
        if (!this.authorizationManager.isOverlord(subject)) {
            throw new AlertDefinitionCreationException("Updating the alert definitions for a resource is an implicit system operation and must only be performed by the overlord");
        }
        AlertDefinition childAlertDefinition = new AlertDefinition(groupAlertDefinition);
        childAlertDefinition.setGroupAlertDefinition(groupAlertDefinition);
        this.alertDefinitionManager.createAlertDefinition(subject, childAlertDefinition, resourceId);
    }

    private List<Integer> getCommittedResourceIdsNeedingGroupAlertDefinitionApplication(Subject subject, int groupAlertDefinitionId, int resourceGroupId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.findResourceIdsNeedingGroupApplication");
        query.setParameter("groupAlertDefinitionId", (Object)groupAlertDefinitionId);
        query.setParameter("resourceGroupId", (Object)resourceGroupId);
        query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        List list = query.getResultList();
        return list;
    }

    @Override
    public int createGroupAlertDefinitions(Subject subject, AlertDefinition groupAlertDefinition, Integer resourceGroupId) throws InvalidAlertDefinitionException {
        ResourceGroup group = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)resourceGroupId);
        groupAlertDefinition.setResourceGroup(group);
        int groupAlertDefinitionId = this.alertDefinitionManager.createAlertDefinition(subject, groupAlertDefinition, null);
        group = (ResourceGroup)this.entityManager.merge((Object)group);
        int definitionCount = 0;
        Subject overlord = this.subjectManager.getOverlord();
        List<Integer> resourceIdsForGroup = this.getCommittedResourceIdsNeedingGroupAlertDefinitionApplication(subject, groupAlertDefinitionId, resourceGroupId);
        for (Integer resourceId : resourceIdsForGroup) {
            try {
                this.updateAlertDefinitionsForResource(overlord, groupAlertDefinition, resourceId);
                if (++definitionCount % 250 != 0) continue;
                this.entityManager.flush();
                this.entityManager.clear();
            }
            catch (AlertDefinitionCreationException adce) {
                LOG.error((Object)adce);
            }
        }
        return groupAlertDefinitionId;
    }

    @Override
    public int disableGroupAlertDefinitions(Subject subject, Integer[] groupAlertDefinitionIds) {
        if (groupAlertDefinitionIds == null || groupAlertDefinitionIds.length == 0) {
            return 0;
        }
        int modified = 0;
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer groupAlertDefinitionId : groupAlertDefinitionIds) {
            List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(subject, groupAlertDefinitionId);
            modified += this.alertDefinitionManager.disableAlertDefinitions(subject, new Integer[]{groupAlertDefinitionId});
            this.alertDefinitionManager.disableAlertDefinitions(overlord, alertDefinitions.toArray(new Integer[alertDefinitions.size()]));
        }
        return modified;
    }

    @Override
    public int enableGroupAlertDefinitions(Subject subject, Integer[] groupAlertDefinitionIds) {
        if (groupAlertDefinitionIds == null || groupAlertDefinitionIds.length == 0) {
            return 0;
        }
        int modified = 0;
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer groupAlertDefinitionId : groupAlertDefinitionIds) {
            List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(subject, groupAlertDefinitionId);
            modified += this.alertDefinitionManager.enableAlertDefinitions(subject, new Integer[]{groupAlertDefinitionId});
            this.alertDefinitionManager.enableAlertDefinitions(overlord, alertDefinitions.toArray(new Integer[alertDefinitions.size()]));
        }
        return modified;
    }

    @Override
    public AlertDefinition updateGroupAlertDefinitions(Subject subject, AlertDefinition groupAlertDefinition, boolean purgeInternals) throws InvalidAlertDefinitionException {
        AlertDefinition updatedTemplate = null;
        try {
            updatedTemplate = this.alertDefinitionManager.updateAlertDefinition(subject, groupAlertDefinition.getId(), groupAlertDefinition, purgeInternals);
        }
        catch (AlertDefinitionUpdateException adue) {
            LOG.error((Object)("Attempt to update a deleted groupAlertDefinition " + groupAlertDefinition.toSimpleString()));
        }
        Subject overlord = this.subjectManager.getOverlord();
        int definitionCount = 0;
        List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(overlord, groupAlertDefinition.getId());
        for (Integer alertDefinitionId : alertDefinitions) {
            try {
                this.alertDefinitionManager.updateAlertDefinition(overlord, alertDefinitionId, groupAlertDefinition, purgeInternals);
            }
            catch (AlertDefinitionUpdateException adue) {
                LOG.error((Object)("Attempt to update a deleted template " + groupAlertDefinition.toSimpleString()));
            }
            if (++definitionCount % 250 != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        List<Integer> resourceIds = this.getCommittedResourceIdsNeedingGroupAlertDefinitionApplication(overlord, groupAlertDefinition.getId(), this.getResourceGroupIdAlertTemplateId(groupAlertDefinition.getId()));
        try {
            for (Integer resourceId : resourceIds) {
                this.updateAlertDefinitionsForResource(overlord, groupAlertDefinition, resourceId);
                if (++definitionCount % 250 != 0) continue;
                this.entityManager.flush();
                this.entityManager.clear();
            }
        }
        catch (AlertDefinitionCreationException adce) {
            LOG.error((Object)adce);
        }
        return updatedTemplate;
    }

    @Override
    public void addGroupAlertDefinitions(Subject subject, int resourceGroupId, int[] resourcesIdsToAdd) {
        if (resourcesIdsToAdd == null || resourcesIdsToAdd.length == 0) {
            return;
        }
        PageList<AlertDefinition> groupAlertDefinitions = this.findGroupAlertDefinitions(subject, resourceGroupId, PageControl.getUnlimitedInstance());
        int definitionCount = 0;
        Subject overlord = this.subjectManager.getOverlord();
        for (AlertDefinition groupAlertDefinition : groupAlertDefinitions) {
            int[] arr$ = resourcesIdsToAdd;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer resourceId = arr$[i$];
                try {
                    this.updateAlertDefinitionsForResource(overlord, groupAlertDefinition, resourceId);
                    if (++definitionCount % 250 != 0) continue;
                    this.entityManager.flush();
                    this.entityManager.clear();
                    continue;
                }
                catch (AlertDefinitionCreationException adce) {
                    LOG.error((Object)adce);
                    continue;
                }
                catch (InvalidAlertDefinitionException iade) {
                    LOG.error((Object)iade);
                }
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void purgeAllGroupAlertDefinitions(Subject subject, int resourceGroupId) {
        PageList<AlertDefinition> groupAlertDefinitions = this.findGroupAlertDefinitions(subject, resourceGroupId, PageControl.getUnlimitedInstance());
        int i = 0;
        Integer[] groupAlertDefinitionIds = new Integer[groupAlertDefinitions.size()];
        for (AlertDefinition groupAlertDefinition : groupAlertDefinitions) {
            groupAlertDefinitionIds[i++] = groupAlertDefinition.getId();
        }
        this.removeGroupAlertDefinitions(subject, groupAlertDefinitionIds);
    }

    @Override
    public void removeGroupAlertDefinitions(Subject subject, int resourceGroupId, int[] resourceIdsToRemove) {
        if (resourceIdsToRemove == null || resourceIdsToRemove.length == 0) {
            return;
        }
        PageList<AlertDefinition> groupAlertDefinitions = this.findGroupAlertDefinitions(subject, resourceGroupId, PageControl.getUnlimitedInstance());
        ArrayList<Integer> allChildrenDefinitionIds = new ArrayList<Integer>();
        Subject overlord = this.subjectManager.getOverlord();
        for (AlertDefinition groupAlertDefinition : groupAlertDefinitions) {
            List<Integer> childDefinitions = this.getChildrenAlertDefinitionIds(subject, groupAlertDefinition.getId());
            allChildrenDefinitionIds.addAll(childDefinitions);
            this.alertDefinitionManager.removeAlertDefinitions(overlord, childDefinitions.toArray(new Integer[childDefinitions.size()]));
        }
        if (allChildrenDefinitionIds.size() > 0) {
            Query breakLinksQuery = this.entityManager.createNamedQuery("AlertDefinition.updateSetParentsNull");
            breakLinksQuery.setParameter("childrenDefinitionIds", allChildrenDefinitionIds);
            breakLinksQuery.executeUpdate();
        }
    }

    private int getResourceGroupIdAlertTemplateId(int groupAlertDefinitionId) {
        Query query = this.entityManager.createQuery("SELECT groupAlertDefinition.resourceGroup.id   FROM AlertDefinition groupAlertDefinition  WHERE groupAlertDefinition.id = :groupAlertDefinitionId");
        query.setParameter("groupAlertDefinitionId", (Object)groupAlertDefinitionId);
        int groupId = ((Number)query.getSingleResult()).intValue();
        return groupId;
    }
}

