/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.common;

public class EntityContext {
    public final Category category;
    public final int resourceId;
    public final int groupId;
    public final int parentResourceId;
    public final int resourceTypeId;

    public Category getCategory() {
        return this.category;
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getParentResourceId() {
        return this.parentResourceId;
    }

    public int getResourceTypeId() {
        return this.resourceTypeId;
    }

    public EntityContext(Integer resourceId, Integer groupId, Integer parentResourceId, Integer resourceTypeId) {
        int rId = resourceId != null && resourceId > 0 ? resourceId : -1;
        int gId = groupId != null && groupId > 0 ? groupId : -1;
        int prId = parentResourceId != null && parentResourceId > 0 ? parentResourceId : -1;
        int rtId = resourceTypeId != null && resourceTypeId > 0 ? resourceTypeId : -1;
        this.resourceId = rId;
        this.groupId = gId;
        this.parentResourceId = prId;
        this.resourceTypeId = rtId;
        if (this.groupId > 0) {
            this.category = Category.ResourceGroup;
        } else if (this.resourceTypeId > 0) {
            this.category = this.parentResourceId > 0 ? Category.AutoGroup : Category.ResourceTemplate;
        } else if (this.resourceId > 0) {
            this.category = Category.Resource;
        } else {
            throw new IllegalArgumentException(this.getUnknownContextMessage());
        }
    }

    public String getLegacyKey() {
        switch (this.category) {
            case Resource: {
                return String.valueOf(this.resourceId);
            }
            case ResourceGroup: {
                return "cg=" + String.valueOf(this.groupId);
            }
            case AutoGroup: {
                return "ag=" + String.valueOf(this.parentResourceId) + ":" + String.valueOf(this.resourceTypeId);
            }
        }
        throw new IllegalArgumentException(this.getUnknownContextMessage());
    }

    public String getUnknownContextMessage() {
        return "Unsupported " + EntityContext.class.getSimpleName() + " '" + this + "'";
    }

    public String toString() {
        return EntityContext.class.getSimpleName() + "[category=" + (Object)((Object)this.category) + ",resourceId=" + this.resourceId + "," + "groupId=" + this.groupId + "," + "parent=" + this.parentResourceId + "," + "type=" + this.resourceTypeId + "]";
    }

    public String toShortString() {
        switch (this.category) {
            case Resource: {
                return "resource[id=" + this.resourceId + "]";
            }
            case ResourceGroup: {
                return "resourceGroup[groupId=" + this.resourceId + "]";
            }
            case AutoGroup: {
                return "autoGroup[parent=" + this.parentResourceId + ",type=" + this.resourceTypeId + "]";
            }
        }
        return this.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category {
        Resource,
        ResourceTemplate,
        ResourceGroup,
        AutoGroup;

    }
}

