/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.jboss.util.StringPropertyReplacer;
import org.rhq.core.clientapi.server.plugin.content.ContentSourcePackageDetails;
import org.rhq.core.clientapi.server.plugin.content.ContentSourcePackageDetailsKey;
import org.rhq.core.clientapi.server.plugin.content.PackageSyncReport;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.Channel;
import org.rhq.core.domain.content.ChannelContentSource;
import org.rhq.core.domain.content.ChannelPackageVersion;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceSyncResults;
import org.rhq.core.domain.content.ContentSourceSyncStatus;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.DownloadMode;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageBits;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.PackageVersionContentSource;
import org.rhq.core.domain.content.PackageVersionContentSourcePK;
import org.rhq.core.domain.content.ProductVersionPackageVersion;
import org.rhq.core.domain.content.composite.LoadedPackageBitsComposite;
import org.rhq.core.domain.content.composite.PackageVersionFile;
import org.rhq.core.domain.content.composite.PackageVersionMetadataComposite;
import org.rhq.core.domain.resource.ProductVersion;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.domain.util.PersistenceUtility;
import org.rhq.core.util.MD5Generator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.content.ContentManagerHelper;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceException;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginContainer;
import org.rhq.enterprise.server.resource.ProductVersionManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class ContentSourceManagerBean
implements ContentSourceManagerLocal {
    private final Log log = LogFactory.getLog(ContentSourceManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS", mappedName="java:/RHQDS")
    private DataSource dataSource;
    @EJB
    private ContentSourceManagerLocal contentSourceManager;
    @EJB
    private ContentManagerLocal contentManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ProductVersionManagerLocal productVersionManager;

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void purgeOrphanedPackageVersions(Subject subject) {
        Query q = this.entityManager.createNamedQuery("PackageVersion.findOrphanedExtraProps");
        List pvs = q.getResultList();
        for (PackageVersion pv : pvs) {
            this.entityManager.remove((Object)pv.getExtraProperties());
            pv.setExtraProperties(null);
        }
        q = this.entityManager.createNamedQuery("PackageVersion.findOrphanedFiles");
        List pvFiles = q.getResultList();
        this.entityManager.flush();
        this.entityManager.clear();
        this.entityManager.createNamedQuery("PackageVersion.deletePVPVIfNoContentSourcesOrChannels").executeUpdate();
        int count = this.entityManager.createNamedQuery("PackageVersion.deleteIfNoContentSourcesOrChannels").executeUpdate();
        this.entityManager.createNamedQuery("PackageBits.deleteIfNoPackageVersion").executeUpdate();
        this.entityManager.flush();
        this.entityManager.clear();
        for (PackageVersionFile pvFile : pvFiles) {
            try {
                File doomed = this.getPackageBitsLocalFilesystemFile(pvFile.getPackageVersionId(), pvFile.getFileName());
                if (!doomed.exists()) continue;
                doomed.delete();
            }
            catch (Exception e) {
                this.log.warn((Object)("Cannot purge orphaned package version file [" + pvFile.getFileName() + "] (" + pvFile.getPackageVersionId() + ")"));
            }
        }
        this.log.info((Object)("User [" + subject + "] purged [" + count + "] orphaned package versions"));
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteContentSource(Subject subject, int contentSourceId) {
        this.log.debug((Object)("User [" + subject + "] is deleting content source [" + contentSourceId + "]"));
        this.entityManager.flush();
        this.entityManager.clear();
        this.entityManager.createNamedQuery("ChannelContentSource.deleteByContentSourceId").setParameter("contentSourceId", (Object)contentSourceId).executeUpdate();
        this.entityManager.createNamedQuery("PackageVersionContentSource.deleteByContentSourceId").setParameter("contentSourceId", (Object)contentSourceId).executeUpdate();
        ContentSource cs = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSourceId);
        if (cs != null) {
            if (cs.getConfiguration() != null) {
                this.entityManager.remove((Object)cs.getConfiguration());
            }
            this.entityManager.remove((Object)cs);
            this.log.debug((Object)("User [" + subject + "] deleted content source [" + cs + "]"));
            try {
                ContentSourcePluginContainer pc = ContentManagerHelper.getPluginContainer();
                pc.unscheduleSyncJob(cs);
                pc.getAdapterManager().shutdownAdapter(cs);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to shutdown adapter for [" + cs + "]"), (Throwable)e);
            }
        } else {
            this.log.debug((Object)("Content Source ID [" + contentSourceId + "] doesn't exist - nothing to delete"));
        }
        this.purgeOrphanedPackageVersions(subject);
    }

    @Override
    public Set<ContentSourceType> getAllContentSourceTypes() {
        Query q = this.entityManager.createNamedQuery("ContentSourceType.findAll");
        List resultList = q.getResultList();
        return new HashSet<ContentSourceType>(resultList);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<ContentSource> getAllContentSources(Subject subject, PageControl pc) {
        pc.initDefaultOrderingField("cs.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ContentSource.findAllWithConfig", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ContentSource.findAll");
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<ContentSource> getAvailableContentSourcesForChannel(Subject subject, Integer channelId, PageControl pc) {
        pc.initDefaultOrderingField("cs.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ContentSource.findAvailableByChannelId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ContentSource.findAvailableByChannelId");
        query.setParameter("channelId", (Object)channelId);
        countQuery.setParameter("channelId", (Object)channelId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public ContentSourceType getContentSourceType(String name) {
        Query q = this.entityManager.createNamedQuery("ContentSourceType.findByNameWithConfigDef");
        q.setParameter("name", (Object)name);
        ContentSourceType type = (ContentSourceType)q.getSingleResult();
        return type;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ContentSource getContentSource(Subject subject, int contentSourceId) {
        Query q = this.entityManager.createNamedQuery("ContentSource.findByIdWithConfig");
        q.setParameter("id", (Object)contentSourceId);
        ContentSource contentSource = null;
        try {
            contentSource = (ContentSource)q.getSingleResult();
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        return contentSource;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ContentSource getContentSourceByNameAndType(Subject subject, String name, String typeName) {
        Query q = this.entityManager.createNamedQuery("ContentSource.findByNameAndTypeName");
        q.setParameter("name", (Object)name);
        q.setParameter("typeName", (Object)typeName);
        ContentSource cs = null;
        try {
            cs = (ContentSource)q.getSingleResult();
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        return cs;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Channel> getAssociatedChannels(Subject subject, int contentSourceId, PageControl pc) {
        pc.initDefaultOrderingField("c.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Channel.findByContentSourceId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Channel.findByContentSourceId");
        query.setParameter("id", (Object)contentSourceId);
        countQuery.setParameter("id", (Object)contentSourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<ContentSourceSyncResults> getContentSourceSyncResults(Subject subject, int contentSourceId, PageControl pc) {
        pc.initDefaultOrderingField("cssr.startTime", PageOrdering.DESC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ContentSourceSyncResults.getAllByCSId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ContentSourceSyncResults.getAllByCSId");
        query.setParameter("contentSourceId", (Object)contentSourceId);
        countQuery.setParameter("contentSourceId", (Object)contentSourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteContentSourceSyncResults(Subject subject, int[] ids) {
        if (ids != null) {
            for (int id : ids) {
                ContentSourceSyncResults doomed = (ContentSourceSyncResults)this.entityManager.getReference(ContentSourceSyncResults.class, (Object)id);
                this.entityManager.remove((Object)doomed);
            }
        }
    }

    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ContentSource createContentSource(Subject subject, String name, String description, String typeName, Configuration configuration, boolean lazyLoad, DownloadMode downloadMode) throws ContentSourceException {
        this.log.debug((Object)("User [" + subject + "] is creating a content source [" + name + "] of type [" + typeName + "]"));
        Query q = this.entityManager.createNamedQuery("ContentSourceType.findByName");
        q.setParameter("name", (Object)typeName);
        ContentSourceType type = (ContentSourceType)q.getSingleResult();
        if (downloadMode == null) {
            downloadMode = type.getDefaultDownloadMode();
        }
        ContentSource source = new ContentSource(name, type);
        source.setDescription(description);
        source.setConfiguration(configuration);
        source.setLazyLoad(lazyLoad);
        source.setDownloadMode(downloadMode);
        this.validateContentSource(source);
        source = this.createContentSource(subject, source);
        return source;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ContentSource createContentSource(Subject subject, ContentSource contentSource) throws ContentSourceException {
        this.validateContentSource(contentSource);
        this.log.debug((Object)("User [" + subject + "] is creating content source [" + contentSource + "]"));
        contentSource.setSyncResults(null);
        this.entityManager.persist((Object)contentSource);
        this.log.debug((Object)("User [" + subject + "] created content source [" + contentSource + "]"));
        try {
            ContentSourcePluginContainer pc = ContentManagerHelper.getPluginContainer();
            pc.getAdapterManager().startAdapter(contentSource);
            pc.scheduleSyncJob(contentSource);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to start adapter for [" + contentSource + "]"), (Throwable)e);
        }
        return contentSource;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ContentSource updateContentSource(Subject subject, ContentSource contentSource) throws ContentSourceException {
        ContentSourcePluginContainer pc;
        this.log.debug((Object)("User [" + subject + "] is updating content source [" + contentSource + "]"));
        ContentSource loaded = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSource.getId());
        if (contentSource.getConfiguration() == null && loaded.getConfiguration() != null) {
            this.entityManager.remove((Object)loaded.getConfiguration());
        }
        if (!loaded.getName().equals(contentSource.getName())) {
            this.log.info((Object)("Content source [" + loaded.getName() + "] is being renamed to [" + contentSource.getName() + "].  Will now unschedule the old sync job"));
            try {
                pc = ContentManagerHelper.getPluginContainer();
                pc.unscheduleSyncJob(loaded);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to unschedule obsolete content source sync job for [" + loaded + "]"), (Throwable)e);
            }
        }
        contentSource = (ContentSource)this.entityManager.merge((Object)contentSource);
        this.log.debug((Object)("User [" + subject + "] updated content source [" + contentSource + "]"));
        try {
            pc = ContentManagerHelper.getPluginContainer();
            pc.unscheduleSyncJob(contentSource);
            pc.getAdapterManager().restartAdapter(contentSource);
            pc.scheduleSyncJob(contentSource);
            pc.syncNow(contentSource);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to restart adapter for [" + contentSource + "]"), (Throwable)e);
        }
        return contentSource;
    }

    private void validateContentSource(ContentSource cs) throws ContentSourceException {
        String name = cs.getName();
        ContentSourceType type = cs.getContentSourceType();
        if (name == null || name.trim().equals("")) {
            throw new ContentSourceException("ContentSource name attribute is required");
        }
        Query q = this.entityManager.createNamedQuery("ContentSource.findByNameAndTypeName");
        q.setParameter("name", (Object)name);
        q.setParameter("typeName", (Object)type.getName());
        List existingMatchingContentSources = q.getResultList();
        if (existingMatchingContentSources.size() > 0) {
            throw new ContentSourceException("Content source with name [" + name + "] and of type [" + type.getName() + "] already exists, please specify a different name.");
        }
    }

    @Override
    public boolean testContentSourceConnection(int contentSourceId) {
        try {
            ContentSourcePluginContainer pc = ContentManagerHelper.getPluginContainer();
            return pc.getAdapterManager().testConnection(contentSourceId);
        }
        catch (Exception e) {
            this.log.info((Object)("Failed to test connection to [" + contentSourceId + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
            this.log.debug((Object)("Content source test connection failure stack follows for [" + contentSourceId + "]"), (Throwable)e);
            return false;
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void synchronizeAndLoadContentSource(Subject subject, int contentSourceId) {
        try {
            ContentSourcePluginContainer pc = ContentManagerHelper.getPluginContainer();
            ContentSource contentSource = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSourceId);
            if (contentSource != null) {
                pc.syncNow(contentSource);
            } else {
                this.log.warn((Object)("Asked to synchronize a non-existing content source [" + contentSourceId + "]"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not spawn the sync job for content source [" + contentSourceId + "]");
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PackageVersionContentSource> getPackageVersionsFromContentSource(Subject subject, int contentSourceId, PageControl pc) {
        pc.initDefaultOrderingField("pvcs.contentSource.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByContentSourceId", (PageControl)pc);
        query.setParameter("id", (Object)contentSourceId);
        List results = query.getResultList();
        long count = this.getPackageVersionCountFromContentSource(subject, contentSourceId);
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public long getPackageVersionCountFromContentSource(Subject subject, int contentSourceId) {
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByContentSourceIdCount");
        countQuery.setParameter("id", (Object)contentSourceId);
        Long count = (Long)countQuery.getSingleResult();
        return count;
    }

    @Override
    public long getPackageBitsLength(int resourceId, PackageDetailsKey packageDetailsKey) {
        Query q = this.entityManager.createNamedQuery("PackageVersion.getPkgBitsLengthByPkgDetailsAndResId");
        q.setParameter("packageName", (Object)packageDetailsKey.getName());
        q.setParameter("packageTypeName", (Object)packageDetailsKey.getPackageTypeName());
        q.setParameter("version", (Object)packageDetailsKey.getVersion());
        q.setParameter("architectureName", (Object)packageDetailsKey.getArchitectureName());
        q.setParameter("resourceId", (Object)resourceId);
        Long count = (Long)q.getSingleResult();
        return count;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PackageVersionContentSource> getPackageVersionsFromContentSources(Subject subject, int[] contentSourceIds, PageControl pc) {
        pc.initDefaultOrderingField("pvcs.contentSource.id");
        ArrayList<Integer> idList = new ArrayList<Integer>(contentSourceIds.length);
        int[] arr$ = contentSourceIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer id = arr$[i$];
            idList.add(id);
        }
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByAllContentSourceIds", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByAllContentSourceIdsCount");
        query.setParameter("ids", idList);
        countQuery.setParameter("ids", idList);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PackageVersionContentSource> getUnloadedPackageVersionsFromContentSource(Subject subject, int contentSourceId, PageControl pc) {
        pc.initDefaultOrderingField("pvcs.contentSource.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByCSIdAndNotLoaded", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByCSIdAndNotLoadedCount");
        query.setParameter("id", (Object)contentSourceId);
        countQuery.setParameter("id", (Object)contentSourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public PackageBits downloadPackageBits(Subject subject, PackageVersionContentSource pvcs) {
        Exception e22;
        Connection conn;
        PackageBits packageBits;
        InputStream bitsStream;
        String packageVersionLocation;
        int contentSourceId;
        block28: {
            PackageVersionContentSourcePK pk = pvcs.getPackageVersionContentSourcePK();
            contentSourceId = pk.getContentSource().getId();
            int packageVersionId = pk.getPackageVersion().getId();
            packageVersionLocation = pvcs.getLocation();
            switch (pk.getContentSource().getDownloadMode()) {
                case NEVER: {
                    return null;
                }
                case DATABASE: {
                    this.log.debug((Object)("Downloading package bits to DB for package located at [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                    break;
                }
                case FILESYSTEM: {
                    this.log.debug((Object)("Downloading package bits to filesystem for package located at [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                    break;
                }
                default: {
                    throw new IllegalStateException(" Unknown download mode - this is a bug, please report it: " + pvcs);
                }
            }
            bitsStream = null;
            packageBits = null;
            ContentSourcePluginContainer pc = ContentManagerHelper.getPluginContainer();
            bitsStream = pc.getAdapterManager().loadPackageBits(contentSourceId, packageVersionLocation);
            conn = null;
            Statement ps = null;
            try {
                packageBits = new PackageBits();
                this.entityManager.persist((Object)packageBits);
                PackageVersion pv = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
                pv.setPackageBits(packageBits);
                this.entityManager.flush();
                if (pk.getContentSource().getDownloadMode() == DownloadMode.DATABASE) {
                    conn = this.dataSource.getConnection();
                    ps = conn.prepareStatement("UPDATE RHQ_PACKAGE_BITS SET BITS = ? WHERE ID = ?");
                    ps.setBinaryStream(1, bitsStream, pv.getFileSize().intValue());
                    ps.setInt(2, packageBits.getId());
                    if (ps.executeUpdate() != 1) {
                        throw new Exception("Did not download the package bits to the DB for [" + pv + "]");
                    }
                } else {
                    File outputFile = this.getPackageBitsLocalFilesystemFile(pv.getId(), pv.getFileName());
                    if (outputFile.exists()) {
                        String expectedMD5 = pv.getMD5() != null ? pv.getMD5() : "<unspecified MD5>";
                        String actualMD5 = MD5Generator.getDigestString((File)outputFile);
                        if (!expectedMD5.trim().toLowerCase().equals(actualMD5.toLowerCase())) {
                            throw new Exception("Already have package bits for [" + pv + "] located at [" + outputFile + "] but the MD5 hashcodes do not match. Expected MD5=[" + expectedMD5 + "], Actual MD5=[" + actualMD5 + "]");
                        }
                        this.log.info((Object)("Asked to download package bits but we already have it at [" + outputFile + "] with matching MD5 of [" + actualMD5 + "]"));
                    } else {
                        StreamUtil.copy((InputStream)bitsStream, (OutputStream)new FileOutputStream(outputFile), (boolean)true);
                        bitsStream = null;
                    }
                }
                Object var17_17 = null;
                if (ps == null) break block28;
            }
            catch (Throwable throwable) {
                Exception e22;
                Object var17_18 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e22) {
                        this.log.warn((Object)("Failed to close prepared statement for package bits [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                    }
                }
                if (conn == null) throw throwable;
                try {
                    conn.close();
                    throw throwable;
                }
                catch (Exception e22) {
                    this.log.warn((Object)("Failed to close connection for package bits [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                }
                throw throwable;
            }
            try {
                ps.close();
            }
            catch (Exception e22) {
                this.log.warn((Object)("Failed to close prepared statement for package bits [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception e22) {
                this.log.warn((Object)("Failed to close connection for package bits [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
            }
        }
        Object var20_22 = null;
        if (bitsStream == null) return packageBits;
        try {
            bitsStream.close();
            return packageBits;
        }
        catch (Exception e3) {
            this.log.warn((Object)("Failed to close stream to package bits located at [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
        }
        return packageBits;
        {
            catch (Throwable t) {
                throw new RuntimeException("Did not download the package bits for [" + pvcs + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)t), t);
            }
        }
        catch (Throwable throwable) {
            Object var20_23 = null;
            if (bitsStream == null) throw throwable;
            try {
                bitsStream.close();
                throw throwable;
            }
            catch (Exception e3) {
                this.log.warn((Object)("Failed to close stream to package bits located at [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
            }
            throw throwable;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean internalSynchronizeContentSource(int contentSourceId) throws Exception {
        ContentSourcePluginContainer pc = ContentManagerHelper.getPluginContainer();
        return pc.getAdapterManager().synchronizeContentSource(contentSourceId);
    }

    @Override
    public ContentSourceSyncResults persistContentSourceSyncResults(ContentSourceSyncResults results) {
        Query q = this.entityManager.createNamedQuery("ContentSourceSyncResults.getInProgressByCSId");
        q.setParameter("contentSourceId", (Object)results.getContentSource().getId());
        List inprogressList = q.getResultList();
        boolean alreadyInProgress = false;
        if (inprogressList.size() > 0) {
            if (results.getStatus() == ContentSourceSyncStatus.INPROGRESS && System.currentTimeMillis() - ((ContentSourceSyncResults)inprogressList.get(0)).getStartTime() < 86400000L) {
                alreadyInProgress = true;
                inprogressList.remove(0);
            }
            for (ContentSourceSyncResults inprogress : inprogressList) {
                inprogress.setStatus(ContentSourceSyncStatus.FAILURE);
                inprogress.setEndTime(Long.valueOf(System.currentTimeMillis()));
                inprogress.setResults("This synchronization seems to have stalled or ended abnormally.");
            }
        }
        ContentSourceSyncResults persistedResults = null;
        if (!alreadyInProgress) {
            this.entityManager.persist((Object)results);
            persistedResults = results;
        }
        return persistedResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentSourceSyncResults mergeContentSourceSyncResults(ContentSourceSyncResults results) {
        return (ContentSourceSyncResults)this.entityManager.merge((Object)results);
    }

    @Override
    public ContentSourceSyncResults getContentSourceSyncResults(int resultsId) {
        return (ContentSourceSyncResults)this.entityManager.find(ContentSourceSyncResults.class, (Object)resultsId);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public ContentSourceSyncResults mergeContentSourceSyncReport(ContentSource contentSource, PackageSyncReport report, Map<ContentSourcePackageDetailsKey, PackageVersionContentSource> previous, ContentSourceSyncResults syncResults) {
        try {
            StringBuilder progress = new StringBuilder();
            if (syncResults.getResults() != null) {
                progress.append(syncResults.getResults());
            }
            syncResults = this.contentSourceManager._mergeContentSourceSyncReportREMOVE(contentSource, report, previous, syncResults, progress);
            ArrayList newPackages = new ArrayList(report.getNewPackages());
            int chunkSize = 200;
            int fromIndex = 0;
            int toIndex = chunkSize;
            int newPackageCount = newPackages.size();
            int addedCount = 0;
            progress.append(new Date()).append(": ").append("Adding");
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
            while (fromIndex < newPackageCount) {
                if (toIndex > newPackageCount) {
                    toIndex = newPackageCount;
                }
                List<ContentSourcePackageDetails> pkgs = newPackages.subList(fromIndex, toIndex);
                syncResults = this.contentSourceManager._mergeContentSourceSyncReportADD(contentSource, pkgs, previous, syncResults, progress, fromIndex);
                addedCount += pkgs.size();
                fromIndex += chunkSize;
                toIndex += chunkSize;
            }
            progress.append("...").append(addedCount).append('\n');
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
            syncResults = this.contentSourceManager._mergeContentSourceSyncReportUPDATE(contentSource, report, previous, syncResults, progress);
            if (report.getNewPackages().size() > 0 || report.getUpdatedPackages().size() > 0 || report.getDeletedPackages().size() > 0) {
                this.contentSourceManager._mergeContentSourceSyncReportUpdateChannel(contentSource.getId());
            }
            progress.append(new Date()).append(": ").append("MERGE COMPLETE.\n");
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        }
        catch (Throwable t) {
            String errorMsg = "Could not process sync report from [" + contentSource + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)t);
            this.log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg, t);
        }
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void _mergeContentSourceSyncReportUpdateChannel(int contentSourceId) {
        long now = System.currentTimeMillis();
        ContentSource contentSource = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSourceId);
        Set ccss = contentSource.getChannelContentSources();
        for (ChannelContentSource ccs : ccss) {
            ccs.getChannelContentSourcePK().getChannel().setLastModifiedDate(now);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentSourceSyncResults _mergeContentSourceSyncReportREMOVE(ContentSource contentSource, PackageSyncReport report, Map<ContentSourcePackageDetailsKey, PackageVersionContentSource> previous, ContentSourceSyncResults syncResults, StringBuilder progress) {
        progress.append(new Date()).append(": ").append("Removing");
        syncResults.setResults(progress.toString());
        syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        int flushCount = 0;
        int removeCount = 0;
        for (ContentSourcePackageDetails doomedDetails : report.getDeletedPackages()) {
            ContentSourcePackageDetailsKey doomedDetailsKey = doomedDetails.getContentSourcePackageDetailsKey();
            PackageVersionContentSource doomedPvcs = previous.get(doomedDetailsKey);
            if ((doomedPvcs = (PackageVersionContentSource)this.entityManager.find(PackageVersionContentSource.class, (Object)doomedPvcs.getPackageVersionContentSourcePK())) != null) {
                this.entityManager.remove((Object)doomedPvcs);
            }
            PackageVersion doomedPv = doomedPvcs.getPackageVersionContentSourcePK().getPackageVersion();
            Query q = this.entityManager.createNamedQuery("PackageVersion.findByIdIfNoContentSourcesOrChannels");
            q.setParameter("id", (Object)doomedPv.getId());
            try {
                doomedPv = (PackageVersion)q.getSingleResult();
                this.entityManager.remove((Object)doomedPv);
            }
            catch (NoResultException nre) {
                // empty catch block
            }
            if (++flushCount % 200 == 0) {
                this.entityManager.flush();
                this.entityManager.clear();
            }
            if (++removeCount % 200 != 0) continue;
            progress.append("...").append(removeCount);
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        }
        progress.append("...").append(removeCount).append('\n');
        syncResults.setResults(progress.toString());
        syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentSourceSyncResults _mergeContentSourceSyncReportADD(ContentSource contentSource, Collection<ContentSourcePackageDetails> newPackages, Map<ContentSourcePackageDetailsKey, PackageVersionContentSource> previous, ContentSourceSyncResults syncResults, StringBuilder progress, int addCount) {
        int flushCount = 0;
        HashMap<ResourceType, ResourceType> knownResourceTypes = new HashMap<ResourceType, ResourceType>();
        HashMap<PackageType, PackageType> knownPackageTypes = new HashMap<PackageType, PackageType>();
        HashMap<Architecture, Architecture> knownArchitectures = new HashMap<Architecture, Architecture>();
        List associatedChannels = null;
        HashMap knownProductVersions = new HashMap();
        for (ContentSourcePackageDetails newDetails : newPackages) {
            Package pkg;
            PackageType pt;
            Query q;
            ResourceType rt;
            block22: {
                ContentSourcePackageDetailsKey key;
                block21: {
                    key = newDetails.getContentSourcePackageDetailsKey();
                    rt = new ResourceType();
                    rt.setName(key.getResourceTypeName());
                    rt.setPlugin(key.getResourceTypePluginName());
                    if (!knownResourceTypes.containsKey(rt)) {
                        q = this.entityManager.createNamedQuery("ResourceType.findByNameAndPlugin");
                        q.setParameter("name", (Object)rt.getName());
                        q.setParameter("plugin", (Object)rt.getPlugin());
                        try {
                            rt = (ResourceType)q.getSingleResult();
                            knownResourceTypes.put(rt, rt);
                            knownProductVersions.put(rt, new HashMap());
                            break block21;
                        }
                        catch (NoResultException nre) {
                            this.log.warn((Object)("Content source adapter found a package for an unknown resource type [" + key.getResourceTypeName() + "|" + key.getResourceTypePluginName() + "] Skipping it."));
                            continue;
                        }
                    }
                    rt = (ResourceType)knownResourceTypes.get(rt);
                }
                pt = new PackageType(key.getPackageTypeName(), rt);
                if (!knownPackageTypes.containsKey(pt)) {
                    q = this.entityManager.createNamedQuery("PackageType.findByResourceTypeIdAndName");
                    q.setParameter("typeId", (Object)rt.getId());
                    q.setParameter("name", (Object)pt.getName());
                    try {
                        pt = (PackageType)q.getSingleResult();
                        pt.setResourceType(rt);
                        knownPackageTypes.put(pt, pt);
                        break block22;
                    }
                    catch (NoResultException nre) {
                        this.log.warn((Object)("Content source adapter found a package of an unknown package type [" + key.getPackageTypeName() + "|" + rt + "] Skipping it."));
                        continue;
                    }
                }
                pt = (PackageType)knownPackageTypes.get(pt);
            }
            q = this.entityManager.createNamedQuery("Package.findByNamePkgTypeResourceType");
            q.setParameter("name", (Object)newDetails.getName());
            q.setParameter("packageTypeName", (Object)newDetails.getPackageTypeName());
            q.setParameter("resourceTypeId", (Object)rt.getId());
            try {
                pkg = (Package)q.getSingleResult();
            }
            catch (NoResultException nre) {
                pkg = new Package(newDetails.getName(), pt);
                pkg.setClassification(newDetails.getClassification());
                pkg = this.contentManager.persistOrMergePackageSafely(pkg);
            }
            Architecture arch = new Architecture(newDetails.getArchitectureName());
            if (!knownArchitectures.containsKey(arch)) {
                q = this.entityManager.createNamedQuery("Architecture.findByName");
                q.setParameter("name", (Object)arch.getName());
                try {
                    arch = (Architecture)q.getSingleResult();
                    knownArchitectures.put(arch, arch);
                }
                catch (NoResultException nre) {
                    this.log.info((Object)("Content source adapter found a previously unknown architecture [" + arch + "] - it will be added to the list of known architectures"));
                }
            } else {
                arch = (Architecture)knownArchitectures.get(arch);
            }
            PackageVersion pv = new PackageVersion(pkg, newDetails.getVersion(), arch);
            pv.setDisplayName(newDetails.getDisplayName());
            pv.setDisplayVersion(newDetails.getDisplayVersion());
            pv.setExtraProperties(newDetails.getExtraProperties());
            pv.setFileCreatedDate(newDetails.getFileCreatedDate());
            pv.setFileName(newDetails.getFileName());
            pv.setFileSize(newDetails.getFileSize());
            pv.setLicenseName(newDetails.getLicenseName());
            pv.setLicenseVersion(newDetails.getLicenseVersion());
            pv.setLongDescription(newDetails.getLongDescription());
            pv.setMD5(newDetails.getMD5());
            pv.setMetadata(newDetails.getMetadata());
            pv.setSHA256(newDetails.getSHA256());
            pv.setShortDescription(newDetails.getShortDescription());
            q = this.entityManager.createNamedQuery("PackageVersion.findByPackageDetailsKey");
            q.setParameter("packageName", (Object)newDetails.getName());
            q.setParameter("packageTypeName", (Object)pt.getName());
            q.setParameter("resourceTypeId", (Object)rt.getId());
            q.setParameter("architectureName", (Object)arch.getName());
            q.setParameter("version", (Object)newDetails.getVersion());
            try {
                PackageVersion pvExisting = (PackageVersion)q.getSingleResult();
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getExtraProperties(), pv, pv.getExtraProperties(), "ExtraProps");
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getFileSize(), pv, pv.getFileSize(), "FileSize");
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getFileName(), pv, pv.getFileName(), "FileName");
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getMD5(), pv, pv.getMD5(), "MD5");
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getSHA256(), pv, pv.getSHA256(), "SHA256");
                pv = pvExisting;
            }
            catch (NoResultException nre) {
                // empty catch block
            }
            pv = this.contentManager.persistOrMergePackageVersionSafely(pv);
            Set resourceVersions = newDetails.getResourceVersions();
            if (resourceVersions != null) {
                Map cachedProductVersions = (Map)knownProductVersions.get(rt);
                for (String version : resourceVersions) {
                    ProductVersion productVersion = (ProductVersion)cachedProductVersions.get(version);
                    if (productVersion == null) {
                        productVersion = this.productVersionManager.addProductVersion(rt, version);
                        cachedProductVersions.put(version, productVersion);
                    }
                    ProductVersionPackageVersion mapping = new ProductVersionPackageVersion(productVersion, pv);
                    this.entityManager.merge((Object)mapping);
                }
            }
            PackageVersionContentSource newPvcs = new PackageVersionContentSource(pv, contentSource, newDetails.getLocation());
            newPvcs = (PackageVersionContentSource)this.entityManager.merge((Object)newPvcs);
            if (associatedChannels == null) {
                q = this.entityManager.createNamedQuery("Channel.findByContentSourceIdFetchCCS");
                q.setParameter("id", (Object)contentSource.getId());
                associatedChannels = q.getResultList();
            }
            for (Channel associatedChannel : associatedChannels) {
                ChannelPackageVersion mapping = new ChannelPackageVersion(associatedChannel, pv);
                this.entityManager.merge((Object)mapping);
            }
            if (++flushCount % 100 == 0) {
                knownResourceTypes.clear();
                knownPackageTypes.clear();
                knownArchitectures.clear();
                associatedChannels = null;
                knownProductVersions.clear();
                this.entityManager.flush();
                this.entityManager.clear();
            }
            if (++addCount % 100 != 0) continue;
            progress.append("...").append(addCount);
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        }
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentSourceSyncResults _mergeContentSourceSyncReportUPDATE(ContentSource contentSource, PackageSyncReport report, Map<ContentSourcePackageDetailsKey, PackageVersionContentSource> previous, ContentSourceSyncResults syncResults, StringBuilder progress) {
        progress.append(new Date()).append(": ").append("Updating");
        syncResults.setResults(progress.toString());
        syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        int flushCount = 0;
        int updateCount = 0;
        for (ContentSourcePackageDetails updatedDetails : report.getUpdatedPackages()) {
            ContentSourcePackageDetailsKey key = updatedDetails.getContentSourcePackageDetailsKey();
            PackageVersionContentSource previousPvcs = previous.get(key);
            PackageVersionContentSource attachedPvcs = (PackageVersionContentSource)this.entityManager.find(PackageVersionContentSource.class, (Object)previousPvcs.getPackageVersionContentSourcePK());
            if (attachedPvcs == null) {
                this.log.warn((Object)("Content source adapter reported that a non-existing package was updated, adding it [" + key + "]"));
                this.entityManager.persist((Object)previousPvcs);
                attachedPvcs = previousPvcs;
            }
            PackageVersion pv = previousPvcs.getPackageVersionContentSourcePK().getPackageVersion();
            pv.setDisplayName(updatedDetails.getDisplayName());
            pv.setDisplayVersion(updatedDetails.getDisplayVersion());
            pv.setExtraProperties(updatedDetails.getExtraProperties());
            pv.setFileCreatedDate(updatedDetails.getFileCreatedDate());
            pv.setFileName(updatedDetails.getFileName());
            pv.setFileSize(updatedDetails.getFileSize());
            pv.setLicenseName(updatedDetails.getLicenseName());
            pv.setLicenseVersion(updatedDetails.getLicenseVersion());
            pv.setLongDescription(updatedDetails.getLongDescription());
            pv.setMD5(updatedDetails.getMD5());
            pv.setMetadata(updatedDetails.getMetadata());
            pv.setSHA256(updatedDetails.getSHA256());
            pv.setShortDescription(updatedDetails.getShortDescription());
            pv = this.contentManager.persistOrMergePackageVersionSafely(pv);
            attachedPvcs.setLocation(updatedDetails.getLocation());
            if (++flushCount % 200 == 0) {
                this.entityManager.flush();
                this.entityManager.clear();
            }
            if (++updateCount % 200 != 0) continue;
            progress.append("...").append(updateCount);
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        }
        progress.append("...").append(updateCount).append('\n');
        syncResults.setResults(progress.toString());
        syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        return syncResults;
    }

    @Override
    public PageList<PackageVersionMetadataComposite> getPackageVersionMetadata(int resourceId, PageControl pc) {
        pc.initDefaultOrderingField("pv.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersion.findMetadataByResourceId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersion.findMetadataByResourceId");
        query.setParameter("resourceId", (Object)resourceId);
        countQuery.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public String getResourceSubscriptionMD5(int resourceId) {
        MD5Generator md5Generator = new MD5Generator();
        Query q = this.entityManager.createNamedQuery("Channel.findChannelsByResourceId");
        q.setParameter("resourceId", (Object)resourceId);
        List channels = q.getResultList();
        for (Channel channel : channels) {
            long modifiedTimestamp = channel.getLastModifiedDate();
            Date modifiedDate = new Date(modifiedTimestamp);
            md5Generator.add(Integer.toString(modifiedDate.hashCode()).getBytes());
        }
        String digestString = md5Generator.getDigestString();
        return digestString;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public long outputPackageVersionBitsGivenResource(int resourceId, PackageDetailsKey packageDetailsKey, OutputStream outputStream) {
        return this.outputPackageVersionBitsRangeGivenResource(resourceId, packageDetailsKey, outputStream, 0L, -1L);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public long outputPackageBitsForChildResource(int parentResourceId, String resourceTypeName, PackageDetailsKey packageDetailsKey, OutputStream outputStream) {
        org.rhq.core.domain.resource.Resource parentResource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)parentResourceId);
        ResourceType parentResourceType = parentResource.getResourceType();
        Query query = this.entityManager.createNamedQuery("ResourceType.findByParentAndName");
        query.setParameter("parent", (Object)parentResourceType);
        query.setParameter("name", (Object)resourceTypeName);
        ResourceType childResourceType = (ResourceType)query.getSingleResult();
        query = this.entityManager.createNamedQuery("PackageVersion.findByPackageDetailsKey");
        query.setParameter("packageName", (Object)packageDetailsKey.getName());
        query.setParameter("packageTypeName", (Object)packageDetailsKey.getPackageTypeName());
        query.setParameter("architectureName", (Object)packageDetailsKey.getArchitectureName());
        query.setParameter("version", (Object)packageDetailsKey.getVersion());
        query.setParameter("resourceTypeId", (Object)childResourceType.getId());
        PackageVersion packageVersion = (PackageVersion)query.getSingleResult();
        return this.outputPackageVersionBitsRangeHelper(parentResourceId, packageDetailsKey, outputStream, 0L, -1L, packageVersion.getId());
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public long outputPackageVersionBitsRangeGivenResource(int resourceId, PackageDetailsKey packageDetailsKey, OutputStream outputStream, long startByte, long endByte) {
        if (startByte < 0L) {
            throw new IllegalArgumentException("startByte[" + startByte + "] < 0");
        }
        if (endByte > -1L && endByte < startByte) {
            throw new IllegalArgumentException("endByte[" + endByte + "] < startByte[" + startByte + "]");
        }
        Query query = this.entityManager.createNamedQuery("PackageVersion.findIdByPackageDetailsKeyAndResId");
        query.setParameter("packageName", (Object)packageDetailsKey.getName());
        query.setParameter("packageTypeName", (Object)packageDetailsKey.getPackageTypeName());
        query.setParameter("architectureName", (Object)packageDetailsKey.getArchitectureName());
        query.setParameter("version", (Object)packageDetailsKey.getVersion());
        query.setParameter("resourceId", (Object)resourceId);
        int packageVersionId = (Integer)query.getSingleResult();
        return this.outputPackageVersionBitsRangeHelper(resourceId, packageDetailsKey, outputStream, startByte, endByte, packageVersionId);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long outputPackageVersionBitsRangeHelper(int resourceId, PackageDetailsKey packageDetailsKey, OutputStream outputStream, long startByte, long endByte, int packageVersionId) {
        block50: {
            block49: {
                block44: {
                    query = this.entityManager.createNamedQuery("PackageBits.isLoaded");
                    query.setParameter("id", (Object)packageVersionId);
                    composite = (LoadedPackageBitsComposite)query.getSingleResult();
                    packageBitsAreAvailable = composite.isPackageBitsAvailable();
                    if (packageBitsAreAvailable && !composite.isPackageBitsInDatabase()) {
                        try {
                            bitsFile = this.getPackageBitsLocalFilesystemFile(composite.getPackageVersionId(), composite.getFileName());
                            if (!bitsFile.exists()) {
                                this.log.warn((Object)("Package version [" + packageDetailsKey + "] has had its bits file [" + bitsFile + "] deleted. Will attempt to download it again."));
                                packageBitsAreAvailable = false;
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Package version [" + packageDetailsKey + "] has had its bits file deleted but cannot download it again.", e);
                        }
                    }
                    pvcs = null;
                    if (!packageBitsAreAvailable) {
                        if (resourceId == -1) {
                            throw new IllegalStateException("Package bits must be inserted prior to the agent asking for them during a cotent-based resource creation");
                        }
                        q2 = this.entityManager.createNamedQuery("PackageVersionContentSource.findByPkgVerIdAndResId");
                        q2.setParameter("resourceId", (Object)resourceId);
                        q2.setParameter("packageVersionId", (Object)packageVersionId);
                        pvcss = q2.getResultList();
                        if (pvcss.size() == 0) {
                            throw new RuntimeException("Resource [" + resourceId + "] cannot access package version [" + packageDetailsKey + "] - no content source exists to deliver it");
                        }
                        pvcs = (PackageVersionContentSource)pvcss.get(0);
                        bits = null;
                        bits = this.contentSourceManager.downloadPackageBits(this.subjectManager.getOverlord(), pvcs);
                        if (bits != null) {
                            query.setParameter("id", (Object)pvcs.getPackageVersionContentSourcePK().getPackageVersion().getId());
                            composite = (LoadedPackageBitsComposite)query.getSingleResult();
                            if (!composite.isPackageBitsAvailable()) {
                                throw new RuntimeException("Failed to download package bits [" + packageDetailsKey + "] for resource [" + resourceId + "]");
                            }
                        } else {
                            composite = null;
                        }
                    }
                    conn = null;
                    ps = null;
                    results = null;
                    bitsStream = null;
                    try {
                        try {
                            if (composite == null) {
                                pc = ContentManagerHelper.getPluginContainer();
                                adapterMgr = pc.getAdapterManager();
                                contentSourceId = pvcs.getPackageVersionContentSourcePK().getContentSource().getId();
                                bitsStream = adapterMgr.loadPackageBits(contentSourceId, pvcs.getLocation());
                            } else if (composite.isPackageBitsInDatabase()) {
                                conn = this.dataSource.getConnection();
                                ps = conn.prepareStatement("SELECT BITS FROM RHQ_PACKAGE_BITS WHERE ID = ?");
                                ps.setInt(1, composite.getPackageBitsId());
                                results = ps.executeQuery();
                                results.next();
                                bitsStream = results.getBinaryStream(1);
                                if (bitsStream == null) {
                                    throw new RuntimeException("Got null for package bits stream from DB for [" + packageDetailsKey + "]");
                                }
                            } else {
                                bitsFile = this.getPackageBitsLocalFilesystemFile(composite.getPackageVersionId(), composite.getFileName());
                                if (!bitsFile.exists()) {
                                    throw new RuntimeException("Package bits at [" + bitsFile + "] are missing for [" + packageDetailsKey + "]");
                                }
                                bitsStream = new FileInputStream(bitsFile);
                            }
                            if (endByte < 0L) {
                                if (startByte > 0L) {
                                    bitsStream.skip(startByte);
                                }
                                bytesRetrieved = StreamUtil.copy((InputStream)bitsStream, (OutputStream)outputStream, (boolean)false);
                            } else {
                                bis = new BufferedInputStream(bitsStream);
                                length = endByte - startByte + 1L;
                                bytesRetrieved = StreamUtil.copy((InputStream)bis, (OutputStream)outputStream, (long)startByte, (long)length);
                            }
                            try {
                                bitsStream.close();
                            }
                            catch (Exception closeError) {
                                this.log.warn((Object)"Failed to close the bits stream", (Throwable)closeError);
                            }
                            bitsStream = null;
                            this.log.debug((Object)("Retrieved and sent [" + bytesRetrieved + "] bytes for [" + packageDetailsKey + "]"));
                            var19_24 = bytesRetrieved;
                            var23_26 = null;
                            if (bitsStream == null) break block44;
                        }
                        catch (SQLException sql) {
                            throw new RuntimeException("Did not download the package bits to the DB for [" + packageDetailsKey + "]", sql);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Could not stream package bits for [" + packageDetailsKey + "]", e);
                        }
                    }
                    catch (Throwable var22_30) {
                        var23_27 = null;
                        if (bitsStream != null) {
                            try {
                                bitsStream.close();
                            }
                            catch (IOException e /* !! */ ) {
                                this.log.warn((Object)("Failed to close bits stream for: " + packageDetailsKey));
                            }
                        }
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (SQLException e /* !! */ ) {
                                this.log.warn((Object)("Failed to close result set from jdbc blob query for: " + packageDetailsKey));
                            }
                        }
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (SQLException e /* !! */ ) {
                                this.log.warn((Object)("Failed to close prepared statement from jdbc blob query for: " + packageDetailsKey));
                            }
                        }
                        if (conn == null) throw var22_30;
                        try {
                            conn.close();
                            throw var22_30;
                        }
                        catch (SQLException e /* !! */ ) {
                            this.log.warn((Object)("Failed to close prepared statement from jdbc blob query for: " + packageDetailsKey));
                            throw var22_30;
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [6 : 925->933)] { 
lbl123:
                    // 1 sources

                    bitsStream.close();
                    break block44;
lbl125:
                    // 1 sources

                    catch (IOException e /* !! */ ) {
                        this.log.warn((Object)("Failed to close bits stream for: " + packageDetailsKey));
                    }
                }
                if (results != null) {
                    ** try [egrp 5[TRYBLOCK] [7 : 969->979)] { 
lbl130:
                    // 1 sources

                    results.close();
                    break block49;
lbl132:
                    // 1 sources

                    catch (SQLException e /* !! */ ) {
                        this.log.warn((Object)("Failed to close result set from jdbc blob query for: " + packageDetailsKey));
                    }
                }
            }
            if (ps != null) {
                ** try [egrp 6[TRYBLOCK] [8 : 1015->1025)] { 
lbl137:
                // 1 sources

                ps.close();
                break block50;
lbl139:
                // 1 sources

                catch (SQLException e /* !! */ ) {
                    this.log.warn((Object)("Failed to close prepared statement from jdbc blob query for: " + packageDetailsKey));
                }
            }
        }
        if (conn == null) return var19_24;
        try {}
        catch (SQLException e /* !! */ ) {
            this.log.warn((Object)("Failed to close prepared statement from jdbc blob query for: " + packageDetailsKey));
            return var19_24;
        }
        conn.close();
        return var19_24;
    }

    private boolean packageVersionAttributeCheck(PackageVersion pv1, Object o1, PackageVersion pv2, Object o2, String logMsg) {
        boolean same = o1 == null ? o2 == null : o1.equals(o2);
        if (!same) {
            StringBuilder str = new StringBuilder();
            str.append("A new package version has data that is different than a previous package version. ");
            str.append("The new package version data will take effect and overwrite the old version: ");
            str.append(logMsg);
            str.append(": package-version1=[").append(pv1);
            str.append("] value1=[").append(o1);
            str.append("; package-version2=[").append(pv2);
            str.append("] value2=[").append(o2);
            str.append("]");
            this.log.warn((Object)str.toString());
        }
        return same;
    }

    private File getPackageBitsLocalFilesystemFile(int packageVersionId, String fileName) throws Exception {
        String filesystemProperty = "rhq.server.content.filesystem";
        String filesystem = System.getProperty("rhq.server.content.filesystem");
        if (filesystem == null) {
            throw new IllegalStateException("Server is misconfigured - missing system property 'rhq.server.content.filesystem'. Don't know where package bits are stored.");
        }
        filesystem = StringPropertyReplacer.replaceProperties((String)filesystem);
        String idGroup = String.valueOf(packageVersionId / 2000);
        StringBuilder bitsFileName = new StringBuilder();
        bitsFileName.append(packageVersionId).append('-').append(fileName);
        if (bitsFileName.length() > 255) {
            bitsFileName.setLength(255);
        }
        File parentDir = new File(filesystem, idGroup);
        File packageBitsFile = new File(parentDir, bitsFileName.toString());
        if (!parentDir.isDirectory()) {
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!parentDir.isDirectory()) {
                throw new Exception("Cannot create content filesystem directory [" + parentDir + "] for package bits storage.");
            }
        }
        return packageBitsFile;
    }
}

