/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.core.CustomJaasDeploymentServiceMBean;
import org.rhq.enterprise.server.core.jaas.JDBCLoginModule;
import org.rhq.enterprise.server.core.jaas.LdapLoginModule;
import org.rhq.enterprise.server.core.jaas.TempSessionLoginModule;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.security.UntrustedSSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomJaasDeploymentService
implements CustomJaasDeploymentServiceMBean,
MBeanRegistration {
    private static final String AUTH_METHOD = "addAppConfig";
    private static final String AUTH_OBJECTNAME = "jboss.security:service=XMLLoginConfig";
    private Log log = LogFactory.getLog((String)CustomJaasDeploymentService.class.getName());
    private MBeanServer mbeanServer = null;

    @Override
    public void installJaasModules() {
        try {
            this.log.info((Object)"Installing RHQ Server's JAAS login modules");
            Properties conf = LookupUtil.getSystemManager().getSystemConfiguration();
            this.registerJaasModules(conf);
        }
        catch (Exception e) {
            this.log.fatal((Object)"Error deploying JAAS login modules", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbeanServer = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() {
    }

    @Override
    public void postDeregister() {
    }

    private void registerJaasModules(Properties conf) throws Exception {
        ArrayList<AppConfigurationEntry> configEntries = new ArrayList<AppConfigurationEntry>();
        try {
            Map<String, String> configOptions = this.getJdbcOptions(conf);
            AppConfigurationEntry ace = new AppConfigurationEntry(JDBCLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, configOptions);
            this.log.info((Object)"Enabling RHQ JDBC JAAS Provider");
            configEntries.add(ace);
            ace = new AppConfigurationEntry(TempSessionLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, new HashMap());
            this.log.info((Object)"Enabled the temporary session login module");
            configEntries.add(ace);
            String provider = conf.getProperty("CAM_JAAS_PROVIDER");
            if (provider != null && provider.equals("LDAP")) {
                configOptions = this.getLdapOptions(conf);
                try {
                    this.validateLdapOptions(configOptions);
                    ace = new AppConfigurationEntry(LdapLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, configOptions);
                    this.log.info((Object)"Enabling RHQ LDAP JAAS Provider");
                    configEntries.add(ace);
                }
                catch (NamingException e) {
                    this.log.info((Object)("Disabling RHQ LDAP JAAS Provider: " + e.getMessage()), (Throwable)e);
                }
            }
            AppConfigurationEntry[] config = configEntries.toArray(new AppConfigurationEntry[0]);
            ObjectName objName = new ObjectName(AUTH_OBJECTNAME);
            Object obj = this.mbeanServer.invoke(objName, AUTH_METHOD, new Object[]{"JON", config}, new String[]{"java.lang.String", config.getClass().getName()});
        }
        catch (Exception e) {
            throw new Exception("Error registering RHQ JAAS Modules", e);
        }
    }

    private Map<String, String> getJdbcOptions(Properties conf) {
        HashMap<String, String> configOptions = new HashMap<String, String>();
        configOptions.put("hashAlgorithm", "MD5");
        configOptions.put("hashEncoding", "base64");
        return configOptions;
    }

    private Map<String, String> getLdapOptions(Properties conf) {
        HashMap<String, String> configOptions = new HashMap<String, String>();
        configOptions.put("java.naming.factory.initial", conf.getProperty("CAM_LDAP_NAMING_FACTORY_INITIAL"));
        configOptions.put("java.naming.provider.url", conf.getProperty("CAM_LDAP_NAMING_PROVIDER_URL"));
        configOptions.put("java.naming.security.protocol", conf.getProperty("CAM_LDAP_PROTOCOL"));
        configOptions.put("LoginProperty", conf.getProperty("CAM_LDAP_LOGIN_PROPERTY"));
        configOptions.put("Filter", conf.getProperty("CAM_LDAP_FILTER"));
        configOptions.put("BaseDN", conf.getProperty("CAM_LDAP_BASE_DN"));
        configOptions.put("BindDN", conf.getProperty("CAM_LDAP_BIND_DN"));
        configOptions.put("BindPW", conf.getProperty("CAM_LDAP_BIND_PW"));
        return configOptions;
    }

    private void validateLdapOptions(Map<String, String> options) throws NamingException {
        Properties env = new Properties();
        String factory = options.get("java.naming.factory.initial");
        if (factory == null) {
            throw new NamingException("No initial context factory");
        }
        String url = options.get("java.naming.provider.url");
        if (url == null) {
            throw new NamingException("Naming provider url not set");
        }
        String protocol = options.get("java.naming.security.protocol");
        if (protocol != null && protocol.equals("ssl")) {
            String ldapSocketFactory = env.getProperty("java.naming.ldap.factory.socket");
            if (ldapSocketFactory == null) {
                env.put("java.naming.ldap.factory.socket", UntrustedSSLSocketFactory.class.getName());
            }
            env.put("java.naming.security.protocol", "ssl");
        }
        env.setProperty("java.naming.factory.initial", factory);
        env.setProperty("java.naming.provider.url", url);
        String bindDN = options.get("BindDN");
        String bindPW = options.get("BindPW");
        if (bindDN != null && bindDN.length() != 0 && bindPW != null && bindPW.length() != 0) {
            env.setProperty("java.naming.security.principal", bindDN);
            env.setProperty("java.naming.security.credentials", bindPW);
            env.setProperty("java.naming.security.authentication", "simple");
        }
        this.log.debug((Object)("Validating LDAP with environment=" + env));
        new InitialLdapContext(env, null);
    }
}

