/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.comm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import mazz.i18n.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.system.server.ServerConfig;
import org.jboss.util.StringPropertyReplacer;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.communications.Ping;
import org.rhq.enterprise.communications.ServiceContainer;
import org.rhq.enterprise.communications.ServiceContainerConfiguration;
import org.rhq.enterprise.communications.ServiceContainerMetricsMBean;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderConfiguration;
import org.rhq.enterprise.communications.command.client.ClientRemotePojoFactory;
import org.rhq.enterprise.communications.command.server.CommandProcessorMetrics;
import org.rhq.enterprise.communications.command.server.discovery.AutoDiscoveryListener;
import org.rhq.enterprise.communications.util.ConcurrencyManager;
import org.rhq.enterprise.communications.util.SecurityUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.agentclient.impl.AgentClientImpl;
import org.rhq.enterprise.server.core.comm.KnownAgents;
import org.rhq.enterprise.server.core.comm.ServerAutoDiscoveryListener;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceMBean;
import org.rhq.enterprise.server.core.comm.ServerConfiguration;
import org.rhq.enterprise.server.core.comm.ServerConfigurationUpgrade;
import org.rhq.enterprise.server.core.comm.ServerI18NFactory;
import org.rhq.enterprise.server.remote.RemoteSafeInvocationHandler;
import org.rhq.enterprise.server.remote.RemoteWsInvocationHandler;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerCommunicationsService
implements ServerCommunicationsServiceMBean,
MBeanRegistration {
    private static Logger LOG = ServerI18NFactory.getLogger(ServerCommunicationsService.class);
    private static final String REMOTE_API_SUBSYSTEM = "REMOTEAPI";
    private static final String WS_REMOTE_API_SUBSYSTEM = "WSREMOTEAPI";
    private MBeanServer m_mbs = null;
    private ServiceContainer m_container = null;
    private ServerConfiguration m_configuration = null;
    private String m_configFile = "server-comm-configuration.xml";
    private String m_preferencesNodeName = "default";
    private Properties m_configurationOverrides = null;
    private KnownAgents m_knownAgents = new KnownAgents();
    private Map<String, AgentClient> m_knownAgentClients = new HashMap<String, AgentClient>();
    private File m_serverPropertiesFile = null;
    private boolean m_started = false;
    private RemoteSafeInvocationHandler m_remoteApiHandler;
    private RemoteWsInvocationHandler m_remoteWsApiHandler;

    @Override
    public ObjectName preRegister(MBeanServer mbs, ObjectName name) throws Exception {
        this.m_mbs = mbs;
        return name;
    }

    @Override
    public void postRegister(Boolean arg0) {
    }

    @Override
    public synchronized void startCommunicationServices() throws Exception {
        if (!this.m_started) {
            ServerConfiguration config = this.reloadConfiguration();
            ServiceContainer container = null == this.m_container ? new ServiceContainer() : this.m_container;
            ServerAutoDiscoveryListener listener = new ServerAutoDiscoveryListener(this.m_knownAgents);
            container.addDiscoveryListener((AutoDiscoveryListener)listener);
            container.start(config.getServiceContainerPreferences().getPreferences(), config.getClientCommandSenderConfiguration(), this.m_mbs);
            this.m_remoteApiHandler = new RemoteSafeInvocationHandler();
            this.m_remoteApiHandler.registerMetricsMBean(container.getMBeanServer());
            container.addInvocationHandler(REMOTE_API_SUBSYSTEM, (ServerInvocationHandler)this.m_remoteApiHandler);
            this.m_remoteWsApiHandler = new RemoteWsInvocationHandler();
            container.addInvocationHandler(WS_REMOTE_API_SUBSYSTEM, (ServerInvocationHandler)this.m_remoteWsApiHandler);
            this.m_container = container;
            this.m_configuration = config;
            this.m_started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.m_container != null) {
            try {
                this.m_remoteApiHandler.unregisterMetricsMBean(this.m_container.getMBeanServer());
                this.m_container.removeInvocationHandler(REMOTE_API_SUBSYSTEM);
                this.m_container.removeInvocationHandler(WS_REMOTE_API_SUBSYSTEM);
            }
            catch (Exception e) {
                LOG.warn("ServerCommunicationsService.remote-api-removal-failure", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)});
            }
            this.m_container.shutdown();
            this.m_container = null;
            this.m_remoteApiHandler = null;
            this.m_remoteWsApiHandler = null;
            this.m_started = false;
        }
        Map<String, AgentClient> map = this.m_knownAgentClients;
        synchronized (map) {
            for (AgentClient client : this.m_knownAgentClients.values()) {
                client.stopSending();
            }
            this.m_knownAgentClients.clear();
        }
    }

    @Override
    public boolean isStarted() {
        return this.m_started;
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.m_mbs = null;
        this.m_container = null;
        this.m_configuration = null;
        this.m_configFile = "server-comm-configuration.xml";
        this.m_preferencesNodeName = "default";
        this.m_configurationOverrides = null;
        this.m_knownAgents.removeAllAgents();
        this.m_knownAgentClients.clear();
        this.m_started = false;
    }

    @Override
    public String getConfigurationFile() {
        return this.m_configFile;
    }

    @Override
    public void setConfigurationFile(String location) {
        this.m_configFile = StringPropertyReplacer.replaceProperties((String)location);
    }

    @Override
    public String getPreferencesNodeName() {
        return this.m_preferencesNodeName;
    }

    @Override
    public void setPreferencesNodeName(String node) {
        this.m_preferencesNodeName = node;
    }

    @Override
    public Properties getConfigurationOverrides() {
        return this.m_configurationOverrides;
    }

    @Override
    public void setConfigurationOverrides(Properties overrides) {
        this.m_configurationOverrides = overrides;
    }

    @Override
    public ServerConfiguration reloadConfiguration() throws Exception {
        this.getPreferencesNode().clear();
        return this.prepareConfigurationPreferences();
    }

    @Override
    public ServerConfiguration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public synchronized ServiceContainer safeGetServiceContainer() {
        if (null == this.m_container) {
            this.m_container = new ServiceContainer();
        }
        return this.m_container;
    }

    @Override
    public ServiceContainer getServiceContainer() {
        return this.m_container;
    }

    @Override
    public String getStartedServerEndpoint() {
        if (this.m_container == null) {
            return null;
        }
        return this.m_container.getServerEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentClient getKnownAgentClient(Agent agent) {
        AgentClient agent_client;
        if (agent == null) {
            throw new IllegalStateException("Agent must be non-null - is a resource not assigned an agent?");
        }
        Map<String, AgentClient> map = this.m_knownAgentClients;
        synchronized (map) {
            String agent_address = agent.getAddress();
            int agent_port = agent.getPort();
            agent_client = this.m_knownAgentClients.get(this.getEndpointKey(agent_address, agent_port));
            if (agent_client == null) {
                String remote_uri;
                InvokerLocator locator = this.m_knownAgents.getAgent(agent_address, agent_port);
                if (locator != null) {
                    remote_uri = locator.getLocatorURI();
                } else {
                    remote_uri = agent.getRemoteEndpoint();
                    if (remote_uri == null) {
                        remote_uri = "socket://" + agent_address + ":" + agent_port;
                    }
                }
                ClientCommandSenderConfiguration client_config = this.getSenderConfiguration(agent);
                ClientCommandSender sender = this.getServiceContainer().createClientCommandSender(remote_uri, client_config);
                agent_client = new AgentClientImpl(agent, sender);
                this.m_knownAgentClients.put(this.getEndpointKey(agent_address, agent_port), agent_client);
            }
        }
        return agent_client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyKnownAgentClient(Agent agent) {
        Map<String, AgentClient> map = this.m_knownAgentClients;
        synchronized (map) {
            String agent_address = agent.getAddress();
            int agent_port = agent.getPort();
            AgentClient agent_client = this.m_knownAgentClients.remove(this.getEndpointKey(agent_address, agent_port));
            if (agent_client != null) {
                agent_client.stopSending();
            }
            File spool_file = null;
            try {
                ClientCommandSenderConfiguration sender_config = this.getSenderConfiguration(agent);
                spool_file = new File(sender_config.dataDirectory, sender_config.commandSpoolFileName);
                if (spool_file.exists()) {
                    new FileOutputStream(spool_file, false).close();
                    spool_file.delete();
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to truncate/delete spool for deleted agent [" + agent + "]" + " please manually remove the file: " + spool_file, new Object[]{e});
            }
        }
    }

    @Override
    public List<InvokerLocator> getAllKnownAgents() {
        return this.m_knownAgents.getAllAgents();
    }

    @Override
    public void addStartedAgent(Agent agent) {
        String endpoint = agent.getRemoteEndpoint();
        this.m_knownAgents.addAgent(endpoint);
        AgentClient client = this.getKnownAgentClient(agent);
        if (client != null) {
            client.startSending();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDownedAgent(String endpoint) {
        AgentClient client;
        InvokerLocator locator;
        this.m_knownAgents.removeAgent(endpoint);
        try {
            locator = new InvokerLocator(endpoint);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        Map<String, AgentClient> map = this.m_knownAgentClients;
        synchronized (map) {
            client = this.m_knownAgentClients.remove(this.getEndpointKey(locator.getHost(), locator.getPort()));
        }
        if (client != null) {
            client.stopSending();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pingEndpoint(String endpoint, long timeoutMillis) {
        ClientCommandSender sender = null;
        boolean pinged = false;
        try {
            ServerConfiguration server_config = this.getConfiguration();
            ClientCommandSenderConfiguration client_config = server_config.getClientCommandSenderConfiguration();
            client_config.commandSpoolFileName = null;
            client_config.enableQueueThrottling = false;
            client_config.enableSendThrottling = false;
            client_config.serverPollingIntervalMillis = -1L;
            sender = this.getServiceContainer().createClientCommandSender(endpoint, client_config);
            sender.startSending();
            ClientRemotePojoFactory factory = sender.getClientRemotePojoFactory();
            factory.setTimeout(Long.valueOf(timeoutMillis));
            Ping pinger = (Ping)factory.getRemotePojo(Ping.class);
            pinger.ping("", null);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.debug("ServerCommunicationsService.ping-failed", new Object[]{endpoint, ThrowableUtil.getAllMessages((Throwable)e, (boolean)true)});
            pinged = false;
        }
        finally {
            if (sender != null) {
                sender.stopSending(false);
            }
        }
        return pinged;
    }

    @Override
    public Integer getGlobalConcurrencyLimit() {
        return this.getServiceContainer().getConfiguration().getGlobalConcurrencyLimit();
    }

    @Override
    public void setGlobalConcurrencyLimit(Integer maxConcurrency) {
        if (maxConcurrency == null) {
            maxConcurrency = -1;
        }
        this.setConcurrencyLimit("rhq.communications.global-concurrency-limit-semaphore", maxConcurrency, false);
        this.persistServerProperty("rhq.communications.global-concurrency-limit", String.valueOf(maxConcurrency));
        this.getServiceContainer().getConfiguration().getPreferences().putInt("rhq.communications.global-concurrency-limit", maxConcurrency);
    }

    @Override
    public Integer getInventoryReportConcurrencyLimit() {
        return this.getServiceContainer().getConcurrencyManager().getConfiguredNumberOfPermitsAllowed("rhq.server.concurrency-limit.inventory-report");
    }

    @Override
    public void setInventoryReportConcurrencyLimit(Integer maxConcurrency) {
        this.setConcurrencyLimit("rhq.server.concurrency-limit.inventory-report", maxConcurrency, true);
    }

    @Override
    public Integer getAvailabilityReportConcurrencyLimit() {
        return this.getServiceContainer().getConcurrencyManager().getConfiguredNumberOfPermitsAllowed("rhq.server.concurrency-limit.availability-report");
    }

    @Override
    public void setAvailabilityReportConcurrencyLimit(Integer maxConcurrency) {
        this.setConcurrencyLimit("rhq.server.concurrency-limit.availability-report", maxConcurrency, true);
    }

    @Override
    public Integer getInventorySyncConcurrencyLimit() {
        return this.getServiceContainer().getConcurrencyManager().getConfiguredNumberOfPermitsAllowed("rhq.server.concurrency-limit.inventory-sync");
    }

    @Override
    public void setInventorySyncConcurrencyLimit(Integer maxConcurrency) {
        this.setConcurrencyLimit("rhq.server.concurrency-limit.inventory-sync", maxConcurrency, true);
    }

    @Override
    public Integer getContentReportConcurrencyLimit() {
        return this.getServiceContainer().getConcurrencyManager().getConfiguredNumberOfPermitsAllowed("rhq.server.concurrency-limit.content-report");
    }

    @Override
    public void setContentReportConcurrencyLimit(Integer maxConcurrency) {
        this.setConcurrencyLimit("rhq.server.concurrency-limit.content-report", maxConcurrency, true);
    }

    @Override
    public Integer getContentDownloadConcurrencyLimit() {
        return this.getServiceContainer().getConcurrencyManager().getConfiguredNumberOfPermitsAllowed("rhq.server.concurrency-limit.content-download");
    }

    @Override
    public void setContentDownloadConcurrencyLimit(Integer maxConcurrency) {
        this.setConcurrencyLimit("rhq.server.concurrency-limit.content-download", maxConcurrency, true);
    }

    @Override
    public Integer getMeasurementReportConcurrencyLimit() {
        return this.getServiceContainer().getConcurrencyManager().getConfiguredNumberOfPermitsAllowed("rhq.server.concurrency-limit.measurement-report");
    }

    @Override
    public void setMeasurementReportConcurrencyLimit(Integer maxConcurrency) {
        this.setConcurrencyLimit("rhq.server.concurrency-limit.measurement-report", maxConcurrency, true);
    }

    @Override
    public Integer getMeasurementScheduleRequestConcurrencyLimit() {
        return this.getServiceContainer().getConcurrencyManager().getConfiguredNumberOfPermitsAllowed("rhq.server.concurrency-limit.measurement-schedule-request");
    }

    @Override
    public void setMeasurementScheduleRequestConcurrencyLimit(Integer maxConcurrency) {
        this.setConcurrencyLimit("rhq.server.concurrency-limit.measurement-schedule-request", maxConcurrency, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean getMaintenanceModeAtStartup() {
        Boolean flag;
        InputStream inputStream = null;
        try {
            File file = this.getServerPropertiesFile();
            Properties props = new Properties();
            inputStream = new FileInputStream(file);
            props.load(inputStream);
            flag = Boolean.parseBoolean(props.getProperty("rhq.server.maintenance-mode-at-startup", "false"));
        }
        catch (Exception e) {
            LOG.error("Cannot read MM-on-startup property from file, will use the sysprop instead", new Object[]{e});
            flag = Boolean.getBoolean("rhq.server.maintenance-mode-at-startup");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return flag;
    }

    @Override
    public Boolean isMaintenanceModeAtStartup() {
        return this.getMaintenanceModeAtStartup();
    }

    @Override
    public void setMaintenanceModeAtStartup(Boolean flag) {
        if (flag == null) {
            flag = Boolean.FALSE;
        }
        this.persistServerProperty("rhq.server.maintenance-mode-at-startup", flag.toString());
        System.setProperty("rhq.server.maintenance-mode-at-startup", flag.toString());
    }

    public void clear() {
        this.getServiceContainerMetricsMBean().clear();
    }

    public long getNumberDroppedCommandsReceived() {
        return this.getServiceContainerMetricsMBean().getNumberDroppedCommandsReceived();
    }

    public long getNumberNotProcessedCommandsReceived() {
        return this.getServiceContainerMetricsMBean().getNumberNotProcessedCommandsReceived();
    }

    public long getNumberFailedCommandsReceived() {
        return this.getServiceContainerMetricsMBean().getNumberFailedCommandsReceived();
    }

    public long getNumberSuccessfulCommandsReceived() {
        return this.getServiceContainerMetricsMBean().getNumberSuccessfulCommandsReceived();
    }

    public long getNumberTotalCommandsReceived() {
        return this.getServiceContainerMetricsMBean().getNumberTotalCommandsReceived();
    }

    public long getAverageExecutionTimeReceived() {
        return this.getServiceContainerMetricsMBean().getAverageExecutionTimeReceived();
    }

    public Map<String, CommandProcessorMetrics.Calltime> getCallTimeDataReceived() {
        return this.getServiceContainerMetricsMBean().getCallTimeDataReceived();
    }

    private ServiceContainerMetricsMBean getServiceContainerMetricsMBean() {
        MBeanServer mbs = this.getServiceContainer().getMBeanServer();
        ServiceContainerMetricsMBean proxy = MBeanServerInvocationHandler.newProxyInstance(mbs, ServiceContainerMetricsMBean.OBJECTNAME_METRICS, ServiceContainerMetricsMBean.class, false);
        return proxy;
    }

    private String getEndpointKey(String host, int port) {
        return host + ":" + port;
    }

    private ClientCommandSenderConfiguration getSenderConfiguration(Agent agent) {
        ServerConfiguration server_config = this.getConfiguration();
        ClientCommandSenderConfiguration client_config = server_config.getClientCommandSenderConfiguration();
        if (client_config.commandSpoolFileName != null) {
            File spool_file = new File(client_config.commandSpoolFileName);
            String file_name = spool_file.getName();
            String parent_path = spool_file.getParent();
            spool_file = new File(parent_path, agent.getName() + "_" + file_name);
            client_config.commandSpoolFileName = spool_file.getPath();
        }
        return client_config;
    }

    private ServerConfiguration prepareConfigurationPreferences() throws Exception {
        Preferences preferences_node = this.getPreferencesNode();
        ServerConfiguration config = new ServerConfiguration(preferences_node);
        if (config.getServerConfigurationVersion() == 0) {
            config = this.loadConfigurationFile();
        } else {
            LOG.debug("ServerCommunicationsService.preferences-already-exist", new Object[]{config.getPreferences()});
        }
        Properties overrides = this.getConfigurationOverrides();
        if (overrides != null) {
            for (Map.Entry<Object, Object> entry : overrides.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                value = StringPropertyReplacer.replaceProperties((String)value);
                preferences_node.put(key, value);
                LOG.debug("ServerCommunicationsService.config-preference-override", new Object[]{key, value});
            }
        }
        try {
            Preferences preferences = config.getPreferences();
            Server server = LookupUtil.getServerManager().getServer();
            String bindAddress = preferences.get("rhq.communications.connector.bind-address", "");
            int bindPort = preferences.getInt("rhq.communications.connector.bind-port", -1);
            if ("".equals(bindAddress)) {
                bindAddress = server.getAddress();
                preferences_node.put("rhq.communications.connector.bind-address", bindAddress);
            }
            if (-1 == bindPort) {
                String transport = config.getPreferences().get("rhq.communications.connector.transport", "socket");
                bindPort = SecurityUtil.isTransportSecure((String)transport) ? server.getSecurePort() : server.getPort();
                preferences_node.put("rhq.communications.connector.bind-port", String.valueOf(bindPort));
            }
        }
        catch (Exception e) {
            LOG.error("Unable to set explicit connector address/port, using defaults: ", new Object[]{e});
            ServiceContainerConfiguration scConfig = new ServiceContainerConfiguration(config.getPreferences());
            preferences_node.put("rhq.communications.connector.bind-address", scConfig.getConnectorBindAddress());
            preferences_node.put("rhq.communications.connector.bind-port", String.valueOf(scConfig.getConnectorBindPort()));
        }
        ServerConfigurationUpgrade.upgradeToLatest(config.getPreferences());
        LOG.debug("ServerCommunicationsService.config-preferences", new Object[]{config});
        return config;
    }

    private ServerConfiguration loadConfigurationFile() throws Exception {
        Serializable config_file;
        String file_name = this.getConfigurationFile();
        String preferences_node_name = this.getPreferencesNodeName();
        InputStream config_file_input_stream = null;
        LOG.debug("ServerCommunicationsService.pref-node-name", new Object[]{preferences_node_name});
        LOG.debug("ServerCommunicationsService.loading-config-file", new Object[]{file_name});
        try {
            config_file = new File(file_name);
            if (((File)config_file).exists()) {
                config_file_input_stream = new FileInputStream((File)config_file);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (config_file_input_stream == null) {
            try {
                config_file = new URL(file_name);
                config_file_input_stream = ((URL)config_file).openStream();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (config_file_input_stream == null) {
            config_file_input_stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file_name);
        }
        if (config_file_input_stream == null) {
            throw new IOException(LOG.getMsgString("ServerCommunicationsService.cannot-find-config-file", new Object[]{file_name}));
        }
        Preferences preferences_node = this.getPreferencesNode();
        ByteArrayOutputStream backup = new ByteArrayOutputStream();
        preferences_node.exportSubtree(backup);
        preferences_node.clear();
        try {
            Preferences.importPreferences(config_file_input_stream);
            if (new ServerConfiguration(preferences_node).getServerConfigurationVersion() == 0) {
                throw new IllegalArgumentException(LOG.getMsgString("ServerCommunicationsService.bad-node-name-in-config-file", new Object[]{file_name, preferences_node_name}));
            }
        }
        catch (Exception e) {
            try {
                Preferences.importPreferences(new ByteArrayInputStream(backup.toByteArray()));
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
        ServerConfiguration server_configuration = new ServerConfiguration(preferences_node);
        LOG.debug("ServerCommunicationsService.loaded-config-file", new Object[]{file_name});
        return server_configuration;
    }

    private Preferences getPreferencesNode() {
        Preferences topNode = Preferences.userRoot().node("rhq-server");
        Preferences preferencesNode = topNode.node(this.getPreferencesNodeName());
        return preferencesNode;
    }

    private File getServerPropertiesFile() {
        if (this.m_serverPropertiesFile == null) {
            ObjectName name = ObjectNameFactory.create((String)"jboss.system:type=ServerConfig");
            ServerConfig mbean = MBeanServerInvocationHandler.newProxyInstance(this.m_mbs, name, ServerConfig.class, false);
            File homeDir = mbean.getHomeDir();
            File binDir = new File(homeDir.getParentFile(), "bin");
            this.m_serverPropertiesFile = new File(binDir, "rhq-server.properties");
        }
        return this.m_serverPropertiesFile;
    }

    private void persistServerProperty(String name, String value) {
        String filePath = this.getServerPropertiesFile().getAbsolutePath();
        PropertiesFileUpdate updater = new PropertiesFileUpdate(filePath);
        try {
            updater.update(name, value);
        }
        catch (IOException e) {
            String msgString = LOG.getMsgString("ServerCommunicationsService.server-property-save-failed", new Object[]{name, value, filePath});
            throw new RuntimeException(msgString, e);
        }
    }

    private void setConcurrencyLimit(String limitName, Integer maxConcurrency, boolean persist) {
        if (maxConcurrency == null) {
            maxConcurrency = -1;
        }
        if (persist) {
            this.persistServerProperty(limitName, String.valueOf(maxConcurrency));
        }
        ConcurrencyManager concurrencyManager = this.getServiceContainer().getConcurrencyManager();
        Map limits = concurrencyManager.getAllConfiguredNumberOfPermitsAllowed();
        limits.put(limitName, maxConcurrency);
        this.getServiceContainer().setConcurrencyManager(new ConcurrencyManager(limits));
        LOG.info("ServerCommunicationsService.new-concurrency-limit", new Object[]{limitName, maxConcurrency});
    }
}

