/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.descriptor.perspective.Perspective;
import org.rhq.core.clientapi.descriptor.perspective.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectiveCacheService {
    private static PerspectiveCacheService INSTANCE;
    private Log log = LogFactory.getLog((String)PerspectiveCacheService.class.getName());
    private Map<String, Perspective> perspectivesByName = new HashMap<String, Perspective>();
    private Map<String, List<Task>> tasksByContext = new HashMap<String, List<Task>>();

    private PerspectiveCacheService() {
        this.parseAllPerspectives();
    }

    public static PerspectiveCacheService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PerspectiveCacheService();
        }
        return INSTANCE;
    }

    public Map<String, Perspective> getPerspectivesByName() {
        return this.perspectivesByName;
    }

    public Map<String, List<Task>> getTasksByContext() {
        return this.tasksByContext;
    }

    private synchronized void parseAllPerspectives() {
        try {
            URL defDirUri = this.getClass().getClassLoader().getResource("perspectives/");
            this.log.debug((Object)("parseAllPerspectives.URI: " + defDirUri));
            File defDir = new File(defDirUri.toURI());
            File[] files = defDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File currFile = files[i];
                if (!currFile.getAbsolutePath().endsWith(".xml")) continue;
                this.log.debug((Object)("parseAllPerspectives.parseAllPerspectives.File: " + currFile));
                Perspective p = this.parsePerspective(currFile.toURL());
                this.perspectivesByName.put(p.getName(), p);
                if (p.getTasks() == null) continue;
                for (Task t : p.getTasks()) {
                    List<Object> tasks;
                    System.out.println("Working with Task: " + t.getName());
                    if (t.getContext() == null) continue;
                    System.out.println("t.getContext: " + t.getContext());
                    if (this.tasksByContext.containsKey(t.getContext())) {
                        System.out.println("t already has context, adding");
                        tasks = this.tasksByContext.get(t.getContext());
                        tasks.add(t);
                        continue;
                    }
                    System.out.println("need to create first entry");
                    tasks = new LinkedList<Task>();
                    tasks.add(t);
                    this.tasksByContext.put(t.getContext(), tasks);
                }
            }
        }
        catch (URISyntaxException e) {
            this.log.error((Object)"Error building url to perspective directory.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            this.log.error((Object)"Error building url to perspective directory.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            this.log.error((Object)"Error parsing perspective xml", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Perspective parsePerspective(URL path) throws JAXBException {
        this.log.debug((Object)"parsePerspective start.");
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.rhq.core.clientapi.descriptor.perspective");
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        ValidationEventCollector vec = new ValidationEventCollector();
        unmarshaller.setEventHandler((ValidationEventHandler)vec);
        Perspective perspective = (Perspective)unmarshaller.unmarshal(path);
        for (ValidationEvent event : vec.getEvents()) {
            this.log.error((Object)(event.getSeverity() + ":" + event.getMessage() + "    " + event.getLinkedException()));
        }
        return perspective;
    }
}

