/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.descriptor.perspective.Perspective;
import org.rhq.core.clientapi.descriptor.perspective.Task;
import org.rhq.enterprise.server.perspective.PerspectiveCacheService;
import org.rhq.enterprise.server.perspective.PerspectiveManagerLocal;
import org.rhq.enterprise.server.perspective.PerspectiveManagerRemote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class PerspectiveManagerBean
implements PerspectiveManagerLocal,
PerspectiveManagerRemote {
    private Log log = LogFactory.getLog((String)PerspectiveManagerBean.class.getName());

    @Override
    public List<Perspective> getAllPerspectives() {
        return new LinkedList<Perspective>(PerspectiveCacheService.getInstance().getPerspectivesByName().values());
    }

    @Override
    public Perspective getPerspective(String name) {
        return PerspectiveCacheService.getInstance().getPerspectivesByName().get(name);
    }

    @Override
    public List<Task> getTasks(String contextName) {
        return this.getTasks(contextName, null);
    }

    @Override
    public List<Task> getTasks(String contextName, Object ... args) {
        this.log.debug((Object)("getTasks called: " + contextName + " id: " + args));
        Map<String, List<Task>> tasksByContext = PerspectiveCacheService.getInstance().getTasksByContext();
        if (tasksByContext.containsKey(contextName)) {
            this.log.debug((Object)"getTasks tasksByContext containsKey, lets fix the paths");
            LinkedList<Task> retval = new LinkedList<Task>();
            List<Task> tasks = tasksByContext.get(contextName);
            for (Task t : tasks) {
                Task newTask = new Task();
                newTask.setContext(t.getContext());
                newTask.setDescription(t.getDescription());
                newTask.setName(t.getName());
                String newPath = MessageFormat.format(t.getPath(), args);
                newTask.setPath(newPath);
                this.log.debug((Object)("getTasks new path: " + newPath));
                retval.add(newTask);
            }
            return retval;
        }
        this.log.debug((Object)"getTasks no matches, Returning null");
        return null;
    }

    @Override
    public List<Task> getTasksWithArgs(String contextName, Object ... args) {
        return this.getTasks(contextName, args);
    }

    private void listPathFiles(String path) {
        URL defDirUri = this.getClass().getClassLoader().getResource(path);
        this.log.debug((Object)("listPathFiles.URI: " + defDirUri));
        File defDir = null;
        try {
            defDir = new File(defDirUri.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return;
        }
        File[] files = defDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File currFile = files[i];
            this.log.debug((Object)("listPathFiles.file: " + currFile));
        }
    }
}

