/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.content;

import java.io.File;

public class ContentSourcePluginContainerConfiguration {
    private File pluginDirectory;
    private File tmpDirectory;

    public File getPluginDirectory() {
        return this.pluginDirectory;
    }

    public void setPluginDirectory(File pluginDirectory) {
        if (pluginDirectory == null) {
            throw new IllegalArgumentException("pluginDirectory == null");
        }
        this.pluginDirectory = pluginDirectory;
    }

    public File getTemporaryDirectory() {
        if (this.tmpDirectory != null) {
            return this.tmpDirectory;
        }
        return new File(System.getProperty("java.io.tmpdir", "."));
    }

    public void setTemporaryDirectory(File tmpDir) {
        this.tmpDirectory = tmpDir;
    }

    public String toString() {
        File pdir = this.getPluginDirectory();
        File tdir = this.getTemporaryDirectory();
        StringBuilder str = new StringBuilder("ContentSourcePluginContainerConfiguration: ");
        str.append("plugin-dir=[" + (pdir != null ? pdir.getAbsolutePath() : "<null>"));
        str.append("], tmp-dir=[" + (tdir != null ? tdir.getAbsolutePath() : "<null>"));
        str.append("]");
        return str.toString();
    }
}

