/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.content;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.descriptor.serverplugin.content.ContentSourcePluginDescriptor;
import org.rhq.core.util.exception.WrappedRemotingException;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginClassLoader;

public class ContentSourcePluginEnvironment {
    private static final Log log = LogFactory.getLog(ContentSourcePluginEnvironment.class);
    private static final String DEFAULT_PLUGIN_DESCRIPTOR_PATH = "META-INF/rhq-serverplugin-content.xml";
    protected URL pluginUrl;
    protected String pluginName;
    protected ClassLoader pluginClassLoader;
    protected ContentSourcePluginDescriptor pluginDescriptor;
    protected String pluginDescriptorPath;

    public ContentSourcePluginEnvironment(URL pluginUrl, ClassLoader classLoader, ClassLoader parentClassLoader, File tmpdir) throws Exception {
        this.initialize(pluginUrl, DEFAULT_PLUGIN_DESCRIPTOR_PATH, classLoader, parentClassLoader, true, tmpdir);
    }

    public ContentSourcePluginEnvironment(URL pluginUrl, ClassLoader classLoader, ClassLoader parentClassLoader, boolean unpackJars, File tmpdir) throws Exception {
        this.initialize(pluginUrl, DEFAULT_PLUGIN_DESCRIPTOR_PATH, classLoader, parentClassLoader, unpackJars, tmpdir);
    }

    public void destroy() {
        if (this.pluginClassLoader instanceof ContentSourcePluginClassLoader) {
            ((ContentSourcePluginClassLoader)this.pluginClassLoader).destroy();
        }
    }

    protected void initialize(URL pluginJarUrl, String descriptorPath, ClassLoader classLoader, ClassLoader parentClassLoader, boolean unpackJars, File tmpDirectory) throws Exception {
        if (classLoader == null) {
            if (parentClassLoader == null) {
                parentClassLoader = this.getClass().getClassLoader();
            }
            classLoader = pluginJarUrl != null ? ContentSourcePluginClassLoader.create(new File(pluginJarUrl.getPath()).getName(), pluginJarUrl, unpackJars, parentClassLoader, tmpDirectory) : parentClassLoader;
        }
        this.initializeDescriptor(classLoader, descriptorPath, pluginJarUrl);
        this.pluginUrl = pluginJarUrl;
        this.pluginDescriptorPath = descriptorPath;
        this.pluginClassLoader = classLoader;
        this.pluginName = this.pluginDescriptor.getName();
    }

    private void initializeDescriptor(ClassLoader classloader, String descriptorPath, URL pluginJarUrl) throws Exception {
        JAXBContext jaxbContext;
        if (pluginJarUrl == null) {
            throw new Exception("A valid plugin JAR URL must be supplied");
        }
        try {
            jaxbContext = JAXBContext.newInstance((String)"org.rhq.core.clientapi.descriptor.serverplugin.content");
        }
        catch (JAXBException e) {
            throw new Exception("Could not instantiate the JAXB Context", (Throwable)new WrappedRemotingException((Throwable)e));
        }
        JarInputStream jis = null;
        JarEntry descriptorEntry = null;
        try {
            jis = new JarInputStream(pluginJarUrl.openStream());
            JarEntry nextEntry = jis.getNextJarEntry();
            while (nextEntry != null && descriptorEntry == null) {
                if (DEFAULT_PLUGIN_DESCRIPTOR_PATH.equals(nextEntry.getName())) {
                    descriptorEntry = nextEntry;
                    continue;
                }
                jis.closeEntry();
                nextEntry = jis.getNextJarEntry();
            }
            if (descriptorEntry == null) {
                throw new Exception("The plugin descriptor does not exist");
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            URL pluginSchemaURL = this.getClass().getClassLoader().getResource("rhq-serverplugin-content.xsd");
            Schema pluginSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(pluginSchemaURL);
            unmarshaller.setSchema(pluginSchema);
            ValidationEventCollector vec = new ValidationEventCollector();
            unmarshaller.setEventHandler((ValidationEventHandler)vec);
            this.pluginDescriptor = (ContentSourcePluginDescriptor)unmarshaller.unmarshal((InputStream)jis);
            for (ValidationEvent event : vec.getEvents()) {
                log.debug((Object)("Plugin [" + this.pluginDescriptor.getName() + "] descriptor messages {Severity: " + event.getSeverity() + ", Message: " + event.getMessage() + ", Exception: " + event.getLinkedException() + "}"));
            }
        }
        catch (Exception e) {
            throw new Exception("Could not successfully parse the plugin descriptor [" + descriptorPath + " found in URL [" + pluginJarUrl + "]", (Throwable)new WrappedRemotingException((Throwable)e));
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (Exception e) {
                    log.warn((Object)("Cannot close jar stream [" + pluginJarUrl + "]. Cause: " + e));
                }
            }
        }
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public URL getPluginUrl() {
        return this.pluginUrl;
    }

    public ClassLoader getClassLoader() {
        return this.pluginClassLoader;
    }

    public ContentSourcePluginDescriptor getDescriptor() {
        return this.pluginDescriptor;
    }

    public String getPluginDescriptorPath() {
        return this.pluginDescriptorPath;
    }

    public String toString() {
        return this.pluginName + ": url=[" + this.pluginUrl + "], descriptor-path=[" + this.pluginDescriptorPath + "]";
    }
}

