/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.content;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.server.plugin.content.ContentSourceAdapter;
import org.rhq.core.clientapi.server.plugin.content.metadata.ContentSourcePluginMetadataManager;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginContainerConfiguration;
import org.rhq.enterprise.server.plugin.content.ContentSourcePluginEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentSourcePluginManager {
    private static final Log log = LogFactory.getLog(ContentSourcePluginManager.class);
    private Map<String, ContentSourcePluginEnvironment> loadedPlugins = new HashMap<String, ContentSourcePluginEnvironment>();
    private ContentSourcePluginMetadataManager metadataManager = new ContentSourcePluginMetadataManager();
    private ContentSourcePluginContainerConfiguration configuration;

    public void initialize() {
        if (this.configuration == null) {
            this.configuration = new ContentSourcePluginContainerConfiguration();
            log.warn((Object)"Didn't get a configuration yet - creating a default one");
        }
        try {
            File[] pluginFiles;
            for (File pluginFile : pluginFiles = this.configuration.getPluginDirectory().listFiles()) {
                if (!pluginFile.getName().endsWith(".jar")) continue;
                URL pluginUrl = pluginFile.toURI().toURL();
                try {
                    log.debug((Object)("Loading content source server plugin from URL: " + pluginUrl));
                    this.loadPlugin(pluginUrl, null);
                }
                catch (Throwable t) {
                    log.error((Object)("Plugin at [" + pluginUrl + "] could not be loaded"), t);
                }
            }
        }
        catch (Exception e) {
            this.shutdown();
            log.error((Object)"Error initializing plugin container", (Throwable)e);
            throw new RuntimeException("Cannot initialize the plugin container", e);
        }
    }

    public void shutdown() {
        for (ContentSourcePluginEnvironment pluginEnvironment : this.loadedPlugins.values()) {
            log.debug((Object)("Cleaning up plugin environment for [" + pluginEnvironment.getPluginName() + "]"));
            pluginEnvironment.destroy();
        }
        this.loadedPlugins.clear();
        this.metadataManager = new ContentSourcePluginMetadataManager();
    }

    public Collection<ContentSourcePluginEnvironment> getPlugins() {
        return this.loadedPlugins.values();
    }

    @Nullable
    public ContentSourcePluginEnvironment getPlugin(String pluginName) {
        return this.loadedPlugins.get(pluginName);
    }

    public ContentSourcePluginEnvironment getPlugin(ContentSourceType type) {
        String pluginName = this.metadataManager.getPluginNameFromContentSourceType(type);
        return this.loadedPlugins.get(pluginName);
    }

    public ContentSourcePluginMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    protected void setConfiguration(ContentSourcePluginContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    private void loadPlugin(URL pluginUrl, ClassLoader classLoader) throws Exception {
        log.info((Object)("Loading content server plugin from: " + pluginUrl));
        ContentSourcePluginEnvironment pluginEnvironment = new ContentSourcePluginEnvironment(pluginUrl, classLoader, null, this.configuration.getTemporaryDirectory());
        this.loadedPlugins.put(pluginEnvironment.getPluginName(), pluginEnvironment);
        Collection newTypes = this.metadataManager.loadPlugin(pluginEnvironment.getDescriptor());
        HashSet newTypesCopy = new HashSet(newTypes);
        for (ContentSourceType newType : newTypesCopy) {
            try {
                String className = newType.getContentSourceApiClass();
                Class<?> apiClass = Class.forName(className, false, pluginEnvironment.getClassLoader());
                if (ContentSourceAdapter.class.isAssignableFrom(apiClass)) continue;
                throw new Exception("The API class [" + className + "] should implement [" + ContentSourceAdapter.class.getName() + "] but does not");
            }
            catch (Exception e) {
                this.metadataManager.unloadPlugin(pluginEnvironment.getPluginName());
                this.loadedPlugins.remove(pluginEnvironment.getPluginName());
                pluginEnvironment.destroy();
                throw e;
            }
        }
    }
}

