/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.Util;
import org.jboss.security.auth.callback.UsernamePasswordHandler;
import org.rhq.core.domain.auth.Principal;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.SubjectCriteria;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PersistenceUtility;
import org.rhq.enterprise.server.auth.SessionException;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.auth.SessionTimeoutException;
import org.rhq.enterprise.server.auth.SubjectException;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerRemote;
import org.rhq.enterprise.server.auth.TemporarySessionPasswordGenerator;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class SubjectManagerBean
implements SubjectManagerLocal,
SubjectManagerRemote {
    private final Log log = LogFactory.getLog(SubjectManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private SystemManagerLocal systemManager;
    private SessionManager sessionManager = SessionManager.getInstance();
    private TemporarySessionPasswordGenerator m_sessionPasswordGenerator = new TemporarySessionPasswordGenerator();

    @Override
    public Subject loadUserConfiguration(Integer subjectId) {
        Subject subject = (Subject)this.entityManager.find(Subject.class, (Object)subjectId);
        Configuration config = subject.getUserConfiguration();
        if (config != null && config.getProperties() != null) {
            config.getProperties().size();
        }
        if (subject.getRoles() != null) {
            subject.getRoles().size();
        }
        return subject;
    }

    @Override
    public PageList<Subject> findSubjectsById(Integer[] subjectIds, PageControl pc) {
        if (subjectIds == null || subjectIds.length == 0) {
            return new PageList(pc);
        }
        pc.initDefaultOrderingField("s.name");
        String queryName = "Subject.findByIds";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        List<Integer> subjectIdsList = Arrays.asList(subjectIds);
        queryCount.setParameter("ids", subjectIdsList);
        query.setParameter("ids", subjectIdsList);
        long count = (Long)queryCount.getSingleResult();
        ArrayList subjects = query.getResultList();
        if (subjects != null) {
            for (Subject subject : subjects) {
                subject.getRoles().size();
            }
        } else {
            subjects = new ArrayList();
        }
        return new PageList(subjects, (int)count, pc);
    }

    @Override
    public Subject updateSubject(Subject whoami, Subject subjectToModify) {
        if (whoami.equals((Object)subjectToModify) || this.authorizationManager.getExplicitGlobalPermissions(whoami).contains(Permission.MANAGE_SECURITY)) {
            if ((subjectToModify.getFsystem() || this.authorizationManager.isSystemSuperuser(subjectToModify)) && !subjectToModify.getFactive()) {
                throw new PermissionException("You cannot disable user [" + subjectToModify.getName() + "] - it must always be active");
            }
        } else {
            throw new PermissionException("You [" + whoami.getName() + "] do not have permission to update user [" + subjectToModify.getName() + "]");
        }
        return (Subject)this.entityManager.merge((Object)subjectToModify);
    }

    @Override
    public Subject getOverlord() {
        return this.sessionManager.getOverlord();
    }

    @Override
    public Subject getSubjectByName(String username) {
        Subject subject;
        try {
            Query query = this.entityManager.createNamedQuery("Subject.findByName");
            query.setParameter("name", (Object)username);
            subject = (Subject)query.getSingleResult();
        }
        catch (NoResultException nre) {
            subject = null;
        }
        return subject;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public Subject createSubject(Subject whoami, Subject subject) throws SubjectException {
        if (this.getSubjectByName(subject.getName()) != null) {
            throw new SubjectException("A user already exists with " + subject.getName());
        }
        if (subject.getFsystem()) {
            throw new SubjectException("Cannot create new system subjects: " + subject.getName());
        }
        subject.setRoles(null);
        Configuration configuration = subject.getUserConfiguration();
        if (configuration != null) {
            configuration = (Configuration)this.entityManager.merge((Object)configuration);
            subject.setUserConfiguration(configuration);
        }
        this.entityManager.persist((Object)subject);
        return subject;
    }

    @Override
    public PageList<Subject> findAllSubjects(PageControl pc) {
        pc.initDefaultOrderingField("s.name");
        String queryName = "Subject.findAll";
        Query subjectQueryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query subjectQuery = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        long totalCount = (Long)subjectQueryCount.getSingleResult();
        List subjects = subjectQuery.getResultList();
        return new PageList((Collection)subjects, (int)totalCount, pc);
    }

    @Override
    public Subject getSubjectById(int id) {
        Subject subject = (Subject)this.entityManager.find(Subject.class, (Object)id);
        return subject;
    }

    @Override
    public String generateTemporarySessionPassword(int sessionId) {
        return this.m_sessionPasswordGenerator.generateSessionPassword(sessionId);
    }

    @Override
    public boolean authenticateTemporarySessionPassword(String password) throws Exception {
        Integer sessionId = this.m_sessionPasswordGenerator.authenticateSessionPassword(password);
        boolean validPassword = false;
        if (sessionId != null && this.sessionManager.getSubject(sessionId) != null) {
            validPassword = true;
        }
        return validPassword;
    }

    @Override
    public Subject login(String username, String password) throws org.rhq.enterprise.server.exception.LoginException {
        if (password == null) {
            throw new org.rhq.enterprise.server.exception.LoginException("No password was given");
        }
        Properties config = this.systemManager.getSystemConfiguration();
        try {
            UsernamePasswordHandler handler = new UsernamePasswordHandler(username, password.toCharArray());
            LoginContext loginContext = new LoginContext("JON", (CallbackHandler)handler);
            loginContext.login();
            loginContext.getSubject().getPrincipals().iterator().next();
            loginContext.logout();
        }
        catch (LoginException e) {
            throw new org.rhq.enterprise.server.exception.LoginException(e.getMessage());
        }
        Subject subject = this.getSubjectByName(username);
        if (subject != null) {
            if (!subject.getFactive()) {
                throw new org.rhq.enterprise.server.exception.LoginException("User account has been disabled.");
            }
            try {
                int session_id = this.sessionManager.getSessionIdFromUsername(username);
                subject.setSessionId(Integer.valueOf(session_id));
                return subject;
            }
            catch (SessionException se) {}
        } else if (config.getProperty("CAM_JAAS_PROVIDER").equals("LDAP")) {
            subject = new Subject();
            subject.setId(0);
            subject.setName(username);
            subject.setFactive(true);
            subject.setFsystem(false);
        } else {
            throw new IllegalStateException("Somehow you authenticated with a principal that has no associated subject. Your account is invalid.");
        }
        this.sessionManager.put(subject);
        return subject;
    }

    @Override
    public void logout(Subject subject) {
        try {
            int sessionId = this.sessionManager.getSessionIdFromUsername(subject.getName());
            this.sessionManager.invalidate(sessionId);
        }
        catch (SessionTimeoutException ste) {
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void logout(int sessionId) {
        this.sessionManager.invalidate(sessionId);
    }

    @Override
    public boolean isLoggedIn(String username) {
        boolean loggedIn = false;
        try {
            this.sessionManager.getSessionIdFromUsername(username);
            loggedIn = true;
        }
        catch (SessionException sessionException) {
            // empty catch block
        }
        return loggedIn;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void createPrincipal(Subject whoami, String username, String password) throws SubjectException {
        Principal principal = new Principal(username, Util.createPasswordHash((String)"MD5", (String)"base64", null, null, (String)password));
        this.createPrincipal(whoami, principal);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void createPrincipal(Subject whoami, Principal principal) throws SubjectException {
        try {
            this.entityManager.persist((Object)principal);
        }
        catch (Exception e) {
            throw new SubjectException("Failed creating principal: " + e.getMessage());
        }
    }

    @Override
    public void changePassword(Subject whoami, String username, String password) {
        if (!whoami.getName().equals(username) && !this.authorizationManager.hasGlobalPermission(whoami, Permission.MANAGE_SECURITY)) {
            throw new PermissionException("You do not have permission to change the password for user [" + username + "]");
        }
        Query q = this.entityManager.createNamedQuery("Principal.findByUsername");
        q.setParameter("principal", (Object)username);
        Principal local = (Principal)q.getSingleResult();
        String hash = Util.createPasswordHash((String)"MD5", (String)"base64", null, null, (String)password);
        local.setPassword(hash);
    }

    @Override
    public boolean isUserWithPrincipal(String username) {
        try {
            Query q = this.entityManager.createNamedQuery("Principal.findByUsername");
            q.setParameter("principal", (Object)username);
            Principal principal = (Principal)q.getSingleResult();
            return principal != null;
        }
        catch (NoResultException e) {
            return false;
        }
    }

    @Override
    public Collection<String> findAllUsersWithPrincipals() {
        Query q = this.entityManager.createNamedQuery("Principal.findAllUsers");
        List principals = q.getResultList();
        ArrayList<String> users = new ArrayList<String>();
        for (Principal p : principals) {
            users.add(p.getPrincipal());
        }
        return users;
    }

    @Override
    public Subject loginUnauthenticated(String username, boolean reattach) throws org.rhq.enterprise.server.exception.LoginException {
        Subject subject;
        if (reattach) {
            try {
                int sessionId = this.sessionManager.getSessionIdFromUsername(username);
                return this.sessionManager.getSubject(sessionId);
            }
            catch (SessionException e) {
                // empty catch block
            }
        }
        if ((subject = this.getSubjectByName(username)) == null) {
            throw new org.rhq.enterprise.server.exception.LoginException("User account does not exist. [" + username + "]");
        }
        if (!subject.getFactive()) {
            throw new org.rhq.enterprise.server.exception.LoginException("User account has been disabled. [" + username + "]");
        }
        this.sessionManager.put(subject, 120000L);
        return subject;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void deleteUsers(Subject subject, int[] subjectIds) {
        int[] arr$ = subjectIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer doomedSubjectId = arr$[i$];
            Subject doomedSubject = this.getSubjectById(doomedSubjectId);
            if (subject.getName().equals(doomedSubject.getName())) {
                throw new PermissionException("You cannot remove yourself: " + doomedSubject.getName());
            }
            Query deleteNotificationQuery = this.entityManager.createQuery("DELETE FROM SubjectNotification sn WHERE sn.subject.id = :subjectId");
            deleteNotificationQuery.setParameter("subjectId", (Object)doomedSubjectId);
            deleteNotificationQuery.executeUpdate();
            Set roles = doomedSubject.getRoles();
            doomedSubject.setRoles(new HashSet());
            for (Role doomedRoleRelationship : roles) {
                doomedRoleRelationship.removeSubject(doomedSubject);
            }
            if (this.isUserWithPrincipal(doomedSubject.getName())) {
                this.deletePrincipal(subject, doomedSubject);
            }
            this.deleteSubject(subject, doomedSubject);
        }
    }

    @Override
    public void deleteSubjects(Subject sessionSubject, int[] subjectIds) {
        this.deleteUsers(sessionSubject, subjectIds);
    }

    private void deleteSubject(Subject whoami, Subject doomedSubject) throws PermissionException {
        if (this.authorizationManager.isSystemSuperuser(doomedSubject)) {
            throw new PermissionException("You cannot delete a system root user - they must always exist");
        }
        this.entityManager.remove((Object)doomedSubject);
    }

    private void deletePrincipal(Subject whoami, Subject subject) throws PermissionException {
        if (this.authorizationManager.isSystemSuperuser(subject)) {
            throw new PermissionException("You cannot delete the principal for the root user [" + subject.getName() + "]");
        }
        Query q = this.entityManager.createNamedQuery("Principal.findByUsername");
        q.setParameter("principal", (Object)subject.getName());
        Principal principal = (Principal)q.getSingleResult();
        this.entityManager.remove((Object)principal);
    }

    @Override
    public Subject getSessionSubject(int sessionId) throws Exception {
        Subject subject = this.sessionManager.getSubject(sessionId);
        return subject;
    }

    @Override
    @ExcludeDefaultInterceptors
    public boolean isValidSessionId(int session, String username) {
        try {
            Subject sessionSubject = this.sessionManager.getSubject(session);
            return username.equals(sessionSubject.getName());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public PageList<Subject> findAvailableSubjectsForAlertDefinition(Subject whoami, Integer alertDefinitionId, Integer[] pendingSubjectIds, PageControl pc) {
        pc.initDefaultOrderingField("s.name");
        String queryName = pendingSubjectIds == null || pendingSubjectIds.length == 0 ? "Subject.findAvailableSubjectForAlertDefinition" : "Subject.findAvailableSubjectsForAlertDefinitionWithExcludes";
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName, (String)"distinct s");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        countQuery.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        query.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        if (pendingSubjectIds != null && pendingSubjectIds.length > 0) {
            List<Integer> pendingIdsList = Arrays.asList(pendingSubjectIds);
            countQuery.setParameter("excludes", pendingIdsList);
            query.setParameter("excludes", pendingIdsList);
        }
        long count = (Long)countQuery.getSingleResult();
        List subjects = query.getResultList();
        for (Subject subject : subjects) {
            subject.getRoles().size();
        }
        return new PageList((Collection)subjects, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public PageList<Subject> findAvailableSubjectsForRole(Subject whoami, Integer roleId, Integer[] pendingSubjectIds, PageControl pc) {
        pc.initDefaultOrderingField("s.name");
        String queryName = pendingSubjectIds == null || pendingSubjectIds.length == 0 ? "Subject.findAvailableSubjectsForRole" : "Subject.findAvailableSubjectsForRoleWithExcludes";
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName, (String)"distinct s");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        countQuery.setParameter("roleId", (Object)roleId);
        query.setParameter("roleId", (Object)roleId);
        if (pendingSubjectIds != null && pendingSubjectIds.length > 0) {
            List<Integer> pendingIdsList = Arrays.asList(pendingSubjectIds);
            countQuery.setParameter("excludes", pendingIdsList);
            query.setParameter("excludes", pendingIdsList);
        }
        long count = (Long)countQuery.getSingleResult();
        List subjects = query.getResultList();
        for (Subject subject : subjects) {
            subject.getRoles().size();
        }
        return new PageList((Collection)subjects, (int)count, pc);
    }

    @Override
    public PageList<Subject> findSubjectsByCriteria(Subject subject, SubjectCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }
}

