/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration.job;

import java.util.List;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGroupConfigurationUpdateJob
implements Job {
    public static final String DATAMAP_INT_CONFIG_GROUP_UPDATE_ID = "configGroupUpdateId";
    public static final String DATAMAP_INT_SUBJECT_ID = "subjectId";

    protected static JobDetail getJobDetail(ResourceGroup group, Subject subject, JobDataMap jobDataMap, Class jobClass, String jobNamePrefix) {
        JobDetail jobDetail = new JobDetail();
        jobDetail.setName(AbstractGroupConfigurationUpdateJob.createUniqueJobName(group, subject, jobNamePrefix));
        jobDetail.setGroup(AbstractGroupConfigurationUpdateJob.createJobGroupName(group, jobNamePrefix));
        jobDetail.setVolatility(false);
        jobDetail.setDurability(false);
        jobDetail.setRequestsRecovery(false);
        jobDetail.setJobClass(jobClass);
        jobDetail.setJobDataMap(jobDataMap);
        return jobDetail;
    }

    public void execute(JobExecutionContext jobContext) throws JobExecutionException {
        JobDetail jobDetail = jobContext.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        Integer configurationGroupUpdateId = jobDataMap.getIntFromString(DATAMAP_INT_CONFIG_GROUP_UPDATE_ID);
        Integer subjectId = jobDataMap.getIntFromString(DATAMAP_INT_SUBJECT_ID);
        Subject subject = LookupUtil.getSubjectManager().getSubjectById(subjectId);
        this.processGroupConfigurationUpdate(configurationGroupUpdateId, subject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGroupConfigurationUpdate(Integer groupConfigurationUpdateId, Subject subject) {
        ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
        String errorMessages = null;
        try {
            try {
                List<Integer> pagedChildUpdateIds;
                long childPluginConfigurationUpdateCount = this.getConfigurationUpdateCount(groupConfigurationUpdateId, configurationManager);
                int rowsProcessed = 0;
                PageControl pc = new PageControl(0, 1000, new OrderingField[]{new OrderingField("cu.id", PageOrdering.ASC)});
                while ((pagedChildUpdateIds = this.getConfigurationUpdateIds(groupConfigurationUpdateId, configurationManager, pc)).size() > 0) {
                    for (Integer childUpdateId : pagedChildUpdateIds) {
                        this.executeConfigurationUpdate(configurationManager, childUpdateId, subject);
                    }
                    if ((long)(rowsProcessed += pagedChildUpdateIds.size()) >= childPluginConfigurationUpdateCount) break;
                    pc.setPageNumber(pc.getPageNumber() + 1);
                }
                Object var13_12 = null;
                this.completeGroupConfigurationUpdate(configurationManager, groupConfigurationUpdateId, errorMessages);
            }
            catch (Exception e) {
                errorMessages = ThrowableUtil.getAllMessages((Throwable)e);
                Object var13_13 = null;
                this.completeGroupConfigurationUpdate(configurationManager, groupConfigurationUpdateId, errorMessages);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.completeGroupConfigurationUpdate(configurationManager, groupConfigurationUpdateId, errorMessages);
            throw throwable;
        }
    }

    private static String createUniqueJobName(ResourceGroup group, Subject subject, String jobNamePrefix) {
        return AbstractGroupConfigurationUpdateJob.createJobGroupName(group, jobNamePrefix) + "-" + subject.getName().hashCode() + "-" + System.currentTimeMillis();
    }

    private static String createJobGroupName(ResourceGroup group, String jobNamePrefix) {
        return jobNamePrefix + group.getId();
    }

    protected abstract List<Integer> getConfigurationUpdateIds(Integer var1, ConfigurationManagerLocal var2, PageControl var3);

    protected abstract long getConfigurationUpdateCount(Integer var1, ConfigurationManagerLocal var2);

    protected abstract void executeConfigurationUpdate(ConfigurationManagerLocal var1, Integer var2, Subject var3);

    protected abstract void completeGroupConfigurationUpdate(ConfigurationManagerLocal var1, Integer var2, String var3);
}

