/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.jboss.util.StringPropertyReplacer;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceSyncResults;
import org.rhq.core.domain.content.ContentSourceSyncStatus;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.Distribution;
import org.rhq.core.domain.content.DistributionFile;
import org.rhq.core.domain.content.DistributionType;
import org.rhq.core.domain.content.DownloadMode;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageBits;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.PackageVersionContentSource;
import org.rhq.core.domain.content.PackageVersionContentSourcePK;
import org.rhq.core.domain.content.ProductVersionPackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoContentSource;
import org.rhq.core.domain.content.RepoDistribution;
import org.rhq.core.domain.content.RepoPackageVersion;
import org.rhq.core.domain.content.composite.LoadedPackageBitsComposite;
import org.rhq.core.domain.content.composite.PackageVersionFile;
import org.rhq.core.domain.content.composite.PackageVersionMetadataComposite;
import org.rhq.core.domain.criteria.RepoCriteria;
import org.rhq.core.domain.resource.ProductVersion;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.domain.util.PersistenceUtility;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.content.ContentManagerHelper;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceException;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.DistributionException;
import org.rhq.enterprise.server.content.DistributionManagerLocal;
import org.rhq.enterprise.server.content.RepoException;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderManager;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetailsKey;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.content.DistributionDetails;
import org.rhq.enterprise.server.plugin.pc.content.DistributionFileDetails;
import org.rhq.enterprise.server.plugin.pc.content.DistributionSource;
import org.rhq.enterprise.server.plugin.pc.content.DistributionSyncReport;
import org.rhq.enterprise.server.plugin.pc.content.InitializationException;
import org.rhq.enterprise.server.plugin.pc.content.PackageSyncReport;
import org.rhq.enterprise.server.plugin.pc.content.RepoDetails;
import org.rhq.enterprise.server.resource.ProductVersionManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class ContentSourceManagerBean
implements ContentSourceManagerLocal {
    private final Log log = LogFactory.getLog(ContentSourceManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS", mappedName="java:/RHQDS")
    private DataSource dataSource;
    @EJB
    private ContentSourceManagerLocal contentSourceManager;
    @EJB
    private ContentManagerLocal contentManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ProductVersionManagerLocal productVersionManager;
    @EJB
    private RepoManagerLocal repoManager;

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void purgeOrphanedPackageVersions(Subject subject) {
        Query q = this.entityManager.createNamedQuery("PackageVersion.findOrphanedExtraProps");
        List pvs = q.getResultList();
        for (PackageVersion pv : pvs) {
            this.entityManager.remove((Object)pv.getExtraProperties());
            pv.setExtraProperties(null);
        }
        q = this.entityManager.createNamedQuery("PackageVersion.findOrphanedFiles");
        List pvFiles = q.getResultList();
        this.entityManager.flush();
        this.entityManager.clear();
        this.entityManager.createNamedQuery("PackageVersion.deletePVPVIfNoContentSourcesOrRepos").executeUpdate();
        int count = this.entityManager.createNamedQuery("PackageVersion.deleteIfNoContentSourcesOrRepos").executeUpdate();
        this.entityManager.createNamedQuery("PackageBits.deleteIfNoPackageVersion").executeUpdate();
        this.entityManager.flush();
        this.entityManager.clear();
        for (PackageVersionFile pvFile : pvFiles) {
            try {
                File doomed = this.getPackageBitsLocalFileAndCreateParentDir(pvFile.getPackageVersionId(), pvFile.getFileName());
                if (!doomed.exists()) continue;
                doomed.delete();
            }
            catch (Exception e) {
                this.log.warn((Object)("Cannot purge orphaned package version file [" + pvFile.getFileName() + "] (" + pvFile.getPackageVersionId() + ")"));
            }
        }
        this.log.info((Object)("User [" + subject + "] purged [" + count + "] orphaned package versions"));
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteContentSource(Subject subject, int contentSourceId) {
        this.log.debug((Object)("User [" + subject + "] is deleting content source [" + contentSourceId + "]"));
        this.entityManager.flush();
        this.entityManager.clear();
        this.entityManager.createNamedQuery("RepoContentSource.deleteByContentSourceId").setParameter("contentSourceId", (Object)contentSourceId).executeUpdate();
        this.entityManager.createNamedQuery("PackageVersionContentSource.deleteByContentSourceId").setParameter("contentSourceId", (Object)contentSourceId).executeUpdate();
        ContentSource cs = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSourceId);
        if (cs != null) {
            if (cs.getConfiguration() != null) {
                this.entityManager.remove((Object)cs.getConfiguration());
            }
            this.entityManager.remove((Object)cs);
            this.log.debug((Object)("User [" + subject + "] deleted content source [" + cs + "]"));
            this.repoManager.deleteCandidatesWithOnlyContentSource(subject, contentSourceId);
            try {
                ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
                pc.unscheduleSyncJob(cs);
                pc.getAdapterManager().shutdownAdapter(cs);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to shutdown adapter for [" + cs + "]"), (Throwable)e);
            }
        } else {
            this.log.debug((Object)("Content Source ID [" + contentSourceId + "] doesn't exist - nothing to delete"));
        }
        this.purgeOrphanedPackageVersions(subject);
    }

    @Override
    public Set<ContentSourceType> getAllContentSourceTypes() {
        Query q = this.entityManager.createNamedQuery("ContentSourceType.findAll");
        List resultList = q.getResultList();
        return new HashSet<ContentSourceType>(resultList);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<ContentSource> getAllContentSources(Subject subject, PageControl pc) {
        pc.initDefaultOrderingField("cs.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ContentSource.findAllWithConfig", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ContentSource.findAll");
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<ContentSource> getAvailableContentSourcesForRepo(Subject subject, Integer repoId, PageControl pc) {
        pc.initDefaultOrderingField("cs.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ContentSource.findAvailableByRepoId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ContentSource.findAvailableByRepoId");
        query.setParameter("repoId", (Object)repoId);
        countQuery.setParameter("repoId", (Object)repoId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public ContentSourceType getContentSourceType(String name) {
        Query q = this.entityManager.createNamedQuery("ContentSourceType.findByNameWithConfigDef");
        q.setParameter("name", (Object)name);
        ContentSourceType type = (ContentSourceType)q.getSingleResult();
        return type;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ContentSource getContentSource(Subject subject, int contentSourceId) {
        Query q = this.entityManager.createNamedQuery("ContentSource.findByIdWithConfig");
        q.setParameter("id", (Object)contentSourceId);
        ContentSource contentSource = null;
        try {
            contentSource = (ContentSource)q.getSingleResult();
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        return contentSource;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ContentSource getContentSourceByNameAndType(Subject subject, String name, String typeName) {
        Query q = this.entityManager.createNamedQuery("ContentSource.findByNameAndTypeName");
        q.setParameter("name", (Object)name);
        q.setParameter("typeName", (Object)typeName);
        ContentSource cs = null;
        try {
            cs = (ContentSource)q.getSingleResult();
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        return cs;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Repo> getAssociatedRepos(Subject subject, int contentSourceId, PageControl pc) {
        pc.initDefaultOrderingField("c.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Repo.findByContentSourceId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Repo.findByContentSourceId");
        query.setParameter("id", (Object)contentSourceId);
        countQuery.setParameter("id", (Object)contentSourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public PageList<Repo> getCandidateRepos(Subject subject, int contentSourceId, PageControl pc) {
        pc.initDefaultOrderingField("c.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Repo.findCandidateByContentSourceId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Repo.findCandidateByContentSourceId");
        query.setParameter("id", (Object)contentSourceId);
        countQuery.setParameter("id", (Object)contentSourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<ContentSourceSyncResults> getContentSourceSyncResults(Subject subject, int contentSourceId, PageControl pc) {
        pc.initDefaultOrderingField("cssr.startTime", PageOrdering.DESC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ContentSourceSyncResults.getAllByCSId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ContentSourceSyncResults.getAllByCSId");
        query.setParameter("contentSourceId", (Object)contentSourceId);
        countQuery.setParameter("contentSourceId", (Object)contentSourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void mergeRepoImportResults(List<RepoDetails> repos) {
        Subject overlord = this.subjectManager.getOverlord();
        for (RepoDetails createMe : repos) {
            String repoName = createMe.getName();
            List<Repo> existingRepo = this.repoManager.getRepoByName(repoName);
            if (existingRepo != null) continue;
            Repo repo = new Repo(repoName);
            repo.setDescription(createMe.getDescription());
            try {
                this.repoManager.createRepo(overlord, repo);
            }
            catch (RepoException e) {
                this.log.error((Object)("Error creating repo [" + repo + "]"), (Throwable)e);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteContentSourceSyncResults(Subject subject, int[] ids) {
        if (ids != null) {
            for (int id : ids) {
                ContentSourceSyncResults doomed = (ContentSourceSyncResults)this.entityManager.getReference(ContentSourceSyncResults.class, (Object)id);
                this.entityManager.remove((Object)doomed);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ContentSource createContentSource(Subject subject, ContentSource contentSource) throws ContentSourceException {
        this.validateContentSource(contentSource);
        this.log.debug((Object)("User [" + subject + "] is creating content source [" + contentSource + "]"));
        try {
            ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
            pc.getAdapterManager().startAdapter(contentSource);
            pc.scheduleSyncJob(contentSource);
            pc.syncNow(contentSource);
        }
        catch (InitializationException ie) {
            this.log.warn((Object)("Failed to start adapter for [" + contentSource + "]"), (Throwable)ie);
            throw new ContentSourceException("Failed to start adapter for [" + contentSource + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)ie));
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to start adapter for [" + contentSource + "]"), (Throwable)e);
        }
        this.entityManager.persist((Object)contentSource);
        contentSource.setSyncResults(null);
        this.log.debug((Object)("User [" + subject + "] created content source [" + contentSource + "]"));
        return contentSource;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ContentSource simpleCreateContentSource(Subject subject, ContentSource contentSource) throws ContentSourceException {
        this.validateContentSource(contentSource);
        contentSource.setSyncResults(new ArrayList());
        this.entityManager.persist((Object)contentSource);
        return contentSource;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ContentSource updateContentSource(Subject subject, ContentSource contentSource) throws ContentSourceException {
        ContentServerPluginContainer pc;
        this.log.debug((Object)("User [" + subject + "] is updating content source [" + contentSource + "]"));
        ContentSource loaded = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSource.getId());
        if (contentSource.getConfiguration() == null && loaded.getConfiguration() != null) {
            this.entityManager.remove((Object)loaded.getConfiguration());
        }
        if (!loaded.getName().equals(contentSource.getName())) {
            this.log.info((Object)("Content source [" + loaded.getName() + "] is being renamed to [" + contentSource.getName() + "].  Will now unschedule the old sync job"));
            try {
                pc = ContentManagerHelper.getPluginContainer();
                pc.unscheduleSyncJob(loaded);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to unschedule obsolete content source sync job for [" + loaded + "]"), (Throwable)e);
            }
        }
        contentSource = (ContentSource)this.entityManager.merge((Object)contentSource);
        this.log.debug((Object)("User [" + subject + "] updated content source [" + contentSource + "]"));
        try {
            pc = ContentManagerHelper.getPluginContainer();
            pc.unscheduleSyncJob(contentSource);
            pc.getAdapterManager().restartAdapter(contentSource);
            pc.scheduleSyncJob(contentSource);
            pc.syncNow(contentSource);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to restart adapter for [" + contentSource + "]"), (Throwable)e);
        }
        return contentSource;
    }

    private void validateContentSource(ContentSource cs) throws ContentSourceException {
        String name = cs.getName();
        ContentSourceType type = cs.getContentSourceType();
        if (name == null || name.trim().equals("")) {
            throw new ContentSourceException("ContentSource name attribute is required");
        }
        Query q = this.entityManager.createNamedQuery("ContentSource.findByNameAndTypeName");
        q.setParameter("name", (Object)name);
        q.setParameter("typeName", (Object)type.getName());
        List existingMatchingContentSources = q.getResultList();
        if (existingMatchingContentSources.size() > 0) {
            throw new ContentSourceException("Content source with name [" + name + "] and of type [" + type.getName() + "] already exists, please specify a different name.");
        }
    }

    @Override
    public boolean testContentSourceConnection(int contentSourceId) {
        try {
            ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
            return pc.getAdapterManager().testConnection(contentSourceId);
        }
        catch (Exception e) {
            this.log.info((Object)("Failed to test connection to [" + contentSourceId + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
            this.log.debug((Object)("Content source test connection failure stack follows for [" + contentSourceId + "]"), (Throwable)e);
            return false;
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void synchronizeAndLoadContentSource(Subject subject, int contentSourceId) {
        try {
            ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
            ContentSource contentSource = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSourceId);
            if (contentSource != null) {
                pc.syncNow(contentSource);
            } else {
                this.log.warn((Object)("Asked to synchronize a non-existing content source [" + contentSourceId + "]"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not spawn the sync job for content source [" + contentSourceId + "]");
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PackageVersionContentSource> getPackageVersionsFromContentSource(Subject subject, int contentSourceId, PageControl pc) {
        pc.initDefaultOrderingField("pvcs.contentSource.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByContentSourceId", (PageControl)pc);
        query.setParameter("id", (Object)contentSourceId);
        List results = query.getResultList();
        long count = this.getPackageVersionCountFromContentSource(subject, contentSourceId);
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public List<PackageVersionContentSource> getPackageVersionsFromContentSourceForRepo(Subject subject, int contentSourceId, int repoId) {
        Query query = this.entityManager.createNamedQuery("PackageVersionContentSource.findByContentSourceIdAndRepoId");
        query.setParameter("content_source_id", (Object)contentSourceId);
        query.setParameter("repo_id", (Object)repoId);
        List results = query.getResultList();
        return results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public long getPackageVersionCountFromContentSource(Subject subject, int contentSourceId) {
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByContentSourceIdCount");
        countQuery.setParameter("id", (Object)contentSourceId);
        Long count = (Long)countQuery.getSingleResult();
        return count;
    }

    @Override
    public long getPackageBitsLength(int resourceId, PackageDetailsKey packageDetailsKey) {
        Query q = this.entityManager.createNamedQuery("PackageVersion.getPkgBitsLengthByPkgDetailsAndResId");
        q.setParameter("packageName", (Object)packageDetailsKey.getName());
        q.setParameter("packageTypeName", (Object)packageDetailsKey.getPackageTypeName());
        q.setParameter("version", (Object)packageDetailsKey.getVersion());
        q.setParameter("architectureName", (Object)packageDetailsKey.getArchitectureName());
        q.setParameter("resourceId", (Object)resourceId);
        Long count = (Long)q.getSingleResult();
        return count;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PackageVersionContentSource> getPackageVersionsFromContentSources(Subject subject, int[] contentSourceIds, PageControl pc) {
        pc.initDefaultOrderingField("pvcs.contentSource.id");
        ArrayList<Integer> idList = new ArrayList<Integer>(contentSourceIds.length);
        int[] arr$ = contentSourceIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer id = arr$[i$];
            idList.add(id);
        }
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByAllContentSourceIds", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByAllContentSourceIdsCount");
        query.setParameter("ids", idList);
        countQuery.setParameter("ids", idList);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PackageVersionContentSource> getUnloadedPackageVersionsFromContentSource(Subject subject, int contentSourceId, PageControl pc) {
        pc.initDefaultOrderingField("pvcs.contentSource.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByCSIdAndNotLoaded", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByCSIdAndNotLoadedCount");
        query.setParameter("id", (Object)contentSourceId);
        countQuery.setParameter("id", (Object)contentSourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        PageList dbList = new PageList((Collection)results, (int)count, pc);
        HashSet<PackageVersionContentSource> uniquePVs = new HashSet<PackageVersionContentSource>();
        uniquePVs.addAll((Collection<PackageVersionContentSource>)dbList);
        ContentSource contentSource = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSourceId);
        if (contentSource.getDownloadMode().equals((Object)DownloadMode.FILESYSTEM)) {
            PageList<PackageVersionContentSource> allPackageVersions = this.contentSourceManager.getPackageVersionsFromContentSource(subject, contentSourceId, pc);
            for (PackageVersionContentSource item : allPackageVersions) {
                PackageVersion pv = item.getPackageVersionContentSourcePK().getPackageVersion();
                File verifyFile = this.getPackageBitsLocalFilesystemFile(pv.getId(), pv.getFileName());
                if (verifyFile.exists()) continue;
                this.log.info((Object)("Missing file from ContentProvider, adding to list: " + verifyFile.getAbsolutePath()));
                uniquePVs.add(item);
            }
        }
        return new PageList(uniquePVs, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public void downloadDistributionBits(Subject subject, ContentSource contentSource) {
        try {
            this.log.debug((Object)"downloadDistributionBits invoked");
            DistributionManagerLocal distManager = LookupUtil.getDistributionManagerLocal();
            ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
            int contentSourceId = contentSource.getId();
            ContentProviderManager cpMgr = pc.getAdapterManager();
            ContentProvider provider = cpMgr.getIsolatedContentProvider(contentSource.getId());
            assert (provider instanceof DistributionSource);
            DistributionSource distSource = (DistributionSource)((Object)provider);
            RepoCriteria reposForContentSource = new RepoCriteria();
            reposForContentSource.addFilterContentSourceIds(new Integer[]{contentSourceId});
            reposForContentSource.addFilterCandidate(Boolean.valueOf(false));
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            PageList<Repo> repos = this.repoManager.findReposByCriteria(overlord, reposForContentSource);
            this.log.debug((Object)("downloadDistributionBits found " + repos.size() + " repos associated with this contentSourceId " + contentSourceId));
            for (Repo repo : repos) {
                this.log.debug((Object)("downloadDistributionBits operating on repo: " + repo.getName() + " id = " + repo.getId()));
                PageControl pageControl = PageControl.getUnlimitedInstance();
                this.log.debug((Object)("Looking up existing distributions for repoId: " + repo.getId()));
                PageList<Distribution> dists = this.repoManager.findAssociatedDistributions(overlord, repo.getId(), pageControl);
                this.log.debug((Object)("Found " + dists.size() + " Distributions for repoId " + repo.getId()));
                for (Distribution dist : dists) {
                    this.log.debug((Object)("Looking up DistributionFiles for dist: " + dist));
                    List<DistributionFile> distFiles = distManager.getDistributionFilesByDistId(dist.getId());
                    this.log.debug((Object)("Found " + distFiles.size() + " DistributionFiles"));
                    for (DistributionFile dFile : distFiles) {
                        String relPath = dist.getBasePath() + "/" + dFile.getRelativeFilename();
                        File outputFile = this.getDistLocalFileAndCreateParentDir(dist.getLabel(), relPath);
                        this.log.debug((Object)("Checking if file exists at: " + outputFile.getAbsolutePath()));
                        if (outputFile.exists()) {
                            this.log.debug((Object)("File " + outputFile.getAbsolutePath() + " exists, checking md5sum"));
                            String expectedMD5 = dFile.getMd5sum() != null ? dFile.getMd5sum() : "<unspecified MD5>";
                            String actualMD5 = MessageDigestGenerator.getDigestString((File)outputFile);
                            if (!expectedMD5.trim().toLowerCase().equals(actualMD5.toLowerCase())) {
                                this.log.error((Object)("Expected [" + expectedMD5 + "] versus actual [" + actualMD5 + "] md5sums for file " + outputFile.getAbsolutePath() + " do not match."));
                                this.log.error((Object)"Need to re-fetch file.  Will download from DistributionSource and overwrite local file.");
                            } else {
                                this.log.info((Object)(outputFile + " exists and md5sum matches [" + actualMD5 + "] no need to re-download"));
                                continue;
                            }
                        }
                        this.log.debug((Object)("Attempting download of " + dFile.getRelativeFilename() + " from contentSourceId " + contentSourceId));
                        String remoteFetchLoc = distSource.getDistFileRemoteLocation(repo.getName(), dist.getLabel(), dFile.getRelativeFilename());
                        InputStream bitsStream = pc.getAdapterManager().loadDistributionFileBits(contentSourceId, remoteFetchLoc);
                        StreamUtil.copy((InputStream)bitsStream, (OutputStream)new FileOutputStream(outputFile), (boolean)true);
                        bitsStream = null;
                        this.log.debug((Object)("DistributionFile has been downloaded to: " + outputFile.getAbsolutePath()));
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public PackageBits downloadPackageBits(Subject subject, PackageVersionContentSource pvcs) {
        PackageVersionContentSourcePK pk = pvcs.getPackageVersionContentSourcePK();
        int contentSourceId = pk.getContentSource().getId();
        int packageVersionId = pk.getPackageVersion().getId();
        String packageVersionLocation = pvcs.getLocation();
        switch (pk.getContentSource().getDownloadMode()) {
            case NEVER: {
                return null;
            }
            case DATABASE: {
                this.log.debug((Object)("Downloading package bits to DB for package located at [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                break;
            }
            case FILESYSTEM: {
                this.log.debug((Object)("Downloading package bits to filesystem for package located at [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                break;
            }
            default: {
                throw new IllegalStateException(" Unknown download mode - this is a bug, please report it: " + pvcs);
            }
        }
        InputStream bitsStream = null;
        PackageBits packageBits = null;
        try {
            ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
            bitsStream = pc.getAdapterManager().loadPackageBits(contentSourceId, packageVersionLocation);
            Connection conn = null;
            Statement ps = null;
            try {
                packageBits = new PackageBits();
                this.entityManager.persist((Object)packageBits);
                PackageVersion pv = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
                pv.setPackageBits(packageBits);
                this.entityManager.flush();
                if (pk.getContentSource().getDownloadMode() == DownloadMode.DATABASE) {
                    conn = this.dataSource.getConnection();
                    ps = conn.prepareStatement("UPDATE RHQ_PACKAGE_BITS SET BITS = ? WHERE ID = ?");
                    ps.setBinaryStream(1, bitsStream, pv.getFileSize().intValue());
                    ps.setInt(2, packageBits.getId());
                    if (ps.executeUpdate() != 1) {
                        throw new Exception("Did not download the package bits to the DB for [" + pv + "]");
                    }
                } else {
                    File outputFile = this.getPackageBitsLocalFileAndCreateParentDir(pv.getId(), pv.getFileName());
                    this.log.info((Object)("OutPutFile is located at: " + outputFile));
                    if (outputFile.exists()) {
                        String expectedMD5 = pv.getMD5() != null ? pv.getMD5() : "<unspecified MD5>";
                        String actualMD5 = MessageDigestGenerator.getDigestString((File)outputFile);
                        if (!expectedMD5.trim().toLowerCase().equals(actualMD5.toLowerCase())) {
                            throw new Exception("Already have package bits for [" + pv + "] located at [" + outputFile + "] but the MD5 hashcodes do not match. Expected MD5=[" + expectedMD5 + "], Actual MD5=[" + actualMD5 + "]");
                        }
                        this.log.info((Object)("Asked to download package bits but we already have it at [" + outputFile + "] with matching MD5 of [" + actualMD5 + "]"));
                    } else {
                        StreamUtil.copy((InputStream)bitsStream, (OutputStream)new FileOutputStream(outputFile), (boolean)true);
                        bitsStream = null;
                    }
                }
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)("Failed to close prepared statement for package bits [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)("Failed to close connection for package bits [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Did not download the package bits for [" + pvcs + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)t), t);
        }
        finally {
            if (bitsStream != null) {
                try {
                    bitsStream.close();
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to close stream to package bits located at [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                }
            }
        }
        return packageBits;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean internalSynchronizeContentSource(int contentSourceId) throws Exception {
        ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
        return pc.getAdapterManager().synchronizeContentSource(contentSourceId);
    }

    @Override
    public ContentSourceSyncResults persistContentSourceSyncResults(ContentSourceSyncResults results) {
        Query q = this.entityManager.createNamedQuery("ContentSourceSyncResults.getInProgressByCSId");
        q.setParameter("contentSourceId", (Object)results.getContentSource().getId());
        List inprogressList = q.getResultList();
        boolean alreadyInProgress = false;
        if (inprogressList.size() > 0) {
            if (results.getStatus() == ContentSourceSyncStatus.INPROGRESS && System.currentTimeMillis() - ((ContentSourceSyncResults)inprogressList.get(0)).getStartTime() < 86400000L) {
                alreadyInProgress = true;
                inprogressList.remove(0);
            }
            for (ContentSourceSyncResults inprogress : inprogressList) {
                inprogress.setStatus(ContentSourceSyncStatus.FAILURE);
                inprogress.setEndTime(Long.valueOf(System.currentTimeMillis()));
                inprogress.setResults("This synchronization seems to have stalled or ended abnormally.");
            }
        }
        ContentSourceSyncResults persistedResults = null;
        if (!alreadyInProgress) {
            this.entityManager.persist((Object)results);
            persistedResults = results;
        }
        return persistedResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentSourceSyncResults mergeContentSourceSyncResults(ContentSourceSyncResults results) {
        return (ContentSourceSyncResults)this.entityManager.merge((Object)results);
    }

    @Override
    public ContentSourceSyncResults getContentSourceSyncResults(int resultsId) {
        return (ContentSourceSyncResults)this.entityManager.find(ContentSourceSyncResults.class, (Object)resultsId);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public ContentSourceSyncResults mergeContentSourceSyncReport(ContentSource contentSource, DistributionSyncReport report, ContentSourceSyncResults syncResults) {
        try {
            StringBuilder progress = new StringBuilder();
            if (syncResults.getResults() != null) {
                progress.append(syncResults.getResults());
            }
            syncResults = this.contentSourceManager._mergeContentSourceSyncReportREMOVE(contentSource, report, syncResults, progress);
            syncResults = this.contentSourceManager._mergeContentSourceSyncReportADD(contentSource, report, syncResults, progress);
            if (report.getDistributions().size() > 0 || report.getDeletedDistributions().size() > 0) {
                this.contentSourceManager._mergeContentSourceSyncReportUpdateRepo(contentSource.getId());
            }
            progress.append(new Date()).append(": ").append("MERGE COMPLETE.\n");
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        }
        catch (Throwable t) {
            String errorMsg = "Could not process sync report from [" + contentSource + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)t);
            this.log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg, t);
        }
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public ContentSourceSyncResults mergeContentSourceSyncReport(ContentSource contentSource, PackageSyncReport report, Map<ContentProviderPackageDetailsKey, PackageVersionContentSource> previous, ContentSourceSyncResults syncResults) {
        try {
            StringBuilder progress = new StringBuilder();
            if (syncResults.getResults() != null) {
                progress.append(syncResults.getResults());
            }
            syncResults = this.contentSourceManager._mergeContentSourceSyncReportREMOVE(contentSource, report, previous, syncResults, progress);
            ArrayList<ContentProviderPackageDetails> newPackages = new ArrayList<ContentProviderPackageDetails>(report.getNewPackages());
            int chunkSize = 200;
            int fromIndex = 0;
            int toIndex = chunkSize;
            int newPackageCount = newPackages.size();
            int addedCount = 0;
            progress.append(new Date()).append(": ").append("Adding");
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
            while (fromIndex < newPackageCount) {
                if (toIndex > newPackageCount) {
                    toIndex = newPackageCount;
                }
                List<ContentProviderPackageDetails> pkgs = newPackages.subList(fromIndex, toIndex);
                syncResults = this.contentSourceManager._mergeContentSourceSyncReportADD(contentSource, pkgs, previous, syncResults, progress, fromIndex);
                addedCount += pkgs.size();
                fromIndex += chunkSize;
                toIndex += chunkSize;
            }
            progress.append("...").append(addedCount).append('\n');
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
            syncResults = this.contentSourceManager._mergeContentSourceSyncReportUPDATE(contentSource, report, previous, syncResults, progress);
            if (report.getNewPackages().size() > 0 || report.getUpdatedPackages().size() > 0 || report.getDeletedPackages().size() > 0) {
                this.contentSourceManager._mergeContentSourceSyncReportUpdateRepo(contentSource.getId());
            }
            progress.append(new Date()).append(": ").append("MERGE COMPLETE.\n");
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        }
        catch (Throwable t) {
            String errorMsg = "Could not process sync report from [" + contentSource + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)t);
            this.log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg, t);
        }
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void _mergeContentSourceSyncReportUpdateRepo(int contentSourceId) {
        long now = System.currentTimeMillis();
        ContentSource contentSource = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSourceId);
        Set ccss = contentSource.getRepoContentSources();
        for (RepoContentSource ccs : ccss) {
            ccs.getRepoContentSourcePK().getRepo().setLastModifiedDate(now);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentSourceSyncResults _mergeContentSourceSyncReportREMOVE(ContentSource contentSource, PackageSyncReport report, Map<ContentProviderPackageDetailsKey, PackageVersionContentSource> previous, ContentSourceSyncResults syncResults, StringBuilder progress) {
        progress.append(new Date()).append(": ").append("Removing");
        syncResults.setResults(progress.toString());
        syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        int flushCount = 0;
        int removeCount = 0;
        for (ContentProviderPackageDetails doomedDetails : report.getDeletedPackages()) {
            ContentProviderPackageDetailsKey doomedDetailsKey = doomedDetails.getContentProviderPackageDetailsKey();
            PackageVersionContentSource doomedPvcs = previous.get((Object)doomedDetailsKey);
            if ((doomedPvcs = (PackageVersionContentSource)this.entityManager.find(PackageVersionContentSource.class, (Object)doomedPvcs.getPackageVersionContentSourcePK())) != null) {
                this.entityManager.remove((Object)doomedPvcs);
            }
            PackageVersion doomedPv = doomedPvcs.getPackageVersionContentSourcePK().getPackageVersion();
            Query q = this.entityManager.createNamedQuery("PackageVersion.findByIdIfNoContentSourcesOrRepos");
            q.setParameter("id", (Object)doomedPv.getId());
            try {
                doomedPv = (PackageVersion)q.getSingleResult();
                this.entityManager.remove((Object)doomedPv);
            }
            catch (NoResultException nre) {
                // empty catch block
            }
            if (++flushCount % 200 == 0) {
                this.entityManager.flush();
                this.entityManager.clear();
            }
            if (++removeCount % 200 != 0) continue;
            progress.append("...").append(removeCount);
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        }
        progress.append("...").append(removeCount).append('\n');
        syncResults.setResults(progress.toString());
        syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentSourceSyncResults _mergeContentSourceSyncReportREMOVE(ContentSource contentSource, DistributionSyncReport report, ContentSourceSyncResults syncResults, StringBuilder progress) {
        progress.append(new Date()).append(": ").append("Removing");
        syncResults.setResults(progress.toString());
        syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        DistributionManagerLocal distManager = LookupUtil.getDistributionManagerLocal();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        for (DistributionDetails doomedDetails : report.getDeletedDistributions()) {
            Distribution doomedDist = distManager.getDistributionByLabel(doomedDetails.getLabel());
            distManager.deleteDistributionByDistId(overlord, doomedDist.getId());
            distManager.deleteDistributionFilesByDistId(overlord, doomedDist.getId());
            progress.append("Removed distribution & distribution files for: " + doomedDetails.getLabel());
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        }
        progress.append("Finished Distribution removal...").append('\n');
        syncResults.setResults(progress.toString());
        syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentSourceSyncResults _mergeContentSourceSyncReportADD(ContentSource contentSource, DistributionSyncReport report, ContentSourceSyncResults syncResults, StringBuilder progress) {
        DistributionManagerLocal distManager = LookupUtil.getDistributionManagerLocal();
        RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        List<DistributionDetails> newDetails = report.getDistributions();
        for (DistributionDetails detail : newDetails) {
            try {
                this.log.debug((Object)("Attempting to create new distribution based off of: " + detail));
                DistributionType distType = distManager.getDistributionTypeByName(detail.getDistributionType());
                Distribution newDist = distManager.createDistribution(overlord, detail.getLabel(), detail.getDistributionPath(), distType);
                this.log.debug((Object)("Created new distribution: " + newDist));
                Repo repo = repoManager.getRepo(overlord, report.getRepoId());
                RepoDistribution repoDist = new RepoDistribution(repo, newDist);
                this.log.debug((Object)("Created new mapping of RepoDistribution repoId = " + repo.getId() + ", distId = " + newDist.getId()));
                this.entityManager.persist((Object)repoDist);
                List<DistributionFileDetails> files = detail.getFiles();
                for (DistributionFileDetails f : files) {
                    this.log.debug((Object)("Creating DistributionFile for: " + f));
                    DistributionFile df = new DistributionFile(newDist, f.getRelativeFilename(), f.getMd5sum());
                    df.setLastModified(f.getLastModified());
                    this.entityManager.persist((Object)df);
                    this.entityManager.flush();
                }
            }
            catch (DistributionException e) {
                progress.append("Caught exception when trying to add: " + detail.getLabel() + "\n");
                progress.append("Error is: " + e.getMessage());
                syncResults.setResults(progress.toString());
                syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
                this.log.error((Object)e);
            }
        }
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentSourceSyncResults _mergeContentSourceSyncReportADD(ContentSource contentSource, Collection<ContentProviderPackageDetails> newPackages, Map<ContentProviderPackageDetailsKey, PackageVersionContentSource> previous, ContentSourceSyncResults syncResults, StringBuilder progress, int addCount) {
        int flushCount = 0;
        HashMap<ResourceType, ResourceType> knownResourceTypes = new HashMap<ResourceType, ResourceType>();
        HashMap<PackageType, PackageType> knownPackageTypes = new HashMap<PackageType, PackageType>();
        HashMap<Architecture, Architecture> knownArchitectures = new HashMap<Architecture, Architecture>();
        List associatedRepos = null;
        HashMap knownProductVersions = new HashMap();
        for (ContentProviderPackageDetails newDetails : newPackages) {
            Package pkg;
            PackageType pt;
            Query q;
            ResourceType rt;
            block22: {
                ContentProviderPackageDetailsKey key;
                block21: {
                    key = newDetails.getContentProviderPackageDetailsKey();
                    rt = new ResourceType();
                    rt.setName(key.getResourceTypeName());
                    rt.setPlugin(key.getResourceTypePluginName());
                    if (!knownResourceTypes.containsKey(rt)) {
                        q = this.entityManager.createNamedQuery("ResourceType.findByNameAndPlugin");
                        q.setParameter("name", (Object)rt.getName());
                        q.setParameter("plugin", (Object)rt.getPlugin());
                        try {
                            rt = (ResourceType)q.getSingleResult();
                            knownResourceTypes.put(rt, rt);
                            knownProductVersions.put(rt, new HashMap());
                            break block21;
                        }
                        catch (NoResultException nre) {
                            this.log.warn((Object)("Content source adapter found a package for an unknown resource type [" + key.getResourceTypeName() + "|" + key.getResourceTypePluginName() + "] Skipping it."));
                            continue;
                        }
                    }
                    rt = (ResourceType)knownResourceTypes.get(rt);
                }
                pt = new PackageType(key.getPackageTypeName(), rt);
                if (!knownPackageTypes.containsKey(pt)) {
                    q = this.entityManager.createNamedQuery("PackageType.findByResourceTypeIdAndName");
                    q.setParameter("typeId", (Object)rt.getId());
                    q.setParameter("name", (Object)pt.getName());
                    try {
                        pt = (PackageType)q.getSingleResult();
                        pt.setResourceType(rt);
                        knownPackageTypes.put(pt, pt);
                        break block22;
                    }
                    catch (NoResultException nre) {
                        this.log.warn((Object)("Content source adapter found a package of an unknown package type [" + key.getPackageTypeName() + "|" + rt + "] Skipping it."));
                        continue;
                    }
                }
                pt = (PackageType)knownPackageTypes.get(pt);
            }
            q = this.entityManager.createNamedQuery("Package.findByNamePkgTypeResourceType");
            q.setParameter("name", (Object)newDetails.getName());
            q.setParameter("packageTypeName", (Object)newDetails.getPackageTypeName());
            q.setParameter("resourceTypeId", (Object)rt.getId());
            try {
                pkg = (Package)q.getSingleResult();
            }
            catch (NoResultException nre) {
                pkg = new Package(newDetails.getName(), pt);
                pkg.setClassification(newDetails.getClassification());
                pkg = this.contentManager.persistOrMergePackageSafely(pkg);
            }
            Architecture arch = new Architecture(newDetails.getArchitectureName());
            if (!knownArchitectures.containsKey(arch)) {
                q = this.entityManager.createNamedQuery("Architecture.findByName");
                q.setParameter("name", (Object)arch.getName());
                try {
                    arch = (Architecture)q.getSingleResult();
                    knownArchitectures.put(arch, arch);
                }
                catch (NoResultException nre) {
                    this.log.info((Object)("Content source adapter found a previously unknown architecture [" + arch + "] - it will be added to the list of known architectures"));
                }
            } else {
                arch = (Architecture)knownArchitectures.get(arch);
            }
            PackageVersion pv = new PackageVersion(pkg, newDetails.getVersion(), arch);
            pv.setDisplayName(newDetails.getDisplayName());
            pv.setDisplayVersion(newDetails.getDisplayVersion());
            pv.setExtraProperties(newDetails.getExtraProperties());
            pv.setFileCreatedDate(newDetails.getFileCreatedDate());
            pv.setFileName(newDetails.getFileName());
            pv.setFileSize(newDetails.getFileSize());
            pv.setLicenseName(newDetails.getLicenseName());
            pv.setLicenseVersion(newDetails.getLicenseVersion());
            pv.setLongDescription(newDetails.getLongDescription());
            pv.setMD5(newDetails.getMD5());
            pv.setMetadata(newDetails.getMetadata());
            pv.setSHA256(newDetails.getSHA256());
            pv.setShortDescription(newDetails.getShortDescription());
            q = this.entityManager.createNamedQuery("PackageVersion.findByPackageDetailsKey");
            q.setParameter("packageName", (Object)newDetails.getName());
            q.setParameter("packageTypeName", (Object)pt.getName());
            q.setParameter("resourceTypeId", (Object)rt.getId());
            q.setParameter("architectureName", (Object)arch.getName());
            q.setParameter("version", (Object)newDetails.getVersion());
            try {
                PackageVersion pvExisting = (PackageVersion)q.getSingleResult();
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getExtraProperties(), pv, pv.getExtraProperties(), "ExtraProps");
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getFileSize(), pv, pv.getFileSize(), "FileSize");
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getFileName(), pv, pv.getFileName(), "FileName");
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getMD5(), pv, pv.getMD5(), "MD5");
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getSHA256(), pv, pv.getSHA256(), "SHA256");
                pv = pvExisting;
            }
            catch (NoResultException nre) {
                // empty catch block
            }
            pv = this.contentManager.persistOrMergePackageVersionSafely(pv);
            Set<String> resourceVersions = newDetails.getResourceVersions();
            if (resourceVersions != null) {
                Map cachedProductVersions = (Map)knownProductVersions.get(rt);
                for (String version : resourceVersions) {
                    ProductVersion productVersion = (ProductVersion)cachedProductVersions.get(version);
                    if (productVersion == null) {
                        productVersion = this.productVersionManager.addProductVersion(rt, version);
                        cachedProductVersions.put(version, productVersion);
                    }
                    ProductVersionPackageVersion mapping = new ProductVersionPackageVersion(productVersion, pv);
                    this.entityManager.merge((Object)mapping);
                }
            }
            PackageVersionContentSource newPvcs = new PackageVersionContentSource(pv, contentSource, newDetails.getLocation());
            newPvcs = (PackageVersionContentSource)this.entityManager.merge((Object)newPvcs);
            if (associatedRepos == null) {
                q = this.entityManager.createNamedQuery("Repo.findByContentSourceIdFetchCCS");
                q.setParameter("id", (Object)contentSource.getId());
                associatedRepos = q.getResultList();
            }
            for (Repo associatedRepo : associatedRepos) {
                RepoPackageVersion mapping = new RepoPackageVersion(associatedRepo, pv);
                this.entityManager.merge((Object)mapping);
            }
            if (++flushCount % 100 == 0) {
                knownResourceTypes.clear();
                knownPackageTypes.clear();
                knownArchitectures.clear();
                associatedRepos = null;
                knownProductVersions.clear();
                this.entityManager.flush();
                this.entityManager.clear();
            }
            if (++addCount % 100 != 0) continue;
            progress.append("...").append(addCount);
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        }
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentSourceSyncResults _mergeContentSourceSyncReportUPDATE(ContentSource contentSource, PackageSyncReport report, Map<ContentProviderPackageDetailsKey, PackageVersionContentSource> previous, ContentSourceSyncResults syncResults, StringBuilder progress) {
        progress.append(new Date()).append(": ").append("Updating");
        syncResults.setResults(progress.toString());
        syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        int flushCount = 0;
        int updateCount = 0;
        for (ContentProviderPackageDetails updatedDetails : report.getUpdatedPackages()) {
            ContentProviderPackageDetailsKey key = updatedDetails.getContentProviderPackageDetailsKey();
            PackageVersionContentSource previousPvcs = previous.get((Object)key);
            PackageVersionContentSource attachedPvcs = (PackageVersionContentSource)this.entityManager.find(PackageVersionContentSource.class, (Object)previousPvcs.getPackageVersionContentSourcePK());
            if (attachedPvcs == null) {
                this.log.warn((Object)("Content source adapter reported that a non-existing package was updated, adding it [" + (Object)((Object)key) + "]"));
                this.entityManager.persist((Object)previousPvcs);
                attachedPvcs = previousPvcs;
            }
            PackageVersion pv = previousPvcs.getPackageVersionContentSourcePK().getPackageVersion();
            pv.setDisplayName(updatedDetails.getDisplayName());
            pv.setDisplayVersion(updatedDetails.getDisplayVersion());
            pv.setExtraProperties(updatedDetails.getExtraProperties());
            pv.setFileCreatedDate(updatedDetails.getFileCreatedDate());
            pv.setFileName(updatedDetails.getFileName());
            pv.setFileSize(updatedDetails.getFileSize());
            pv.setLicenseName(updatedDetails.getLicenseName());
            pv.setLicenseVersion(updatedDetails.getLicenseVersion());
            pv.setLongDescription(updatedDetails.getLongDescription());
            pv.setMD5(updatedDetails.getMD5());
            pv.setMetadata(updatedDetails.getMetadata());
            pv.setSHA256(updatedDetails.getSHA256());
            pv.setShortDescription(updatedDetails.getShortDescription());
            pv = this.contentManager.persistOrMergePackageVersionSafely(pv);
            attachedPvcs.setLocation(updatedDetails.getLocation());
            if (++flushCount % 200 == 0) {
                this.entityManager.flush();
                this.entityManager.clear();
            }
            if (++updateCount % 200 != 0) continue;
            progress.append("...").append(updateCount);
            syncResults.setResults(progress.toString());
            syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        }
        progress.append("...").append(updateCount).append('\n');
        syncResults.setResults(progress.toString());
        syncResults = this.contentSourceManager.mergeContentSourceSyncResults(syncResults);
        return syncResults;
    }

    @Override
    public PageList<PackageVersionMetadataComposite> getPackageVersionMetadata(int resourceId, PageControl pc) {
        pc.initDefaultOrderingField("pv.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersion.findMetadataByResourceId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersion.findMetadataByResourceId");
        query.setParameter("resourceId", (Object)resourceId);
        countQuery.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public String getResourceSubscriptionMD5(int resourceId) {
        MessageDigestGenerator md5Generator = new MessageDigestGenerator();
        Query q = this.entityManager.createNamedQuery("Repo.findReposByResourceId");
        q.setParameter("resourceId", (Object)resourceId);
        List repos = q.getResultList();
        for (Repo repo : repos) {
            long modifiedTimestamp = repo.getLastModifiedDate();
            Date modifiedDate = new Date(modifiedTimestamp);
            md5Generator.add(Integer.toString(modifiedDate.hashCode()).getBytes());
        }
        String digestString = md5Generator.getDigestString();
        return digestString;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public long outputPackageVersionBitsGivenResource(int resourceId, PackageDetailsKey packageDetailsKey, OutputStream outputStream) {
        return this.outputPackageVersionBitsRangeGivenResource(resourceId, packageDetailsKey, outputStream, 0L, -1L);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public long outputPackageBitsForChildResource(int parentResourceId, String resourceTypeName, PackageDetailsKey packageDetailsKey, OutputStream outputStream) {
        org.rhq.core.domain.resource.Resource parentResource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)parentResourceId);
        ResourceType parentResourceType = parentResource.getResourceType();
        Query query = this.entityManager.createNamedQuery("ResourceType.findByParentAndName");
        query.setParameter("parent", (Object)parentResourceType);
        query.setParameter("name", (Object)resourceTypeName);
        ResourceType childResourceType = (ResourceType)query.getSingleResult();
        query = this.entityManager.createNamedQuery("PackageVersion.findByPackageDetailsKey");
        query.setParameter("packageName", (Object)packageDetailsKey.getName());
        query.setParameter("packageTypeName", (Object)packageDetailsKey.getPackageTypeName());
        query.setParameter("architectureName", (Object)packageDetailsKey.getArchitectureName());
        query.setParameter("version", (Object)packageDetailsKey.getVersion());
        query.setParameter("resourceTypeId", (Object)childResourceType.getId());
        PackageVersion packageVersion = (PackageVersion)query.getSingleResult();
        return this.outputPackageVersionBitsRangeHelper(parentResourceId, packageDetailsKey, outputStream, 0L, -1L, packageVersion.getId());
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public long outputPackageVersionBitsRangeGivenResource(int resourceId, PackageDetailsKey packageDetailsKey, OutputStream outputStream, long startByte, long endByte) {
        if (startByte < 0L) {
            throw new IllegalArgumentException("startByte[" + startByte + "] < 0");
        }
        if (endByte > -1L && endByte < startByte) {
            throw new IllegalArgumentException("endByte[" + endByte + "] < startByte[" + startByte + "]");
        }
        Query query = this.entityManager.createNamedQuery("PackageVersion.findIdByPackageDetailsKeyAndResId");
        query.setParameter("packageName", (Object)packageDetailsKey.getName());
        query.setParameter("packageTypeName", (Object)packageDetailsKey.getPackageTypeName());
        query.setParameter("architectureName", (Object)packageDetailsKey.getArchitectureName());
        query.setParameter("version", (Object)packageDetailsKey.getVersion());
        query.setParameter("resourceId", (Object)resourceId);
        int packageVersionId = (Integer)query.getSingleResult();
        return this.outputPackageVersionBitsRangeHelper(resourceId, packageDetailsKey, outputStream, startByte, endByte, packageVersionId);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long outputPackageVersionBitsRangeHelper(int resourceId, PackageDetailsKey packageDetailsKey, OutputStream outputStream, long startByte, long endByte, int packageVersionId) {
        block50: {
            block49: {
                block44: {
                    query = this.entityManager.createNamedQuery("PackageBits.isLoaded");
                    query.setParameter("id", (Object)packageVersionId);
                    composite = (LoadedPackageBitsComposite)query.getSingleResult();
                    packageBitsAreAvailable = composite.isPackageBitsAvailable();
                    if (packageBitsAreAvailable && !composite.isPackageBitsInDatabase()) {
                        try {
                            bitsFile = this.getPackageBitsLocalFileAndCreateParentDir(composite.getPackageVersionId(), composite.getFileName());
                            if (!bitsFile.exists()) {
                                this.log.warn((Object)("Package version [" + packageDetailsKey + "] has had its bits file [" + bitsFile + "] deleted. Will attempt to download it again."));
                                packageBitsAreAvailable = false;
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Package version [" + packageDetailsKey + "] has had its bits file deleted but cannot download it again.", e);
                        }
                    }
                    pvcs = null;
                    if (!packageBitsAreAvailable) {
                        if (resourceId == -1) {
                            throw new IllegalStateException("Package bits must be inserted prior to the agent asking for them during a cotent-based resource creation");
                        }
                        q2 = this.entityManager.createNamedQuery("PackageVersionContentSource.findByPkgVerIdAndResId");
                        q2.setParameter("resourceId", (Object)resourceId);
                        q2.setParameter("packageVersionId", (Object)packageVersionId);
                        pvcss = q2.getResultList();
                        if (pvcss.size() == 0) {
                            throw new RuntimeException("Resource [" + resourceId + "] cannot access package version [" + packageDetailsKey + "] - no content source exists to deliver it");
                        }
                        pvcs = (PackageVersionContentSource)pvcss.get(0);
                        bits = null;
                        bits = this.contentSourceManager.downloadPackageBits(this.subjectManager.getOverlord(), pvcs);
                        if (bits != null) {
                            query.setParameter("id", (Object)pvcs.getPackageVersionContentSourcePK().getPackageVersion().getId());
                            composite = (LoadedPackageBitsComposite)query.getSingleResult();
                            if (!composite.isPackageBitsAvailable()) {
                                throw new RuntimeException("Failed to download package bits [" + packageDetailsKey + "] for resource [" + resourceId + "]");
                            }
                        } else {
                            composite = null;
                        }
                    }
                    conn = null;
                    ps = null;
                    results = null;
                    bitsStream = null;
                    try {
                        try {
                            if (composite == null) {
                                pc = ContentManagerHelper.getPluginContainer();
                                adapterMgr = pc.getAdapterManager();
                                contentSourceId = pvcs.getPackageVersionContentSourcePK().getContentSource().getId();
                                bitsStream = adapterMgr.loadPackageBits(contentSourceId, pvcs.getLocation());
                            } else if (composite.isPackageBitsInDatabase()) {
                                conn = this.dataSource.getConnection();
                                ps = conn.prepareStatement("SELECT BITS FROM RHQ_PACKAGE_BITS WHERE ID = ?");
                                ps.setInt(1, composite.getPackageBitsId());
                                results = ps.executeQuery();
                                results.next();
                                bitsStream = results.getBinaryStream(1);
                                if (bitsStream == null) {
                                    throw new RuntimeException("Got null for package bits stream from DB for [" + packageDetailsKey + "]");
                                }
                            } else {
                                bitsFile = this.getPackageBitsLocalFileAndCreateParentDir(composite.getPackageVersionId(), composite.getFileName());
                                if (!bitsFile.exists()) {
                                    throw new RuntimeException("Package bits at [" + bitsFile + "] are missing for [" + packageDetailsKey + "]");
                                }
                                bitsStream = new FileInputStream(bitsFile);
                            }
                            if (endByte < 0L) {
                                if (startByte > 0L) {
                                    bitsStream.skip(startByte);
                                }
                                bytesRetrieved = StreamUtil.copy((InputStream)bitsStream, (OutputStream)outputStream, (boolean)false);
                            } else {
                                bis = new BufferedInputStream(bitsStream);
                                length = endByte - startByte + 1L;
                                bytesRetrieved = StreamUtil.copy((InputStream)bis, (OutputStream)outputStream, (long)startByte, (long)length);
                            }
                            try {
                                bitsStream.close();
                            }
                            catch (Exception closeError) {
                                this.log.warn((Object)"Failed to close the bits stream", (Throwable)closeError);
                            }
                            bitsStream = null;
                            this.log.debug((Object)("Retrieved and sent [" + bytesRetrieved + "] bytes for [" + packageDetailsKey + "]"));
                            var19_24 = bytesRetrieved;
                            var23_26 = null;
                            if (bitsStream == null) break block44;
                        }
                        catch (SQLException sql) {
                            throw new RuntimeException("Did not download the package bits to the DB for [" + packageDetailsKey + "]", sql);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Could not stream package bits for [" + packageDetailsKey + "]", e);
                        }
                    }
                    catch (Throwable var22_30) {
                        var23_27 = null;
                        if (bitsStream != null) {
                            try {
                                bitsStream.close();
                            }
                            catch (IOException e /* !! */ ) {
                                this.log.warn((Object)("Failed to close bits stream for: " + packageDetailsKey));
                            }
                        }
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (SQLException e /* !! */ ) {
                                this.log.warn((Object)("Failed to close result set from jdbc blob query for: " + packageDetailsKey));
                            }
                        }
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (SQLException e /* !! */ ) {
                                this.log.warn((Object)("Failed to close prepared statement from jdbc blob query for: " + packageDetailsKey));
                            }
                        }
                        if (conn == null) throw var22_30;
                        try {
                            conn.close();
                            throw var22_30;
                        }
                        catch (SQLException e /* !! */ ) {
                            this.log.warn((Object)("Failed to close prepared statement from jdbc blob query for: " + packageDetailsKey));
                            throw var22_30;
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [6 : 926->934)] { 
lbl123:
                    // 1 sources

                    bitsStream.close();
                    break block44;
lbl125:
                    // 1 sources

                    catch (IOException e /* !! */ ) {
                        this.log.warn((Object)("Failed to close bits stream for: " + packageDetailsKey));
                    }
                }
                if (results != null) {
                    ** try [egrp 5[TRYBLOCK] [7 : 970->980)] { 
lbl130:
                    // 1 sources

                    results.close();
                    break block49;
lbl132:
                    // 1 sources

                    catch (SQLException e /* !! */ ) {
                        this.log.warn((Object)("Failed to close result set from jdbc blob query for: " + packageDetailsKey));
                    }
                }
            }
            if (ps != null) {
                ** try [egrp 6[TRYBLOCK] [8 : 1016->1026)] { 
lbl137:
                // 1 sources

                ps.close();
                break block50;
lbl139:
                // 1 sources

                catch (SQLException e /* !! */ ) {
                    this.log.warn((Object)("Failed to close prepared statement from jdbc blob query for: " + packageDetailsKey));
                }
            }
        }
        if (conn == null) return var19_24;
        try {}
        catch (SQLException e /* !! */ ) {
            this.log.warn((Object)("Failed to close prepared statement from jdbc blob query for: " + packageDetailsKey));
            return var19_24;
        }
        conn.close();
        return var19_24;
    }

    private boolean packageVersionAttributeCheck(PackageVersion pv1, Object o1, PackageVersion pv2, Object o2, String logMsg) {
        boolean same = o1 == null ? o2 == null : o1.equals(o2);
        if (!same) {
            StringBuilder str = new StringBuilder();
            str.append("A new package version has data that is different than a previous package version. ");
            str.append("The new package version data will take effect and overwrite the old version: ");
            str.append(logMsg);
            str.append(": package-version1=[").append(pv1);
            str.append("] value1=[").append(o1);
            str.append("; package-version2=[").append(pv2);
            str.append("] value2=[").append(o2);
            str.append("]");
            this.log.warn((Object)str.toString());
        }
        return same;
    }

    private File getDistributionFileBitsLocalFilesystemFile(String distLabel, String fileName) {
        String filesystemProperty = "rhq.server.content.filesystem";
        String filesystem = System.getProperty("rhq.server.content.filesystem");
        if (filesystem == null) {
            throw new IllegalStateException("Server is misconfigured - missing system property 'rhq.server.content.filesystem'. Don't know where distribution bits are stored.");
        }
        filesystem = StringPropertyReplacer.replaceProperties((String)filesystem);
        String loc = "dists/" + distLabel;
        File parentDir = new File(filesystem, loc);
        File distBitsFile = new File(parentDir, fileName);
        return distBitsFile;
    }

    private File getPackageBitsLocalFilesystemFile(int packageVersionId, String fileName) {
        String filesystemProperty = "rhq.server.content.filesystem";
        String filesystem = System.getProperty("rhq.server.content.filesystem");
        if (filesystem == null) {
            throw new IllegalStateException("Server is misconfigured - missing system property 'rhq.server.content.filesystem'. Don't know where package bits are stored.");
        }
        filesystem = StringPropertyReplacer.replaceProperties((String)filesystem);
        String idGroup = String.valueOf(packageVersionId / 2000);
        StringBuilder bitsFileName = new StringBuilder();
        bitsFileName.append(packageVersionId).append('-').append(fileName);
        if (bitsFileName.length() > 255) {
            bitsFileName.setLength(255);
        }
        File parentDir = new File(filesystem, idGroup);
        File packageBitsFile = new File(parentDir, bitsFileName.toString());
        return packageBitsFile;
    }

    private File getDistLocalFileAndCreateParentDir(String distLabel, String fileName) throws Exception {
        File distBitsFile = this.getDistributionFileBitsLocalFilesystemFile(distLabel, fileName);
        File parentDir = distBitsFile.getParentFile();
        if (!parentDir.isDirectory()) {
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!parentDir.isDirectory()) {
                throw new Exception("Cannot create content filesystem directory [" + parentDir + "] for distribution bits storage.");
            }
        }
        return distBitsFile;
    }

    private File getPackageBitsLocalFileAndCreateParentDir(int packageVersionId, String fileName) throws Exception {
        File packageBitsFile = this.getPackageBitsLocalFilesystemFile(packageVersionId, fileName);
        File parentDir = packageBitsFile.getParentFile();
        if (!parentDir.isDirectory()) {
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!parentDir.isDirectory()) {
                throw new Exception("Cannot create content filesystem directory [" + parentDir + "] for package bits storage.");
            }
        }
        return packageBitsFile;
    }
}

