/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.plugin;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorMetadataParser;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPluginScanner {
    private Log log = LogFactory.getLog(ServerPluginScanner.class);
    private DatabaseType dbType = null;
    private List<File> scanned = new ArrayList<File>();
    private Map<File, PluginWithDescriptor> serverPluginsOnFilesystem = new HashMap<File, PluginWithDescriptor>();
    private File serverPluginDir;

    public File getServerPluginDir() {
        return this.serverPluginDir;
    }

    public void setServerPluginDir(File dir) {
        this.serverPluginDir = dir;
    }

    void registerServerPlugins() throws Exception {
        for (File file : this.scanned) {
            this.log.debug((Object)("Deploying server plugin [" + file + "]..."));
            this.registerServerPlugin(file);
        }
        this.scanned.clear();
    }

    void serverPluginScan() throws Exception {
        this.log.debug((Object)"Scanning for server plugins");
        if (this.getServerPluginDir() == null || !this.getServerPluginDir().isDirectory()) {
            return;
        }
        List<File> updatedFiles1 = this.serverPluginScanFilesystem();
        List<File> updatedFiles2 = this.serverPluginScanDatabase();
        ArrayList<File> allUpdatedFiles = new ArrayList<File>();
        allUpdatedFiles.addAll(updatedFiles1);
        allUpdatedFiles.addAll(updatedFiles2);
        for (File updatedFile : allUpdatedFiles) {
            this.log.debug((Object)("Scan detected server plugin [" + updatedFile + "]..."));
            this.scanned.add(updatedFile);
        }
    }

    private void registerServerPlugin(File pluginFile) {
        try {
            PluginKey newPluginKey;
            ServerPluginsLocal serverPluginsManager;
            PluginStatusType status;
            ServerPluginDescriptorType descriptor = this.serverPluginsOnFilesystem.get((Object)pluginFile).descriptor;
            String pluginName = descriptor.getName();
            String displayName = descriptor.getDisplayName();
            ComparableVersion version = ServerPluginDescriptorUtil.getPluginVersion((File)pluginFile, (ServerPluginDescriptorType)descriptor);
            this.log.debug((Object)("Registering server plugin [" + pluginName + "], version " + version));
            ServerPlugin plugin = new ServerPlugin(pluginName, pluginFile.getName());
            plugin.setDisplayName(displayName != null ? displayName : pluginName);
            plugin.setEnabled(!descriptor.isDisabledOnDiscovery());
            plugin.setDescription(descriptor.getDescription());
            plugin.setMtime(pluginFile.lastModified());
            plugin.setVersion(version.toString());
            plugin.setAmpsVersion(descriptor.getApiVersion());
            plugin.setMD5(MessageDigestGenerator.getDigestString((File)pluginFile));
            plugin.setPluginConfiguration(this.getDefaultPluginConfiguration(descriptor));
            plugin.setScheduledJobsConfiguration(this.getDefaultScheduledJobsConfiguration(descriptor));
            plugin.setType(new ServerPluginType(descriptor).stringify());
            if (descriptor.getHelp() != null && !descriptor.getHelp().getContent().isEmpty()) {
                plugin.setHelp(String.valueOf(descriptor.getHelp().getContent().get(0)));
            }
            if (PluginStatusType.DELETED == (status = (serverPluginsManager = LookupUtil.getServerPlugins()).getServerPluginStatus(newPluginKey = new PluginKey(plugin)))) {
                this.log.warn((Object)("Plugin file [" + pluginFile + "] has been detected but that plugin with name [" + pluginName + "] was previously undeployed. Will not re-register that plugin and the file will be deleted."));
                pluginFile.delete();
            } else {
                SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
                ServerPlugin dbPlugin = serverPluginsManager.registerServerPlugin(subjectManager.getOverlord(), plugin, pluginFile);
                this.log.info((Object)("Registered server plugin [" + dbPlugin.getName() + "], version " + dbPlugin.getVersion()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to register server plugin file [" + pluginFile + "]"), (Throwable)e);
        }
    }

    private Configuration getDefaultPluginConfiguration(ServerPluginDescriptorType descriptor) throws Exception {
        Configuration defaults = null;
        ConfigurationDefinition def = ServerPluginDescriptorMetadataParser.getPluginConfigurationDefinition((ServerPluginDescriptorType)descriptor);
        if (def != null) {
            defaults = def.getDefaultTemplate().createConfiguration();
        }
        return defaults;
    }

    private Configuration getDefaultScheduledJobsConfiguration(ServerPluginDescriptorType descriptor) throws Exception {
        Configuration defaults = null;
        ConfigurationDefinition def = ServerPluginDescriptorMetadataParser.getScheduledJobsDefinition((ServerPluginDescriptorType)descriptor);
        if (def != null) {
            defaults = def.getDefaultTemplate().createConfiguration();
        }
        return defaults;
    }

    private List<File> serverPluginScanFilesystem() {
        ArrayList<File> updated = new ArrayList<File>();
        File[] pluginJars = this.getServerPluginDir().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        ArrayList<File> doomedPluginFiles = new ArrayList<File>();
        for (File cachedPluginFile : this.serverPluginsOnFilesystem.keySet()) {
            boolean existsOnFileSystem = false;
            for (File filesystemPluginFile : pluginJars) {
                if (!cachedPluginFile.equals(filesystemPluginFile)) continue;
                existsOnFileSystem = true;
            }
            if (existsOnFileSystem) continue;
            doomedPluginFiles.add(cachedPluginFile);
        }
        for (File deletedPluginFile : doomedPluginFiles) {
            this.serverPluginsOnFilesystem.remove(deletedPluginFile);
        }
        for (File pluginJar : pluginJars) {
            String md5 = null;
            PluginWithDescriptor pluginWithDescriptor = this.serverPluginsOnFilesystem.get(pluginJar);
            ServerPlugin plugin = null;
            if (pluginWithDescriptor != null) {
                plugin = pluginWithDescriptor.plugin;
            }
            try {
                if (plugin != null) {
                    if (pluginJar.lastModified() == 0L) {
                        md5 = MessageDigestGenerator.getDigestString((File)pluginJar);
                        if (!md5.equals(plugin.getMd5())) {
                            plugin = null;
                        }
                    } else if (pluginJar.lastModified() != plugin.getMtime()) {
                        plugin = null;
                    }
                }
                if (plugin != null) continue;
                this.cacheFilesystemServerPluginJar(pluginJar, md5);
                updated.add(pluginJar);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to scan server plugin [" + pluginJar + "] found on filesystem. Skipping. Cause: " + e));
                this.serverPluginsOnFilesystem.remove(pluginJar);
                updated.remove(pluginJar);
            }
        }
        doomedPluginFiles.clear();
        HashMap<String, ServerPlugin> pluginsByName = new HashMap<String, ServerPlugin>();
        for (Map.Entry<File, PluginWithDescriptor> currentPluginFileEntry : this.serverPluginsOnFilesystem.entrySet()) {
            ServerPlugin currentPlugin = currentPluginFileEntry.getValue().plugin;
            ServerPlugin existingPlugin = (ServerPlugin)pluginsByName.get(currentPlugin.getName());
            if (existingPlugin == null) {
                pluginsByName.put(currentPlugin.getName(), currentPlugin);
                continue;
            }
            ServerPlugin obsolete = ServerPluginDescriptorUtil.determineObsoletePlugin((ServerPlugin)currentPlugin, (ServerPlugin)existingPlugin);
            if (obsolete == null) {
                obsolete = currentPlugin;
            }
            doomedPluginFiles.add(new File(this.getServerPluginDir(), obsolete.getPath()));
            if (obsolete != existingPlugin) continue;
            pluginsByName.put(currentPlugin.getName(), currentPlugin);
        }
        for (File doomedPluginFile : doomedPluginFiles) {
            if (doomedPluginFile.delete()) {
                this.log.info((Object)("Deleted an obsolete server plugin file: " + doomedPluginFile));
                this.serverPluginsOnFilesystem.remove(doomedPluginFile);
                updated.remove(doomedPluginFile);
                continue;
            }
            this.log.warn((Object)("Failed to delete what was deemed an obsolete server plugin file: " + doomedPluginFile));
        }
        return updated;
    }

    private ServerPlugin cacheFilesystemServerPluginJar(File pluginJar, String md5) throws Exception {
        if (md5 == null) {
            md5 = MessageDigestGenerator.getDigestString((File)pluginJar);
        }
        URL pluginUrl = pluginJar.toURI().toURL();
        ServerPluginDescriptorType descriptor = ServerPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)pluginUrl);
        String version = ServerPluginDescriptorUtil.getPluginVersion((File)pluginJar, (ServerPluginDescriptorType)descriptor).toString();
        String name = descriptor.getName();
        ServerPlugin plugin = new ServerPlugin(name, pluginJar.getName());
        plugin.setMd5(md5);
        plugin.setVersion(version);
        plugin.setMtime(pluginJar.lastModified());
        this.serverPluginsOnFilesystem.put(pluginJar, new PluginWithDescriptor(plugin, descriptor));
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> serverPluginScanDatabase() throws Exception {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ServerPlugin> updatedPlugins = new ArrayList<ServerPlugin>();
        ArrayList<File> updatedFiles = new ArrayList<File>();
        try {
            DataSource ds = LookupUtil.getDataSource();
            conn = ds.getConnection();
            ps = conn.prepareStatement("SELECT NAME, PATH, MD5, MTIME, VERSION FROM RHQ_PLUGIN WHERE DEPLOYMENT = 'SERVER' AND STATUS = 'INSTALLED' ");
            rs = ps.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                String path = rs.getString(2);
                String md5 = rs.getString(3);
                long mtime = rs.getLong(4);
                String version = rs.getString(5);
                File expectedFile = new File(this.getServerPluginDir(), path);
                File currentFile = null;
                PluginWithDescriptor pluginWithDescriptor = this.serverPluginsOnFilesystem.get(expectedFile);
                if (pluginWithDescriptor != null) {
                    currentFile = expectedFile;
                    if (!pluginWithDescriptor.plugin.getName().equals(name)) {
                        this.log.warn((Object)("For some reason, the server plugin file [" + expectedFile + "] is plugin [" + pluginWithDescriptor.plugin.getName() + "] but the database says it should be [" + name + "]"));
                    } else {
                        this.log.debug((Object)("File system and database agree on a server plugin location for [" + expectedFile + "]"));
                    }
                } else {
                    for (Map.Entry<File, PluginWithDescriptor> cacheEntry : this.serverPluginsOnFilesystem.entrySet()) {
                        if (!cacheEntry.getValue().plugin.getName().equals(name)) continue;
                        currentFile = cacheEntry.getKey();
                        pluginWithDescriptor = cacheEntry.getValue();
                        this.log.info((Object)("Filesystem has a server plugin [" + name + "] at the file [" + currentFile + "] which is different than where the DB thinks it should be [" + expectedFile + "]"));
                        break;
                    }
                }
                if (pluginWithDescriptor != null && currentFile != null && currentFile.exists()) {
                    ServerPlugin dbPlugin = new ServerPlugin(name, path);
                    dbPlugin.setMd5(md5);
                    dbPlugin.setVersion(version);
                    dbPlugin.setMtime(mtime);
                    ServerPlugin obsoletePlugin = ServerPluginDescriptorUtil.determineObsoletePlugin((ServerPlugin)dbPlugin, (ServerPlugin)pluginWithDescriptor.plugin);
                    if (obsoletePlugin == pluginWithDescriptor.plugin) {
                        StringBuilder logMsg = new StringBuilder();
                        logMsg.append("Found server plugin [").append(name);
                        logMsg.append("] in the DB that is newer than the one on the filesystem: ");
                        logMsg.append("DB path=[").append(path);
                        logMsg.append("]; file path=[").append(currentFile.getName());
                        logMsg.append("]; DB MD5=[").append(md5);
                        logMsg.append("]; file MD5=[").append(pluginWithDescriptor.plugin.getMd5());
                        logMsg.append("]; DB version=[").append(version);
                        logMsg.append("]; file version=[").append(pluginWithDescriptor.plugin.getVersion());
                        logMsg.append("]; DB timestamp=[").append(new Date(mtime));
                        logMsg.append("]; file timestamp=[").append(new Date(pluginWithDescriptor.plugin.getMtime()));
                        logMsg.append("]");
                        this.log.info((Object)logMsg.toString());
                        updatedPlugins.add(dbPlugin);
                        if (currentFile.delete()) {
                            this.log.info((Object)("Deleted the obsolete server plugin file to be updated: " + currentFile));
                            this.serverPluginsOnFilesystem.remove(currentFile);
                        } else {
                            this.log.warn((Object)("Failed to delete the obsolete (to-be-updated) server plugin file: " + currentFile));
                        }
                        currentFile = null;
                        continue;
                    }
                    if (obsoletePlugin == null) {
                        currentFile.setLastModified(mtime);
                        pluginWithDescriptor.plugin.setMtime(mtime);
                        pluginWithDescriptor.plugin.setVersion(version);
                        pluginWithDescriptor.plugin.setMd5(md5);
                        continue;
                    }
                    this.log.info((Object)("It appears that the server plugin [" + dbPlugin + "] in the database may be obsolete. If so, it will be updated later."));
                    continue;
                }
                this.log.info((Object)("Found server plugin in the DB that we do not yet have: " + name));
                ServerPlugin plugin = new ServerPlugin(name, path, md5);
                plugin.setMtime(mtime);
                plugin.setVersion(version);
                updatedPlugins.add(plugin);
                this.serverPluginsOnFilesystem.remove(expectedFile);
            }
            JDBCUtil.safeClose((Statement)ps, (ResultSet)rs);
            ps = conn.prepareStatement("SELECT CONTENT FROM RHQ_PLUGIN WHERE DEPLOYMENT = 'SERVER' AND STATUS = 'INSTALLED' AND NAME = ?");
            for (ServerPlugin plugin : updatedPlugins) {
                File file = new File(this.getServerPluginDir(), plugin.getPath());
                ps.setString(1, plugin.getName());
                rs = ps.executeQuery();
                rs.next();
                InputStream content = rs.getBinaryStream(1);
                StreamUtil.copy((InputStream)content, (OutputStream)new FileOutputStream(file));
                rs.close();
                file.setLastModified(plugin.getMtime());
                updatedFiles.add(file);
                this.cacheFilesystemServerPluginJar(file, null);
            }
            Object var20_19 = null;
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            JDBCUtil.safeClose((Connection)conn, (Statement)ps, rs);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)ps, (ResultSet)rs);
        return updatedFiles;
    }

    private void setEnabledFlag(Connection conn, PreparedStatement ps, int index, boolean enabled) throws Exception {
        if (null == this.dbType) {
            this.dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
        }
        if (this.dbType instanceof PostgresqlDatabaseType || this.dbType instanceof H2DatabaseType) {
            ps.setBoolean(index, enabled);
        } else if (this.dbType instanceof OracleDatabaseType || this.dbType instanceof SQLServerDatabaseType) {
            ps.setInt(index, enabled ? 1 : 0);
        } else {
            throw new RuntimeException("Unknown database type : " + this.dbType);
        }
    }

    /*
     * Loose catch block
     */
    private void streamPluginFileContentToDatabase(String name, File file, boolean different) throws Exception {
        block11: {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            TransactionManager tm = null;
            String sql = "UPDATE RHQ_PLUGIN SET CONTENT = ?, MD5 = ?, MTIME = ?, PATH = ? WHERE DEPLOYMENT = 'SERVER' AND STATUS = 'INSTALLED' AND NAME = ?";
            String md5 = !different ? MessageDigestGenerator.getDigestString((File)file) : "TO BE UPDATED";
            long mtime = !different ? file.lastModified() : 0L;
            InputStream fis = !different ? new FileInputStream(file) : new ByteArrayInputStream(new byte[0]);
            int contentSize = (int)(!different ? file.length() : 0L);
            tm = LookupUtil.getTransactionManager();
            tm.begin();
            DataSource ds = LookupUtil.getDataSource();
            conn = ds.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setBinaryStream(1, (InputStream)new BufferedInputStream(fis), contentSize);
            ps.setString(2, md5);
            ps.setLong(3, mtime);
            ps.setString(4, file.getName());
            ps.setString(5, name);
            int updateResults = ps.executeUpdate();
            if (updateResults != 1) {
                throw new Exception("Failed to update content for plugin [" + name + "] from [" + file + "]");
            }
            this.log.info((Object)("Stored content for plugin [" + name + "] in the db. file=" + file));
            Object var17_16 = null;
            JDBCUtil.safeClose((Connection)conn, (Statement)ps, rs);
            try {
                fis.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (tm != null) {
                tm.commit();
            }
            break block11;
            {
                catch (Exception e) {
                    tm.rollback();
                    tm = null;
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                JDBCUtil.safeClose(conn, ps, rs);
                try {
                    fis.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (tm != null) {
                    tm.commit();
                }
                throw throwable;
            }
        }
    }

    private class PluginWithDescriptor {
        public ServerPlugin plugin;
        public ServerPluginDescriptorType descriptor;

        public PluginWithDescriptor(ServerPlugin plugin, ServerPluginDescriptorType descriptor) {
            this.plugin = plugin;
            this.descriptor = descriptor;
        }
    }
}

