/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.event;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.EventCriteria;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.event.composite.EventComposite;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.domain.util.PersistenceUtility;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.event.EventException;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.event.EventManagerRemote;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitor;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
public class EventManagerBean
implements EventManagerLocal,
EventManagerRemote {
    private static final String EVENT_SOURCE_INSERT_STMT = "INSERT INTO RHQ_Event_Source (id, event_def_id, resource_id, location) SELECT %s, (SELECT id FROM RHQ_Event_Def WHERE name = ? AND resource_type_id = (SELECT id FROM RHQ_Resource_Type WHERE name = ? AND plugin = ?)), ?, ? FROM RHQ_Numbers WHERE i = 42 AND NOT EXISTS (SELECT * FROM RHQ_Event_Source WHERE event_def_id = (SELECT id FROM RHQ_Event_Def WHERE name = ? AND resource_type_id = (SELECT id FROM RHQ_Resource_Type WHERE name = ? AND plugin = ?)) AND resource_id = ? AND location = ?)";
    private static final String EVENT_SOURCE_INSERT_STMT_AUTOINC = "INSERT INTO RHQ_Event_Source (event_def_id, resource_id, location) SELECT (SELECT id FROM RHQ_Event_Def WHERE name = ? AND resource_type_id = (SELECT id FROM RHQ_Resource_Type WHERE name = ? AND plugin = ?)), ?, ? FROM RHQ_Numbers WHERE i = 42 AND NOT EXISTS (SELECT * FROM RHQ_Event_Source WHERE event_def_id = (SELECT id FROM RHQ_Event_Def WHERE name = ? AND resource_type_id = (SELECT id FROM RHQ_Resource_Type WHERE name = ? AND plugin = ?)) AND resource_id = ? AND location = ?)";
    private static final String EVENT_INSERT_STMT = "INSERT INTO RHQ_Event (id, event_source_id, timestamp, severity, detail) VALUES (%s, (SELECT id FROM RHQ_Event_Source WHERE event_def_id = (SELECT id FROM RHQ_Event_Def WHERE name = ? AND resource_type_id = (SELECT id FROM RHQ_Resource_Type WHERE name = ? AND plugin = ?)) AND resource_id = ? AND location = ?), ?, ?, ?)";
    private static final String EVENT_INSERT_STMT_AUTOINC = "INSERT INTO RHQ_Event (event_source_id, timestamp, severity, detail) VALUES ((SELECT id FROM RHQ_Event_Source WHERE event_def_id = (SELECT id FROM RHQ_Event_Def WHERE name = ? AND resource_type_id = (SELECT id FROM RHQ_Resource_Type WHERE name = ? AND plugin = ?)) AND resource_id = ? AND location = ?), ?, ?, ?)";
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS")
    private DataSource rhqDs;
    private DatabaseType dbType;
    @EJB
    private AlertConditionCacheManagerLocal alertConditionCacheManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private ResourceGroupManagerLocal resGrpMgr;
    Log log = LogFactory.getLog(EventManagerBean.class);

    @PostConstruct
    public void init() {
        Connection conn = null;
        try {
            try {
                conn = this.rhqDs.getConnection();
                this.dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            JDBCUtil.safeClose((Connection)conn);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addEventData(Map<EventSource, Set<Event>> events) {
        if (events == null) return;
        if (events.size() == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            try {
                String statementSql;
                String nextvalSql;
                conn = this.rhqDs.getConnection();
                DatabaseType dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
                if (dbType instanceof PostgresqlDatabaseType || dbType instanceof OracleDatabaseType || dbType instanceof H2DatabaseType) {
                    nextvalSql = JDBCUtil.getNextValSql((Connection)conn, (String)"RHQ_EVENT_SOURCE");
                    statementSql = String.format(EVENT_SOURCE_INSERT_STMT, nextvalSql);
                } else {
                    if (!(dbType instanceof SQLServerDatabaseType)) throw new IllegalArgumentException("Unknown database type, can't continue: " + dbType);
                    statementSql = EVENT_SOURCE_INSERT_STMT_AUTOINC;
                }
                ps = conn.prepareStatement(statementSql);
                try {
                    for (EventSource eventSource : events.keySet()) {
                        int paramIndex = 1;
                        ps.setString(paramIndex++, eventSource.getEventDefinition().getName());
                        ps.setString(paramIndex++, eventSource.getEventDefinition().getResourceType().getName());
                        ps.setString(paramIndex++, eventSource.getEventDefinition().getResourceType().getPlugin());
                        ps.setInt(paramIndex++, eventSource.getResource().getId());
                        ps.setString(paramIndex++, eventSource.getLocation());
                        ps.setString(paramIndex++, eventSource.getEventDefinition().getName());
                        ps.setString(paramIndex++, eventSource.getEventDefinition().getResourceType().getName());
                        ps.setString(paramIndex++, eventSource.getEventDefinition().getResourceType().getPlugin());
                        ps.setInt(paramIndex++, eventSource.getResource().getId());
                        ps.setString(paramIndex++, eventSource.getLocation());
                        ps.addBatch();
                    }
                    ps.executeBatch();
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    JDBCUtil.safeClose((Statement)ps);
                    throw throwable;
                }
                JDBCUtil.safeClose((Statement)ps);
                if (dbType instanceof PostgresqlDatabaseType || dbType instanceof OracleDatabaseType || dbType instanceof H2DatabaseType) {
                    nextvalSql = JDBCUtil.getNextValSql((Connection)conn, (String)"RHQ_EVENT");
                    statementSql = String.format(EVENT_INSERT_STMT, nextvalSql);
                } else {
                    if (!(dbType instanceof SQLServerDatabaseType)) throw new IllegalArgumentException("Unknown database type, can't continue: " + dbType);
                    statementSql = EVENT_INSERT_STMT_AUTOINC;
                }
                ps = conn.prepareStatement(statementSql);
                try {
                    for (EventSource eventSource : events.keySet()) {
                        Set<Event> eventData = events.get(eventSource);
                        for (Event event : eventData) {
                            int paramIndex = 1;
                            ps.setString(paramIndex++, eventSource.getEventDefinition().getName());
                            ps.setString(paramIndex++, eventSource.getEventDefinition().getResourceType().getName());
                            ps.setString(paramIndex++, eventSource.getEventDefinition().getResourceType().getPlugin());
                            ps.setInt(paramIndex++, eventSource.getResource().getId());
                            ps.setString(paramIndex++, eventSource.getLocation());
                            ps.setLong(paramIndex++, event.getTimestamp());
                            ps.setString(paramIndex++, event.getSeverity().toString());
                            ps.setString(paramIndex++, event.getDetail());
                            ps.addBatch();
                        }
                        this.notifyAlertConditionCacheManager("addEventData", eventSource, eventData.toArray(new Event[eventData.size()]));
                    }
                    ps.executeBatch();
                    Object var13_17 = null;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    JDBCUtil.safeClose((Statement)ps);
                    throw throwable;
                }
                JDBCUtil.safeClose((Statement)ps);
                Object var15_20 = null;
            }
            catch (Throwable t) {
                this.log.warn((Object)("addEventData: Insert of events failed : " + t.getMessage()));
                Object var15_21 = null;
                JDBCUtil.safeClose((Connection)conn);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            JDBCUtil.safeClose((Connection)conn);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn);
    }

    private void notifyAlertConditionCacheManager(String callingMethod, EventSource source, Event ... events) {
        AlertConditionCacheStats stats = this.alertConditionCacheManager.checkConditions(source, events);
        this.log.debug((Object)(callingMethod + ": " + stats.toString()));
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=21600)
    public int purgeEventData(Date deleteUpToTime) throws SQLException {
        Query q = this.entityManager.createQuery("DELETE FROM Event e WHERE e.timestamp < :cutOff");
        q.setParameter("cutOff", (Object)deleteUpToTime.getTime());
        long startTime = System.currentTimeMillis();
        int deleted = q.executeUpdate();
        MeasurementMonitor.getMBean().incrementPurgeTime(System.currentTimeMillis() - startTime);
        MeasurementMonitor.getMBean().setPurgedEvents(deleted);
        return deleted;
    }

    @Override
    @NotNull
    public List<Event> findEventsForResources(Subject subject, List<org.rhq.core.domain.resource.Resource> resources, long startDate, long endDate) {
        if (resources == null || resources.size() == 0) {
            return new ArrayList<Event>();
        }
        Query q = this.entityManager.createNamedQuery("Event.FIND_EVENTS_FOR_RESOURCES_AND_TIME");
        q.setParameter("resources", resources);
        q.setParameter("start", (Object)startDate);
        q.setParameter("end", (Object)endDate);
        List ret = q.getResultList();
        return ret;
    }

    @Override
    public PageList<EventComposite> findEventsForAutoGroup(Subject subject, int parent, int type, long begin, long endDate, EventSeverity[] severities, PageControl pc) {
        List<org.rhq.core.domain.resource.Resource> resources = this.resGrpMgr.findResourcesForAutoGroup(subject, parent, type);
        int[] resourceIds = new int[resources.size()];
        int i = 0;
        for (org.rhq.core.domain.resource.Resource res : resources) {
            resourceIds[i++] = res.getId();
        }
        PageList<EventComposite> comp = this.findEvents(subject, resourceIds, begin, endDate, severities, null, null, pc);
        return comp;
    }

    @Override
    public PageList<EventComposite> findEventsForAutoGroup(Subject subject, int parent, int type, long begin, long endDate, EventSeverity[] severities, String source, String searchString, PageControl pc) {
        List<org.rhq.core.domain.resource.Resource> resources = this.resGrpMgr.findResourcesForAutoGroup(subject, parent, type);
        for (org.rhq.core.domain.resource.Resource res : resources) {
            if (this.authorizationManager.canViewResource(subject, res.getId())) continue;
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view event history for autoGroup[parentResourceId=" + parent + ", resourceTypeId=" + type + "], root cause: missing permission to view resource[id=" + res.getId() + "]");
        }
        int[] resourceIds = new int[resources.size()];
        int i = 0;
        for (org.rhq.core.domain.resource.Resource res : resources) {
            resourceIds[i++] = res.getId();
        }
        PageList<EventComposite> comp = this.findEvents(subject, resourceIds, begin, endDate, severities, source, searchString, pc);
        return comp;
    }

    @Override
    public PageList<EventComposite> findEventsForCompGroup(Subject subject, int groupId, long begin, long endDate, EventSeverity[] severities, PageControl pc) {
        List<org.rhq.core.domain.resource.Resource> resources = this.resGrpMgr.findResourcesForResourceGroup(subject, groupId, GroupCategory.COMPATIBLE);
        int[] resourceIds = new int[resources.size()];
        int i = 0;
        for (org.rhq.core.domain.resource.Resource res : resources) {
            resourceIds[i++] = res.getId();
        }
        PageList<EventComposite> comp = this.findEvents(subject, resourceIds, begin, endDate, severities, null, null, pc);
        return comp;
    }

    @Override
    public PageList<EventComposite> findEventsForCompGroup(Subject subject, int groupId, long begin, long endDate, EventSeverity[] severities, String source, String searchString, PageControl pc) {
        List<org.rhq.core.domain.resource.Resource> resources = this.resGrpMgr.findResourcesForResourceGroup(subject, groupId, GroupCategory.COMPATIBLE);
        int[] resourceIds = new int[resources.size()];
        int i = 0;
        for (org.rhq.core.domain.resource.Resource res : resources) {
            resourceIds[i++] = res.getId();
        }
        PageList<EventComposite> comp = this.findEvents(subject, resourceIds, begin, endDate, severities, source, searchString, pc);
        return comp;
    }

    @Override
    public int[] getEventCounts(Subject subject, int resourceId, long begin, long end, int numBuckets) {
        int[] buckets = new int[numBuckets];
        PageList<EventComposite> events = this.findEventsForResource(subject, resourceId, begin, end, null, null);
        long timeDiff = end - begin;
        long timePerBucket = timeDiff / (long)numBuckets;
        for (EventComposite event : events) {
            int bucket;
            long evTime = event.getTimestamp().getTime();
            int n = bucket = (int)((evTime -= begin) / timePerBucket);
            buckets[n] = buckets[n] + 1;
        }
        return buckets;
    }

    @Override
    public EventSeverity[] getSeverityBuckets(Subject subject, int resourceId, long begin, long end, int numBuckets) {
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view event buckets for resource[id=" + resourceId + "]");
        }
        try {
            org.rhq.core.domain.resource.Resource res = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)resourceId);
            ArrayList<org.rhq.core.domain.resource.Resource> resources = new ArrayList<org.rhq.core.domain.resource.Resource>(1);
            resources.add(res);
            return this.getSeverityBucketsForResources(subject, resources, begin, end, numBuckets);
        }
        catch (NoResultException nre) {
            return new EventSeverity[numBuckets];
        }
    }

    @Override
    public EventSeverity[] getSeverityBucketsForAutoGroup(Subject subject, int parentId, int type, long begin, long end, int numBuckets) {
        List<org.rhq.core.domain.resource.Resource> resources = this.resGrpMgr.findResourcesForAutoGroup(subject, parentId, type);
        for (org.rhq.core.domain.resource.Resource res : resources) {
            if (this.authorizationManager.canViewResource(subject, res.getId())) continue;
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view event buckets for autoGroup[parentResourceId=" + parentId + ", resourceTypeId=" + type + "], root cause: missing permission to view resource[id=" + res.getId() + "]");
        }
        return this.getSeverityBucketsForResources(subject, resources, begin, end, numBuckets);
    }

    @Override
    public EventSeverity[] getSeverityBucketsForCompGroup(Subject subject, int groupId, long begin, long end, int numBuckets) {
        if (!this.authorizationManager.canViewGroup(subject, groupId)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view event buckets for resourceGroup[id=" + groupId + "]");
        }
        List<org.rhq.core.domain.resource.Resource> resources = this.resGrpMgr.findResourcesForResourceGroup(subject, groupId, GroupCategory.COMPATIBLE);
        return this.getSeverityBucketsForResources(subject, resources, begin, end, numBuckets);
    }

    private EventSeverity[] getSeverityBucketsForResources(Subject subject, List<org.rhq.core.domain.resource.Resource> resources, long begin, long end, int numBuckets) {
        EventSeverity[] buckets = new EventSeverity[numBuckets];
        if (resources == null || resources.size() == 0) {
            return buckets;
        }
        List<Event> events = this.findEventsForResources(subject, resources, begin, end);
        long timeDiff = end - begin;
        long timePerBucket = timeDiff / (long)numBuckets;
        for (Event event : events) {
            long evTime = event.getTimestamp();
            int bucket = (int)((evTime -= begin) / timePerBucket);
            if (!event.getSeverity().isMoreSevereThan(buckets[bucket])) continue;
            buckets[bucket] = event.getSeverity();
        }
        return buckets;
    }

    @Override
    @NotNull
    public PageList<EventComposite> findEventsForResource(Subject subject, int resourceId, long startDate, long endDate, EventSeverity[] severities, PageControl pc) {
        PageList<EventComposite> comp = this.findEvents(subject, new int[]{resourceId}, startDate, endDate, severities, null, null, pc);
        return comp;
    }

    @Override
    public PageList<EventComposite> findEvents(Subject subject, int[] resourceIds, long begin, long end, EventSeverity[] severities, String source, String searchString, PageControl pc) {
        if (pc == null) {
            pc = new PageControl();
        }
        PageList pl = new PageList(pc);
        if (resourceIds == null || resourceIds.length == 0) {
            return pl;
        }
        String query = this.setupEventsQuery(resourceIds, severities, source, searchString, pc, false);
        this.runEventsQuery(resourceIds, begin, end, severities, source, searchString, pc, (PageList<EventComposite>)pl, query);
        query = this.setupEventsQuery(resourceIds, severities, source, searchString, pc, true);
        int totals = this.runEventsCountQuery(resourceIds, begin, end, severities, source, searchString, pc, (PageList<EventComposite>)pl, query);
        pl.setTotalSize(totals);
        return pl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runEventsQuery(int[] resourceIds, long begin, long end, EventSeverity[] severities, String source, String searchString, PageControl pc, PageList<EventComposite> pl, String query) {
        Connection conn = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            try {
                conn = this.rhqDs.getConnection();
                stm = conn.prepareStatement(query);
                int i = 1;
                JDBCUtil.bindNTimes((PreparedStatement)stm, (int[])resourceIds, (int)i);
                i += resourceIds.length;
                stm.setLong(i++, begin);
                stm.setLong(i++, end);
                if (severities != null) {
                    for (int j = 0; j < severities.length; ++j) {
                        stm.setString(i++, severities[j].toString());
                    }
                }
                if (this.isFilled(searchString)) {
                    stm.setString(i++, PersistenceUtility.formatSearchParameter((String)searchString));
                }
                if (this.isFilled(source)) {
                    stm.setString(i++, PersistenceUtility.formatSearchParameter((String)source));
                }
                rs = stm.executeQuery();
                while (rs.next()) {
                    EventComposite ec = new EventComposite(rs.getString(1), rs.getInt(6), rs.getString(7), rs.getInt(2), EventSeverity.valueOf((String)rs.getString(4)), rs.getString(3), Long.valueOf(rs.getLong(5)));
                    pl.add((Object)ec);
                }
                Object var18_17 = null;
            }
            catch (SQLException sq) {
                this.log.error((Object)("runEventsQuery: Error retrieving events: " + sq.getMessage()), (Throwable)sq);
                this.log.error((Object)("query is [" + query + "]."));
                this.log.error((Object)("resourceIds[] has [" + resourceIds.length + "] members."));
                this.log.error((Object)("severities are [" + (null == severities ? severities : Arrays.asList(severities)) + "]."));
                this.log.error((Object)("source is [" + source + "]."));
                this.log.error((Object)("searchString is [" + searchString + "]."));
                this.log.error((Object)("PageControl is [" + pc + "]."));
                Object var18_18 = null;
                JDBCUtil.safeClose((Connection)conn, (Statement)stm, (ResultSet)rs);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            JDBCUtil.safeClose((Connection)conn, (Statement)stm, rs);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)stm, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int runEventsCountQuery(int[] resourceIds, long begin, long end, EventSeverity[] severities, String source, String searchString, PageControl pc, PageList<EventComposite> pl, String query) {
        Connection conn = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        int num = 0;
        try {
            try {
                conn = this.rhqDs.getConnection();
                stm = conn.prepareStatement(query);
                int i = 1;
                JDBCUtil.bindNTimes((PreparedStatement)stm, (int[])resourceIds, (int)i);
                i += resourceIds.length;
                stm.setLong(i++, begin);
                stm.setLong(i++, end);
                if (severities != null) {
                    for (int j = 0; j < severities.length; ++j) {
                        stm.setString(i++, severities[j].toString());
                    }
                }
                if (this.isFilled(searchString)) {
                    stm.setString(i++, PersistenceUtility.formatSearchParameter((String)searchString));
                }
                if (this.isFilled(source)) {
                    stm.setString(i++, PersistenceUtility.formatSearchParameter((String)source));
                }
                rs = stm.executeQuery();
                while (rs.next()) {
                    num = rs.getInt(1);
                }
                Object var19_17 = null;
            }
            catch (SQLException sq) {
                this.log.error((Object)("runEventsCountQuery: Error retrieving events: " + sq.getMessage()), (Throwable)sq);
                Object var19_18 = null;
                JDBCUtil.safeClose((Connection)conn, (Statement)stm, rs);
                return num;
            }
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            JDBCUtil.safeClose((Connection)conn, (Statement)stm, rs);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)stm, (ResultSet)rs);
        return num;
    }

    private String setupEventsQuery(int[] resourceIds, EventSeverity[] severities, String source, String searchString, PageControl pc, boolean isCountQuery) {
        String query = isCountQuery ? "SELECT count(ev.id) " : "SELECT ev.detail, ev.id AS evid, evs.location, ev.severity, ev.timestamp, res.id AS resid, res.name ";
        query = query + " FROM RHQ_Event ev ";
        query = query + " INNER JOIN RHQ_Event_Source evs ON evs.id = ev.event_source_id ";
        if (!isCountQuery) {
            query = query + " LEFT JOIN rhq_resource res ON evs.resource_id = res.id ";
        }
        query = query + " WHERE evs.resource_id IN ( ";
        query = query + JDBCUtil.generateInBinds((int)resourceIds.length);
        query = query + " ) ";
        query = query + " AND ev.timestamp BETWEEN ? AND ? ";
        if (severities != null) {
            query = query + " AND ev.severity IN ( ";
            query = query + JDBCUtil.generateInBinds((int)severities.length);
            query = query + " ) ";
        }
        if (this.isFilled(searchString)) {
            query = query + " AND upper(ev.detail) LIKE ? ";
        }
        if (this.isFilled(source)) {
            query = query + " AND upper(evs.location) LIKE ? ";
        }
        if (!isCountQuery) {
            pc.initDefaultOrderingField("ev.timestamp", PageOrdering.DESC);
            if (this.dbType instanceof PostgresqlDatabaseType) {
                query = PersistenceUtility.addPostgresNativePagingSortingToQuery((String)query, (PageControl)pc);
            } else if (this.dbType instanceof OracleDatabaseType) {
                query = PersistenceUtility.addOracleNativePagingSortingToQuery((String)query, (PageControl)pc);
            } else if (this.dbType instanceof H2DatabaseType) {
                query = PersistenceUtility.addH2NativePagingSortingToQuery((String)query, (PageControl)pc);
            } else if (this.dbType instanceof SQLServerDatabaseType) {
                query = PersistenceUtility.addSQLServerNativePagingSortingToQuery((String)query, (PageControl)pc, (boolean)true);
            } else {
                throw new RuntimeException("Unknown database type : " + this.dbType);
            }
        }
        return query;
    }

    @Override
    public EventComposite getEventDetailForEventId(Subject subject, int eventId) throws EventException {
        Query q = this.entityManager.createNamedQuery("Event.GET_DETAILS_FOR_EVENT_IDS");
        ArrayList<Integer> eventIds = new ArrayList<Integer>(1);
        eventIds.add(eventId);
        q.setParameter("eventIds", eventIds);
        List composites = q.getResultList();
        if (composites.size() == 1) {
            return (EventComposite)composites.get(0);
        }
        throw new EventException("No event found for eventId[" + eventId + "]");
    }

    @Override
    public void deleteEventSourcesForDefinition(EventDefinition def) {
        Query q = this.entityManager.createNamedQuery("EventSource.deletebyEventDefinition");
        q.setParameter("definition", (Object)def);
        List sources = q.getResultList();
        for (EventSource source : sources) {
            this.entityManager.remove((Object)source);
        }
    }

    @Override
    public int getEventDefinitionCountForResourceType(int resourceTypeId) {
        Query query = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"EventDefinition.findByResourceTypeId");
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        long result = (Long)query.getSingleResult();
        return (int)result;
    }

    private boolean isFilled(String in) {
        return in != null && !in.equals("");
    }

    @Override
    public int deleteEvents(Subject subject, List<Integer> eventIds) {
        if (eventIds == null || eventIds.size() == 0) {
            return 0;
        }
        Query q = this.entityManager.createNamedQuery("Event.deleteByEventIds");
        q.setParameter("eventIds", eventIds);
        int deletedCount = q.executeUpdate();
        return deletedCount;
    }

    @Override
    public int deleteAllEventsForResource(Subject subject, int resourceId) {
        Query q = this.entityManager.createNamedQuery("Event.deleteAllByResource");
        q.setParameter("resourceId", (Object)resourceId);
        int deletedCount = q.executeUpdate();
        return deletedCount;
    }

    @Override
    public int deleteAllEventsForCompatibleGroup(Subject subject, int groupId) {
        Query q = this.entityManager.createNamedQuery("Event.deleteAllByResourceGroup");
        q.setParameter("groupId", (Object)groupId);
        int deletedCount = q.executeUpdate();
        return deletedCount;
    }

    @Override
    public Map<EventSeverity, Integer> getEventCountsBySeverity(Subject subject, int resourceId, long startDate, long endDate) {
        HashMap<EventSeverity, Integer> results = new HashMap<EventSeverity, Integer>();
        Query q = this.entityManager.createNamedQuery("Event.eventCountsBySeverity");
        q.setParameter("resourceId", (Object)resourceId);
        q.setParameter("start", (Object)startDate);
        q.setParameter("end", (Object)endDate);
        List rawResults = q.getResultList();
        for (Object[] rawResult : rawResults) {
            EventSeverity severity = (EventSeverity)rawResult[0];
            long count = (Long)rawResult[1];
            results.put(severity, (int)count);
        }
        return results;
    }

    @Override
    public PageList<EventComposite> findEventsForResource(Subject subject, int resourceId, long startDate, long endDate, EventSeverity severity, String source, String detail, PageControl pc) {
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view event history for resource[id=" + resourceId + "]");
        }
        EventSeverity[] severities = new EventSeverity[]{severity};
        PageList<EventComposite> comp = this.findEvents(subject, new int[]{resourceId}, startDate, endDate, severities, source, detail, pc);
        return comp;
    }

    @Override
    public PageList<EventComposite> findEventsForCompGroup(Subject subject, int groupId, long begin, long endDate, EventSeverity severity, String source, String searchString, PageControl pc) {
        if (!this.authorizationManager.canViewGroup(subject, groupId)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view event history for resourceGroup[id=" + groupId + "]");
        }
        EventSeverity[] severities = new EventSeverity[]{severity};
        return this.findEventsForCompGroup(subject, groupId, begin, endDate, severities, source, searchString, pc);
    }

    @Override
    public PageList<EventComposite> findEventsForAutoGroup(Subject subject, int parentResourceId, int resourceTypeId, long begin, long end, EventSeverity severity, String source, String detail, PageControl pc) {
        EventSeverity[] severities = new EventSeverity[]{severity};
        PageList<EventComposite> comp = this.findEventsForAutoGroup(subject, parentResourceId, resourceTypeId, begin, end, severities, source, detail, pc);
        return comp;
    }

    @Override
    public PageList<Event> findEventsByCriteria(Subject subject, EventCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, "source.resource", subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }
}

