/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.operation;

import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.operation.OperationJob;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.operation.ResourceOperationSchedule;
import org.rhq.enterprise.server.util.LookupUtil;

public class ResourceOperationJob
extends OperationJob {
    public static final String DATAMAP_INT_RESOURCE_ID = "resourceId";
    private static final String RESOURCE_JOB_NAME_PREFIX = "rhq-resource-";

    public static String createUniqueJobName(Resource resource, String operationName) {
        return RESOURCE_JOB_NAME_PREFIX + resource.getId() + "-" + operationName.hashCode() + "-" + System.currentTimeMillis();
    }

    public static String createJobGroupName(Resource resource) {
        return RESOURCE_JOB_NAME_PREFIX + resource.getId();
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        ResourceOperationSchedule schedule = null;
        try {
            JobDetail jobDetail = context.getJobDetail();
            OperationManagerLocal operationManager = LookupUtil.getOperationManager();
            this.updateOperationScheduleEntity(jobDetail, context.getNextFireTime(), operationManager);
            schedule = operationManager.getResourceOperationSchedule(LookupUtil.getSubjectManager().getOverlord(), jobDetail);
            schedule.setSubject(this.getUserWithSession(schedule.getSubject(), false));
            operationManager.getResourceOperationSchedule(schedule.getSubject(), jobDetail);
            ResourceOperationHistory resourceHistory = this.createOperationHistory(jobDetail.getName(), jobDetail.getGroup(), schedule, null, operationManager);
            this.invokeOperationOnResource(schedule, resourceHistory, operationManager);
        }
        catch (Exception e) {
            String error = "Failed to execute scheduled operation [" + schedule + "]";
            LogFactory.getLog(ResourceOperationJob.class).error((Object)error, (Throwable)e);
            throw new JobExecutionException(error, (Throwable)e, false);
        }
    }

    void invokeOperationOnResource(ResourceOperationSchedule schedule, ResourceOperationHistory resourceHistory, OperationManagerLocal operationManager) throws Exception {
        schedule.setSubject(this.getUserWithSession(schedule.getSubject(), true));
        try {
            Resource resource = schedule.getResource();
            AgentManagerLocal agentManager = LookupUtil.getAgentManager();
            AgentClient agentClient = agentManager.getAgentClient(resource.getId());
            agentClient.getOperationAgentService().invokeOperation(resourceHistory.getJobId().toString(), resource.getId(), schedule.getOperationName(), schedule.getParameters());
        }
        catch (Exception e) {
            resourceHistory.setErrorMessageFromThrowable((Throwable)e);
            operationManager.updateOperationHistory(this.getUserWithSession(schedule.getSubject(), true), (OperationHistory)resourceHistory);
            operationManager.checkForCompletedGroupOperation(resourceHistory.getId());
            throw e;
        }
    }
}

