/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.perspective.MenuItem;
import org.rhq.enterprise.server.perspective.PerspectiveException;
import org.rhq.enterprise.server.perspective.PerspectiveManagerHelper;
import org.rhq.enterprise.server.perspective.PerspectiveManagerLocal;
import org.rhq.enterprise.server.perspective.PerspectiveManagerRemote;
import org.rhq.enterprise.server.perspective.Tab;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.FacetActivatorSetType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.FacetActivatorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.GlobalPermissionActivatorSetType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.GlobalPermissionActivatorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.GlobalPermissionType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.MenuItemType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.ResourceActivatorSetType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.ResourceActivatorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class PerspectiveManagerBean
implements PerspectiveManagerLocal,
PerspectiveManagerRemote {
    private final Log log = LogFactory.getLog(PerspectiveManagerBean.class);
    private static Map<Integer, CacheEntry> cache = new HashMap<Integer, CacheEntry>();
    private static Map<Integer, String> urlMap = new HashMap<Integer, String>();
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;

    @Override
    public synchronized List<MenuItem> getCoreMenu(Subject subject) throws PerspectiveException {
        List<MenuItem> coreMenu;
        Integer sessionId = subject.getSessionId();
        CacheEntry cacheEntry = cache.get(sessionId);
        if (null == cacheEntry) {
            this.cleanCache();
            cacheEntry = new CacheEntry();
            cache.put(sessionId, cacheEntry);
        }
        if (null == (coreMenu = cacheEntry.getCoreMenu())) {
            try {
                coreMenu = PerspectiveManagerHelper.getPluginMetadataManager().getCoreMenu();
                coreMenu = this.getActivatedMenu(subject, coreMenu);
                cacheEntry.setCoreMenu(coreMenu);
            }
            catch (Exception e) {
                throw new PerspectiveException("Failed to get Core Menu.", e);
            }
        }
        return coreMenu;
    }

    @Override
    @NotNull
    public List<Tab> getResourceTabs(Subject subject, Resource resource) {
        List<Tab> resourceTabs;
        try {
            resourceTabs = PerspectiveManagerHelper.getPluginMetadataManager().getResourceTabs();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ArrayList<Tab> activeResourceTabs = new ArrayList<Tab>();
        ResourceFacets facets = this.resourceTypeManager.getResourceFacets(resource.getResourceType().getId());
        for (Tab resourceTab : resourceTabs) {
            if (!this.isActive(resourceTab, facets)) continue;
            activeResourceTabs.add(resourceTab);
            List<Tab> subtabs = resourceTab.getChildren();
            ArrayList<Tab> activeSubtabs = new ArrayList<Tab>();
            for (Tab subtab : subtabs) {
                if (!this.isActive(subtab, facets)) continue;
                activeSubtabs.add(subtab);
            }
            resourceTab.setChildren(activeSubtabs);
        }
        return activeResourceTabs;
    }

    private boolean isActive(Tab resourceTab, ResourceFacets facets) {
        List<ResourceActivatorSetType> currentResourceActivatorSets = resourceTab.getCurrentResourceOrGroupActivatorSets();
        if (currentResourceActivatorSets != null) {
            for (ResourceActivatorSetType currentResourceActivatorSet : currentResourceActivatorSets) {
                List resourceActivators = currentResourceActivatorSet.getResourceActivator();
                for (ResourceActivatorType resourceActivator : resourceActivators) {
                    FacetActivatorSetType facetActivatorSet = resourceActivator.getFacetActivatorSet();
                    List facetActivators = facetActivatorSet.getFacetActivator();
                    for (FacetActivatorType facetActivator : facetActivators) {
                        String facetName = facetActivator.getFacet().value();
                        if (facetName.equals("measurement") && !facets.isMeasurement()) {
                            return false;
                        }
                        if (facetName.equals("event") && !facets.isEvent()) {
                            return false;
                        }
                        if (facetName.equals("pluginConfiguration") && !facets.isPluginConfiguration()) {
                            return false;
                        }
                        if (facetName.equals("configuration") && !facets.isConfiguration()) {
                            return false;
                        }
                        if (facetName.equals("operation") && !facets.isOperation()) {
                            return false;
                        }
                        if (facetName.equals("content") && !facets.isOperation()) {
                            return false;
                        }
                        if (!facetName.equals("callTime") || facets.isCallTime()) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public synchronized int getUrlKey(String url) {
        int key = url.hashCode();
        String mapEntry = urlMap.get(key);
        while (null != mapEntry && !mapEntry.equals(url)) {
            mapEntry = urlMap.get(key *= 13);
        }
        if (null == mapEntry) {
            urlMap.put(key, url);
        }
        return key;
    }

    @Override
    public String getUrlViaKey(int key) {
        return urlMap.get(key);
    }

    private void cleanCache() {
        for (Integer sessionId : cache.keySet()) {
            try {
                Subject subject = this.subjectManager.getSessionSubject(sessionId);
                if (null != subject) continue;
                this.log.debug((Object)("Removing perspective cache entry for session " + sessionId));
                cache.remove(sessionId);
            }
            catch (Exception e) {
                this.log.debug((Object)("Removing perspective cache entry for session " + sessionId));
                cache.remove(sessionId);
            }
        }
    }

    private List<MenuItem> getActivatedMenu(Subject subject, List<MenuItem> menu) {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>(menu.size());
        for (MenuItem menuItem : menu) {
            List globalPermissionActivatorSet;
            MenuItemType item = menuItem.getItem();
            List inventoriedResourceActivatorSet = item.getInventoriedResourceActivatorSet();
            if (!this.checkActivators(subject, inventoriedResourceActivatorSet, globalPermissionActivatorSet = item.getGlobalPermissionActivatorSet())) continue;
            MenuItem copy = new MenuItem(menuItem.getItem());
            result.add(copy);
            if (!menuItem.isMenuGroup()) continue;
            copy.setChildren(this.getActivatedMenu(subject, menuItem.getChildren()));
        }
        return result;
    }

    private boolean checkActivators(Subject subject, List<ResourceActivatorSetType> resourceActivatorSets, List<GlobalPermissionActivatorSetType> permissionActivatorSets) {
        for (GlobalPermissionActivatorSetType permissionActivatorSet : permissionActivatorSets) {
            boolean any = permissionActivatorSet.isAny();
            boolean anyPassed = false;
            boolean anyFailed = false;
            for (GlobalPermissionActivatorType permissionActivator : permissionActivatorSet.getGlobalPermissionActivator()) {
                boolean hasPermission;
                anyPassed = hasPermission = this.hasGlobalPermission(subject, permissionActivator.getPermission());
                boolean bl = anyFailed = !hasPermission;
                if ((!any || !anyPassed) && (any || !anyFailed)) continue;
                break;
            }
            if ((!any || anyPassed) && (any || !anyFailed)) continue;
            return false;
        }
        for (ResourceActivatorSetType resourceActivatorSet : resourceActivatorSets) {
        }
        return true;
    }

    private boolean hasGlobalPermission(Subject subject, GlobalPermissionType permissionType) {
        if (permissionType == GlobalPermissionType.SUPERUSER) {
            return this.authorizationManager.isSystemSuperuser(subject);
        }
        return this.authorizationManager.hasGlobalPermission(subject, Permission.valueOf((String)permissionType.name()));
    }

    private void printMenu(List<MenuItem> menu, String indent) {
        if (null == menu) {
            return;
        }
        for (MenuItem menuItem : menu) {
            System.out.println(indent + menuItem.getItem().getName());
            this.printMenu(menuItem.getChildren(), indent + "..");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheEntry {
        private List<MenuItem> coreMenu = null;

        public List<MenuItem> getCoreMenu() {
            return this.coreMenu;
        }

        public void setCoreMenu(List<MenuItem> coreMenu) {
            this.coreMenu = coreMenu;
        }
    }
}

